/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.network.discovery;

import com.hybridlab.hyve3d.network.discovery.DiscoveryServerThread;
import com.hybridlab.hyve3d.network.discovery.ServerEntry;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class NetworkServiceManager {
    public static final String SERVICE_ApplicationControl_SPIDERMONKEY = "HyveApplicationControl_SPIDERMONKEY";
    public static final String SERVICE_HISCLIENT_CONTROLLER_SPIDERMONKEY = "hisclient_ctrl_spidermonkey";
    public static final String SERVICE_SATELLITE_SPIDERMONKEY = "satellite_spidermonkey";
    public static final String SERVICE_SATELLITE_FAB8 = "satellite_fab8";
    public static final String SERVICE_HUBNODE_HOST = "interconnection_hubnode_host";
    public static final int startport = 8910;
    public static final int multicastPort = 6665;
    public static final String multicastAddressGroup = "224.168.100.2";
    private Thread thread = null;
    private static final Logger logger = Logger.getLogger(NetworkServiceManager.class.getName());
    Map<String, List<ServerEntry>> serviceList = new HashMap<String, List<ServerEntry>>();
    Map<String, Integer> portList = new HashMap<String, Integer>();

    public int registerService(String id) throws UnknownHostException, SocketException {
        String mainAddress = InetAddress.getLocalHost().getHostAddress();
        int port = this.getNextFreePort(mainAddress);
        this.registerService(id, port);
        return port;
    }

    public int registerService(String id, int port) throws IllegalArgumentException, UnknownHostException, SocketException {
        InetAddress localhost = null;
        try {
            localhost = InetAddress.getByName("127.0.0.1");
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        Enumeration<NetworkInterface> enumNI = NetworkInterface.getNetworkInterfaces();
        while (enumNI.hasMoreElements()) {
            NetworkInterface ifc = enumNI.nextElement();
            if (!ifc.isUp()) continue;
            Enumeration<InetAddress> enumAdds = ifc.getInetAddresses();
            while (enumAdds.hasMoreElements()) {
                InetAddress address = enumAdds.nextElement();
                if (address.equals(localhost) || address.toString().contains(":")) continue;
                this.registerService(id, address.getHostAddress(), port);
            }
        }
        return port;
    }

    public int registerService(String id, String address) throws IllegalArgumentException {
        int port = this.getNextFreePort(address);
        return this.registerService(id, address, port);
    }

    public int registerService(String id, String address, int port) throws IllegalArgumentException {
        List<ServerEntry> entryList = null;
        entryList = this.serviceList.containsKey(id) ? this.serviceList.get(id) : new ArrayList<ServerEntry>();
        entryList.add(new ServerEntry(id, address, port));
        this.serviceList.put(id, entryList);
        logger.info("RegisterSerice : " + id + " " + address + ":" + port);
        return port;
    }

    public List<ServerEntry> getServiceForId(String id) {
        if (this.serviceList.containsKey(id)) {
            return this.serviceList.get(id);
        }
        return null;
    }

    private int getNextFreePort(String address) {
        int port = 8910;
        if (this.portList.containsKey(address)) {
            port = this.portList.get(address);
        }
        this.portList.put(address, port + 1);
        return port;
    }

    public void start() {
        this.stop();
        this.thread = new DiscoveryServerThread(this, multicastAddressGroup, 6665);
        this.thread.start();
    }

    public void stop() {
        if (null != this.thread) {
            this.thread.interrupt();
            this.thread = null;
        }
    }

    public void unRegisterService(String serviceHubnodeHost, int port) {
        System.out.println("TODO: void unRegisterService(String serviceHubnodeHost, int port) in " + NetworkServiceManager.class.getName());
    }
}

