/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.network.interconnection.implementations;

import com.hybridlab.hyve3d.core.DrawingAreaStateMemento;
import com.hybridlab.hyve3d.core.DrawingAreaTransformation;
import com.hybridlab.hyve3d.core.HisDrawingAreaListener;
import com.hybridlab.hyve3d.network.interconnection.HisDrawingArea;
import com.hybridlab.hyve3d.network.interconnection.IdeationSpace;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;

public class RemoteDrawingArea
implements HisDrawingArea,
IdeationSpace.IdeationSpacePropertyListener {
    private UUID id;
    private UUID ideationSpaceId;
    private String label;
    private ColorRGBA frameColor;
    private DrawingAreaTransformation transformation;
    private Set<HisDrawingAreaListener> listeners = new HashSet<HisDrawingAreaListener>();
    private IdeationSpace owner;
    private boolean shouldBeVisible = true;
    private boolean notifyAboutTransformationChange = false;

    public RemoteDrawingArea(DrawingAreaStateMemento dam) {
        this.id = dam.id;
        this.label = dam.label;
        this.transformation = dam.transformation;
        this.ideationSpaceId = dam.ideationSpaceId;
        this.frameColor = dam.frameColor;
    }

    @Override
    public DrawingAreaTransformation getTransformation() {
        return this.transformation;
    }

    @Override
    public void applyTransformation(DrawingAreaTransformation datrf) {
        this.transformation.setFrom(datrf);
        HashSet<HisDrawingAreaListener> listenerCopy = new HashSet<HisDrawingAreaListener>(this.listeners);
        for (HisDrawingAreaListener l : listenerCopy) {
            l.onTransformationHasChanged(this);
        }
    }

    @Override
    public UUID getID() {
        return this.id;
    }

    @Override
    public DrawingAreaStateMemento getMemento() {
        DrawingAreaStateMemento dam = new DrawingAreaStateMemento();
        dam.id = this.id;
        dam.label = this.label;
        dam.frameColor = this.getFrameColor();
        dam.transformation = this.transformation.getCopy();
        dam.ideationSpaceId = this.ideationSpaceId;
        return dam;
    }

    @Override
    public String getLabelText() {
        return this.label;
    }

    @Override
    public void registerListener(HisDrawingAreaListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void adaptTo(DrawingAreaStateMemento dam) {
        this.applyTransformation(dam.transformation);
        this.setFrameColor(dam.frameColor);
        this.setLabel(dam.label);
    }

    public void setFrameColor(ColorRGBA frameColor) {
        if (frameColor == null) {
            return;
        }
        if (!frameColor.equals((Object)this.frameColor)) {
            this.frameColor = frameColor;
            for (HisDrawingAreaListener l : this.listeners) {
                l.onFrameColorHasChanged(this);
            }
        }
    }

    private void setLabel(String label) {
        this.label = label;
        HashSet<HisDrawingAreaListener> listenerCopy = new HashSet<HisDrawingAreaListener>(this.listeners);
        for (HisDrawingAreaListener l : listenerCopy) {
            l.onLabelHasChanged(this);
        }
    }

    @Override
    public UUID getIdeationSpaceId() {
        return this.ideationSpaceId;
    }

    @Override
    public void setOwningIdeationSpace(IdeationSpace owner) {
        this.owner = owner;
        this.owner.registerPropertyListener(this);
    }

    @Override
    public void onTransformationHasChanged(IdeationSpace space) {
        this.transformation.setCamRigRotation(space.getRotation());
        this.transformation.setCameraRigWorldPosition(space.getPosition());
        if (this.notifyAboutTransformationChange) {
            HashSet<HisDrawingAreaListener> listenerCopy = new HashSet<HisDrawingAreaListener>(this.listeners);
            for (HisDrawingAreaListener l : listenerCopy) {
                l.onTransformationHasChanged(this);
            }
        }
    }

    @Override
    public void onNameHasChanged(IdeationSpace space) {
    }

    @Override
    public void hide() {
        this.shouldBeVisible = false;
        HashSet<HisDrawingAreaListener> listenerCopy = new HashSet<HisDrawingAreaListener>(this.listeners);
        for (HisDrawingAreaListener l : listenerCopy) {
            l.onVisibilityChanged(this, this.shouldBeVisible);
        }
    }

    @Override
    public void show() {
        this.shouldBeVisible = true;
        HashSet<HisDrawingAreaListener> listenerCopy = new HashSet<HisDrawingAreaListener>(this.listeners);
        for (HisDrawingAreaListener l : listenerCopy) {
            l.onVisibilityChanged(this, this.shouldBeVisible);
        }
    }

    @Override
    public void setKeepAlignmentDuringCameraRotation(boolean b) {
        this.notifyAboutTransformationChange = b;
        if (this.notifyAboutTransformationChange) {
            HashSet<HisDrawingAreaListener> listenerCopy = new HashSet<HisDrawingAreaListener>(this.listeners);
            for (HisDrawingAreaListener l : listenerCopy) {
                l.onTransformationHasChanged(this);
            }
        }
    }

    @Override
    public ColorRGBA getFrameColor() {
        return this.frameColor;
    }

    @Override
    public Vector3f getPosition() {
        return this.transformation.getTranslation();
    }
}

