/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.network.interconnection.implementations;

import com.hybridlab.hyve3d.network.interconnection.HisDrawingArea;
import com.hybridlab.hyve3d.network.interconnection.IdeationSpace;
import com.hybridlab.hyve3d.network.interconnection.IdeationSpaceMemento;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;

public class RemoteIdeationSpace
implements IdeationSpace {
    private UUID ideationSpaceId;
    private String ideationSpaceName;
    private Vector3f position = Vector3f.NAN;
    private Quaternion rotation = Quaternion.ZERO;
    private Set<IdeationSpace.IdeationSpacePropertyListener> propertyListeners = new HashSet<IdeationSpace.IdeationSpacePropertyListener>();
    private Set<HisDrawingArea> localDrawingAreas = new HashSet<HisDrawingArea>();

    public String toString() {
        return String.format("RemoteIdeationSpace [ideationSpaceId=%s, ideationSpaceName=%s, hashCode()=%s]", this.ideationSpaceId, this.ideationSpaceName, this.hashCode());
    }

    public RemoteIdeationSpace(UUID ideationSpaceId, String ideationSpaceName, Vector3f position, Quaternion rotation) {
        this.ideationSpaceId = ideationSpaceId;
        this.ideationSpaceName = ideationSpaceName;
        this.position = position;
        this.rotation = rotation;
    }

    @Override
    public UUID getId() {
        return this.ideationSpaceId;
    }

    @Override
    public String getName() {
        return this.ideationSpaceName;
    }

    @Override
    public void setName(String name) {
        if (!this.ideationSpaceName.equals(name)) {
            this.ideationSpaceName = name;
            for (IdeationSpace.IdeationSpacePropertyListener l : this.propertyListeners) {
                l.onNameHasChanged(this);
            }
        }
    }

    @Override
    public Vector3f getPosition() {
        return this.position.clone();
    }

    @Override
    public Quaternion getRotation() {
        return this.rotation.clone();
    }

    @Override
    public void setPosition(Vector3f position) {
        if (this.position.equals((Object)position)) {
            return;
        }
        this.position = position.clone();
        for (IdeationSpace.IdeationSpacePropertyListener l : this.propertyListeners) {
            l.onTransformationHasChanged(this);
        }
    }

    @Override
    public void setRotation(Quaternion rotation) {
        if (this.rotation.equals((Object)rotation)) {
            return;
        }
        this.rotation = rotation;
        for (IdeationSpace.IdeationSpacePropertyListener l : this.propertyListeners) {
            l.onTransformationHasChanged(this);
        }
    }

    @Override
    public void adaptTo(IdeationSpaceMemento m) {
        this.setPosition(m.position);
        this.setRotation(m.rotation);
    }

    @Override
    public void registerPropertyListener(IdeationSpace.IdeationSpacePropertyListener l) {
        this.propertyListeners.add(l);
    }

    @Override
    public void unRegisterPropertyListener(IdeationSpace.IdeationSpacePropertyListener l) {
        this.propertyListeners.remove(l);
    }

    @Override
    public IdeationSpaceMemento getMemento() {
        IdeationSpaceMemento m = new IdeationSpaceMemento();
        m.id = this.getId();
        m.name = this.getName();
        m.position = this.getPosition();
        m.rotation = this.getRotation();
        return m;
    }

    @Override
    public Set<HisDrawingArea> getLocalDrawingAreas() {
        return this.localDrawingAreas;
    }

    public void setLocalDrawingAreas(Set<HisDrawingArea> das) {
        this.localDrawingAreas = das;
    }
}

