/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.network.interconnection.implementations;

import com.hybridlab.hyve3d.data.synch.SynchronizationProgressTracer;
import com.hybridlab.hyve3d.data.synch.messages.ChunkedSynchMessage;
import com.hybridlab.hyve3d.network.interconnection.HubConnection;
import com.hybridlab.hyve3d.network.interconnection.HubNode;
import com.hybridlab.hyve3d.network.interconnection.HubNodeHost;
import com.hybridlab.hyve3d.network.interconnection.implementations.SpiderMonkeyHubConnection;
import com.hybridlab.hyve3d.network.interconnection.implementations.adressing.InternetReachableHubNodeAdress;
import com.jme3.network.ConnectionListener;
import com.jme3.network.HostedConnection;
import com.jme3.network.Message;
import com.jme3.network.MessageListener;
import com.jme3.network.Network;
import com.jme3.network.Server;
import com.jme3.network.service.HostedService;
import com.jme3.network.service.serializer.ServerSerializerRegistrationsService;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class SpiderMonkeyHubNodeHost
extends HubNodeHost {
    private int port;
    private Server spiderMonkeyServer;
    private Map<HostedConnection, SpiderMonkeyHubConnection> connections = new HashMap<HostedConnection, SpiderMonkeyHubConnection>();
    private Logger logger = Logger.getLogger("de.codemacher.his.jolly.network.interconnection");
    private ServerListener l = new ServerListener();
    private SynchronizationProgressTracer tracer = new SynchronizationProgressTracer(){

        @Override
        public void trace(ChunkedSynchMessage message, SynchronizationProgressTracer.MessageDirection direction, String connectionkey) {
        }
    };

    public SpiderMonkeyHubNodeHost(HubNode owner, int port, SynchronizationProgressTracer tracer) {
        this(owner, port);
        this.tracer = tracer;
    }

    public SpiderMonkeyHubNodeHost(HubNode owner, int port) {
        super(owner);
        this.port = port;
    }

    @Override
    public void stop() {
        this.spiderMonkeyServer.close();
        this.ownerHubNode.getConnector().removeAdress(this.getAdress());
    }

    @Override
    public void start() {
        try {
            int version = 2;
            String gameName = "Hyve";
            this.spiderMonkeyServer = Network.createServer((String)gameName, (int)version, (int)this.port, (int)this.port);
            this.spiderMonkeyServer.getServices().removeService((HostedService)this.spiderMonkeyServer.getServices().getService(ServerSerializerRegistrationsService.class));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.spiderMonkeyServer.addConnectionListener(new ConnectionListener(){

            public void connectionRemoved(Server server, HostedConnection conn) {
                HubConnection removed = SpiderMonkeyHubNodeHost.this.connections.remove(conn);
                SpiderMonkeyHubNodeHost.this.onHubConnectionRemoved(removed);
            }

            public void connectionAdded(Server server, HostedConnection conn) {
                Object ni = conn.getAttribute("nodeid");
                if (ni != null) {
                    String string = (String)ni;
                }
                SpiderMonkeyHubConnection c = new SpiderMonkeyHubConnection(conn, SpiderMonkeyHubNodeHost.this.ownerHubNode, SpiderMonkeyHubNodeHost.this.tracer);
                SpiderMonkeyHubNodeHost.this.connections.put(conn, c);
                SpiderMonkeyHubNodeHost.this.onNewHubConnectionEstablished(c);
            }
        });
        this.setupMessageListeners();
        this.spiderMonkeyServer.start();
        this.logger.info(this.getClass().getSimpleName() + (this.spiderMonkeyServer.isRunning() ? " is " : " is NOT ") + "running.\n  Adress: " + this.getAdress().toString());
        this.ownerHubNode.getConnector().addAddress(this.getAdress());
    }

    private void setupMessageListeners() {
        this.spiderMonkeyServer.addMessageListener((MessageListener)this.l);
    }

    private InternetReachableHubNodeAdress getAdress() {
        try {
            InternetReachableHubNodeAdress a = new InternetReachableHubNodeAdress();
            a.adress = InetAddress.getLocalHost();
            a.port = this.port;
            this.address = a;
            return a;
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public boolean isAccepting() {
        if (this.spiderMonkeyServer == null) {
            return false;
        }
        return this.spiderMonkeyServer.isRunning();
    }

    @Override
    public int getPort() {
        return this.port;
    }

    class ServerListener
    implements MessageListener<HostedConnection> {
        ServerListener() {
        }

        public void messageReceived(HostedConnection source, Message message) {
            SpiderMonkeyHubConnection c = SpiderMonkeyHubNodeHost.this.connections.get(source);
            if (c != null) {
                c.messageReceived(message);
            }
        }
    }
}

