/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.network.messages;

import com.hybridlab.hyve3d.network.messages.AbstractHisMessage;
import com.hybridlab.hyve3d.network.messages.TransformMessage;
import com.jme3.math.Matrix3f;
import com.jme3.math.Quaternion;
import com.jme3.network.serializing.Serializable;

@Serializable
public class Matrix3fMessage
extends AbstractHisMessage {
    private Matrix3f matrix;
    private MatrixType matrixType;

    public Matrix3f getMatrix() {
        return this.matrix;
    }

    public MatrixType getMatrixType() {
        return this.matrixType;
    }

    public Matrix3fMessage() {
        this.matrix = new Matrix3f();
        this.matrixType = MatrixType.Unkown;
    }

    public Matrix3fMessage(MatrixType matrixType, Matrix3f matrix) {
        this.matrix = matrix;
        this.matrixType = matrixType;
    }

    public String toString() {
        return "MatrixMessage " + this.matrixType.toString() + " " + this.matrix.toString();
    }

    public TransformMessage asTransformMessage() {
        Quaternion q = new Quaternion();
        q.fromRotationMatrix(this.matrix);
        TransformMessage m = new TransformMessage(q);
        return m;
    }

    public static enum MatrixType {
        Unkown,
        RotationMatrix;

    }
}

