/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.network.messages;

import com.hybridlab.hyve3d.network.messages.AbstractHisMessage;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector2f;
import com.jme3.network.serializing.Serializable;
import java.util.Locale;

@Serializable
public class TransformMessage
extends AbstractHisMessage {
    private Source source = Source.UNKNOWN;
    private Quaternion quaternion;
    private SubType type;
    float[] eulerAngles;
    private Vector2f[] pivots = null;
    static final Quaternion RPos90X = new Quaternion(new float[]{1.5707964f, 0.0f, 0.0f});
    static final Quaternion RNeg90X = new Quaternion(new float[]{-1.5707964f, 0.0f, 0.0f});
    static final Quaternion RPos90Y = new Quaternion(new float[]{0.0f, 1.5707964f, 0.0f});
    static final Quaternion RNeg90Y = new Quaternion(new float[]{0.0f, -1.5707964f, 0.0f});
    static final Quaternion RPos90Z = new Quaternion(new float[]{0.0f, 0.0f, 1.5707964f});
    static final Quaternion RNeg90Z = new Quaternion(new float[]{0.0f, 0.0f, -1.5707964f});
    static final Quaternion RZ180 = new Quaternion(new float[]{0.0f, 0.0f, (float)Math.PI});
    static final Quaternion iOSDeviceMotionCoordinateSystemBaseRotation = RPos90Y.mult(RNeg90X);
    static final Quaternion HydraCoordinateSystemBaseRotation = RNeg90X.mult(RPos90Z);

    public Source getSource() {
        return this.source;
    }

    public Quaternion getQuaternion() {
        return this.quaternion;
    }

    public float getSingleAxisRotationAngleDeg() {
        if (this.eulerAngles == null) {
            this.eulerAngles = new float[]{0.0f, 0.0f, 0.0f};
            this.quaternion.toAngles(this.eulerAngles);
        }
        return this.eulerAngles[2];
    }

    public SubType getType() {
        return this.type;
    }

    public TransformMessage(Quaternion q, Source s) {
        this.source = s;
        this.type = SubType.ROTATION_QUATERNION;
        this.quaternion = q;
    }

    public TransformMessage(float yaw, float pitch, float roll, Source s) {
        this.source = s;
        this.type = SubType.ROTATION_QUATERNION;
        this.quaternion = new Quaternion();
        this.quaternion = this.quaternion.fromAngles(pitch, yaw, roll);
    }

    public TransformMessage(float yaw, float pitch, float roll) {
        this(yaw, pitch, roll, Source.IPAD);
    }

    public TransformMessage(Quaternion q) {
        this(q, Source.IPAD);
    }

    public TransformMessage(float singleAxisRotationAngleInDegrees) {
        this.type = SubType.SINGLE_AXIS_ROTATION_ANGLE_DEG;
        this.eulerAngles[2] = singleAxisRotationAngleInDegrees;
        this.quaternion = new Quaternion(this.eulerAngles);
    }

    public String toString() {
        Object s;
        boolean euleranglestyle = false;
        if (euleranglestyle) {
            if (this.eulerAngles == null) {
                this.eulerAngles = new float[]{0.0f, 0.0f, 0.0f};
                this.quaternion.toAngles(this.eulerAngles);
            }
            s = String.format(Locale.ENGLISH, "%s %s rx %.3f ry %.3f rz %.3f", new Object[]{TransformMessage.class.getSimpleName(), this.type, Float.valueOf(this.eulerAngles[0]), Float.valueOf(this.eulerAngles[1]), Float.valueOf(this.eulerAngles[2])});
        } else {
            s = String.format(Locale.ENGLISH, "%s %s x %.3f y %.3f z %.3f w %.3f", new Object[]{TransformMessage.class.getSimpleName(), this.type, Float.valueOf(this.quaternion.getX()), Float.valueOf(this.quaternion.getY()), Float.valueOf(this.quaternion.getZ()), Float.valueOf(this.quaternion.getW())});
        }
        int numPivots = this.getNumberOfPivots();
        if (numPivots > 0) {
            s = (String)s + " PivotPoints[ ";
            for (Vector2f p : this.pivots) {
                s = (String)s + p.toString() + " ";
            }
            s = (String)s + "]";
        }
        return s;
    }

    public void setPivotPoints(Vector2f[] pivots) {
        this.pivots = pivots;
    }

    public Vector2f[] getPivotPoints() {
        return this.pivots;
    }

    public boolean isGlobal() {
        return this.type == SubType.GLOBAL_ROTATION_QUATERNION || this.type == SubType.GLOBAL_ROTATION_QUATERNION_AND_ROTATION_POINTS;
    }

    public int getNumberOfPivots() {
        return this.pivots == null ? 0 : this.pivots.length;
    }

    public Quaternion getCorrectedQuaternion() {
        Quaternion received = this.quaternion;
        switch (this.source) {
            case HYDRA: {
                Quaternion correctedhydra = received.mult(HydraCoordinateSystemBaseRotation);
                return correctedhydra;
            }
            case IPAD: {
                Quaternion correctedipad = iOSDeviceMotionCoordinateSystemBaseRotation.mult(received);
                return correctedipad;
            }
        }
        return received;
    }

    private void printEulerAngles(Quaternion q, String desc) {
        float[] eulerangles = new float[3];
        q.toAngles(eulerangles);
        float rx = eulerangles[0] * 57.295776f;
        float ry = eulerangles[1] * 57.295776f;
        float rz = eulerangles[2] * 57.295776f;
        System.out.println(String.format("%s: rx=%.3f ry=%.3f rz=%.3f (%s)", desc, Float.valueOf(rx), Float.valueOf(ry), Float.valueOf(rz), q.toString()));
    }

    public static enum Source {
        IPAD,
        HYDRA,
        UNKNOWN;

    }

    public static enum SubType {
        ROTATION_QUATERNION(1),
        ROTATION_QUATERNION_AND_ROTATION_POINTS(2),
        GLOBAL_ROTATION_QUATERNION(3),
        GLOBAL_ROTATION_QUATERNION_AND_ROTATION_POINTS(4),
        SINGLE_AXIS_ROTATION_ANGLE_DEG(5);

        private final short code;

        private SubType(short c) {
            this.code = c;
        }

        public short getCode() {
            return this.code;
        }

        public static SubType getFromShort(short s) {
            if (SubType.ROTATION_QUATERNION.code == s) {
                return ROTATION_QUATERNION;
            }
            if (SubType.ROTATION_QUATERNION_AND_ROTATION_POINTS.code == s) {
                return ROTATION_QUATERNION_AND_ROTATION_POINTS;
            }
            if (SubType.GLOBAL_ROTATION_QUATERNION.code == s) {
                return GLOBAL_ROTATION_QUATERNION;
            }
            if (SubType.GLOBAL_ROTATION_QUATERNION_AND_ROTATION_POINTS.code == s) {
                return GLOBAL_ROTATION_QUATERNION_AND_ROTATION_POINTS;
            }
            if (SubType.SINGLE_AXIS_ROTATION_ANGLE_DEG.code == s) {
                return SINGLE_AXIS_ROTATION_ANGLE_DEG;
            }
            return ROTATION_QUATERNION;
        }
    }
}

