/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.network.messages;

import com.hybridlab.hyve3d.core.FrameRect;
import com.hybridlab.hyve3d.network.messages.AbstractHisMessage;
import com.jme3.network.serializing.Serializable;
import org.json.JSONException;

@Serializable
public class ZoomMessage
extends AbstractHisMessage {
    private int id;
    private Type t;
    private SubType st;
    private float zoomValue = 1.0f;
    private FrameRect frameRect;

    public ZoomMessage(int id, Type type, SubType subType) {
        this.setId(id);
        this.setType(type);
        this.setSubType(subType);
    }

    public int getId() {
        return this.id;
    }

    private void setId(int id) {
        this.id = id;
    }

    public Type getType() {
        return this.t;
    }

    private void setType(Type t) {
        this.t = t;
    }

    public SubType getSt() {
        return this.st;
    }

    private void setSubType(SubType st) {
        this.st = st;
    }

    public float getZoomValue() {
        return this.zoomValue;
    }

    public void setZoomValue(float z) {
        this.zoomValue = z;
    }

    public FrameRect getFrameRect() {
        return this.frameRect;
    }

    public void setFrameRect(FrameRect frameRect) {
        this.frameRect = frameRect;
    }

    public String toString() {
        String s = this.getClass().getName() + "@" + Integer.toHexString(this.hashCode());
        s = s + " Type: " + this.t.toString();
        s = s + " SubType: " + this.st.toString();
        s = s + String.format(" id: %d", this.id);
        if (this.frameRect != null) {
            try {
                s = s + " Framerect: " + this.frameRect.asJSONObject().toString();
            }
            catch (JSONException e) {
                s = s + " Framerect: ERROR!";
            }
        }
        s = s + String.format(" zoomValue: %.2f", Float.valueOf(this.zoomValue));
        return s;
    }

    public static enum Type {
        ZOOM_1D;

    }

    public static enum SubType {
        ZOOM_BEGIN,
        ZOOM_CHANGE,
        ZOOM_END;

    }
}

