/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.network.spacemouse;

import com.hybridlab.hyve3d.network.messages.SpaceMouseMessage;
import com.hybridlab.hyve3d.network.spacemouse.SpaceMouseClientTestProgram;
import com.hybridlab.hyve3d.network.spacemouse.SpaceMouseValueTCPSocketConnection;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SpaceMouseTcpSocketConnectionListener
implements Runnable {
    boolean running = false;
    SpaceMouseValueTCPSocketConnection connection;
    int sleepMilliseconds = 49;
    private List<SpaceMouseMessageProcessor> processors = new ArrayList<SpaceMouseMessageProcessor>();

    public void addProcessor(SpaceMouseMessageProcessor p) {
        this.processors.add(p);
    }

    public SpaceMouseTcpSocketConnectionListener(SpaceMouseValueTCPSocketConnection client) {
        this.connection = client;
    }

    @Override
    public void run() {
        this.running = true;
        while (this.running) {
            try {
                SpaceMouseMessage s = this.connection.receiveNewestSpaceMouseMessage();
                if (this.processors.isEmpty()) {
                    System.out.println(s.toString());
                } else {
                    for (SpaceMouseMessageProcessor p : this.processors) {
                        p.onMessageReceived(s);
                    }
                }
                try {
                    Thread.sleep(this.sleepMilliseconds);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(SpaceMouseClientTestProgram.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            catch (IOException ioex) {
                Logger.getLogger(SpaceMouseClientTestProgram.class.getName()).log(Level.SEVERE, null, ioex);
                this.running = false;
                try {
                    this.connection.disconnect();
                }
                catch (IOException ex1) {
                    Logger.getLogger(SpaceMouseClientTestProgram.class.getName()).log(Level.SEVERE, null, ex1);
                }
            }
            catch (Exception e) {
                this.running = false;
                Logger.getLogger(SpaceMouseClientTestProgram.class.getName()).log(Level.SEVERE, null, e);
            }
        }
    }

    public void stop() {
        this.running = false;
    }

    public static interface SpaceMouseMessageProcessor {
        public void onMessageReceived(SpaceMouseMessage var1);
    }
}

