/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.network.transport.appCtrl;

import com.hybridlab.hyve3d.network.messages.ByteMessage;
import com.hybridlab.hyve3d.network.transport.fab8.FAB8_MessageTranslator;
import com.hybridlab.hyve3d.network.transport.fab8.FrameReceiveErrorException;
import com.hybridlab.hyve3d.network.transport.fab8.MessageDeSerializationException;
import com.hybridlab.hyve3d.network.transport.fab8.MessageSerializationException;
import com.hybridlab.hyveclient.SimpleAppControl.FileMessage;
import com.hybridlab.hyveclient.SimpleAppControl.SimpleCommandMessage;
import com.hybridlab.hyveclient.SimpleAppControl.SimpleCommandWithFloatArgumentMessage;
import com.hybridlab.hyveclient.SimpleAppControl.SimpleCommandWithIntegerArgumentsMessage;
import com.hybridlab.hyveclient.SimpleAppControl.SimpleCommandWithStringArgumentMessage;
import com.hybridlab.utils.ByteUtils;
import com.jme3.network.AbstractMessage;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class AppCtrl_MessageTranslator {
    Logger logger = Logger.getLogger(AppCtrl_MessageTranslator.class.getSimpleName());
    public static final ByteOrder BYTE_ORDER_RECEIVING = ByteOrder.BIG_ENDIAN;
    public static final ByteOrder BYTE_ORDER_SENDING = ByteOrder.BIG_ENDIAN;
    public static final short MESSAGE_CODE_SIMPLECOMMAND_MESSAGE = 4097;
    public static final short MESSAGE_CODE_SIMPLECOMMAND_WITH_STRING_MESSAGE = 4098;
    public static final short MESSAGE_CODE_SIMPLECOMMAND_WITH_FLOAT_MESSAGE = 4099;
    public static final short MESSAGE_CODE_SIMPLECOMMAND_WITH_INTEGER_ARGUMENTS_MESSAGE = 4104;
    public static final short MESSAGE_CODE_FILE_MESSAGE = 4100;
    private Map<Short, HisMessageSerDes> serdesMap = new HashMap<Short, HisMessageSerDes>();
    private Map<Class, Short> classToMsgTypeMap = new HashMap<Class, Short>();
    static final byte[] controlbytes = ByteUtils.hexToBytes("F8FAFE");
    public static final byte SHIFT = controlbytes[0];
    public static final byte START = controlbytes[1];
    public static final byte STOP = controlbytes[2];
    Map<Byte, Byte> escapeTable = new HashMap<Byte, Byte>();
    Map<Byte, Byte> inverseEcapeTable = new HashMap<Byte, Byte>();
    protected static final char[] hexArray = "0123456789ABCDEF".toCharArray();

    public AppCtrl_MessageTranslator() {
        this.register(SimpleCommandMessage.class, new SimpleCommandMessageSerDes(), (short)4097);
        this.register(SimpleCommandWithStringArgumentMessage.class, new SimpleCommandWithStringMessageSerDes(), (short)4098);
        this.register(SimpleCommandWithFloatArgumentMessage.class, new SimpleCommandWithFloatArgumentMessageSerDes(), (short)4099);
        this.register(SimpleCommandWithIntegerArgumentsMessage.class, new SimpleCommandWithIntegerArgumentsMessageSerDes(), (short)4104);
        this.register(FileMessage.class, new FileMessageSerDes(), (short)4100);
        this.escapeTable.put(SHIFT, (byte)0);
        this.escapeTable.put(START, (byte)1);
        this.escapeTable.put(STOP, (byte)2);
        this.inverseEcapeTable.put((byte)0, SHIFT);
        this.inverseEcapeTable.put((byte)1, START);
        this.inverseEcapeTable.put((byte)2, STOP);
    }

    void register(Class c, HisMessageSerDes serDes, short messageCode) {
        this.classToMsgTypeMap.put(c, messageCode);
        this.serdesMap.put(messageCode, serDes);
    }

    public byte getControlByteForEscapeByte(byte escapeByte) throws FrameReceiveErrorException {
        if (!this.inverseEcapeTable.containsKey(escapeByte)) {
            throw new FrameReceiveErrorException("No substitution for escape byte " + ByteMessage.bytesToHex(new byte[]{escapeByte}) + " found!");
        }
        return this.inverseEcapeTable.get(escapeByte);
    }

    /*
     * WARNING - void declaration
     */
    public byte[] wrapBytesForAbstractHisMessageIntoFrame(byte[] bytesOfHisMessage) {
        void var6_13;
        byte[] escapedFramelengthLower;
        void var6_10;
        int numextra = 0;
        for (byte by : bytesOfHisMessage) {
            if (by != SHIFT && by != START && by != STOP) continue;
            numextra = (short)(numextra + 1);
        }
        ByteBuffer completeEscapedHisMessage = ByteBuffer.allocate(bytesOfHisMessage.length + numextra);
        byte[] byArray = bytesOfHisMessage;
        int n = byArray.length;
        boolean bl = false;
        while (var6_10 < n) {
            byte b1 = byArray[var6_10];
            if (b1 == SHIFT) {
                completeEscapedHisMessage.put(SHIFT).put(this.escapeTable.get(SHIFT));
            } else if (b1 == START) {
                completeEscapedHisMessage.put(SHIFT).put(this.escapeTable.get(START));
            } else if (b1 == STOP) {
                completeEscapedHisMessage.put(SHIFT).put(this.escapeTable.get(STOP));
            } else {
                completeEscapedHisMessage.put(b1);
            }
            ++var6_10;
        }
        byte[] completeEscapedHisMessageArray = completeEscapedHisMessage.array();
        byte[] framelengthBytes = ByteBuffer.allocate(2).order(BYTE_ORDER_SENDING).putShort((short)(completeEscapedHisMessageArray.length + 1)).array();
        if (framelengthBytes[0] == SHIFT || framelengthBytes[0] == START || framelengthBytes[0] == STOP) {
            byte[] byArray2 = new byte[]{SHIFT, this.escapeTable.get(framelengthBytes[0])};
        } else {
            byte[] byArray3 = new byte[]{framelengthBytes[0]};
        }
        if (framelengthBytes[1] == SHIFT || framelengthBytes[1] == START || framelengthBytes[1] == STOP) {
            escapedFramelengthLower = new byte[2];
            escapedFramelengthLower[0] = SHIFT;
            escapedFramelengthLower[0] = this.escapeTable.get(framelengthBytes[1]);
        } else {
            escapedFramelengthLower = new byte[]{framelengthBytes[1]};
        }
        ByteBuffer completeFrame = ByteBuffer.allocate(completeEscapedHisMessage.limit() + ((void)var6_13).length + escapedFramelengthLower.length + 2);
        byte[] result = completeFrame.order(BYTE_ORDER_SENDING).put(START).put((byte[])var6_13).put(escapedFramelengthLower).put(completeEscapedHisMessageArray).put(STOP).array();
        return result;
    }

    public byte[] getBytesForAbstractHisMessage(AbstractMessage message) throws Exception {
        short msgCode = this.classToMsgTypeMap.get(message.getClass());
        HisMessageSerDes serdes = this.serdesMap.get(msgCode);
        byte[] data = serdes.serialize(message);
        byte[] msg = HisNetworkMessageWrapperUnWrapper.wrapMessageBytes(data, msgCode);
        return msg;
    }

    public AbstractMessage parseMessage(short messageType, byte[] array) throws Exception {
        HisMessageSerDes serdes = this.serdesMap.get(messageType);
        if (serdes != null) {
            return serdes.fromByteArray(array);
        }
        return null;
    }

    public static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    private static class SimpleCommandMessageSerDes
    implements HisMessageSerDes<SimpleCommandMessage> {
        final int msgLength = 4;

        private SimpleCommandMessageSerDes() {
        }

        @Override
        public SimpleCommandMessage fromByteArray(byte[] messagebytes) {
            ByteBuffer bytes = ByteBuffer.wrap(messagebytes).order(BYTE_ORDER_RECEIVING);
            int cmd = bytes.getInt();
            return new SimpleCommandMessage(cmd);
        }

        @Override
        public byte[] serialize(SimpleCommandMessage message) {
            byte[] data = ByteBuffer.allocate(4).order(FAB8_MessageTranslator.BYTE_ORDER_SENDING).putInt(message.getCommandCodeNumber()).array();
            return data;
        }
    }

    static interface HisMessageSerDes<T extends AbstractMessage> {
        public T fromByteArray(byte[] var1) throws MessageDeSerializationException;

        public byte[] serialize(T var1) throws MessageSerializationException;
    }

    private static class SimpleCommandWithStringMessageSerDes
    implements HisMessageSerDes<SimpleCommandWithStringArgumentMessage> {
        static final Charset encoding = Charset.forName("UTF-8");

        private SimpleCommandWithStringMessageSerDes() {
        }

        @Override
        public SimpleCommandWithStringArgumentMessage fromByteArray(byte[] messagebytes) {
            ByteBuffer bytes = ByteBuffer.wrap(messagebytes).order(BYTE_ORDER_RECEIVING);
            int cmd = bytes.getInt();
            byte[] txtBytes = new byte[messagebytes.length - 4];
            bytes.get(4, txtBytes);
            String txt = new String(txtBytes, encoding);
            return new SimpleCommandWithStringArgumentMessage(cmd, txt);
        }

        @Override
        public byte[] serialize(SimpleCommandWithStringArgumentMessage message) {
            byte[] stringbytes = message.getArgumentString().getBytes(encoding);
            int msgLength = 4 + stringbytes.length;
            byte[] data = ByteBuffer.allocate(msgLength).order(BYTE_ORDER_SENDING).putInt(message.getCommandCodeNumber()).put(stringbytes).array();
            return data;
        }
    }

    private static class SimpleCommandWithFloatArgumentMessageSerDes
    implements HisMessageSerDes<SimpleCommandWithFloatArgumentMessage> {
        final int msgLength = 8;

        private SimpleCommandWithFloatArgumentMessageSerDes() {
        }

        @Override
        public SimpleCommandWithFloatArgumentMessage fromByteArray(byte[] messagebytes) {
            ByteBuffer bytes = ByteBuffer.wrap(messagebytes).order(BYTE_ORDER_RECEIVING);
            int cmd = bytes.getInt();
            float f = bytes.getFloat();
            return new SimpleCommandWithFloatArgumentMessage(cmd, f);
        }

        @Override
        public byte[] serialize(SimpleCommandWithFloatArgumentMessage message) {
            byte[] data = ByteBuffer.allocate(8).order(BYTE_ORDER_SENDING).putInt(message.getCommandCodeNumber()).putFloat(message.getFloat()).array();
            return data;
        }
    }

    private static class SimpleCommandWithIntegerArgumentsMessageSerDes
    implements HisMessageSerDes<SimpleCommandWithIntegerArgumentsMessage> {
        final int msgLength = 20;

        private SimpleCommandWithIntegerArgumentsMessageSerDes() {
        }

        @Override
        public SimpleCommandWithIntegerArgumentsMessage fromByteArray(byte[] messagebytes) {
            ByteBuffer bytes = ByteBuffer.wrap(messagebytes).order(BYTE_ORDER_RECEIVING);
            int cmd = bytes.getInt();
            int i1 = bytes.getInt();
            int i2 = bytes.getInt();
            int i3 = bytes.getInt();
            int i4 = bytes.getInt();
            return new SimpleCommandWithIntegerArgumentsMessage(cmd, i1, i2, i3, i4);
        }

        @Override
        public byte[] serialize(SimpleCommandWithIntegerArgumentsMessage message) {
            byte[] data = ByteBuffer.allocate(20).order(FAB8_MessageTranslator.BYTE_ORDER_SENDING).putInt(message.getCommandCodeNumber()).putInt(message.getArgs()[0]).putInt(message.getArgs()[1]).putInt(message.getArgs()[2]).putInt(message.getArgs()[3]).array();
            return data;
        }
    }

    private static class FileMessageSerDes
    implements HisMessageSerDes<FileMessage> {
        static final Charset encoding = Charset.forName("UTF-8");
        static final String partSeparator = "<-SEP->";

        private FileMessageSerDes() {
        }

        @Override
        public FileMessage fromByteArray(byte[] messagebytes) {
            ByteBuffer bytes = ByteBuffer.wrap(messagebytes).order(BYTE_ORDER_RECEIVING);
            int cmd = bytes.getInt();
            byte[] txtBytes = new byte[messagebytes.length - 4];
            bytes.get(4, txtBytes);
            String txt = new String(txtBytes, encoding);
            String[] parts = StringUtils.splitByWholeSeparator(txt, partSeparator);
            int cmdCode = cmd;
            String directory = parts[0];
            String filename = parts[1];
            String typeEnumString = parts[2];
            String options = parts[3];
            return new FileMessage(cmdCode, directory, filename, typeEnumString, options);
        }

        @Override
        public byte[] serialize(FileMessage message) {
            return null;
        }
    }

    static abstract class HisNetworkMessageWrapperUnWrapper {
        HisNetworkMessageWrapperUnWrapper() {
        }

        public static byte[] wrapMessageBytes(byte[] messageDataWithoutHeaderInfosBytes, short messageType) {
            int headLength = 2;
            short type = messageType;
            short messageLength = (short)messageDataWithoutHeaderInfosBytes.length;
            byte[] completeMessage = ByteBuffer.allocate(headLength + messageLength).order(BYTE_ORDER_SENDING).putShort(type).put(messageDataWithoutHeaderInfosBytes).array();
            return completeMessage;
        }
    }
}

