/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.network.transport.fab8;

import com.hybridlab.hyve3d.core.FrameRect;
import com.hybridlab.hyve3d.core.StrokeId;
import com.hybridlab.hyve3d.core.StrokeInk;
import com.hybridlab.hyve3d.core.commands.Command;
import com.hybridlab.hyve3d.core.commands.CommandFactory;
import com.hybridlab.hyve3d.network.messages.AbstractHisMessage;
import com.hybridlab.hyve3d.network.messages.ByteMessage;
import com.hybridlab.hyve3d.network.messages.CommandMessage;
import com.hybridlab.hyve3d.network.messages.FrameRectDefinitionMessage;
import com.hybridlab.hyve3d.network.messages.JsonMessage;
import com.hybridlab.hyve3d.network.messages.Move2DMessage;
import com.hybridlab.hyve3d.network.messages.Move3DMessage;
import com.hybridlab.hyve3d.network.messages.PinchPointsMessage;
import com.hybridlab.hyve3d.network.messages.Pointing2DTransmissionPartMessage;
import com.hybridlab.hyve3d.network.messages.SatelliteSessionSetupMessage;
import com.hybridlab.hyve3d.network.messages.SpaceMouseMessage;
import com.hybridlab.hyve3d.network.messages.Stroke2DTransmissionPartMessage;
import com.hybridlab.hyve3d.network.messages.StrokeInkMessage;
import com.hybridlab.hyve3d.network.messages.TextMessage;
import com.hybridlab.hyve3d.network.messages.TransformMessage;
import com.hybridlab.hyve3d.network.messages.ZoomMessage;
import com.hybridlab.hyve3d.network.transport.fab8.FrameReceiveErrorException;
import com.hybridlab.hyve3d.network.transport.fab8.MessageDeSerializationException;
import com.hybridlab.hyve3d.network.transport.fab8.MessageSerializationException;
import com.hybridlab.hyve3d.satellitecenter.SessionID;
import com.hybridlab.utils.ByteUtils;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class FAB8_MessageTranslator {
    Logger logger = Logger.getLogger(FAB8_MessageTranslator.class.getSimpleName());
    public static final ByteOrder BYTE_ORDER_RECEIVING = ByteOrder.BIG_ENDIAN;
    public static final ByteOrder BYTE_ORDER_SENDING = ByteOrder.BIG_ENDIAN;
    public static final byte ENCODING_TYPE_SHORT = 2;
    public static final short MESSAGE_CODE_BYTE_MESSAGE = 0;
    public static final short MESSAGE_CODE_SPACEMOUSE_MESSAGE = 1;
    public static final short MESSAGE_CODE_SATELLITE_SESSION_SETUP_MESSAGE = 2;
    public static final short MESSAGE_CODE_TEXT_MESSAGE = 3;
    public static final short MESSAGE_CODE_JSON_MESSAGE = 4;
    public static final short MESSAGE_CODE_MOVE3D_MESSAGE = 5;
    public static final short MESSAGE_CODE_MOVE2D_MESSAGE = 6;
    public static final short MESSAGE_CODE_ZOOM_MESSAGE = 7;
    public static final short MESSAGE_CODE_POINTING_TRANSMISSION = 9;
    public static final short MESSAGE_CODE_STROKE_TRANSMISSION = 16;
    public static final short MESSAGE_CODE_TRANSFORM_MESSAGE = 17;
    public static final short MESSAGE_CODE_STROKE_INK_MESSAGE = 32;
    public static final short MESSAGE_CODE_FRAMERECT_DEFINIITON_MESSAGE = 48;
    public static final short MESSAGE_CODE_COMMAND_MESSAGE = 256;
    public static final short MESSAGE_CODE_PINCHPOINTS_MESSAGE = 291;
    private ByteMessageSerDes bmserdes = new ByteMessageSerDes();
    private Map<Short, HisMessageSerDes> serdesMap = new HashMap<Short, HisMessageSerDes>();
    private Map<Class, Short> classToMsgTypeMap = new HashMap<Class, Short>();
    static final byte[] controlbytes = ByteUtils.hexToBytes("F8FAFE");
    public static final byte SHIFT = controlbytes[0];
    public static final byte START = controlbytes[1];
    public static final byte STOP = controlbytes[2];
    Map<Byte, Byte> escapeTable = new HashMap<Byte, Byte>();
    Map<Byte, Byte> inverseEcapeTable = new HashMap<Byte, Byte>();
    protected static final char[] hexArray = "0123456789ABCDEF".toCharArray();

    public FAB8_MessageTranslator() {
        this.bmserdes = new ByteMessageSerDes();
        this.register(ByteMessage.class, this.bmserdes, (short)0);
        this.register(SpaceMouseMessage.class, new SpaceMouseMessageSerDes(), (short)1);
        this.register(SatelliteSessionSetupMessage.class, new SatelliteSessionSetupMessageSerDes(), (short)2);
        this.register(TextMessage.class, new TextMessageSerDes(), (short)3);
        this.register(JsonMessage.class, new JsonMessageSerDes(), (short)4);
        this.register(TransformMessage.class, new TransformMessageSerDes(), (short)17);
        this.register(Stroke2DTransmissionPartMessage.class, new Stroke2DTransmissionPartMessageSerDes(), (short)16);
        this.register(Pointing2DTransmissionPartMessage.class, new Pointing2DTransmissionPartMessageSerDes(), (short)9);
        this.register(Move2DMessage.class, new Move2DMessageSerDes(), (short)6);
        this.register(Move3DMessage.class, new Move3DMessageSerDes(), (short)5);
        this.register(StrokeInkMessage.class, new StrokeInkMessageSerDes(), (short)32);
        this.register(ZoomMessage.class, new ZoomMessageSerDes(), (short)7);
        this.register(FrameRectDefinitionMessage.class, new FrameRectDefinitionMessageSerDes(), (short)48);
        this.register(CommandMessage.class, new CommandMessageSerDes(), (short)256);
        this.register(PinchPointsMessage.class, new PinchPointsMessageSerDes(), (short)291);
        this.escapeTable.put(SHIFT, (byte)0);
        this.escapeTable.put(START, (byte)1);
        this.escapeTable.put(STOP, (byte)2);
        this.inverseEcapeTable.put((byte)0, SHIFT);
        this.inverseEcapeTable.put((byte)1, START);
        this.inverseEcapeTable.put((byte)2, STOP);
    }

    void register(Class c, HisMessageSerDes serDes, short messageCode) {
        this.classToMsgTypeMap.put(c, messageCode);
        this.serdesMap.put(messageCode, serDes);
    }

    public byte getControlByteForEscapeByte(byte escapeByte) throws FrameReceiveErrorException {
        if (!this.inverseEcapeTable.containsKey(escapeByte)) {
            throw new FrameReceiveErrorException("No substitution for escape byte " + ByteMessage.bytesToHex(new byte[]{escapeByte}) + " found!");
        }
        return this.inverseEcapeTable.get(escapeByte);
    }

    /*
     * WARNING - void declaration
     */
    public byte[] wrapBytesForAbstractHisMessageIntoFrame(byte[] bytesOfHisMessage) {
        void var6_13;
        byte[] escapedFramelengthLower;
        void var6_10;
        int numextra = 0;
        for (byte by : bytesOfHisMessage) {
            if (by != SHIFT && by != START && by != STOP) continue;
            numextra = (short)(numextra + 1);
        }
        ByteBuffer completeEscapedHisMessage = ByteBuffer.allocate(bytesOfHisMessage.length + numextra);
        byte[] byArray = bytesOfHisMessage;
        int n = byArray.length;
        boolean bl = false;
        while (var6_10 < n) {
            byte b1 = byArray[var6_10];
            if (b1 == SHIFT) {
                completeEscapedHisMessage.put(SHIFT).put(this.escapeTable.get(SHIFT));
            } else if (b1 == START) {
                completeEscapedHisMessage.put(SHIFT).put(this.escapeTable.get(START));
            } else if (b1 == STOP) {
                completeEscapedHisMessage.put(SHIFT).put(this.escapeTable.get(STOP));
            } else {
                completeEscapedHisMessage.put(b1);
            }
            ++var6_10;
        }
        byte[] completeEscapedHisMessageArray = completeEscapedHisMessage.array();
        byte[] framelengthBytes = ByteBuffer.allocate(2).order(BYTE_ORDER_SENDING).putShort((short)(completeEscapedHisMessageArray.length + 1)).array();
        if (framelengthBytes[0] == SHIFT || framelengthBytes[0] == START || framelengthBytes[0] == STOP) {
            byte[] byArray2 = new byte[]{SHIFT, this.escapeTable.get(framelengthBytes[0])};
        } else {
            byte[] byArray3 = new byte[]{framelengthBytes[0]};
        }
        if (framelengthBytes[1] == SHIFT || framelengthBytes[1] == START || framelengthBytes[1] == STOP) {
            escapedFramelengthLower = new byte[2];
            escapedFramelengthLower[0] = SHIFT;
            escapedFramelengthLower[0] = this.escapeTable.get(framelengthBytes[1]);
        } else {
            escapedFramelengthLower = new byte[]{framelengthBytes[1]};
        }
        ByteBuffer completeFrame = ByteBuffer.allocate(completeEscapedHisMessage.limit() + ((void)var6_13).length + escapedFramelengthLower.length + 2);
        byte[] result = completeFrame.order(BYTE_ORDER_SENDING).put(START).put((byte[])var6_13).put(escapedFramelengthLower).put(completeEscapedHisMessageArray).put(STOP).array();
        return result;
    }

    public byte[] getBytesForAbstractHisMessage(AbstractHisMessage message) throws Exception {
        short msgCode = this.classToMsgTypeMap.get(message.getClass());
        HisMessageSerDes serdes = this.serdesMap.get(msgCode);
        byte[] data = serdes.serialize(message);
        byte[] msg = HisNetworkMessageWrapperUnWrapper.wrapMessageBytes(data, msgCode);
        return msg;
    }

    public AbstractHisMessage parseMessage(short messageType, byte[] array) throws Exception {
        HisMessageSerDes serdes = this.serdesMap.get(messageType);
        if (serdes != null) {
            return serdes.fromByteArray(array);
        }
        return this.bmserdes.fromByteArray(array);
    }

    public static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    private class ByteMessageSerDes
    implements HisMessageSerDes<ByteMessage> {
        private ByteMessageSerDes() {
        }

        @Override
        public ByteMessage fromByteArray(byte[] messagebytes) {
            return new ByteMessage(messagebytes);
        }

        @Override
        public byte[] serialize(ByteMessage message) {
            return ByteBuffer.wrap(message.getData()).order(BYTE_ORDER_SENDING).array();
        }
    }

    static interface HisMessageSerDes<T extends AbstractHisMessage> {
        public T fromByteArray(byte[] var1) throws MessageDeSerializationException;

        public byte[] serialize(T var1) throws MessageSerializationException;
    }

    private class SpaceMouseMessageSerDes
    implements HisMessageSerDes<SpaceMouseMessage> {
        final int msgLength = 32;

        private SpaceMouseMessageSerDes() {
        }

        @Override
        public SpaceMouseMessage fromByteArray(byte[] messagebytes) {
            Vector3f translation = Vector3f.ZERO.clone();
            Vector3f rotation = Vector3f.ZERO.clone();
            int buttonstate = 0;
            ByteBuffer bytes = ByteBuffer.wrap(messagebytes).order(BYTE_ORDER_RECEIVING);
            int msgID = bytes.getInt();
            translation.x = bytes.getFloat();
            translation.y = bytes.getFloat();
            translation.z = bytes.getFloat();
            rotation.x = bytes.getFloat();
            rotation.y = bytes.getFloat();
            rotation.z = bytes.getFloat();
            buttonstate = bytes.getInt();
            SpaceMouseMessage deSerialized = new SpaceMouseMessage(translation, rotation, buttonstate);
            return deSerialized;
        }

        @Override
        public byte[] serialize(SpaceMouseMessage m) {
            int msgId = 1;
            Vector3f translation = m.getTranslation();
            Vector3f rotation = m.getRotation();
            int buttonstate = m.getButtonstate();
            byte[] data = ByteBuffer.allocate(32).order(BYTE_ORDER_SENDING).putInt(msgId).putFloat(translation.x).putFloat(translation.y).putFloat(translation.z).putFloat(rotation.x).putFloat(rotation.y).putFloat(rotation.z).putInt(buttonstate).array();
            return data;
        }
    }

    private class SatelliteSessionSetupMessageSerDes
    implements HisMessageSerDes<SatelliteSessionSetupMessage> {
        final JsonMessageSerDes jsonSerDes;
        static final String KEY_SESSION_ID = "sidstr";
        static final String KEY_SATELLITE_DEVICE_ID = "didstr";
        static final String KEY_SATELLITE_DEVICE_NAME = "deviceName";
        static final String KEY_SATELLITE_VERSION = "satelliteVersion";
        static final String KEY_SATELLITE_DESIRED_FRAMERECT = "framerect";
        static final String KEY_SATELLITE_IS_TRACKING_ENABLED = "isTrackingEnabled";
        static final String KEY_SATELLITE_TRACKING_IDENTIFIER = "trackingIdentifier";

        private SatelliteSessionSetupMessageSerDes() {
            this.jsonSerDes = new JsonMessageSerDes();
        }

        @Override
        public SatelliteSessionSetupMessage fromByteArray(byte[] messagebytes) throws MessageDeSerializationException {
            SatelliteSessionSetupMessage deSerialized;
            JSONObject jo;
            JsonMessage jsonMessage = this.jsonSerDes.fromByteArray(messagebytes);
            try {
                jo = jsonMessage.getJsonObject();
            }
            catch (JSONException e1) {
                throw new MessageDeSerializationException("JSONException while analyzing SatelliteSessionSetupMessage", (Exception)((Object)e1));
            }
            try {
                SessionID sid = new SessionID(jo.getString(KEY_SESSION_ID));
                deSerialized = new SatelliteSessionSetupMessage(sid);
            }
            catch (JSONException e) {
                throw new MessageDeSerializationException("No Session Id found while analyzing SatelliteSessionSetupMessage", (Exception)((Object)e));
            }
            try {
                String deviceID = jo.getString(KEY_SATELLITE_DEVICE_ID);
                deSerialized.setSatelliteDeviceId(deviceID);
            }
            catch (JSONException deviceID) {
                // empty catch block
            }
            try {
                String deviceName = jo.getString(KEY_SATELLITE_DEVICE_NAME);
                deSerialized.setDeviceName(deviceName);
            }
            catch (JSONException deviceName) {
                // empty catch block
            }
            try {
                String version = jo.getString(KEY_SATELLITE_VERSION);
                deSerialized.setVersion(version);
            }
            catch (JSONException e) {
                deSerialized.setVersion("pre A l b e r t i 0 . 3 . 13");
            }
            try {
                String tid = jo.getString(KEY_SATELLITE_TRACKING_IDENTIFIER);
                deSerialized.setTrackingIdentifier(tid);
            }
            catch (JSONException tid) {
                // empty catch block
            }
            try {
                Boolean te = jo.getBoolean(KEY_SATELLITE_IS_TRACKING_ENABLED);
                deSerialized.setIsTrackingEnabled(te);
            }
            catch (JSONException te) {
                // empty catch block
            }
            JSONObject jFrameRect = null;
            try {
                jFrameRect = jo.getJSONObject(KEY_SATELLITE_DESIRED_FRAMERECT);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            if (jFrameRect != null) {
                try {
                    FrameRect r = FrameRect.fromJSONObject(jFrameRect);
                    deSerialized.setDesiredFrameRect(r);
                }
                catch (JSONException e) {
                    throw new MessageDeSerializationException("JSONException while parsing FrameRect in SatelliteSessionSetupMessage", (Exception)((Object)e));
                }
            }
            return deSerialized;
        }

        @Override
        public byte[] serialize(SatelliteSessionSetupMessage m) throws MessageSerializationException {
            JSONObject j = this.messageToJson(m);
            byte[] data = this.jsonSerDes.serialize(new JsonMessage(j));
            return data;
        }

        public JSONObject messageToJson(SatelliteSessionSetupMessage m) throws MessageSerializationException {
            JSONObject j = new JSONObject();
            try {
                SessionID sid = m.getSessionId();
                j.put(KEY_SESSION_ID, (Object)sid.toString());
                if (m.hasSatelliteDeviceId()) {
                    j.put(KEY_SATELLITE_DEVICE_ID, (Object)m.getSatelliteDeviceId());
                }
                if (m.hasFrameRect()) {
                    j.put(KEY_SATELLITE_DESIRED_FRAMERECT, (Object)m.getDesiredFrameRect().asJSONObject());
                }
                if (m.hasTrackingInfo()) {
                    j.put(KEY_SATELLITE_IS_TRACKING_ENABLED, (Object)m.getIsTrackingEnabled());
                    j.put(KEY_SATELLITE_TRACKING_IDENTIFIER, (Object)m.getTrackingIdentifier());
                }
            }
            catch (SatelliteSessionSetupMessage.NoSessionIdException e) {
                throw new MessageSerializationException("No SessionId defined during SatelliteSessionSetupMessage Serialization", e);
            }
            catch (JSONException e) {
                throw new MessageSerializationException("JSONException during SatelliteSessionSetupMessage Serialization", (Exception)((Object)e));
            }
            catch (SatelliteSessionSetupMessage.NoSatelliteDeviceIdException e) {
                throw new MessageSerializationException("No SatelliteDeviceId defined during SatelliteSessionSetupMessage Serialization but necessary", e);
            }
            catch (SatelliteSessionSetupMessage.NoFrameRectException e) {
                throw new MessageSerializationException("No FrameRect defined during SatelliteSessionSetupMessage Serialization but necessary", e);
            }
            return j;
        }
    }

    private class TextMessageSerDes
    implements HisMessageSerDes<TextMessage> {
        final Charset encoding = Charset.forName("UTF-8");

        private TextMessageSerDes() {
        }

        @Override
        public TextMessage fromByteArray(byte[] messagebytes) {
            byte[] txtBytes = messagebytes;
            String txt = new String(txtBytes, this.encoding);
            TextMessage deSerialized = new TextMessage(txt);
            return deSerialized;
        }

        @Override
        public byte[] serialize(TextMessage m) {
            byte[] data = ByteBuffer.wrap(m.getMessage().getBytes(this.encoding)).order(BYTE_ORDER_SENDING).array();
            return data;
        }
    }

    private class JsonMessageSerDes
    implements HisMessageSerDes<JsonMessage> {
        private Logger logger = Logger.getLogger(JsonMessageSerDes.class.getSimpleName());
        final Charset encoding = Charset.forName("UTF-8");

        private JsonMessageSerDes() {
        }

        @Override
        public JsonMessage fromByteArray(byte[] messagebytes) throws MessageDeSerializationException {
            byte[] txtBytes = messagebytes;
            String txt = new String(txtBytes, this.encoding);
            return new JsonMessage(txt);
        }

        @Override
        public byte[] serialize(JsonMessage message) throws MessageSerializationException {
            byte[] data = ByteBuffer.wrap(message.getJsonString().getBytes(this.encoding)).order(BYTE_ORDER_SENDING).array();
            return data;
        }
    }

    private class TransformMessageSerDes
    implements HisMessageSerDes<TransformMessage> {
        private TransformMessageSerDes() {
        }

        @Override
        public TransformMessage fromByteArray(byte[] messagebytes) throws MessageDeSerializationException {
            ByteBuffer bytes = ByteBuffer.wrap(messagebytes).order(BYTE_ORDER_RECEIVING);
            short subTypeValue = bytes.getShort();
            TransformMessage.SubType subType = TransformMessage.SubType.getFromShort(subTypeValue);
            switch (subType) {
                case ROTATION_QUATERNION: 
                case GLOBAL_ROTATION_QUATERNION: {
                    float x = (float)bytes.getDouble();
                    float y = (float)bytes.getDouble();
                    float z = (float)bytes.getDouble();
                    float w = (float)bytes.getDouble();
                    Quaternion q = new Quaternion(x, y, z, w);
                    TransformMessage deSerialized = new TransformMessage(q);
                    return deSerialized;
                }
                case ROTATION_QUATERNION_AND_ROTATION_POINTS: 
                case GLOBAL_ROTATION_QUATERNION_AND_ROTATION_POINTS: {
                    float x = (float)bytes.getDouble();
                    float y = (float)bytes.getDouble();
                    float z = (float)bytes.getDouble();
                    float w = (float)bytes.getDouble();
                    Quaternion q = new Quaternion(x, y, z, w);
                    TransformMessage deSerialized = new TransformMessage(q);
                    short numpivots = bytes.getShort();
                    Vector2f[] pivots = new Vector2f[numpivots];
                    for (short i = 0; i < numpivots; i = (short)(i + 1)) {
                        float px = bytes.getFloat();
                        float py = bytes.getFloat();
                        pivots[i] = new Vector2f(px, py);
                    }
                    deSerialized.setPivotPoints(pivots);
                    return deSerialized;
                }
            }
            throw new MessageDeSerializationException("no valid subtype given for TransformMessage");
        }

        @Override
        public byte[] serialize(TransformMessage m) {
            ByteBuffer buf = null;
            switch (m.getType()) {
                case ROTATION_QUATERNION: {
                    buf = ByteBuffer.allocate(34).order(BYTE_ORDER_SENDING);
                    buf.putShort(m.getType().getCode());
                    Quaternion q = m.getQuaternion();
                    buf.putDouble(q.getX()).putDouble(q.getY()).putDouble(q.getZ()).putDouble(q.getW());
                    return buf.array();
                }
            }
            new Exception("Serialization for Subtype missing in " + m.getClass().getSimpleName() + ".").printStackTrace();
            return new byte[0];
        }
    }

    private class Stroke2DTransmissionPartMessageSerDes
    implements HisMessageSerDes<Stroke2DTransmissionPartMessage> {
        private StrokeId currentStrokeId = null;

        private Stroke2DTransmissionPartMessageSerDes() {
        }

        @Override
        public Stroke2DTransmissionPartMessage fromByteArray(byte[] messagebytes) throws MessageDeSerializationException {
            ByteBuffer bytes = ByteBuffer.wrap(messagebytes).order(BYTE_ORDER_RECEIVING);
            short subTypeValue = bytes.getShort();
            Stroke2DTransmissionPartMessage.SubType subType = Stroke2DTransmissionPartMessage.SubType.getFromShort(subTypeValue);
            StrokeId sid = new StrokeId();
            int numPoints = 0;
            short inkStringLength = 0;
            StrokeInk ink = null;
            switch (subType) {
                case COMPLETE: {
                    byte[] uuidbytes = new byte[16];
                    bytes.get(uuidbytes);
                    sid = StrokeId.fromUUIDBytes(uuidbytes);
                    inkStringLength = bytes.getShort();
                    if (inkStringLength > 0) {
                        byte[] inkBytes = new byte[inkStringLength];
                        bytes.get(inkBytes);
                        StrokeInkMessageSerDes inkserdes = new StrokeInkMessageSerDes();
                        StrokeInkMessage msg = inkserdes.fromByteArray(inkBytes);
                        ink = StrokeInkMessage.toStrokeInk(msg);
                    }
                    numPoints = bytes.getShort();
                    Vector2f[] points = new Vector2f[numPoints];
                    short[] pressures = new short[numPoints];
                    for (int i = 0; i < numPoints; ++i) {
                        short pressure;
                        pressures[i] = pressure = bytes.getShort();
                        float x = bytes.getFloat();
                        float y = bytes.getFloat();
                        points[i] = new Vector2f(x, y);
                    }
                    Stroke2DTransmissionPartMessage deSerialized = ink != null ? new Stroke2DTransmissionPartMessage(sid, points, pressures, subType, ink) : new Stroke2DTransmissionPartMessage(sid, points, pressures, subType);
                    return deSerialized;
                }
                case BEGIN: {
                    byte[] uuidbytes = new byte[16];
                    bytes.get(uuidbytes);
                    this.currentStrokeId = sid = StrokeId.fromUUIDBytes(uuidbytes);
                    inkStringLength = bytes.getShort();
                    if (inkStringLength > 0) {
                        byte[] inkBytes = new byte[inkStringLength];
                        bytes.get(inkBytes);
                        StrokeInkMessageSerDes inkserdes = new StrokeInkMessageSerDes();
                        StrokeInkMessage msg = inkserdes.fromByteArray(inkBytes);
                        ink = StrokeInkMessage.toStrokeInk(msg);
                    }
                    numPoints = 1;
                    Vector2f[] points = new Vector2f[numPoints];
                    short[] pressures = new short[numPoints];
                    for (int i = 0; i < numPoints; ++i) {
                        short pressure;
                        pressures[i] = pressure = bytes.getShort();
                        float x = bytes.getFloat();
                        float y = bytes.getFloat();
                        points[i] = new Vector2f(x, y);
                    }
                    Stroke2DTransmissionPartMessage deSerialized = ink != null ? new Stroke2DTransmissionPartMessage(sid, points, pressures, subType, ink) : new Stroke2DTransmissionPartMessage(sid, points, pressures, subType);
                    return deSerialized;
                }
                case ADD: {
                    numPoints = bytes.getShort();
                    Vector2f[] points = new Vector2f[numPoints];
                    short[] pressures = new short[numPoints];
                    for (int i = 0; i < numPoints; ++i) {
                        short pressure;
                        pressures[i] = pressure = bytes.getShort();
                        float x = bytes.getFloat();
                        float y = bytes.getFloat();
                        points[i] = new Vector2f(x, y);
                    }
                    Stroke2DTransmissionPartMessage deSerialized = new Stroke2DTransmissionPartMessage(this.currentStrokeId, points, pressures, subType);
                    return deSerialized;
                }
                case END: {
                    numPoints = 1;
                    Vector2f[] points = new Vector2f[numPoints];
                    short[] pressures = new short[numPoints];
                    for (int i = 0; i < numPoints; ++i) {
                        short pressure;
                        pressures[i] = pressure = bytes.getShort();
                        float x = bytes.getFloat();
                        float y = bytes.getFloat();
                        points[i] = new Vector2f(x, y);
                    }
                    Stroke2DTransmissionPartMessage deSerialized = new Stroke2DTransmissionPartMessage(this.currentStrokeId, points, pressures, subType);
                    return deSerialized;
                }
            }
            throw new RuntimeException();
        }

        @Override
        public byte[] serialize(Stroke2DTransmissionPartMessage m) throws MessageSerializationException {
            Vector2f[] points = m.getPoints();
            short[] pressures = m.getPressures();
            ByteBuffer byteBuffer = null;
            switch (m.getType()) {
                case COMPLETE: {
                    int messageLength = 2;
                    messageLength += 2;
                    messageLength += 10 * points.length;
                    messageLength += 16;
                    messageLength += 2;
                    StrokeInk ink = m.getInk();
                    short inkMessageLength = 0;
                    byte[] inkMessage = null;
                    if (ink != null) {
                        StrokeInkMessage msg = StrokeInkMessage.fromStrokeInk(ink);
                        StrokeInkMessageSerDes des = new StrokeInkMessageSerDes();
                        inkMessage = des.serialize(msg);
                        inkMessageLength = (short)inkMessage.length;
                        messageLength += inkMessageLength;
                    }
                    byteBuffer = ByteBuffer.allocate(messageLength).order(BYTE_ORDER_SENDING);
                    byteBuffer.putShort(m.getType().getCode());
                    byteBuffer.put(m.getStrokeId().getUuidBytes());
                    byteBuffer.putShort(inkMessageLength);
                    if (inkMessageLength > 0) {
                        byteBuffer.put(inkMessage);
                    }
                    byteBuffer.putShort((short)points.length);
                    for (int i = 0; i < points.length; ++i) {
                        byteBuffer.putShort(pressures[i]);
                        Vector2f p = points[i];
                        byteBuffer.putFloat(p.x).putFloat(p.y);
                    }
                    return byteBuffer.array();
                }
            }
            new Exception("Serialization for Subtype missing in " + m.getClass().getSimpleName() + ".").printStackTrace();
            return new byte[0];
        }
    }

    private class Pointing2DTransmissionPartMessageSerDes
    implements HisMessageSerDes<Pointing2DTransmissionPartMessage> {
        private int dummyStrokeCounter = 0;

        private Pointing2DTransmissionPartMessageSerDes() {
        }

        @Override
        public Pointing2DTransmissionPartMessage fromByteArray(byte[] messagebytes) {
            ByteBuffer bytes = ByteBuffer.wrap(messagebytes).order(BYTE_ORDER_RECEIVING);
            short subTypeValue = bytes.getShort();
            Pointing2DTransmissionPartMessage.SubType subType = Pointing2DTransmissionPartMessage.SubType.getFromShort(subTypeValue);
            int numPoints = 0;
            numPoints = subType.equals((Object)Pointing2DTransmissionPartMessage.SubType.ADD) ? bytes.getShort() : 1;
            Vector2f[] points = new Vector2f[numPoints];
            for (int i = 0; i < numPoints; ++i) {
                float x = bytes.getFloat();
                float y = bytes.getFloat();
                points[i] = new Vector2f(x, y);
            }
            if (subType.equals((Object)Pointing2DTransmissionPartMessage.SubType.BEGIN)) {
                ++this.dummyStrokeCounter;
            }
            if (subType.equals((Object)Pointing2DTransmissionPartMessage.SubType.END)) {
                // empty if block
            }
            Pointing2DTransmissionPartMessage deSerialized = new Pointing2DTransmissionPartMessage(points, subType);
            return deSerialized;
        }

        @Override
        public byte[] serialize(Pointing2DTransmissionPartMessage message) throws MessageSerializationException {
            throw new MessageSerializationException("Serialization of " + Pointing2DTransmissionPartMessage.class.getName() + " not supperted yet.");
        }
    }

    private class Move2DMessageSerDes
    implements HisMessageSerDes<Move2DMessage> {
        private Move2DMessageSerDes() {
        }

        @Override
        public Move2DMessage fromByteArray(byte[] messagebytes) throws MessageDeSerializationException {
            ByteBuffer bytes = ByteBuffer.wrap(messagebytes).order(BYTE_ORDER_RECEIVING);
            short subTypeValue = bytes.getShort();
            Move2DMessage.Type subType = Move2DMessage.Type.getFromShort(subTypeValue);
            float x = (float)bytes.getDouble();
            float y = (float)bytes.getDouble();
            Vector2f v = new Vector2f(x, y);
            if (bytes.hasRemaining()) {
                Move2DMessage.State state = Move2DMessage.State.getFromByte(bytes.get());
                Move2DMessage deSerialized = new Move2DMessage(subType, v, state);
                return deSerialized;
            }
            Move2DMessage deSerialized = new Move2DMessage(subType, v, null);
            return deSerialized;
        }

        @Override
        public byte[] serialize(Move2DMessage m) {
            ByteBuffer buf = null;
            buf = ByteBuffer.allocate(18).order(BYTE_ORDER_SENDING);
            buf.putShort(m.getType().getCode());
            Vector2f v = m.getVector();
            buf.putDouble(v.getX()).putDouble(v.getY());
            return buf.array();
        }
    }

    private class Move3DMessageSerDes
    implements HisMessageSerDes<Move3DMessage> {
        private Move3DMessageSerDes() {
        }

        @Override
        public Move3DMessage fromByteArray(byte[] messagebytes) throws MessageDeSerializationException {
            ByteBuffer bytes = ByteBuffer.wrap(messagebytes).order(BYTE_ORDER_RECEIVING);
            short subTypeValue = bytes.getShort();
            Move3DMessage.Type subType = Move3DMessage.Type.getFromShort(subTypeValue);
            if (subType.equals((Object)Move3DMessage.Type.TYPE_ABSOLUTE_DEVICE_ACCELEROMETERBASED_METER) || subType.equals((Object)Move3DMessage.Type.TYPE_RELATIVE_HYDRA_BASED)) {
                float x = (float)bytes.getDouble();
                float y = (float)bytes.getDouble();
                float z = (float)bytes.getDouble();
                Vector3f v = new Vector3f(x, y, z);
                Move3DMessage deSerialized = new Move3DMessage(subType, v);
                return deSerialized;
            }
            throw new MessageDeSerializationException("no valid subtype given for " + Move3DMessage.class.getSimpleName());
        }

        @Override
        public byte[] serialize(Move3DMessage m) {
            ByteBuffer buf = null;
            switch (m.getType()) {
                case TYPE_ABSOLUTE_DEVICE_ACCELEROMETERBASED_METER: 
                case TYPE_RELATIVE_HYDRA_BASED: {
                    buf = ByteBuffer.allocate(14).order(BYTE_ORDER_SENDING);
                    buf.putShort(m.getType().getCode());
                    Vector3f v = m.getVector();
                    buf.putDouble(v.getX()).putDouble(v.getY()).putDouble(v.getZ());
                    return buf.array();
                }
            }
            new Exception("Serialization for Subtype missing in " + m.getClass().getSimpleName() + ".").printStackTrace();
            return new byte[0];
        }
    }

    public class StrokeInkMessageSerDes
    implements HisMessageSerDes<StrokeInkMessage> {
        @Override
        public StrokeInkMessage fromByteArray(byte[] messagebytes) throws MessageDeSerializationException {
            ByteBuffer bytes = ByteBuffer.wrap(messagebytes).order(BYTE_ORDER_RECEIVING);
            if (bytes.capacity() != 15) {
                throw new MessageDeSerializationException("Wrong size of StrokeInkMessage");
            }
            short subTypeValue = bytes.getShort();
            byte red = bytes.get();
            byte green = bytes.get();
            byte blue = bytes.get();
            byte alpha = bytes.get();
            float width = bytes.getFloat();
            float pressurefactor = bytes.getFloat();
            byte style = bytes.get();
            StrokeInkMessage msg = new StrokeInkMessage();
            msg.subType = subTypeValue;
            msg.red = (float)ByteUtils.unsignedToBytes(red) / 255.0f;
            msg.green = (float)ByteUtils.unsignedToBytes(green) / 255.0f;
            msg.blue = (float)ByteUtils.unsignedToBytes(blue) / 255.0f;
            msg.alpha = (float)ByteUtils.unsignedToBytes(alpha) / 255.0f;
            msg.thickness = width;
            msg.pressurefactor = pressurefactor;
            if (style == 0) {
                msg.style = StrokeInk.StrokeStyle.TriangleStrokeTube;
            }
            if (style == 1) {
                msg.style = StrokeInk.StrokeStyle.Line;
            }
            return msg;
        }

        @Override
        public byte[] serialize(StrokeInkMessage message) throws MessageSerializationException {
            ByteBuffer byteBuffer = ByteBuffer.allocate(15).order(BYTE_ORDER_SENDING);
            byteBuffer.putShort(message.subType);
            byteBuffer.put((byte)(message.red * 255.0f));
            byteBuffer.put((byte)(message.green * 255.0f));
            byteBuffer.put((byte)(message.blue * 255.0f));
            byteBuffer.put((byte)(message.alpha * 255.0f));
            byteBuffer.putFloat(message.thickness);
            byteBuffer.putFloat(message.pressurefactor);
            switch (message.style) {
                case Line: {
                    byteBuffer.put((byte)1);
                    break;
                }
                default: {
                    byteBuffer.put((byte)0);
                }
            }
            return byteBuffer.array();
        }
    }

    public class ZoomMessageSerDes
    implements HisMessageSerDes<ZoomMessage> {
        final JsonMessageSerDes jsonSerDes;
        static final String KEY_ID = "id";
        static final String KEY_TYPE = "type";
        static final String KEY_SUBTYPE = "subtype";
        static final String KEY_FRAMERECT = "framerect";
        static final String KEY_ABOLUTE_ZOOM_VALUE = "absoluteZoomValue";
        static final short ZOOM_BEGIN = 0;
        static final short ZOOM_CHANGE = 1;
        static final short ZOOM_END = 17;
        static final short ZOOM_TYPE_1D = 1;

        public ZoomMessageSerDes() {
            this.jsonSerDes = new JsonMessageSerDes();
        }

        @Override
        public ZoomMessage fromByteArray(byte[] messagebytes) throws MessageDeSerializationException {
            try {
                ZoomMessage.SubType st;
                JsonMessage jsonMessage = this.jsonSerDes.fromByteArray(messagebytes);
                JSONObject jo = jsonMessage.getJsonObject();
                int id = jo.optInt(KEY_ID, -1);
                short type = (short)jo.getInt(KEY_TYPE);
                ZoomMessage.Type t = switch (type) {
                    case 1 -> ZoomMessage.Type.ZOOM_1D;
                    default -> throw new MessageDeSerializationException("unknown type while analyzing " + ZoomMessage.class.getName());
                };
                FrameRect fr = null;
                short subtype = (short)jo.getInt(KEY_SUBTYPE);
                switch (subtype) {
                    case 0: {
                        st = ZoomMessage.SubType.ZOOM_BEGIN;
                        fr = FrameRect.fromJSONObject(jo.getJSONObject(KEY_FRAMERECT));
                        break;
                    }
                    case 1: {
                        st = ZoomMessage.SubType.ZOOM_CHANGE;
                        break;
                    }
                    case 17: {
                        st = ZoomMessage.SubType.ZOOM_END;
                        fr = FrameRect.fromJSONObject(jo.getJSONObject(KEY_FRAMERECT));
                        break;
                    }
                    default: {
                        throw new MessageDeSerializationException("unknown type while analyzing " + ZoomMessage.class.getName());
                    }
                }
                ZoomMessage z = new ZoomMessage(id, t, st);
                z.setZoomValue((float)jo.getDouble(KEY_ABOLUTE_ZOOM_VALUE));
                if (null != fr) {
                    z.setFrameRect(fr);
                }
                return z;
            }
            catch (JSONException e1) {
                throw new MessageDeSerializationException("JSONException while analyzing " + ZoomMessage.class.getName(), (Exception)((Object)e1));
            }
        }

        @Override
        public byte[] serialize(ZoomMessage message) throws MessageSerializationException {
            try {
                JSONObject json = new JSONObject();
                json.put(KEY_ID, message.getId());
                switch (message.getType()) {
                    case ZOOM_1D: {
                        json.put(KEY_TYPE, 1);
                        break;
                    }
                    default: {
                        throw new MessageSerializationException("unknown type while serializing " + ZoomMessage.class.getName(), null);
                    }
                }
                switch (message.getSt()) {
                    case ZOOM_BEGIN: {
                        json.put(KEY_SUBTYPE, 0);
                        json.put(KEY_FRAMERECT, (Object)message.getFrameRect().asJSONObject());
                        json.put(KEY_ABOLUTE_ZOOM_VALUE, (double)message.getZoomValue());
                        break;
                    }
                    case ZOOM_END: {
                        json.put(KEY_SUBTYPE, 17);
                        json.put(KEY_FRAMERECT, (Object)message.getFrameRect().asJSONObject());
                        json.put(KEY_ABOLUTE_ZOOM_VALUE, (double)message.getZoomValue());
                        break;
                    }
                    case ZOOM_CHANGE: {
                        json.put(KEY_SUBTYPE, 1);
                        json.put(KEY_ABOLUTE_ZOOM_VALUE, (double)message.getZoomValue());
                        break;
                    }
                    default: {
                        throw new MessageSerializationException("unknown type while analyzing " + ZoomMessage.class.getName());
                    }
                }
                byte[] data = this.jsonSerDes.serialize(new JsonMessage(json));
                return data;
            }
            catch (JSONException e) {
                throw new MessageSerializationException("JSONException during " + StrokeInkMessage.class.getName() + " Serialization", (Exception)((Object)e));
            }
        }
    }

    public class FrameRectDefinitionMessageSerDes
    implements HisMessageSerDes<FrameRectDefinitionMessage> {
        final JsonMessageSerDes jsonSerDes;
        static final String KEY_FRAMERECT = "framerect";
        static final String KEY_BOTTOM = "bottom";
        static final String KEY_LEFT = "left";
        static final String KEY_RIGHT = "right";
        static final String KEY_TOP = "top";

        public FrameRectDefinitionMessageSerDes() {
            this.jsonSerDes = new JsonMessageSerDes();
        }

        @Override
        public FrameRectDefinitionMessage fromByteArray(byte[] messagebytes) throws MessageDeSerializationException {
            try {
                JsonMessage jsonMessage = this.jsonSerDes.fromByteArray(messagebytes);
                JSONObject jo = jsonMessage.getJsonObject();
                JSONObject c = jo.getJSONObject(KEY_FRAMERECT);
                FrameRectDefinitionMessage frmess = new FrameRectDefinitionMessage(FrameRect.fromJSONObject(c));
                return frmess;
            }
            catch (JSONException e1) {
                throw new MessageDeSerializationException("JSONException while analyzing " + FrameRectDefinitionMessage.class.getName(), (Exception)((Object)e1));
            }
        }

        @Override
        public byte[] serialize(FrameRectDefinitionMessage message) throws MessageSerializationException {
            try {
                JSONObject json = new JSONObject();
                json.put(KEY_FRAMERECT, (Object)message.getFrameRect().asJSONObject());
                byte[] data = this.jsonSerDes.serialize(new JsonMessage(json));
                return data;
            }
            catch (JSONException e) {
                throw new MessageSerializationException("JSONException during " + FrameRectDefinitionMessage.class.getName() + " Serialization", (Exception)((Object)e));
            }
        }
    }

    public class CommandMessageSerDes
    implements HisMessageSerDes<CommandMessage> {
        final JsonMessageSerDes jsonSerDes;

        public CommandMessageSerDes() {
            this.jsonSerDes = new JsonMessageSerDes();
        }

        @Override
        public CommandMessage fromByteArray(byte[] messagebytes) throws MessageDeSerializationException {
            JsonMessage jsonMessage = this.jsonSerDes.fromByteArray(messagebytes);
            try {
                JSONObject cmdJsonObject = jsonMessage.getJsonObject();
                Command cmd = CommandFactory.create(cmdJsonObject);
                CommandMessage deSerialized = new CommandMessage(cmd);
                return deSerialized;
            }
            catch (JSONException e) {
                throw new MessageDeSerializationException("JSONException while analyzing " + CommandMessage.class.getName(), (Exception)((Object)e));
            }
        }

        @Override
        public byte[] serialize(CommandMessage message) throws MessageSerializationException {
            try {
                Command cmd = message.getCommand();
                JSONObject json = cmd.toJSON();
                byte[] data = this.jsonSerDes.serialize(new JsonMessage(json));
                return data;
            }
            catch (JSONException e) {
                throw new MessageSerializationException("JSONException during " + CommandMessage.class.getName() + " Serialization", (Exception)((Object)e));
            }
        }
    }

    public class PinchPointsMessageSerDes
    implements HisMessageSerDes<PinchPointsMessage> {
        @Override
        public PinchPointsMessage fromByteArray(byte[] messagebytes) throws MessageDeSerializationException {
            Vector2f v;
            ByteBuffer bytes = ByteBuffer.wrap(messagebytes).order(BYTE_ORDER_RECEIVING);
            PinchPointsMessage msg = new PinchPointsMessage();
            byte subTypeValue = bytes.get();
            byte phase = bytes.get();
            msg.setType(PinchPointsMessage.Type.getFromByte(subTypeValue));
            msg.setPhase(PinchPointsMessage.Phase.getFromByte(phase));
            float x = bytes.getFloat();
            float y = bytes.getFloat();
            msg.initiatingTouch1Position = v = new Vector2f(x, y);
            x = bytes.getFloat();
            y = bytes.getFloat();
            msg.initiatingTouch2Position = v = new Vector2f(x, y);
            x = bytes.getFloat();
            y = bytes.getFloat();
            msg.currentTouch1Position = v = new Vector2f(x, y);
            x = bytes.getFloat();
            y = bytes.getFloat();
            msg.currentTouch2Position = v = new Vector2f(x, y);
            return msg;
        }

        @Override
        public byte[] serialize(PinchPointsMessage message) throws MessageSerializationException {
            throw new MessageSerializationException("not yet implemented!");
        }
    }

    static abstract class HisNetworkMessageWrapperUnWrapper {
        HisNetworkMessageWrapperUnWrapper() {
        }

        public static byte[] wrapMessageBytes(byte[] messageDataWithoutHeaderInfosBytes, short messageType) {
            int headLength = 2;
            short type = messageType;
            short messageLength = (short)messageDataWithoutHeaderInfosBytes.length;
            byte[] completeMessage = ByteBuffer.allocate(headLength + messageLength).order(BYTE_ORDER_SENDING).putShort(type).put(messageDataWithoutHeaderInfosBytes).array();
            return completeMessage;
        }
    }
}

