/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.network.transport.spidermonkey;

import com.hybridlab.hyve3d.network.messages.AbstractHisMessage;
import com.hybridlab.hyve3d.network.messages.Matrix3fMessage;
import com.hybridlab.hyve3d.network.messages.Move2DMessage;
import com.hybridlab.hyve3d.network.messages.PositionChangeVectorMessage;
import com.hybridlab.hyve3d.network.messages.SatelliteSessionSetupMessage;
import com.hybridlab.hyve3d.network.messages.Stroke2DTransmissionPartMessage;
import com.hybridlab.hyve3d.network.messages.TextMessage;
import com.hybridlab.hyve3d.network.messages.TouchEventMessage;
import com.hybridlab.hyve3d.network.transport.MessageTransportConnection;
import com.hybridlab.hyve3d.satellitecenter.SatelliteClientConnectionListener;
import com.jme3.network.HostedConnection;
import com.jme3.network.Message;
import com.jme3.network.MessageListener;
import com.jme3.network.Server;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SpiderMonkeyConnection
implements MessageTransportConnection {
    Server serverConnection;
    HostedConnection clientConnection;
    SatelliteClientConnectionListener listener;
    Logger logger = Logger.getLogger(SpiderMonkeyConnection.class.getSimpleName());

    public SpiderMonkeyConnection(Server server, HostedConnection conn, SatelliteClientConnectionListener listener) {
        this.serverConnection = server;
        this.clientConnection = conn;
        this.listener = listener;
        this.setTextMessageHandler();
        this.setMatrix3fMessageHandler();
        this.setPositionChangedVectorMessageHandler();
        this.setMoveMessageHandler();
        this.setTouchEventMessageHandler();
        this.setStrokeEventMessageHandler();
        this.setSatelliteSessionSetupMessageHandler();
        this.listener.onConnectionEstablished(this);
    }

    private void setMoveMessageHandler() {
        this.serverConnection.addMessageListener((MessageListener)new MessageListener<HostedConnection>(){

            public void messageReceived(HostedConnection source, Message message) {
                SpiderMonkeyConnection.this.listener.onMessageReceived((Move2DMessage)message);
            }
        }, new Class[]{Move2DMessage.class});
    }

    private void setStrokeEventMessageHandler() {
        this.serverConnection.addMessageListener((MessageListener)new MessageListener<HostedConnection>(){

            public void messageReceived(HostedConnection source, Message message) {
                SpiderMonkeyConnection.this.listener.onMessageReceived((Stroke2DTransmissionPartMessage)message);
            }
        }, new Class[]{Stroke2DTransmissionPartMessage.class});
    }

    private void setSatelliteSessionSetupMessageHandler() {
        this.serverConnection.addMessageListener((MessageListener)new MessageListener<HostedConnection>(){

            public void messageReceived(HostedConnection source, Message message) {
                SpiderMonkeyConnection.this.listener.onMessageReceived((SatelliteSessionSetupMessage)message);
            }
        }, new Class[]{SatelliteSessionSetupMessage.class});
    }

    private void setTouchEventMessageHandler() {
        this.serverConnection.addMessageListener((MessageListener)new MessageListener<HostedConnection>(){

            public void messageReceived(HostedConnection source, Message message) {
                SpiderMonkeyConnection.this.listener.onMessageReceived((TouchEventMessage)message);
            }
        }, new Class[]{TouchEventMessage.class});
    }

    private void setPositionChangedVectorMessageHandler() {
        this.serverConnection.addMessageListener((MessageListener)new MessageListener<HostedConnection>(){

            public void messageReceived(HostedConnection source, Message message) {
                SpiderMonkeyConnection.this.listener.onMessageReceived((PositionChangeVectorMessage)message);
            }
        }, new Class[]{PositionChangeVectorMessage.class});
    }

    private void setMatrix3fMessageHandler() {
        this.serverConnection.addMessageListener((MessageListener)new MessageListener<HostedConnection>(){

            public void messageReceived(HostedConnection source, Message message) {
                SpiderMonkeyConnection.this.listener.onMessageReceived((Matrix3fMessage)message);
            }
        }, new Class[]{Matrix3fMessage.class});
    }

    private void setTextMessageHandler() {
        this.serverConnection.addMessageListener((MessageListener)new MessageListener<HostedConnection>(){

            public void messageReceived(HostedConnection source, Message message) {
                SpiderMonkeyConnection.this.logger.log(Level.INFO, String.format("message from [ %s ]:\n %s", source.toString(), message.toString()));
                TextMessage answer = new TextMessage("thank you for your message: " + message.toString());
                SpiderMonkeyConnection.this.serverConnection.broadcast((Message)answer);
            }
        }, new Class[]{TextMessage.class});
    }

    @Override
    public void disconnect() throws IOException {
        this.clientConnection.close("Connection was closed from server side.");
    }

    @Override
    public void send(AbstractHisMessage message) throws MessageTransportConnection.SendFailedException {
        this.clientConnection.send((Message)message);
    }
}

