/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.nina;

import com.hybridlab.hyve3d.rendering.ProgressVisualizer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

class BackGroundWindow
extends JFrame
implements ProgressVisualizer {
    private Color bgcolor = new Color(230, 144, 31);
    private Color greycolor = new Color(68, 82, 95);
    private static final long serialVersionUID = -2278550048848585310L;
    private JLabel label;
    private JLabel labelFPS;
    private Map<String, ProgressInfo> info = new HashMap<String, ProgressInfo>();
    private JLabel label1;
    private JLabel label2;
    private JPanel panel_1;
    private JLabel label3;
    private JLabel label4;
    private JLabel label5;
    private JPanel panel_2;
    private JLabel lblClickHereTo;
    private JButton btnNewButton;

    public BackGroundWindow(final BeginClickCallback beginclickcallback, boolean isFullscreen) {
        this.getContentPane().setBackground(this.bgcolor);
        try {
            InputStream is = this.getClass().getResourceAsStream("backgroundscreen.png");
            BufferedImage myPicture = ImageIO.read(is);
            ImageIcon icon = new ImageIcon(myPicture);
            this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
            this.panel_2 = new JPanel();
            this.panel_2.setBackground(this.bgcolor);
            this.getContentPane().add(this.panel_2);
            GridBagLayout gbl_panel_2 = new GridBagLayout();
            gbl_panel_2.columnWidths = new int[]{100, 0, 0, 0, 0, 100, 0};
            gbl_panel_2.rowHeights = new int[]{80, 0, 0, 0, 0, 0, 0, 80, 0};
            gbl_panel_2.columnWeights = new double[]{0.0, 1.0, 0.0, 0.0, 1.0, 0.0, Double.MIN_VALUE};
            gbl_panel_2.rowWeights = new double[]{0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, Double.MIN_VALUE};
            this.panel_2.setLayout(gbl_panel_2);
            this.lblClickHereTo = new JLabel("click here to begin ...");
            this.lblClickHereTo.setForeground(this.greycolor);
            if (isFullscreen) {
                this.lblClickHereTo.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent arg0) {
                        BackGroundWindow.this.lblClickHereTo.setForeground(BackGroundWindow.this.bgcolor);
                        beginclickcallback.beginWasClicked();
                    }
                });
            } else {
                this.lblClickHereTo.setForeground(this.bgcolor);
            }
            this.btnNewButton = new JButton("");
            this.btnNewButton.setFont(new Font("Lucida Grande", 0, 5));
            this.btnNewButton.setForeground(this.bgcolor);
            this.btnNewButton.setBackground(this.bgcolor);
            this.btnNewButton.setBorderPainted(false);
            this.btnNewButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    System.out.println(e.toString());
                }
            });
            GridBagConstraints gbc_btnNewButton = new GridBagConstraints();
            gbc_btnNewButton.insets = new Insets(0, 0, 0, 0);
            gbc_btnNewButton.gridx = 3;
            gbc_btnNewButton.gridy = 0;
            this.panel_2.add((Component)this.btnNewButton, gbc_btnNewButton);
            this.lblClickHereTo.setFont(new Font("Lucida Grande", 0, 42));
            GridBagConstraints gbc_lblClickHereTo = new GridBagConstraints();
            gbc_lblClickHereTo.anchor = 17;
            gbc_lblClickHereTo.gridwidth = 3;
            gbc_lblClickHereTo.insets = new Insets(0, 0, 5, 5);
            gbc_lblClickHereTo.gridx = 1;
            gbc_lblClickHereTo.gridy = 1;
            this.panel_2.add((Component)this.lblClickHereTo, gbc_lblClickHereTo);
            this.label = new JLabel();
            GridBagConstraints gbc_label = new GridBagConstraints();
            gbc_label.gridwidth = 2;
            gbc_label.insets = new Insets(0, 0, 5, 5);
            gbc_label.gridx = 2;
            gbc_label.gridy = 3;
            this.panel_2.add((Component)this.label, gbc_label);
            this.label.setAlignmentX(0.5f);
            this.label.setAlignmentY(0.5f);
            this.label.setBounds(0, 0, 1255, 306);
            this.label.setIcon(icon);
            this.labelFPS = new JLabel("   ");
            GridBagConstraints gbc_labelFPS = new GridBagConstraints();
            gbc_labelFPS.insets = new Insets(0, 0, 5, 5);
            gbc_labelFPS.gridx = 3;
            gbc_labelFPS.gridy = 5;
            this.panel_2.add((Component)this.labelFPS, gbc_labelFPS);
            this.labelFPS.setAlignmentY(1.0f);
            this.labelFPS.setForeground(this.greycolor);
            this.panel_1 = new JPanel();
            GridBagConstraints gbc_panel_1 = new GridBagConstraints();
            gbc_panel_1.insets = new Insets(0, 0, 5, 5);
            gbc_panel_1.gridx = 3;
            gbc_panel_1.gridy = 6;
            this.panel_2.add((Component)this.panel_1, gbc_panel_1);
            this.panel_1.setBackground(this.bgcolor);
            GridBagLayout gbl_panel_1 = new GridBagLayout();
            gbl_panel_1.columnWidths = new int[]{61, 0};
            gbl_panel_1.rowHeights = new int[]{16, 0, 0, 0, 0};
            gbl_panel_1.columnWeights = new double[]{0.0, Double.MIN_VALUE};
            gbl_panel_1.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
            this.panel_1.setLayout(gbl_panel_1);
            this.label1 = new JLabel("");
            this.label1.setForeground(this.greycolor);
            GridBagConstraints gbc_label1 = new GridBagConstraints();
            gbc_label1.anchor = 18;
            gbc_label1.insets = new Insets(0, 0, 5, 0);
            gbc_label1.gridx = 0;
            gbc_label1.gridy = 0;
            this.panel_1.add((Component)this.label1, gbc_label1);
            this.label2 = new JLabel("");
            this.label2.setForeground(this.greycolor);
            GridBagConstraints gbc_label2 = new GridBagConstraints();
            gbc_label2.insets = new Insets(0, 0, 5, 0);
            gbc_label2.anchor = 18;
            gbc_label2.gridx = 0;
            gbc_label2.gridy = 1;
            this.panel_1.add((Component)this.label2, gbc_label2);
            this.label3 = new JLabel("");
            this.label3.setForeground(this.greycolor);
            GridBagConstraints gbc_label3 = new GridBagConstraints();
            gbc_label3.insets = new Insets(0, 0, 5, 0);
            gbc_label3.gridx = 0;
            gbc_label3.gridy = 2;
            this.panel_1.add((Component)this.label3, gbc_label3);
            this.label4 = new JLabel("");
            this.label4.setForeground(this.greycolor);
            GridBagConstraints gbc_label4 = new GridBagConstraints();
            gbc_label4.gridx = 0;
            gbc_label4.gridy = 3;
            this.panel_1.add((Component)this.label4, gbc_label4);
            this.label5 = new JLabel("");
            this.label5.setForeground(this.greycolor);
            GridBagConstraints gbc_label5 = new GridBagConstraints();
            gbc_label5.gridx = 0;
            gbc_label5.gridy = 4;
            this.panel_1.add((Component)this.label5, gbc_label5);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProgressInfo getInfo(String id) {
        Map<String, ProgressInfo> map = this.info;
        synchronized (map) {
            ProgressInfo i = this.info.get(id);
            if (i == null) {
                i = new ProgressInfo();
                this.info.put(id, i);
            }
            return i;
        }
    }

    private void setProgressInfo(String id, String txt) {
        ProgressInfo pi = this.getInfo(id);
        pi.info = txt;
    }

    public void setFPSText(final String txt) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BackGroundWindow.this.labelFPS.setText(txt);
            }
        });
    }

    @Override
    public void setProgressText(String id, String txt) {
        this.setProgressInfo(id, txt);
    }

    @Override
    public void setProgressComplete(final String id) {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Map<String, ProgressInfo> map = BackGroundWindow.this.info;
                synchronized (map) {
                    BackGroundWindow.this.info.remove(id);
                }
            }
        });
    }

    public void updateProgressVisualization() {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ArrayList<String> list = new ArrayList<String>();
                Map<String, ProgressInfo> map = BackGroundWindow.this.info;
                synchronized (map) {
                    for (ProgressInfo i : BackGroundWindow.this.info.values()) {
                        list.add(i.info);
                    }
                }
                JLabel[] labels = new JLabel[]{BackGroundWindow.this.label1, BackGroundWindow.this.label2, BackGroundWindow.this.label3, BackGroundWindow.this.label4, BackGroundWindow.this.label5};
                for (int i = 0; i < labels.length - (list.size() > labels.length ? 1 : 0); ++i) {
                    JLabel lbl = labels[i];
                    if (i < list.size()) {
                        lbl.setText((String)list.get(i));
                        continue;
                    }
                    lbl.setText("");
                }
                if (list.size() > labels.length - 1) {
                    JLabel lblLast = labels[labels.length - 1];
                    lblLast.setText(String.valueOf(list.size() - labels.length - 1) + "more tasks ...");
                }
            }
        });
    }

    public JButton getForeGroundButton() {
        return this.btnNewButton;
    }

    public static interface BeginClickCallback {
        public void beginWasClicked();
    }

    private class ProgressInfo {
        public String info;

        private ProgressInfo() {
        }
    }
}

