/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.nina;

import com.hybridlab.hyve3d.nina.ConnectionTemplate;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ConnectionTemplateData {
    public List<ConnectionTemplate> templateEntries = new ArrayList<ConnectionTemplate>();
    public int selectedindex = -1;
    private static String KEY_SELECTED = "selected";
    private static String KEY_ENTRIES = "entries";
    private static String KEY_TITLE = "title";
    private static String KEY_HOST = "host";
    private static String KEY_PORT = "port";
    public static ConnectionTemplateData Default = new ConnectionTemplateData();

    public List<ConnectionTemplate> getTemplates() {
        return this.templateEntries;
    }

    public static String toJSONString(ConnectionTemplateData d) {
        JSONObject o = new JSONObject();
        try {
            o.put(KEY_SELECTED, d.selectedindex);
            JSONArray a = new JSONArray();
            for (ConnectionTemplate e : d.templateEntries) {
                JSONObject je = new JSONObject();
                je.put(KEY_TITLE, (Object)e.getTitle());
                je.put(KEY_HOST, (Object)e.getHost());
                je.put(KEY_PORT, e.getPort());
                a.put((Object)je);
            }
            o.put(KEY_ENTRIES, (Object)a);
            return o.toString(2);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return "{}";
        }
    }

    public static ConnectionTemplateData fromJSONString(String json) {
        try {
            ConnectionTemplateData d = new ConnectionTemplateData();
            JSONObject o = new JSONObject(json);
            d.selectedindex = o.getInt(KEY_SELECTED);
            JSONArray a = o.getJSONArray(KEY_ENTRIES);
            for (int i = 0; i < a.length(); ++i) {
                JSONObject je = a.getJSONObject(i);
                String title = je.getString(KEY_TITLE);
                String host = je.getString(KEY_HOST);
                int port = je.getInt(KEY_PORT);
                d.templateEntries.add(new ConnectionTemplate(title, host, port));
            }
            return d;
        }
        catch (JSONException e) {
            e.printStackTrace();
            return Default;
        }
    }

    public boolean hasEntryLike(String host, int port) {
        for (ConnectionTemplate e : this.templateEntries) {
            if (e.getPort() != port || !e.getHost().equalsIgnoreCase(host)) continue;
            return true;
        }
        return false;
    }

    public int getIndexOf(ConnectionTemplate ct) {
        return this.templateEntries.indexOf(ct);
    }

    static {
        ArrayList<ConnectionTemplate> l = new ArrayList<ConnectionTemplate>();
        l.add(ConnectionTemplate.MontrealServer);
        ConnectionTemplateData.Default.templateEntries = l;
        ConnectionTemplateData.Default.selectedindex = 0;
    }
}

