/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.nina;

import java.awt.Adjustable;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLEditorKit;

public class EULAWindow
extends JFrame {
    private static final long serialVersionUID = 2821830054745787045L;
    private JPanel panel;
    private JButton btn_OK;
    private JButton btn_Cancel;
    private EulaAcceptedCallback callback;
    private JCheckBox chkbox_EULA_accept;
    private JScrollPane scrollPane;
    private JLabel labelAskToAcceptEULA;
    private JEditorPane editorPane;
    private JLabel logoLabel;
    private JPanel panel_logo;
    private Color bgcolor = new Color(230, 144, 31);

    public EULAWindow(EulaAcceptedCallback cb, String eulaHTMLText) {
        this.callback = cb;
        this.setDefaultCloseOperation(0);
        this.setResizable(false);
        this.setAlwaysOnTop(true);
        this.setSize(750, 750);
        this.setTitle("End User License Agreement");
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0};
        gridBagLayout.rowHeights = new int[]{200, 200, 0, 0, 0, 0};
        gridBagLayout.columnWeights = new double[]{1.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, 1.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        this.getContentPane().setLayout(gridBagLayout);
        InputStream is = this.getClass().getResourceAsStream("licencewindowlogo.png");
        try {
            BufferedImage myPicture = ImageIO.read(is);
            ImageIcon icon = new ImageIcon(myPicture);
            this.logoLabel = new JLabel();
            this.logoLabel.setAlignmentX(0.5f);
            this.logoLabel.setAlignmentY(0.5f);
            this.logoLabel.setBounds(25, 0, 700, 200);
            this.logoLabel.setIcon(icon);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        this.panel_logo = new JPanel();
        FlowLayout flowLayout = (FlowLayout)this.panel_logo.getLayout();
        flowLayout.setVgap(0);
        flowLayout.setHgap(0);
        this.panel_logo.setBackground(this.bgcolor);
        GridBagConstraints gbc_panel_logo = new GridBagConstraints();
        gbc_panel_logo.insets = new Insets(0, 0, 5, 0);
        gbc_panel_logo.fill = 1;
        gbc_panel_logo.gridx = 0;
        gbc_panel_logo.gridy = 0;
        this.getContentPane().add((Component)this.panel_logo, gbc_panel_logo);
        this.panel_logo.add(this.logoLabel);
        this.scrollPane = new JScrollPane();
        GridBagConstraints gbc_scrollPane = new GridBagConstraints();
        gbc_scrollPane.insets = new Insets(0, 0, 5, 0);
        gbc_scrollPane.fill = 1;
        gbc_scrollPane.gridx = 0;
        gbc_scrollPane.gridy = 1;
        this.getContentPane().add((Component)this.scrollPane, gbc_scrollPane);
        this.editorPane = new JEditorPane();
        this.editorPane.setEditable(false);
        HTMLEditorKit kit = new HTMLEditorKit();
        this.editorPane.setEditorKit(kit);
        Document doc = kit.createDefaultDocument();
        this.editorPane.setDocument(doc);
        this.editorPane.setText(eulaHTMLText);
        this.editorPane.setCaretPosition(0);
        this.scrollPane.setViewportView(this.editorPane);
        this.chkbox_EULA_accept = new JCheckBox("I accept the End User License Agreement");
        this.chkbox_EULA_accept.setSelected(false);
        this.chkbox_EULA_accept.setEnabled(false);
        GridBagConstraints gbc_chkbox_EULA_accept = new GridBagConstraints();
        gbc_chkbox_EULA_accept.insets = new Insets(0, 0, 5, 0);
        gbc_chkbox_EULA_accept.gridx = 0;
        gbc_chkbox_EULA_accept.gridy = 2;
        this.getContentPane().add((Component)this.chkbox_EULA_accept, gbc_chkbox_EULA_accept);
        this.scrollPane.getVerticalScrollBar().addAdjustmentListener(new MyAdjustmentListener());
        this.chkbox_EULA_accept.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (EULAWindow.this.chkbox_EULA_accept.isSelected()) {
                    EULAWindow.this.labelAskToAcceptEULA.setText("");
                }
                EULAWindow.this.btn_OK.setEnabled(EULAWindow.this.chkbox_EULA_accept.isSelected());
            }
        });
        this.labelAskToAcceptEULA = new JLabel("");
        this.labelAskToAcceptEULA.setForeground(Color.RED);
        GridBagConstraints gbc_labelAskToAcceptEULA = new GridBagConstraints();
        gbc_labelAskToAcceptEULA.insets = new Insets(0, 0, 5, 0);
        gbc_labelAskToAcceptEULA.gridx = 0;
        gbc_labelAskToAcceptEULA.gridy = 3;
        this.getContentPane().add((Component)this.labelAskToAcceptEULA, gbc_labelAskToAcceptEULA);
        this.panel = new JPanel();
        GridBagConstraints gbc_panel = new GridBagConstraints();
        gbc_panel.fill = 2;
        gbc_panel.gridx = 0;
        gbc_panel.gridy = 4;
        this.getContentPane().add((Component)this.panel, gbc_panel);
        GridBagLayout gbl_panel = new GridBagLayout();
        gbl_panel.columnWidths = new int[]{0, 0, 0, 0};
        gbl_panel.rowHeights = new int[]{0, 0, 0};
        gbl_panel.columnWeights = new double[]{1.0, 1.0, 1.0, Double.MIN_VALUE};
        gbl_panel.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        this.panel.setLayout(gbl_panel);
        this.btn_Cancel = new JButton("Cancel");
        this.btn_Cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EULAWindow.this.cancelButtonClicked();
            }
        });
        GridBagConstraints gbc_btn_Cancel = new GridBagConstraints();
        gbc_btn_Cancel.insets = new Insets(0, 0, 0, 5);
        gbc_btn_Cancel.gridx = 0;
        gbc_btn_Cancel.gridy = 1;
        this.panel.add((Component)this.btn_Cancel, gbc_btn_Cancel);
        this.btn_OK = new JButton("Proceed");
        this.btn_OK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                EULAWindow.this.okButtonClicked();
            }
        });
        this.btn_OK.setEnabled(false);
        GridBagConstraints gbc_btn_OK = new GridBagConstraints();
        gbc_btn_OK.gridx = 2;
        gbc_btn_OK.gridy = 1;
        this.panel.add((Component)this.btn_OK, gbc_btn_OK);
    }

    protected void setAcceptPossible(boolean b) {
        this.chkbox_EULA_accept.setEnabled(b);
    }

    protected void cancelButtonClicked() {
        this.callback.onCanceled();
        this.setVisible(false);
    }

    protected void okButtonClicked() {
        if (this.hasAcceptedEULA()) {
            this.setFinished();
            this.setVisible(false);
        } else {
            this.tellToAcceptEULA();
        }
    }

    private boolean hasAcceptedEULA() {
        return this.chkbox_EULA_accept.isSelected();
    }

    private void tellToAcceptEULA() {
        this.labelAskToAcceptEULA.setText("You need to accept the End User License Agreement to proceed.");
    }

    private void setFinished() {
        this.setVisible(false);
        this.callback.onEulaAccepted();
    }

    public static interface EulaAcceptedCallback {
        public void onEulaAccepted();

        public void onCanceled();
    }

    class MyAdjustmentListener
    implements AdjustmentListener {
        MyAdjustmentListener() {
        }

        @Override
        public void adjustmentValueChanged(AdjustmentEvent evt) {
            int max;
            Adjustable source = evt.getAdjustable();
            if (evt.getValueIsAdjusting()) {
                return;
            }
            int value = evt.getValue();
            EULAWindow.this.setAcceptPossible(value >= (int)(0.75f * (float)(max = source.getMaximum())));
        }
    }
}

