/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.nina;

import com.hybridlab.hyve3d.core.FrameRect;
import com.hybridlab.hyve3d.data.valueobjects.Transformation;
import com.hybridlab.hyve3d.hyve.OrthoShooter;
import com.hybridlab.utils.ThreePerpendicularAxes;
import com.hybridlab.utils.math.MathUtils;
import com.jme3.math.Vector3f;
import com.jme3.post.SceneProcessor;
import com.jme3.profile.AppProfiler;
import com.jme3.renderer.Camera;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.Renderer;
import com.jme3.renderer.ViewPort;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.texture.FrameBuffer;
import com.jme3.texture.Image;
import com.jme3.util.BufferUtils;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import org.apache.commons.io.output.ByteArrayOutputStream;

public class ProcessorOrthoShooter
implements SceneProcessor {
    private static final Logger logger = Logger.getLogger(ProcessorOrthoShooter.class.getName());
    private boolean postframeWork = false;
    private Renderer renderer;
    private RenderManager rm;
    private ByteBuffer outBuf;
    private int width;
    private int height;
    private OrthoShooter.FinishCallback callback;
    private String shotId;
    private Camera orthoCam;
    private boolean preframeWork;
    private FrameRect frame;
    private Transformation transformation;
    private boolean initialized = false;
    private boolean buffercreated = false;
    private BufferedImage awtImage;
    private FrameBuffer renderBuffer;
    private boolean useAntialias;
    public static Image.Format UsedImageFormat = Image.Format.ABGR8;

    public ProcessorOrthoShooter(ViewPort vp, Camera orthoCam, boolean useAntialias) {
        this.orthoCam = orthoCam;
        vp.addProcessor((SceneProcessor)this);
        this.useAntialias = useAntialias;
    }

    public void initialize(RenderManager rm, ViewPort vp) {
        if (!this.initialized) {
            this.initialized = true;
            this.renderer = rm.getRenderer();
            this.rm = rm;
            this.reshape(vp, this.orthoCam.getWidth(), this.orthoCam.getHeight());
            if (this.useAntialias) {
                this.renderBuffer = new FrameBuffer(this.width, this.height, 1);
                this.renderBuffer.setDepthTarget(FrameBuffer.FrameBufferTarget.newTarget((Image.Format)Image.Format.Depth));
                this.renderBuffer.addColorTarget(FrameBuffer.FrameBufferTarget.newTarget((Image.Format)UsedImageFormat));
            }
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void reshape(ViewPort vp, int w, int h) {
        if (!this.buffercreated) {
            this.buffercreated = true;
            this.outBuf = BufferUtils.createByteBuffer((int)(w * h * 4));
            this.width = w;
            this.height = h;
            this.awtImage = new BufferedImage(w, h, 6);
        }
    }

    public void preFrame(float tpf) {
        if (this.preframeWork) {
            this.preframeWork = false;
            this.postframeWork = true;
            float near = -0.001f;
            float far = 10000.0f;
            float top = this.frame.getHeight() * 0.5f;
            float bottom = -top;
            float right = this.frame.getWidth() * 0.5f;
            float left = -right;
            this.orthoCam.setFrustum(near, far, left, right, top, bottom);
            this.orthoCam.setLocation(this.transformation.getPosition());
            ThreePerpendicularAxes axes = MathUtils.getQuaternionAxes(this.transformation.getRotation());
            Vector3f up = axes.X;
            Vector3f direction = axes.Z.negate();
            this.orthoCam.lookAtDirection(direction, up);
        }
    }

    public void postQueue(RenderQueue rq) {
    }

    public void shoot(OrthoShooter.FinishCallback callback, String shootid, FrameRect frame, Transformation transformation) {
        this.callback = callback;
        this.shotId = shootid;
        this.frame = frame;
        this.transformation = transformation;
        this.preframeWork = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postFrame(FrameBuffer out) {
        if (this.postframeWork) {
            this.postframeWork = false;
            Camera curCamera = this.orthoCam;
            int viewX = (int)(curCamera.getViewPortLeft() * (float)curCamera.getWidth());
            int viewY = (int)(curCamera.getViewPortBottom() * (float)curCamera.getHeight());
            int viewWidth = (int)((curCamera.getViewPortRight() - curCamera.getViewPortLeft()) * (float)curCamera.getWidth());
            int viewHeight = (int)((curCamera.getViewPortTop() - curCamera.getViewPortBottom()) * (float)curCamera.getHeight());
            this.renderer.setViewPort(0, 0, this.width, this.height);
            if (this.useAntialias) {
                this.renderer.copyFrameBuffer(out, this.renderBuffer, true, false);
                this.renderer.readFrameBuffer(this.renderBuffer, this.outBuf);
            } else {
                this.renderer.readFrameBuffer(out, this.outBuf);
            }
            this.renderer.setViewPort(viewX, viewY, viewWidth, viewHeight);
            ByteArrayOutputStream outStream = null;
            try {
                outStream = new ByteArrayOutputStream();
                ProcessorOrthoShooter.convertScreenShot(this.outBuf, this.awtImage);
                ImageIO.write((RenderedImage)this.awtImage, "png", outStream);
                byte[] data = outStream.toByteArray();
                this.callback.onFinishedShooting(this.shotId, data);
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, "Error while saving screenshot", ex);
            }
            finally {
                if (outStream != null) {
                    try {
                        outStream.close();
                    }
                    catch (IOException ex) {
                        logger.log(Level.SEVERE, "Error while saving screenshot", ex);
                    }
                }
            }
        }
    }

    public static void convertScreenShot(ByteBuffer bgraBuf, BufferedImage out) {
        WritableRaster wr = out.getRaster();
        DataBufferByte db = (DataBufferByte)wr.getDataBuffer();
        byte[] cpuArray = db.getData();
        bgraBuf.clear();
        bgraBuf.get(cpuArray);
        bgraBuf.clear();
        int width = wr.getWidth();
        int height = wr.getHeight();
        int heightdiv2ceil = height % 2 == 1 ? height / 2 + 1 : height / 2;
        for (int y = 0; y < heightdiv2ceil; ++y) {
            for (int x = 0; x < width; ++x) {
                int inPtr = (y * width + x) * 4;
                int outPtr = ((height - y - 1) * width + x) * 4;
                byte b1 = cpuArray[inPtr + 0];
                byte g1 = cpuArray[inPtr + 1];
                byte r1 = cpuArray[inPtr + 2];
                byte a1 = cpuArray[inPtr + 3];
                byte b2 = cpuArray[outPtr + 0];
                byte g2 = cpuArray[outPtr + 1];
                byte r2 = cpuArray[outPtr + 2];
                byte a2 = cpuArray[outPtr + 3];
                cpuArray[outPtr + 0] = a1;
                cpuArray[outPtr + 1] = r1;
                cpuArray[outPtr + 2] = g1;
                cpuArray[outPtr + 3] = b1;
                cpuArray[inPtr + 0] = a2;
                cpuArray[inPtr + 1] = r2;
                cpuArray[inPtr + 2] = g2;
                cpuArray[inPtr + 3] = b2;
            }
        }
    }

    public void cleanup() {
        this.initialized = false;
    }

    public void setProfiler(AppProfiler arg0) {
    }
}

