/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.nina;

import com.hybridlab.hyve3d.core.FrameRect;
import com.hybridlab.hyve3d.core.Satellite;
import com.hybridlab.hyve3d.core.SatelliteObserver;
import com.hybridlab.hyve3d.core.Stroke2D;
import com.hybridlab.hyve3d.core.TransformationOptions;
import com.hybridlab.hyve3d.core.commands.Command;
import com.hybridlab.hyve3d.core.commands.CommandChangeMode;
import com.hybridlab.hyve3d.core.commands.CommandChangeModeRequest;
import com.hybridlab.hyve3d.core.commands.DrawAreaTransformOptionsCommand;
import com.hybridlab.hyve3d.core.commands.SimpleStringCommand;
import com.hybridlab.hyve3d.data.valueobjects.Transformation;
import com.hybridlab.hyve3d.hyve.StrokeCreationAdapter;
import com.hybridlab.hyve3d.network.discovery.NetworkServiceManager;
import com.hybridlab.hyve3d.network.interconnection.messages.Registry;
import com.hybridlab.hyve3d.network.messages.AbstractHisMessage;
import com.hybridlab.hyve3d.network.messages.CommandMessage;
import com.hybridlab.hyve3d.network.messages.FrameRectDefinitionMessage;
import com.hybridlab.hyve3d.network.messages.Move2DMessage;
import com.hybridlab.hyve3d.network.messages.Move3DMessage;
import com.hybridlab.hyve3d.network.messages.PinchPointsMessage;
import com.hybridlab.hyve3d.network.messages.Pointing2DTransmissionPartMessage;
import com.hybridlab.hyve3d.network.messages.SatelliteSessionSetupMessage;
import com.hybridlab.hyve3d.network.messages.Stroke2DTransmissionPartMessage;
import com.hybridlab.hyve3d.network.messages.StrokeInkMessage;
import com.hybridlab.hyve3d.network.messages.TransformMessage;
import com.hybridlab.hyve3d.network.messages.ZoomMessage;
import com.hybridlab.hyve3d.nina.RotationCheckPlane;
import com.hybridlab.hyve3d.satellitecenter.SatelliteServer;
import com.hybridlab.hyve3d.satellitecenter.SatelliteSession;
import com.hybridlab.hyve3d.satellitecenter.SatelliteSessionObserver;
import com.jme3.app.SimpleApplication;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RotationCheckApp
extends SimpleApplication {
    private NetworkServiceManager networkServiceManager;
    private SatelliteServer satelliteServer;
    private RotationCheckPlane plane;

    public void simpleInitApp() {
        Registry.registerMessageTypes();
        this.networkServiceManager = new NetworkServiceManager();
        this.networkServiceManager.start();
        this.satelliteServer = new SatelliteServer(this.networkServiceManager);
        this.satelliteServer.registerSessionObserver(new Obs());
        this.satelliteServer.startListenForConnectionsAndServe();
        this.plane = new RotationCheckPlane(this.getAssetManager(), this.rootNode);
    }

    public static void main(String[] args) {
        Logger.getLogger("de.lessvoid").setLevel(Level.SEVERE);
        Logger.getLogger("com.jme3").setLevel(Level.SEVERE);
        RotationCheckApp n = new RotationCheckApp();
        n.start();
    }

    public void stop() {
        super.stop();
        this.satelliteServer.shutdown();
        this.networkServiceManager.stop();
    }

    private class Obs
    implements SatelliteSessionObserver {
        private SatelliteSession session;
        private Satellite sat;

        private Obs() {
        }

        @Override
        public void onNewSatelliteSession(final SatelliteSession session) {
            this.session = session;
            this.sat = new Satellite(){

                @Override
                public void processMessage(SatelliteSession satelliteSession, AbstractHisMessage message) {
                }

                @Override
                public void setTrackingInfos(Boolean isTrackingEnabled, String trackingIdentifier) {
                }

                @Override
                public void setTemporaryFrameColor(ColorRGBA c) {
                }

                @Override
                public void setStrokeCreationAdapter(StrokeCreationAdapter sketcher) {
                }

                @Override
                public void setRotationSource(TransformMessage.Source rotationSource) {
                }

                @Override
                public void setRegularFrameColor(ColorRGBA color) {
                }

                @Override
                public void setName(String satelliteName) {
                }

                @Override
                public void setFrame(FrameRect r) {
                }

                @Override
                public void setCurrentMode(CommandChangeMode.SatelliteMode newMode) {
                    CommandChangeMode answercmd = new CommandChangeMode(newMode);
                    CommandMessage message = new CommandMessage(answercmd);
                    this.sendMessage(message);
                }

                @Override
                public void sendUndoRedoStepsCommand(int undosteps, int redosteps) {
                }

                @Override
                public void sendMessage(AbstractHisMessage message) {
                    session.sendMessage(message);
                }

                @Override
                public void registerObserver(SatelliteObserver observer) {
                }

                @Override
                public void processMessage(CommandMessage message) {
                    Logger logger = Logger.getAnonymousLogger();
                    logger.info(message.toString());
                    Command cmd = message.getCommand();
                    if (null == cmd.getCommandName()) {
                        logger.log(Level.SEVERE, "Command is EMPTY");
                        return;
                    }
                    block0 : switch (cmd.getCommandName()) {
                        case drawAreaTransformOptions: {
                            DrawAreaTransformOptionsCommand daTrfOptionsCommand = (DrawAreaTransformOptionsCommand)cmd;
                            logger.info(daTrfOptionsCommand.getOptions().toString());
                            break;
                        }
                        case changeModeRequest: {
                            CommandChangeModeRequest changeModeRequest = (CommandChangeModeRequest)cmd;
                            switch (changeModeRequest.getMode()) {
                                case Navigation: 
                                case SelectionTransformation: 
                                case Editing: 
                                case IpadCalibration: 
                                case DrawingAreaTransformation: {
                                    this.setCurrentMode(changeModeRequest.getMode());
                                    break block0;
                                }
                                case Drawing: {
                                    break block0;
                                }
                            }
                            break;
                        }
                        case simpleString: {
                            SimpleStringCommand stringCmd = (SimpleStringCommand)cmd;
                            logger.info(stringCmd.getCommandString());
                            break;
                        }
                        default: {
                            logger.severe("Unkown Command" + cmd.getCommandName());
                        }
                    }
                }

                @Override
                public void processMessage(PinchPointsMessage message) {
                }

                @Override
                public void processMessage(FrameRectDefinitionMessage message) {
                }

                @Override
                public void processMessage(ZoomMessage message) {
                }

                @Override
                public void processMessage(Pointing2DTransmissionPartMessage message) {
                }

                @Override
                public void processMessage(StrokeInkMessage message) {
                }

                @Override
                public void processMessage(Move3DMessage message) {
                }

                @Override
                public void processMessage(Move2DMessage message) {
                }

                @Override
                public void processMessage(Stroke2DTransmissionPartMessage message) {
                }

                @Override
                public void processMessage(TransformMessage m) {
                    Quaternion q = m.getCorrectedQuaternion();
                    Obs.this.setRotation(q);
                }

                @Override
                public boolean shouldReceiveProjectedStrokes() {
                    return false;
                }

                @Override
                public void onSessionOpened(SatelliteSession session2) {
                }

                @Override
                public void onSessionClosed(SatelliteSession session2) {
                }

                @Override
                public void onDrawingAreaDisconnect() {
                }

                @Override
                public void onDrawingAreaConnect() {
                }

                @Override
                public void manageFreshStroke(Stroke2D stroke2d) {
                }

                @Override
                public Transformation getTransformation() {
                    return null;
                }

                @Override
                public TransformationOptions getTransformOptions() {
                    return null;
                }

                @Override
                public SatelliteSession getSession() throws NullPointerException {
                    return null;
                }

                @Override
                public String getSatelliteId() {
                    return null;
                }

                @Override
                public Quaternion getRotation() {
                    return null;
                }

                @Override
                public ColorRGBA getRegularFrameColor() {
                    return null;
                }

                @Override
                public Vector3f getPosition() {
                    return null;
                }

                @Override
                public String getName() {
                    return null;
                }

                @Override
                public FrameRect getFrame() {
                    return null;
                }

                @Override
                public Satellite.SatelliteState getCurrentState() {
                    return null;
                }

                @Override
                public CommandChangeMode.SatelliteMode getCurrentMode() {
                    return null;
                }

                @Override
                public void clearSatelliteCanvasAndShowStrokes(List<Stroke2D> strokes) {
                }
            };
            session.setSessionHandlingSatelliteInstanceOnServer(this.sat);
        }

        protected void setRotation(final Quaternion q) {
            RotationCheckApp.this.enqueue(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    RotationCheckApp.this.plane.getRootNode().setLocalRotation(q.clone());
                    return null;
                }
            });
        }

        @Override
        public void onSatelliteSessionClosed(SatelliteSession session) {
        }

        @Override
        public void onSessionSetup(SatelliteSession session, SatelliteSessionSetupMessage setupMessage) {
            Logger.getAnonymousLogger().info(setupMessage.toString());
            this.sat.setCurrentMode(CommandChangeMode.SatelliteMode.DrawingAreaTransformation);
        }
    }
}

