/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.nina;

import com.hybridlab.hyve3d.hyve.DrawingAreaDirectionAdapter;
import com.hybridlab.hyve3d.hyve.Hyve;
import com.hybridlab.hyve3d.rendering.Jme3HyveSceneManager;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SceneControlWindow
extends JFrame {
    private JSpinner spinner_dirX;
    private JSpinner spinner_dirY;
    private JSpinner spinner_dirZ;
    private static final long serialVersionUID = -2460828522637831435L;
    private Jme3HyveSceneManager sceneManager;
    private JLabel lblDirectionalLightSource;
    private JSpinner spinner_ambient_white;
    private JSpinner spinner_dl2_x;
    private JSpinner spinner_dl2_y;
    private JSpinner spinner_dl2_z;
    private JPanel panel;
    private JLabel lblWhitevalue;
    private JSpinner spinner_dl1_color;
    private JSpinner spinner_dl2_color;
    private JPanel panel_2;
    private JLabel lblWhitevalue_1;
    private JCheckBox cb_enabled_dl1;
    private JLabel lblX;
    private JLabel lblY;
    private JLabel lblZ;
    private JPanel panel_3;
    private JCheckBox cb_enabled_dl2;
    private JLabel label_2;
    private JLabel label_3;
    private JLabel label_4;
    private JLabel label_5;
    private JLabel label_6;
    private Hyve localHyve;
    private Map<ButtonControl, MyDirectionObserver> waiting = new HashMap<ButtonControl, MyDirectionObserver>();
    private JButton btn_dl1;
    private JButton btn_dl2;

    public SceneControlWindow() {
        this.setSize(468, 497);
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0, 0, 0, 0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
        gridBagLayout.columnWeights = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, Double.MIN_VALUE};
        this.getContentPane().setLayout(gridBagLayout);
        this.panel_2 = new JPanel();
        this.panel_2.setBorder(new TitledBorder(new LineBorder(new Color(0, 0, 0), 1, true), "Ambient Light", 4, 2, null, new Color(0, 0, 0)));
        GridBagConstraints gbc_panel_2 = new GridBagConstraints();
        gbc_panel_2.gridwidth = 3;
        gbc_panel_2.insets = new Insets(0, 0, 5, 5);
        gbc_panel_2.fill = 1;
        gbc_panel_2.gridx = 1;
        gbc_panel_2.gridy = 1;
        this.getContentPane().add((Component)this.panel_2, gbc_panel_2);
        GridBagLayout gbl_panel_2 = new GridBagLayout();
        gbl_panel_2.columnWidths = new int[]{0, 0, 0, 0};
        gbl_panel_2.rowHeights = new int[]{0, 0, 0};
        gbl_panel_2.columnWeights = new double[]{1.0, 1.0, 1.0, Double.MIN_VALUE};
        gbl_panel_2.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        this.panel_2.setLayout(gbl_panel_2);
        this.lblWhitevalue_1 = new JLabel("whitevalue");
        GridBagConstraints gbc_lblWhitevalue_1 = new GridBagConstraints();
        gbc_lblWhitevalue_1.gridwidth = 3;
        gbc_lblWhitevalue_1.insets = new Insets(0, 0, 5, 0);
        gbc_lblWhitevalue_1.gridx = 0;
        gbc_lblWhitevalue_1.gridy = 0;
        this.panel_2.add((Component)this.lblWhitevalue_1, gbc_lblWhitevalue_1);
        this.spinner_ambient_white = new JSpinner();
        GridBagConstraints gbc_spinner_ambient_white = new GridBagConstraints();
        gbc_spinner_ambient_white.fill = 2;
        gbc_spinner_ambient_white.insets = new Insets(0, 0, 0, 5);
        gbc_spinner_ambient_white.gridx = 1;
        gbc_spinner_ambient_white.gridy = 1;
        this.panel_2.add((Component)this.spinner_ambient_white, gbc_spinner_ambient_white);
        this.panel = new JPanel();
        this.panel.setBorder(new TitledBorder(new LineBorder(new Color(0, 0, 0), 1, true), "Directional Light 1", 4, 2, null, new Color(0, 0, 0)));
        GridBagConstraints gbc_panel = new GridBagConstraints();
        gbc_panel.gridwidth = 3;
        gbc_panel.insets = new Insets(0, 0, 5, 5);
        gbc_panel.fill = 1;
        gbc_panel.gridx = 1;
        gbc_panel.gridy = 3;
        this.getContentPane().add((Component)this.panel, gbc_panel);
        GridBagLayout gbl_panel = new GridBagLayout();
        gbl_panel.columnWidths = new int[]{0, 0, 0, 0, 0, 0, 0};
        gbl_panel.rowHeights = new int[]{0, 0, 0, 0, 0, 0};
        gbl_panel.columnWeights = new double[]{0.0, 0.0, 1.0, 0.0, 1.0, 0.0, Double.MIN_VALUE};
        gbl_panel.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        this.panel.setLayout(gbl_panel);
        this.cb_enabled_dl1 = new JCheckBox("enabled");
        GridBagConstraints gbc_cb_enabled_dl1 = new GridBagConstraints();
        gbc_cb_enabled_dl1.gridwidth = 3;
        gbc_cb_enabled_dl1.insets = new Insets(0, 0, 5, 5);
        gbc_cb_enabled_dl1.gridx = 2;
        gbc_cb_enabled_dl1.gridy = 0;
        this.panel.add((Component)this.cb_enabled_dl1, gbc_cb_enabled_dl1);
        this.lblDirectionalLightSource = new JLabel("direction");
        GridBagConstraints gbc_lblDirectionalLightSource = new GridBagConstraints();
        gbc_lblDirectionalLightSource.insets = new Insets(0, 0, 5, 5);
        gbc_lblDirectionalLightSource.gridx = 2;
        gbc_lblDirectionalLightSource.gridy = 1;
        this.panel.add((Component)this.lblDirectionalLightSource, gbc_lblDirectionalLightSource);
        this.lblWhitevalue = new JLabel("whitevalue");
        GridBagConstraints gbc_lblWhitevalue = new GridBagConstraints();
        gbc_lblWhitevalue.insets = new Insets(0, 0, 5, 5);
        gbc_lblWhitevalue.gridx = 4;
        gbc_lblWhitevalue.gridy = 1;
        this.panel.add((Component)this.lblWhitevalue, gbc_lblWhitevalue);
        this.lblX = new JLabel("x");
        GridBagConstraints gbc_lblX = new GridBagConstraints();
        gbc_lblX.insets = new Insets(0, 0, 5, 5);
        gbc_lblX.gridx = 1;
        gbc_lblX.gridy = 2;
        this.panel.add((Component)this.lblX, gbc_lblX);
        this.spinner_dirX = new JSpinner();
        GridBagConstraints gbc_spinner_dirX = new GridBagConstraints();
        gbc_spinner_dirX.fill = 2;
        gbc_spinner_dirX.insets = new Insets(0, 0, 5, 5);
        gbc_spinner_dirX.gridx = 2;
        gbc_spinner_dirX.gridy = 2;
        this.panel.add((Component)this.spinner_dirX, gbc_spinner_dirX);
        this.spinner_dl1_color = new JSpinner();
        GridBagConstraints gbc_spinner_dl1_color = new GridBagConstraints();
        gbc_spinner_dl1_color.fill = 2;
        gbc_spinner_dl1_color.insets = new Insets(0, 0, 5, 5);
        gbc_spinner_dl1_color.gridx = 4;
        gbc_spinner_dl1_color.gridy = 2;
        this.panel.add((Component)this.spinner_dl1_color, gbc_spinner_dl1_color);
        this.lblY = new JLabel("y");
        GridBagConstraints gbc_lblY = new GridBagConstraints();
        gbc_lblY.insets = new Insets(0, 0, 5, 5);
        gbc_lblY.gridx = 1;
        gbc_lblY.gridy = 3;
        this.panel.add((Component)this.lblY, gbc_lblY);
        this.spinner_dirY = new JSpinner();
        GridBagConstraints gbc_spinner_dirY = new GridBagConstraints();
        gbc_spinner_dirY.fill = 2;
        gbc_spinner_dirY.insets = new Insets(0, 0, 5, 5);
        gbc_spinner_dirY.gridx = 2;
        gbc_spinner_dirY.gridy = 3;
        this.panel.add((Component)this.spinner_dirY, gbc_spinner_dirY);
        this.lblZ = new JLabel("z");
        GridBagConstraints gbc_lblZ = new GridBagConstraints();
        gbc_lblZ.insets = new Insets(0, 0, 0, 5);
        gbc_lblZ.gridx = 1;
        gbc_lblZ.gridy = 4;
        this.panel.add((Component)this.lblZ, gbc_lblZ);
        this.spinner_dirZ = new JSpinner();
        GridBagConstraints gbc_spinner_dirZ = new GridBagConstraints();
        gbc_spinner_dirZ.insets = new Insets(0, 0, 0, 5);
        gbc_spinner_dirZ.fill = 2;
        gbc_spinner_dirZ.gridx = 2;
        gbc_spinner_dirZ.gridy = 4;
        this.panel.add((Component)this.spinner_dirZ, gbc_spinner_dirZ);
        this.btn_dl1 = new JButton("connect 3d-cursor");
        GridBagConstraints gbc_btn_dl1 = new GridBagConstraints();
        gbc_btn_dl1.gridheight = 2;
        gbc_btn_dl1.insets = new Insets(0, 0, 0, 5);
        gbc_btn_dl1.gridx = 4;
        gbc_btn_dl1.gridy = 3;
        this.panel.add((Component)this.btn_dl1, gbc_btn_dl1);
        this.panel_3 = new JPanel();
        this.panel_3.setBorder(new TitledBorder(new LineBorder(new Color(0, 0, 0), 1, true), "Directional Light 2", 4, 2, null, new Color(0, 0, 0)));
        GridBagConstraints gbc_panel_3 = new GridBagConstraints();
        gbc_panel_3.gridwidth = 3;
        gbc_panel_3.insets = new Insets(0, 0, 5, 5);
        gbc_panel_3.fill = 1;
        gbc_panel_3.gridx = 1;
        gbc_panel_3.gridy = 5;
        this.getContentPane().add((Component)this.panel_3, gbc_panel_3);
        GridBagLayout gbl_panel_3 = new GridBagLayout();
        gbl_panel_3.columnWidths = new int[]{0, 0, 0, 0, 0, 0, 0};
        gbl_panel_3.rowHeights = new int[]{0, 0, 0, 0, 0, 0};
        gbl_panel_3.columnWeights = new double[]{0.0, 0.0, 1.0, 0.0, 1.0, 0.0, Double.MIN_VALUE};
        gbl_panel_3.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        this.panel_3.setLayout(gbl_panel_3);
        this.cb_enabled_dl2 = new JCheckBox("enabled");
        GridBagConstraints gbc_cb_enabled_dl2 = new GridBagConstraints();
        gbc_cb_enabled_dl2.gridwidth = 3;
        gbc_cb_enabled_dl2.insets = new Insets(0, 0, 5, 5);
        gbc_cb_enabled_dl2.gridx = 2;
        gbc_cb_enabled_dl2.gridy = 0;
        this.panel_3.add((Component)this.cb_enabled_dl2, gbc_cb_enabled_dl2);
        this.label_2 = new JLabel("direction");
        GridBagConstraints gbc_label_2 = new GridBagConstraints();
        gbc_label_2.insets = new Insets(0, 0, 5, 5);
        gbc_label_2.gridx = 2;
        gbc_label_2.gridy = 1;
        this.panel_3.add((Component)this.label_2, gbc_label_2);
        this.label_3 = new JLabel("whitevalue");
        GridBagConstraints gbc_label_3 = new GridBagConstraints();
        gbc_label_3.insets = new Insets(0, 0, 5, 5);
        gbc_label_3.gridx = 4;
        gbc_label_3.gridy = 1;
        this.panel_3.add((Component)this.label_3, gbc_label_3);
        this.label_4 = new JLabel("x");
        GridBagConstraints gbc_label_4 = new GridBagConstraints();
        gbc_label_4.insets = new Insets(0, 0, 5, 5);
        gbc_label_4.gridx = 1;
        gbc_label_4.gridy = 2;
        this.panel_3.add((Component)this.label_4, gbc_label_4);
        this.spinner_dl2_x = new JSpinner();
        GridBagConstraints gbc_spinner_dl2_x = new GridBagConstraints();
        gbc_spinner_dl2_x.fill = 2;
        gbc_spinner_dl2_x.insets = new Insets(0, 0, 5, 5);
        gbc_spinner_dl2_x.gridx = 2;
        gbc_spinner_dl2_x.gridy = 2;
        this.panel_3.add((Component)this.spinner_dl2_x, gbc_spinner_dl2_x);
        this.spinner_dl2_color = new JSpinner();
        GridBagConstraints gbc_spinner_dl2_color = new GridBagConstraints();
        gbc_spinner_dl2_color.fill = 2;
        gbc_spinner_dl2_color.insets = new Insets(0, 0, 5, 5);
        gbc_spinner_dl2_color.gridx = 4;
        gbc_spinner_dl2_color.gridy = 2;
        this.panel_3.add((Component)this.spinner_dl2_color, gbc_spinner_dl2_color);
        this.label_5 = new JLabel("y");
        GridBagConstraints gbc_label_5 = new GridBagConstraints();
        gbc_label_5.insets = new Insets(0, 0, 5, 5);
        gbc_label_5.gridx = 1;
        gbc_label_5.gridy = 3;
        this.panel_3.add((Component)this.label_5, gbc_label_5);
        this.spinner_dl2_y = new JSpinner();
        GridBagConstraints gbc_spinner_dl2_y = new GridBagConstraints();
        gbc_spinner_dl2_y.fill = 2;
        gbc_spinner_dl2_y.insets = new Insets(0, 0, 5, 5);
        gbc_spinner_dl2_y.gridx = 2;
        gbc_spinner_dl2_y.gridy = 3;
        this.panel_3.add((Component)this.spinner_dl2_y, gbc_spinner_dl2_y);
        this.btn_dl2 = new JButton("connect 3d-cursor");
        GridBagConstraints gbc_button_1 = new GridBagConstraints();
        gbc_button_1.gridheight = 2;
        gbc_button_1.insets = new Insets(0, 0, 5, 5);
        gbc_button_1.gridx = 4;
        gbc_button_1.gridy = 3;
        this.panel_3.add((Component)this.btn_dl2, gbc_button_1);
        this.label_6 = new JLabel("z");
        GridBagConstraints gbc_label_6 = new GridBagConstraints();
        gbc_label_6.insets = new Insets(0, 0, 0, 5);
        gbc_label_6.gridx = 1;
        gbc_label_6.gridy = 4;
        this.panel_3.add((Component)this.label_6, gbc_label_6);
        this.spinner_dl2_z = new JSpinner();
        GridBagConstraints gbc_spinner_dl2_z = new GridBagConstraints();
        gbc_spinner_dl2_z.fill = 2;
        gbc_spinner_dl2_z.insets = new Insets(0, 0, 0, 5);
        gbc_spinner_dl2_z.gridx = 2;
        gbc_spinner_dl2_z.gridy = 4;
        this.panel_3.add((Component)this.spinner_dl2_z, gbc_spinner_dl2_z);
    }

    public void setSceneManager(Jme3HyveSceneManager sceneManager) {
        this.sceneManager = sceneManager;
        new Vector3fSpinnerControl(this.createAdapter(sceneManager.getDirectional1()), this.spinner_dirX, this.spinner_dirY, this.spinner_dirZ, -1.0f, 1.0f, 0.01f);
        new Vector3fSpinnerControl(this.createAdapter(sceneManager.getDirectional2()), this.spinner_dl2_x, this.spinner_dl2_y, this.spinner_dl2_z, -1.0f, 1.0f, 0.01f);
        new FloatSpinnerControl(this.createColorAdapter(sceneManager.getAmbient()), this.spinner_ambient_white, 0.0f, 1.0f, 0.05f);
        new FloatSpinnerControl(this.createColorAdapter(sceneManager.getDirectional1()), this.spinner_dl1_color, 0.0f, 1.0f, 0.05f);
        new FloatSpinnerControl(this.createColorAdapter(sceneManager.getDirectional2()), this.spinner_dl2_color, 0.0f, 1.0f, 0.05f);
        new CheckBoxControl(new EnabledValueAdapter(sceneManager.getDirectional1()), this.cb_enabled_dl1);
        new CheckBoxControl(new EnabledValueAdapter(sceneManager.getDirectional2()), this.cb_enabled_dl2);
        new ButtonControl(this.btn_dl1, sceneManager.getDirectional1());
        new ButtonControl(this.btn_dl2, sceneManager.getDirectional2());
    }

    private FloatValueAdapter createColorAdapter(Jme3HyveSceneManager.LightAdapter l) {
        return new LightColorWhiteValueAdapter(l);
    }

    private Vector3fValueAdapter createAdapter(Jme3HyveSceneManager.LightAdapter la) {
        return new LightVector3fValueAdapter(la);
    }

    private MyDirectionObserver connectDrawingAreaDirectionObserver(Jme3HyveSceneManager.LightAdapter la, ButtonControl b) {
        MyDirectionObserver diro = new MyDirectionObserver(la, b);
        this.waiting.put(b, diro);
        this.localHyve.registerDrawingAreaDirectionObserver(diro);
        return diro;
    }

    public void connectHyve(Hyve localHyve) {
        this.localHyve = localHyve;
    }

    private class Vector3fSpinnerControl
    implements ValueAdapter.ValueHasChangedListener {
        private ChangeListener cl = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent ce) {
                if (ce.getSource() == Vector3fSpinnerControl.this.nmx) {
                    Vector3fSpinnerControl.this.va.setX((Float)Vector3fSpinnerControl.this.nmx.getValue());
                } else if (ce.getSource() == Vector3fSpinnerControl.this.nmy) {
                    Vector3fSpinnerControl.this.va.setY((Float)Vector3fSpinnerControl.this.nmy.getValue());
                } else if (ce.getSource() == Vector3fSpinnerControl.this.nmz) {
                    Vector3fSpinnerControl.this.va.setZ((Float)Vector3fSpinnerControl.this.nmz.getValue());
                }
            }
        };
        private Vector3fValueAdapter va;
        private SpinnerNumberModel nmx;
        private SpinnerNumberModel nmy;
        private SpinnerNumberModel nmz;

        public Vector3fSpinnerControl(Vector3fValueAdapter va, JSpinner x, JSpinner y, JSpinner z, float min, float max, float step) {
            this.va = va;
            this.va.add(this);
            this.nmx = new SpinnerNumberModel(va.getX(), Float.valueOf(min), Float.valueOf(max), Float.valueOf(step));
            this.nmx.addChangeListener(this.cl);
            x.setModel(this.nmx);
            this.nmy = new SpinnerNumberModel(va.getY(), Float.valueOf(min), Float.valueOf(max), Float.valueOf(step));
            this.nmy.addChangeListener(this.cl);
            y.setModel(this.nmy);
            this.nmz = new SpinnerNumberModel(va.getZ(), Float.valueOf(min), Float.valueOf(max), Float.valueOf(step));
            this.nmz.addChangeListener(this.cl);
            z.setModel(this.nmz);
        }

        @Override
        public void hasChanged() {
            this.nmx.removeChangeListener(this.cl);
            this.nmy.removeChangeListener(this.cl);
            this.nmz.removeChangeListener(this.cl);
            this.nmx.setValue(this.va.getX());
            this.nmy.setValue(this.va.getY());
            this.nmz.setValue(this.va.getZ());
            this.nmx.addChangeListener(this.cl);
            this.nmy.addChangeListener(this.cl);
            this.nmz.addChangeListener(this.cl);
        }
    }

    public static interface Vector3fValueAdapter
    extends ValueAdapter {
        public Float getX();

        public Float getY();

        public Float getZ();

        public void setX(Float var1);

        public void setY(Float var1);

        public void setZ(Float var1);
    }

    private class FloatSpinnerControl
    implements ValueAdapter.ValueHasChangedListener {
        private SpinnerNumberModel nmx;
        private ChangeListener cl = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent ce) {
                FloatSpinnerControl.this.va.set((Float)FloatSpinnerControl.this.nmx.getValue());
            }
        };
        private FloatValueAdapter va;

        public FloatSpinnerControl(FloatValueAdapter va, JSpinner x, float min, float max, float step) {
            this.va = va;
            this.nmx = new SpinnerNumberModel(va.get(), Float.valueOf(min), Float.valueOf(max), Float.valueOf(step));
            x.setModel(this.nmx);
            this.nmx.setValue(va.get());
            this.nmx.addChangeListener(this.cl);
            va.add(this);
        }

        @Override
        public void hasChanged() {
            this.nmx.removeChangeListener(this.cl);
            this.nmx.setValue(this.va.get());
            this.nmx.addChangeListener(this.cl);
        }
    }

    public static interface FloatValueAdapter
    extends ValueAdapter {
        public Float get();

        public void set(Float var1);
    }

    private class CheckBoxControl
    implements ValueAdapter.ValueHasChangedListener {
        private JCheckBox cb;
        private EnabledValueAdapter va;

        public CheckBoxControl(EnabledValueAdapter va, JCheckBox cb) {
            this.va = va;
            this.cb = cb;
            boolean b = va.get();
            this.cb.setSelected(b);
            this.cb.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    boolean b = CheckBoxControl.this.cb.isSelected();
                    CheckBoxControl.this.va.set(b);
                }
            });
            this.va.add(this);
        }

        @Override
        public void hasChanged() {
            boolean b = this.va.get();
            this.cb.setSelected(b);
        }
    }

    private class EnabledValueAdapter
    implements BooleanValueAdapter,
    Jme3HyveSceneManager.LightAdapter.HasChangedListener {
        private Set<ValueAdapter.ValueHasChangedListener> listeners = new HashSet<ValueAdapter.ValueHasChangedListener>();
        private Jme3HyveSceneManager.LightAdapter la;

        public EnabledValueAdapter(Jme3HyveSceneManager.LightAdapter la) {
            this.la = la;
            la.add(this);
        }

        @Override
        public void add(ValueAdapter.ValueHasChangedListener l) {
            this.listeners.add(l);
        }

        @Override
        public void hasChanged() {
            for (ValueAdapter.ValueHasChangedListener l : this.listeners) {
                l.hasChanged();
            }
        }

        @Override
        public Boolean get() {
            return this.la.getEnabled();
        }

        @Override
        public void set(Boolean b) {
            this.la.setEnabled(b);
        }
    }

    private class ButtonControl {
        private ActionListener connectAndWait = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ButtonControl.this.request();
            }
        };
        private ActionListener cancel = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ButtonControl.this.diro != null) {
                    ButtonControl.this.diro.cancelFromButton();
                    ButtonControl.this.cancel();
                }
            }
        };
        private JButton button;
        private Jme3HyveSceneManager.LightAdapter light;
        private String regularText;
        private MyDirectionObserver diro;

        public ButtonControl(JButton button, Jme3HyveSceneManager.LightAdapter light) {
            this.regularText = button.getText();
            this.button = button;
            this.light = light;
            button.addActionListener(this.connectAndWait);
        }

        private void request() {
            this.button.removeActionListener(this.connectAndWait);
            this.diro = SceneControlWindow.this.connectDrawingAreaDirectionObserver(this.light, this);
            this.button.setText("waiting ... (press to cancel)");
            this.button.addActionListener(this.cancel);
        }

        public void cancel() {
            this.button.setText(this.regularText);
            this.button.removeActionListener(this.cancel);
            this.button.addActionListener(this.connectAndWait);
            this.diro = null;
        }

        private void onConnect() {
            this.button.setText("disconnect");
        }
    }

    private class LightColorWhiteValueAdapter
    implements FloatValueAdapter,
    Jme3HyveSceneManager.LightAdapter.HasChangedListener {
        private Jme3HyveSceneManager.LightAdapter l;
        private Set<ValueAdapter.ValueHasChangedListener> listeners = new HashSet<ValueAdapter.ValueHasChangedListener>();

        public LightColorWhiteValueAdapter(Jme3HyveSceneManager.LightAdapter l) {
            this.l = l;
            this.l.add(this);
        }

        @Override
        public void set(Float x) {
            ColorRGBA c = this.l.getColor().clone();
            c.set(x.floatValue(), x.floatValue(), x.floatValue(), c.a);
            this.l.setColor(c);
        }

        @Override
        public Float get() {
            return Float.valueOf(this.l.getColor().getBlue());
        }

        @Override
        public void add(ValueAdapter.ValueHasChangedListener l) {
            this.listeners.add(l);
        }

        @Override
        public void hasChanged() {
            for (ValueAdapter.ValueHasChangedListener l : this.listeners) {
                l.hasChanged();
            }
        }
    }

    private class LightVector3fValueAdapter
    implements Vector3fValueAdapter,
    Jme3HyveSceneManager.LightAdapter.HasChangedListener {
        private Jme3HyveSceneManager.LightAdapter lightAdapter;
        private Set<ValueAdapter.ValueHasChangedListener> listeners = new HashSet<ValueAdapter.ValueHasChangedListener>();

        public LightVector3fValueAdapter(Jme3HyveSceneManager.LightAdapter la) {
            this.lightAdapter = la;
            this.lightAdapter.add(this);
        }

        @Override
        public void setZ(Float z) {
            Vector3f v = this.lightAdapter.getDirection().clone();
            v.z = z.floatValue();
            this.lightAdapter.setDirection(v);
            this.print(this.lightAdapter.getDirection());
        }

        @Override
        public void setY(Float y) {
            Vector3f v = this.lightAdapter.getDirection().clone();
            v.y = y.floatValue();
            this.lightAdapter.setDirection(v);
            this.print(this.lightAdapter.getDirection());
        }

        @Override
        public void setX(Float x) {
            Vector3f v = this.lightAdapter.getDirection().clone();
            v.x = x.floatValue();
            this.lightAdapter.setDirection(v);
            this.print(this.lightAdapter.getDirection());
        }

        private void print(Vector3f direction) {
            System.out.println("direction: " + direction);
        }

        @Override
        public Float getZ() {
            return Float.valueOf(this.lightAdapter.getDirection().getZ());
        }

        @Override
        public Float getY() {
            return Float.valueOf(this.lightAdapter.getDirection().getY());
        }

        @Override
        public Float getX() {
            return Float.valueOf(this.lightAdapter.getDirection().getX());
        }

        @Override
        public void add(ValueAdapter.ValueHasChangedListener l) {
            this.listeners.add(l);
        }

        @Override
        public void hasChanged() {
            for (ValueAdapter.ValueHasChangedListener l : this.listeners) {
                l.hasChanged();
            }
        }
    }

    private class MyDirectionObserver
    implements DrawingAreaDirectionAdapter.DirectionObserver {
        private DrawingAreaDirectionAdapter adapter;
        private Jme3HyveSceneManager.LightAdapter la;
        private ButtonControl button;

        public MyDirectionObserver(Jme3HyveSceneManager.LightAdapter la, ButtonControl b) {
            this.la = la;
            this.button = b;
        }

        @Override
        public void onDirectionChange(Vector3f newDirection) {
            this.la.setDirection(newDirection);
        }

        @Override
        public void connect(DrawingAreaDirectionAdapter adapter) {
            this.adapter = adapter;
            this.adapter.addObserver(this);
            this.la.setDirection(adapter.getDirection());
            this.button.onConnect();
        }

        @Override
        public void cancel() {
            this.button.cancel();
        }

        public void cancelFromButton() {
            if (this.adapter != null) {
                this.adapter.destroy();
            }
        }
    }

    public static interface BooleanValueAdapter
    extends ValueAdapter {
        public Boolean get();

        public void set(Boolean var1);
    }

    public static interface ValueAdapter {
        public void add(ValueHasChangedListener var1);

        public static interface ValueHasChangedListener {
            public void hasChanged();
        }
    }
}

