/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.pointcloud;

import com.hybridlab.hyve3d.pointcloud.PointCloudJme3GraphGenerator;
import com.jme3.asset.AssetManager;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.util.BufferUtils;
import java.nio.FloatBuffer;
import java.util.Collection;

public abstract class AbstractPointCloudGraphGenerator
implements PointCloudJme3GraphGenerator {
    protected AssetManager assetManager;

    public AbstractPointCloudGraphGenerator(AssetManager assetManager) {
        this.assetManager = assetManager;
    }

    protected abstract Node generatePointCloudGraphFrom(FloatBuffer var1);

    protected abstract Node generatePointCloudGraphFrom(FloatBuffer var1, FloatBuffer var2);

    @Override
    public Node generatePointCloudGraph(float[] pointCoordinates3d) throws Exception {
        if (pointCoordinates3d == null) {
            throw new Exception("point cloud mustn'nt be null!");
        }
        if (pointCoordinates3d.length % 3 != 0) {
            throw new Exception("number of point coordinates must be a multiple of 3!");
        }
        FloatBuffer coords = BufferUtils.createFloatBuffer((float[])pointCoordinates3d);
        return this.generatePointCloudGraph(coords, null);
    }

    @Override
    public Node generatePointCloudGraph(FloatBuffer pointCoordinates3d) throws Exception {
        if (pointCoordinates3d == null) {
            throw new Exception("point cloud mustn'nt be null!");
        }
        FloatBuffer coords = pointCoordinates3d;
        return this.generatePointCloudGraph(coords, null);
    }

    @Override
    public Node generatePointCloudGraph(Vector3f[] pointCoordinates3d) throws Exception {
        if (pointCoordinates3d == null) {
            throw new Exception("point cloud mustn'nt be null!");
        }
        FloatBuffer coords = BufferUtils.createFloatBuffer((Vector3f[])pointCoordinates3d);
        return this.generatePointCloudGraph(coords, null);
    }

    @Override
    public Node generatePointCloudGraph(Collection<Vector3f> pointCoordinates3d) throws Exception {
        if (pointCoordinates3d == null) {
            throw new Exception("point cloud mustn'nt be null!");
        }
        FloatBuffer coords = BufferUtils.createFloatBuffer((int)(3 * pointCoordinates3d.size()));
        for (Vector3f current : pointCoordinates3d) {
            coords.put(current.x).put(current.y).put(current.z);
        }
        coords.rewind();
        return this.generatePointCloudGraph(coords, null);
    }

    @Override
    public Node generatePointCloudGraph(float[] pointCoordinates3d, float[] colorsRGBA) throws Exception {
        if (pointCoordinates3d == null) {
            throw new Exception("point cloud mustn'nt be null!");
        }
        if (colorsRGBA == null) {
            return this.generatePointCloudGraph(pointCoordinates3d);
        }
        if (pointCoordinates3d.length % 3 != 0) {
            throw new NumberFormatException("number of point coordinates must be a multiple of 3!");
        }
        if (colorsRGBA.length % 4 != 0) {
            throw new NumberFormatException("number of color values must be a multiple of 4!");
        }
        if (pointCoordinates3d.length / 3 != colorsRGBA.length / 4) {
            throw new Exception("There should be a color value for each point, if colors are used!");
        }
        FloatBuffer coords = BufferUtils.createFloatBuffer((float[])pointCoordinates3d);
        FloatBuffer colors = BufferUtils.createFloatBuffer((float[])colorsRGBA);
        return this.generatePointCloudGraph(coords, colors);
    }

    @Override
    public Node generatePointCloudGraph(FloatBuffer pointCoordinates3d, FloatBuffer colorsRGBA) throws Exception {
        if (pointCoordinates3d == null) {
            throw new Exception("point cloud mustn'nt be null!");
        }
        if (colorsRGBA == null) {
            return this.generatePointCloudGraphFrom(pointCoordinates3d);
        }
        return this.generatePointCloudGraphFrom(pointCoordinates3d, colorsRGBA);
    }

    @Override
    public Node generatePointCloudGraph(Vector3f[] pointCoordinates3d, ColorRGBA[] colorsRGBA) throws Exception {
        if (pointCoordinates3d == null) {
            throw new Exception("point cloud mustn'nt be null!");
        }
        if (colorsRGBA == null) {
            return this.generatePointCloudGraph(pointCoordinates3d);
        }
        if (pointCoordinates3d.length != colorsRGBA.length) {
            throw new Exception("There should be a color value for each point, if colors are used!");
        }
        FloatBuffer coords = BufferUtils.createFloatBuffer((Vector3f[])pointCoordinates3d);
        FloatBuffer colors = BufferUtils.createFloatBuffer((int)(4 * colorsRGBA.length));
        for (int i = 0; i < colorsRGBA.length; ++i) {
            colors.put(colorsRGBA[i].r).put(colorsRGBA[i].g).put(colorsRGBA[i].b).put(colorsRGBA[i].a);
        }
        colors.rewind();
        return this.generatePointCloudGraph(coords, colors);
    }

    @Override
    public Node generatePointCloudGraph(Collection<Vector3f> pointCoordinates3d, Collection<ColorRGBA> colorsRGBA) throws Exception {
        if (pointCoordinates3d == null) {
            throw new Exception("point cloud mustn'nt be null!");
        }
        if (colorsRGBA == null) {
            return this.generatePointCloudGraph(pointCoordinates3d);
        }
        if (pointCoordinates3d.size() != colorsRGBA.size()) {
            throw new Exception("There should be a color value for each point, if colors are used!");
        }
        FloatBuffer coords = BufferUtils.createFloatBuffer((int)(3 * pointCoordinates3d.size()));
        for (Vector3f current : pointCoordinates3d) {
            coords.put(current.x).put(current.y).put(current.z);
        }
        coords.rewind();
        FloatBuffer colors = BufferUtils.createFloatBuffer((int)(4 * colorsRGBA.size()));
        for (ColorRGBA current2 : colorsRGBA) {
            colors.put(current2.r).put(current2.g).put(current2.b).put(current2.a);
        }
        colors.rewind();
        return this.generatePointCloudGraph(coords, colors);
    }
}

