/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.pointcloud;

import com.hybridlab.hyve3d.pointcloud.AbstractPointCloudGraphGenerator;
import com.jme3.asset.AssetManager;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.util.BufferUtils;
import java.nio.FloatBuffer;

public class RawPointCloudGraphGenerator
extends AbstractPointCloudGraphGenerator {
    public RawPointCloudGraphGenerator(AssetManager assetManager) {
        super(assetManager);
    }

    @Override
    protected Node generatePointCloudGraphFrom(FloatBuffer pointCoordinates3d) {
        FloatBuffer colors = this.createColorBuffer(new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f), pointCoordinates3d);
        return this.generatePointCloudGraphFrom(pointCoordinates3d, colors);
    }

    @Override
    protected Node generatePointCloudGraphFrom(FloatBuffer pointCoordinates3d, FloatBuffer colorsRGBA) {
        FloatBuffer sizes = this.createSizeBuffer(10.0f, pointCoordinates3d);
        return this.generatePointCloudGraphFrom(pointCoordinates3d, colorsRGBA, sizes);
    }

    protected Node generatePointCloudGraphFrom(FloatBuffer pointCoordinates3d, FloatBuffer colorsRGBA, FloatBuffer sizes) {
        Node result = new Node();
        Material mat = new Material(this.assetManager, "Common/MatDefs/Misc/Particle.j3md");
        mat.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        mat.setBoolean("PointSprite", true);
        mat.setFloat("Quadratic", 1.25f);
        Mesh m = new Mesh();
        m.setMode(Mesh.Mode.Points);
        m.setBuffer(VertexBuffer.Type.Position, 3, pointCoordinates3d);
        m.setBuffer(VertexBuffer.Type.Color, 4, colorsRGBA);
        m.setBuffer(VertexBuffer.Type.Size, 1, sizes);
        m.setStatic();
        m.updateBound();
        Geometry g = new Geometry("Point Cloud", m);
        g.setShadowMode(RenderQueue.ShadowMode.Off);
        g.setQueueBucket(RenderQueue.Bucket.Transparent);
        g.setMaterial(mat);
        g.updateModelBound();
        result.attachChild((Spatial)g);
        result.updateModelBound();
        return result;
    }

    protected FloatBuffer createColorBuffer(ColorRGBA color, FloatBuffer points) {
        int bufferSize = points.limit() / 3 * 4;
        FloatBuffer result = BufferUtils.createFloatBuffer((int)bufferSize);
        for (int i = 0; i < bufferSize / 4; ++i) {
            result.put(color.r).put(color.g).put(color.b).put(color.a);
        }
        return result;
    }

    protected FloatBuffer createSizeBuffer(float pointSize, FloatBuffer points) {
        int bufferSize = points.limit() / 3;
        FloatBuffer result = BufferUtils.createFloatBuffer((int)bufferSize);
        for (int i = 0; i < bufferSize; ++i) {
            result.put(pointSize);
        }
        return result;
    }
}

