/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.pointcloud;

import com.hybridlab.hyve3d.pointcloud.RawPointCloudGraphGenerator;
import com.jme3.app.SimpleApplication;
import com.jme3.math.Vector3f;
import com.jme3.scene.Spatial;
import java.util.Random;

public class TestPointCloud
extends SimpleApplication {
    public Vector3f MIN = new Vector3f(-4.675392f, -3.287754f, 0.0f);
    public Vector3f MAX = new Vector3f(5.847956f, 2.126556f, 19.251f);
    public Vector3f CENTER = this.MAX.add(this.MIN).mult(0.5f);
    public Vector3f DELTA = this.MAX.subtract(this.CENTER);
    public int NUMPOINTS = 2000000;

    public static void main(String[] args) {
        TestPointCloud test1 = new TestPointCloud();
        test1.start();
    }

    public void simpleInitApp() {
        float[] points = this.generatePoints(this.NUMPOINTS);
        float[] colors = this.generateColors(this.NUMPOINTS);
        RawPointCloudGraphGenerator generator = new RawPointCloudGraphGenerator(this.assetManager);
        try {
            this.rootNode.attachChild((Spatial)generator.generatePointCloudGraph(points, colors));
        }
        catch (Exception e) {
            this.handleError(e.getMessage(), e);
        }
        this.cam.setFrustumPerspective(45.0f, (float)this.cam.getWidth() / (float)this.cam.getHeight(), 0.05f, 100.0f);
        this.cam.setLocation(new Vector3f(0.0f, 0.0f, -5.0f));
        this.cam.lookAtDirection(Vector3f.UNIT_Z, Vector3f.UNIT_Y);
        this.cam.update();
    }

    public float[] generatePoints(int numberOfPoints) {
        float[] result = new float[3 * numberOfPoints];
        Random random = new Random();
        for (int i = 0; i < numberOfPoints; ++i) {
            result[i * 3] = this.CENTER.x + this.DELTA.x * (random.nextFloat() - random.nextFloat());
            result[i * 3 + 1] = this.CENTER.y + this.DELTA.y * (random.nextFloat() - random.nextFloat());
            result[i * 3 + 2] = this.CENTER.z + this.DELTA.z * (random.nextFloat() - random.nextFloat());
        }
        return result;
    }

    public float[] generateColors(int numberOfPoints) {
        float[] result = new float[4 * numberOfPoints];
        Random random = new Random();
        for (int i = 0; i < numberOfPoints; ++i) {
            result[i * 4] = random.nextFloat();
            result[i * 4 + 1] = 0.5f + 0.5f * random.nextFloat();
            result[i * 4 + 2] = random.nextFloat();
            result[i * 4 + 3] = 1.0f;
        }
        return result;
    }
}

