/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.rendering;

import com.hybridlab.hyve3d.core.FrameRect;
import com.hybridlab.hyve3d.core.animation.AnimatedValueSetter;
import com.hybridlab.hyve3d.data.domainobjects.DrawingArea;
import com.hybridlab.hyve3d.data.valueobjects.Transformation;
import com.hybridlab.hyve3d.hyve.GlobalSettings;
import com.hybridlab.hyve3d.rendering.Jme3HyveDataVisualization;
import com.hybridlab.hyve3d.rendering.Jme3SessionVisualizer;
import com.hybridlab.hyve3d.rendering.ProgressVisualizer;
import com.jme3.asset.AssetManager;
import com.jme3.font.BitmapFont;
import com.jme3.font.BitmapText;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.debug.Arrow;
import com.jme3.scene.shape.Box;
import com.jme3.scene.shape.Line;
import com.jme3.scene.shape.Quad;
import com.jme3.scene.shape.Sphere;
import java.beans.PropertyChangeEvent;

public class Jme3DrawingAreaVisualization
extends Jme3HyveDataVisualization {
    private DrawingArea drawingArea;
    private String labelText;
    protected BitmapText label;
    protected BitmapText label2;
    private Node daRootNode;
    private Material matBottom;
    private Material matTop;
    private Material matLeft;
    private Material matRight;
    private Geometry frameTopMagenta;
    private Geometry frameBottomCyanNextToControls;
    private Geometry frameRightGreyNextToButton;
    private Geometry frameLeftYellowNextToCamera;
    private Geometry planeGeoFront;
    private Geometry touchDot;
    private float topDummyScale = 1.0f;
    private Material matTransparentDrawAreaUnShaded;
    private Style style = Style.REGULAR;
    private float thickness = 0.006f;
    private float zShiftForTransparentQuad = -0.8f * this.thickness;
    private ColorRGBA colorOfDrawingArea;
    private ColorRGBA frameColor = ColorRGBA.Blue;
    private float touchdotRadius = 0.02f;
    private static final float defaultBorderSizeFactor = 0.2f;
    private static final float defaultCursorSizeFactor = 0.35f;
    private static final float defaultTransparency = 0.8f;
    private float borderSizeFactor = 0.2f;
    private float cursorSizeFactor = 0.35f;
    private FrameRect frameRect = new FrameRect();
    private Transformation initialTransformation;
    private boolean isLocal = false;
    private AnimatedValueSetter translucencySetter;
    private final float whitevalue = 0.4f;
    private Node coordinateAxes;
    private boolean useFading = false;
    private Node satOrientationNode;
    private Spatial satOrientationAxes;
    private Spatial satOrientationAxesCorrected;

    public Jme3DrawingAreaVisualization(AssetManager assetManager, DrawingArea da, Jme3SessionVisualizer.Updater updater, ProgressVisualizer progressVisiualizer) {
        super(assetManager, da, updater, progressVisiualizer);
        this.drawingArea = da;
        this.frameColor = da.getRegularFrameColor();
        this.frameRect = da.getFrame();
        this.labelText = da.getName();
        this.initialTransformation = da.getTransformation().copy();
        this.addChange("building", new Runnable(){

            @Override
            public void run() {
                Jme3DrawingAreaVisualization.this.build();
            }
        });
    }

    public void setIsLocal() {
        this.isLocal = true;
    }

    private boolean isLocal() {
        return this.isLocal;
    }

    @Override
    public void destroy() {
        super.destroy();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() == this.drawingArea) {
            String prop = evt.getPropertyName();
            if (prop.endsWith("transformation")) {
                final Transformation t = (Transformation)evt.getNewValue();
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        Jme3DrawingAreaVisualization.this.getRootNode().setLocalTranslation(t.getPosition());
                        Jme3DrawingAreaVisualization.this.getRootNode().setLocalRotation(t.getRotation());
                        Jme3DrawingAreaVisualization.this.satOrientationNode.setLocalTranslation(t.getPosition());
                        Jme3DrawingAreaVisualization.this.orientAndPositionLabel();
                    }
                };
                this.addChange("transformation", r);
            } else if (prop.endsWith("satelliteorientation")) {
                final Quaternion o = (Quaternion)evt.getNewValue();
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        Jme3DrawingAreaVisualization.this.satOrientationAxes.setLocalRotation(o);
                        Jme3DrawingAreaVisualization.this.satOrientationNode.setCullHint(GlobalSettings.showSatelliteOrientationPhantomInDrawingArea != false ? Spatial.CullHint.Inherit : Spatial.CullHint.Always);
                    }
                };
                this.addChange("satelliteorientation", r);
            } else if (prop.endsWith("satelliteorientationcorrected")) {
                final Quaternion o = (Quaternion)evt.getNewValue();
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        Jme3DrawingAreaVisualization.this.satOrientationAxesCorrected.setLocalRotation(o);
                        Jme3DrawingAreaVisualization.this.satOrientationNode.setCullHint(GlobalSettings.showSatelliteOrientationPhantomInDrawingArea != false ? Spatial.CullHint.Inherit : Spatial.CullHint.Always);
                    }
                };
                this.addChange("satelliteorientationcorrected", r);
            } else if (prop.endsWith("name")) {
                this.labelText = (String)evt.getNewValue();
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        Jme3DrawingAreaVisualization.this.updateLabelText();
                    }
                };
                this.addChange("name", r);
            } else if (prop.endsWith("frame")) {
                final FrameRect fr = (FrameRect)evt.getNewValue();
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        Jme3DrawingAreaVisualization.this.frameRect = fr;
                        Jme3DrawingAreaVisualization.this.createOrUpdateFrameBorders();
                        Jme3DrawingAreaVisualization.this.orientAndPositionLabel();
                    }
                };
                this.addChange("frame", r);
            } else if (prop.endsWith("regularFrameColor")) {
                final ColorRGBA c = (ColorRGBA)evt.getNewValue();
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        Jme3DrawingAreaVisualization.this.frameColor = c;
                        Jme3DrawingAreaVisualization.this.setMaterialColors();
                    }
                };
                this.addChange("regularFrameColor", r);
            } else if (prop.endsWith("isTransLucent")) {
                if (this.isLocal()) {
                    final boolean b = (Boolean)evt.getNewValue();
                    Runnable r = new Runnable(){

                        @Override
                        public void run() {
                            Jme3DrawingAreaVisualization.this.setTranslucent(b);
                        }
                    };
                    this.addTodo(r);
                }
            } else if (prop.endsWith("isPaused")) {
                final boolean b = (Boolean)evt.getNewValue();
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        Jme3DrawingAreaVisualization.this.setPaused(b);
                    }
                };
                this.addTodo(r);
            } else if (prop.endsWith("cursorVisibility")) {
                final boolean b = (Boolean)evt.getNewValue();
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        Jme3DrawingAreaVisualization.this.touchDot.setCullHint(b ? Spatial.CullHint.Inherit : Spatial.CullHint.Always);
                    }
                };
                this.addTodo(r);
            } else if (prop.endsWith("cursorPosition")) {
                final Vector2f pos = (Vector2f)evt.getNewValue();
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        Jme3DrawingAreaVisualization.this.touchDot.setLocalTranslation(pos.x, pos.y, 0.0f);
                    }
                };
                this.addTodo(r);
            }
        }
    }

    protected void updateLabelText() {
        Object txt = this.labelText;
        switch (this.style) {
            case PAUSED: {
                txt = (String)txt + " - PAUSED";
                break;
            }
        }
        this.label.setText((String)txt);
        this.label2.setText((String)txt);
    }

    protected void setPaused(boolean isPaused) {
        this.style = isPaused ? Style.PAUSED : Style.REGULAR;
        this.coordinateAxes.setCullHint(isPaused ? Spatial.CullHint.Always : Spatial.CullHint.Inherit);
        this.setMaterialColors();
        this.updateLabelText();
    }

    protected void setTranslucent(boolean b) {
        if (this.useFading) {
            if (this.translucencySetter == null) {
                this.translucencySetter = new AnimatedValueSetter(new AnimatedValueSetter.SetableValue(){
                    float min = 0.0f;
                    float max = 0.8f;

                    @Override
                    public void setValue(float value) {
                        if (value <= this.min) {
                            Jme3DrawingAreaVisualization.this.colorOfDrawingArea = new ColorRGBA(0.4f, 0.4f, 0.4f, this.min);
                            Jme3DrawingAreaVisualization.this.planeGeoFront.setCullHint(Spatial.CullHint.Always);
                        } else if (value >= this.max) {
                            Jme3DrawingAreaVisualization.this.planeGeoFront.setCullHint(Spatial.CullHint.Inherit);
                            Jme3DrawingAreaVisualization.this.colorOfDrawingArea = new ColorRGBA(0.4f, 0.4f, 0.4f, this.max);
                        } else {
                            Jme3DrawingAreaVisualization.this.colorOfDrawingArea = new ColorRGBA(0.4f, 0.4f, 0.4f, value);
                            Jme3DrawingAreaVisualization.this.planeGeoFront.setCullHint(Spatial.CullHint.Inherit);
                        }
                        Jme3DrawingAreaVisualization.this.matTransparentDrawAreaUnShaded.setColor("Color", Jme3DrawingAreaVisualization.this.colorOfDrawingArea);
                    }

                    @Override
                    public float getMin() {
                        return this.min;
                    }

                    @Override
                    public float getMax() {
                        return this.max;
                    }
                }, this, 800);
            }
            this.translucencySetter.goToMax(b);
        } else {
            this.planeGeoFront.setCullHint(b ? Spatial.CullHint.Inherit : Spatial.CullHint.Always);
        }
    }

    protected void build() {
        this.satOrientationNode = new Node("satOrientation");
        this.getRootNode().getParent().attachChild((Spatial)this.satOrientationNode);
        this.satOrientationNode.setCullHint(GlobalSettings.showSatelliteOrientationPhantomInDrawingArea != false ? Spatial.CullHint.Inherit : Spatial.CullHint.Always);
        this.satOrientationAxes = this.createSatelliteCoordinateAxes(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.3f, 0.4f, 0.5f), ColorRGBA.Cyan, 3.0f);
        this.satOrientationNode.attachChild(this.satOrientationAxes);
        this.satOrientationAxesCorrected = this.createSatelliteCoordinateAxes(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.3f, 0.4f, 0.5f), ColorRGBA.Magenta, 3.0f);
        this.satOrientationNode.attachChild(this.satOrientationAxesCorrected);
        this.daRootNode = new Node("drawing area visualization node");
        this.getRootNode().attachChild((Spatial)this.daRootNode);
        this.matBottom = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        this.matTop = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        this.matLeft = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        this.matRight = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        this.setMaterialColors();
        this.createOrUpdateFrameBorders();
        this.createOrUpdateTouchDot();
        Material matdot = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        matdot.setColor("Color", ColorRGBA.Blue);
        this.touchDot.setMaterial(matdot);
        this.daRootNode.attachChild((Spatial)this.touchDot);
        this.frameTopMagenta.setMaterial(this.matTop);
        this.frameBottomCyanNextToControls.setMaterial(this.matBottom);
        this.frameRightGreyNextToButton.setMaterial(this.matRight);
        this.frameLeftYellowNextToCamera.setMaterial(this.matLeft);
        this.daRootNode.attachChild((Spatial)this.frameTopMagenta);
        this.daRootNode.attachChild((Spatial)this.frameRightGreyNextToButton);
        this.daRootNode.attachChild((Spatial)this.frameLeftYellowNextToCamera);
        this.daRootNode.attachChild((Spatial)this.frameBottomCyanNextToControls);
        this.coordinateAxes = this.createMyCoordinateAxes(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(1.0f, 1.0f, 1.0f));
        this.daRootNode.attachChild((Spatial)this.coordinateAxes);
        this.matTransparentDrawAreaUnShaded = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        float whitevalue = 0.4f;
        this.colorOfDrawingArea = new ColorRGBA(whitevalue, whitevalue, whitevalue, 0.7f);
        this.matTransparentDrawAreaUnShaded.setColor("Color", this.colorOfDrawingArea);
        this.matTransparentDrawAreaUnShaded.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        this.matTransparentDrawAreaUnShaded.getAdditionalRenderState().setFaceCullMode(RenderState.FaceCullMode.Off);
        this.planeGeoFront.setQueueBucket(RenderQueue.Bucket.Transparent);
        this.planeGeoFront.setMaterial(this.matTransparentDrawAreaUnShaded);
        this.planeGeoFront.setCullHint(Spatial.CullHint.Always);
        this.getRootNode().attachChild((Spatial)this.planeGeoFront);
        BitmapFont font = this.assetManager.loadFont("Interface/Fonts/Default.fnt");
        float textSize = 0.35f;
        this.label = new BitmapText(font, false);
        this.label.setSize(textSize);
        this.label.setText(this.labelText);
        this.label.setColor(new ColorRGBA(1.0f, 1.0f, 1.0f, 0.8f));
        this.label.rotate(0.0f, 0.0f, -1.5707964f);
        this.label2 = new BitmapText(font, false);
        this.label2.setSize(textSize);
        this.label2.setText(this.labelText);
        this.label2.setColor(new ColorRGBA(1.0f, 1.0f, 1.0f, 0.8f));
        this.label2.rotate(0.0f, (float)Math.PI, 0.0f);
        this.label2.rotate(0.0f, 0.0f, 1.5707964f);
        this.updateLabelText();
        this.getRootNode().attachChild((Spatial)this.label2);
        this.getRootNode().attachChild((Spatial)this.label);
        this.orientAndPositionLabel();
        Transformation t = this.initialTransformation;
        this.getRootNode().setLocalTranslation(t.getPosition().clone());
        this.getRootNode().setLocalRotation(t.getRotation().clone());
    }

    protected Node createMyCoordinateAxes(Vector3f pos, Vector3f sizeEachDimension) {
        Node node = new Node("axes");
        Line lx = new Line(Vector3f.ZERO, new Vector3f(sizeEachDimension.x, 0.0f, 0.0f));
        Line ly = new Line(Vector3f.ZERO, new Vector3f(0.0f, sizeEachDimension.y, 0.0f));
        lx.setLineWidth(2.0f);
        ly.setLineWidth(2.0f);
        Geometry g = this.putShape((Mesh)lx, ColorRGBA.Red);
        g.setLocalTranslation(pos);
        node.attachChild((Spatial)g);
        g = this.putShape((Mesh)ly, ColorRGBA.Green);
        g.setLocalTranslation(pos);
        node.attachChild((Spatial)g);
        Arrow arrow = new Arrow(new Vector3f(0.0f, 0.0f, sizeEachDimension.z));
        arrow.setLineWidth(2.0f);
        g = this.putShape((Mesh)arrow, ColorRGBA.Blue);
        g.setLocalTranslation(pos);
        node.attachChild((Spatial)g);
        return node;
    }

    private Node createSatelliteCoordinateAxes(Vector3f pos, Vector3f sizeEachDimension, ColorRGBA color, float linewidth) {
        Node node = new Node("axes");
        Line lx = new Line(Vector3f.ZERO, new Vector3f(sizeEachDimension.x, 0.0f, 0.0f));
        Line ly = new Line(Vector3f.ZERO, new Vector3f(0.0f, sizeEachDimension.y, 0.0f));
        lx.setLineWidth(linewidth);
        ly.setLineWidth(linewidth);
        Geometry g = this.putShape((Mesh)lx, color);
        g.setLocalTranslation(pos);
        node.attachChild((Spatial)g);
        g = this.putShape((Mesh)ly, color);
        g.setLocalTranslation(pos);
        node.attachChild((Spatial)g);
        Arrow arrow = new Arrow(new Vector3f(0.0f, 0.0f, sizeEachDimension.z));
        arrow.setLineWidth(2.0f);
        g = this.putShape((Mesh)arrow, ColorRGBA.Blue);
        g.setLocalTranslation(pos);
        node.attachChild((Spatial)g);
        return node;
    }

    private void orientAndPositionLabel() {
        float tabletFrameWidth = this.topDummyScale * this.frameRect.getWidth() * 0.5f;
        float tabletFrameHeight = this.topDummyScale * this.frameRect.getHeight() * 0.5f;
        Vector3f pos = new Vector3f(-tabletFrameHeight, tabletFrameWidth, 0.0f);
        this.label.setLocalTranslation(pos);
        this.label.setLocalScale(this.frameRect.getDiagonalLength() * 0.15f);
        this.label2.setLocalTranslation(pos.x, -pos.y, pos.z);
        this.label2.setLocalScale(this.frameRect.getDiagonalLength() * 0.15f);
    }

    private void setMaterialColors() {
        switch (this.style) {
            default: {
                boolean useDebugFrameColors = false;
                if (useDebugFrameColors) {
                    this.matBottom.setColor("Color", ColorRGBA.Cyan);
                    this.matTop.setColor("Color", ColorRGBA.Magenta);
                    this.matLeft.setColor("Color", ColorRGBA.Yellow);
                    this.matRight.setColor("Color", ColorRGBA.Gray);
                    break;
                }
                ColorRGBA frameColor = this.frameColor;
                this.matBottom.setColor("Color", frameColor);
                this.matTop.setColor("Color", frameColor);
                this.matLeft.setColor("Color", frameColor);
                this.matRight.setColor("Color", frameColor);
                break;
            }
            case ACTIVE_SELECTION_PROCESS: 
            case MODIFY_SELECTION: {
                ColorRGBA frameColor = ColorRGBA.Magenta;
                this.matBottom.setColor("Color", frameColor);
                this.matTop.setColor("Color", frameColor);
                this.matLeft.setColor("Color", frameColor);
                this.matRight.setColor("Color", frameColor);
                break;
            }
            case PAUSED: {
                ColorRGBA frameColor = ColorRGBA.Gray;
                this.matBottom.setColor("Color", frameColor);
                this.matTop.setColor("Color", frameColor);
                this.matLeft.setColor("Color", frameColor);
                this.matRight.setColor("Color", frameColor);
            }
        }
    }

    private void createOrUpdateTouchDot() {
        Spatial.CullHint touchdotHint;
        float r = this.touchdotRadius * this.frameRect.getDiagonalLength() * this.cursorSizeFactor;
        Sphere dotMesh = new Sphere(12, 12, r);
        if (this.touchDot == null) {
            this.touchDot = new Geometry("Touchdot", (Mesh)dotMesh);
        } else {
            this.touchDot.setMesh((Mesh)dotMesh);
        }
        if (this.drawingArea.getCursorVisibility().booleanValue()) {
            touchdotHint = Spatial.CullHint.Inherit;
            Vector2f pos = this.drawingArea.getCursorPosition();
            this.touchDot.setLocalTranslation(pos.x, pos.y, 0.0f);
        } else {
            touchdotHint = Spatial.CullHint.Always;
        }
        this.touchDot.setCullHint(touchdotHint);
    }

    private void createOrUpdateFrameBorders() {
        float borderthickness = this.borderSizeFactor * this.thickness * this.frameRect.getDiagonalLength();
        float tabletFrameWidth = this.topDummyScale * this.frameRect.getWidth() * 0.5f;
        float tabletFrameHeight = this.topDummyScale * this.frameRect.getHeight() * 0.5f;
        Box meshTop = new Box(borderthickness, tabletFrameWidth, borderthickness);
        Box meshBottom = new Box(borderthickness, tabletFrameWidth, borderthickness);
        Box meshRight = new Box(tabletFrameHeight, borderthickness, borderthickness);
        Box meshLeft = new Box(tabletFrameHeight, borderthickness, borderthickness);
        if (this.frameTopMagenta == null) {
            this.frameTopMagenta = new Geometry("frameTop", (Mesh)meshTop);
        } else {
            this.frameTopMagenta.setMesh((Mesh)meshTop);
        }
        if (this.frameBottomCyanNextToControls == null) {
            this.frameBottomCyanNextToControls = new Geometry("frameBottomCyanNextToControls", (Mesh)meshBottom);
        } else {
            this.frameBottomCyanNextToControls.setMesh((Mesh)meshBottom);
        }
        if (this.frameRightGreyNextToButton == null) {
            this.frameRightGreyNextToButton = new Geometry("frameRightNextToButton", (Mesh)meshRight);
        } else {
            this.frameRightGreyNextToButton.setMesh((Mesh)meshRight);
        }
        if (this.frameLeftYellowNextToCamera == null) {
            this.frameLeftYellowNextToCamera = new Geometry("frameLeftNextToCamera", (Mesh)meshLeft);
        } else {
            this.frameLeftYellowNextToCamera.setMesh((Mesh)meshLeft);
        }
        float positionFactor = 1.0f;
        this.frameTopMagenta.setLocalTranslation(positionFactor * tabletFrameHeight, 0.0f, 0.0f);
        this.frameBottomCyanNextToControls.setLocalTranslation(-positionFactor * tabletFrameHeight, 0.0f, 0.0f);
        this.frameRightGreyNextToButton.setLocalTranslation(0.0f, -positionFactor * tabletFrameWidth, 0.0f);
        this.frameLeftYellowNextToCamera.setLocalTranslation(0.0f, positionFactor * tabletFrameWidth, 0.0f);
        float planeXDimension = this.topDummyScale * this.frameRect.getHeight();
        float planeYDimension = this.topDummyScale * this.frameRect.getWidth();
        if (this.planeGeoFront == null) {
            this.planeGeoFront = new Geometry("planequad", (Mesh)new Quad(planeXDimension, planeYDimension));
        } else {
            this.planeGeoFront.setMesh((Mesh)new Quad(planeXDimension, planeYDimension));
        }
        float zShift = 0.0f;
        this.planeGeoFront.setLocalTranslation(planeXDimension * -0.5f, planeYDimension * -0.5f, zShift);
    }

    private static enum Style {
        REGULAR,
        ACTIVE_SELECTION_PROCESS,
        MODIFY_SELECTION,
        PAUSED;

    }

    static enum tabletPlanes {
        XZ,
        XY;

    }
}

