/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.rendering;

import com.hybridlab.hyve3d.data.HyveData;
import com.hybridlab.hyve3d.hyve.QueuedRunner;
import com.hybridlab.hyve3d.rendering.Jme3SessionVisualizer;
import com.hybridlab.hyve3d.rendering.ProgressVisualizer;
import com.jme3.asset.AssetManager;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.debug.Arrow;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;

public abstract class Jme3HyveDataVisualization
implements PropertyChangeListener,
QueuedRunner {
    private Node rootNode;
    protected AssetManager assetManager;
    private HyveData data;
    private Jme3SessionVisualizer.Updater updater;
    private TreeMap<String, Runnable> changes = new TreeMap();
    private List<Runnable> todos = new ArrayList<Runnable>();
    private ProgressVisualizer progressVisualizer;

    public Jme3HyveDataVisualization(AssetManager assetManager, HyveData data, Jme3SessionVisualizer.Updater updater, ProgressVisualizer progVis) {
        this.progressVisualizer = progVis;
        this.assetManager = assetManager;
        this.rootNode = new Node(this.getClass().getSimpleName() + " (" + String.valueOf(this.hashCode()) + ") Root");
        this.data = data;
        this.data.addPropertyChangeListener(this);
        this.updater = updater;
    }

    protected ProgressVisualizer getProgressVisualizer() {
        return this.progressVisualizer;
    }

    public Node getRootNode() {
        return this.rootNode;
    }

    public HyveData getData() {
        return this.data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addChange(String slot, Runnable r) {
        TreeMap<String, Runnable> treeMap = this.changes;
        synchronized (treeMap) {
            this.changes.put(slot, r);
        }
        this.updater.registerForUpdate(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTodo(Runnable r) {
        List<Runnable> list = this.todos;
        synchronized (list) {
            this.todos.add(r);
        }
        this.updater.registerForUpdate(this);
    }

    protected Geometry putShape(Mesh shape, ColorRGBA color) {
        Geometry g = new Geometry("coordinate axis", shape);
        Material mat = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        mat.getAdditionalRenderState().setWireframe(true);
        mat.setColor("Color", color);
        g.setMaterial(mat);
        return g;
    }

    protected Node createCoordinateAxes(Vector3f pos) {
        return this.createCoordinateAxes(pos, new Vector3f(2.0f, 2.0f, 2.0f));
    }

    protected Node createArrow(Vector3f pos, Vector3f dir, ColorRGBA color, float thickness) {
        Node node = new Node("axes");
        Arrow arrow = new Arrow(dir);
        arrow.setLineWidth(thickness);
        Geometry g = this.putShape((Mesh)arrow, color);
        g.setLocalTranslation(pos);
        node.attachChild((Spatial)g);
        return node;
    }

    protected Node createCoordinateAxes(Vector3f pos, Vector3f sizeEachDimension) {
        Node node = new Node("axes");
        Arrow arrow = new Arrow(new Vector3f(sizeEachDimension.x, 0.0f, 0.0f));
        arrow.setLineWidth(2.0f);
        Geometry g = this.putShape((Mesh)arrow, ColorRGBA.Red);
        g.setLocalTranslation(pos);
        node.attachChild((Spatial)g);
        arrow = new Arrow(new Vector3f(0.0f, sizeEachDimension.y, 0.0f));
        arrow.setLineWidth(2.0f);
        g = this.putShape((Mesh)arrow, ColorRGBA.Green);
        g.setLocalTranslation(pos);
        node.attachChild((Spatial)g);
        arrow = new Arrow(new Vector3f(0.0f, 0.0f, sizeEachDimension.z));
        arrow.setLineWidth(2.0f);
        g = this.putShape((Mesh)arrow, ColorRGBA.Blue);
        g.setLocalTranslation(pos);
        node.attachChild((Spatial)g);
        return node;
    }

    public void destroy() {
        if (this.data != null) {
            this.data.removePropertyChangeListener(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processChangesAndTodos() {
        ArrayList<Runnable> todosCopy;
        TreeMap<String, Runnable> treeMap = this.changes;
        synchronized (treeMap) {
            for (Runnable r : this.changes.values()) {
                r.run();
            }
            this.changes.clear();
        }
        Iterator iterator = this.todos;
        synchronized (iterator) {
            todosCopy = new ArrayList<Runnable>(this.todos);
            this.todos.clear();
        }
        for (Runnable r : todosCopy) {
            r.run();
        }
    }
}

