/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.rendering;

import com.hybridlab.hyve3d.data.Session;
import com.hybridlab.hyve3d.data.domainobjects.Asset;
import com.hybridlab.hyve3d.data.domainobjects.DirectionalLight;
import com.hybridlab.hyve3d.data.domainobjects.Sky;
import com.hybridlab.hyve3d.geometry.SceneCoordinateSystem;
import com.hybridlab.hyve3d.pointcloud.AbstractPointCloudGraphGenerator;
import com.hybridlab.hyve3d.pointcloud.PointCloudData;
import com.hybridlab.hyve3d.pointcloud.PointCloudHelper;
import com.hybridlab.hyve3d.pointcloud.RawPointCloudGraphGenerator;
import com.hybridlab.hyve3d.rendering.ErrorVisualizer;
import com.hybridlab.hyve3d.rendering.Jme3ThreadingHelper;
import com.jme3.asset.AssetManager;
import com.jme3.asset.DesktopAssetManager;
import com.jme3.asset.TextureKey;
import com.jme3.asset.plugins.FileLocator;
import com.jme3.asset.plugins.ZipLocator;
import com.jme3.light.AmbientLight;
import com.jme3.light.Light;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.debug.Arrow;
import com.jme3.scene.debug.Grid;
import com.jme3.texture.Texture;
import com.jme3.util.SkyFactory;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;

public class Jme3HyveSceneManager {
    private boolean grid = true;
    private boolean city = false;
    private boolean sky = false;
    private Spatial citySceneModel;
    private Spatial gokceTestSceneModel;
    private Spatial skySpatial;
    private Spatial cubes1000Model;
    private Spatial carModel;
    private AssetManager assetManager;
    private Jme3ThreadingHelper jme3ThreadingHelper;
    private ErrorVisualizer errorVisualizer;
    private String tempFolder;
    private String assetPath;
    private Node gridnode;
    private Node cameraRigRootNode;
    private Node subSceneNode;
    private Node importedGeometriesNode;
    private AmbientLightAdapter ambientLightl;
    private DirectionalLightAdapter directionalLight_1;
    private DirectionalLightAdapter directionalLight_2;
    private AbstractPointCloudGraphGenerator generator;

    public Jme3HyveSceneManager(AssetManager assetManager, Jme3ThreadingHelper jme3ThreadingHelper, ErrorVisualizer errorVisualizer, String tempFolder) {
        this.tempFolder = tempFolder;
        this.assetManager = assetManager;
        this.jme3ThreadingHelper = jme3ThreadingHelper;
        this.errorVisualizer = errorVisualizer;
        this.buildSceneComponents();
    }

    public void setAssetPath(String pathWithTrailingDash) {
        this.assetPath = pathWithTrailingDash;
    }

    public LightAdapter getAmbient() {
        return this.ambientLightl;
    }

    public LightAdapter getDirectional1() {
        return this.directionalLight_1;
    }

    public LightAdapter getDirectional2() {
        return this.directionalLight_2;
    }

    public void removeLight(com.hybridlab.hyve3d.data.domainobjects.Light l) {
        if (l.getId().equals(this.ambientLightl.getLightId())) {
            this.ambientLightl.disconnect();
        } else if (l.getId().equals(this.directionalLight_1.getLightId())) {
            this.directionalLight_1.disconnect();
        } else if (l.getId().equals(this.directionalLight_2.getLightId())) {
            this.directionalLight_2.disconnect();
        }
    }

    public void addLight(com.hybridlab.hyve3d.data.domainobjects.Light l) {
        if (l.getId().equals(this.ambientLightl.getLightId())) {
            this.ambientLightl.connect(l);
        } else if (l.getId().equals(this.directionalLight_1.getLightId())) {
            DirectionalLight dl = (DirectionalLight)l;
            this.directionalLight_1.connect(dl);
        } else if (l.getId().equals(this.directionalLight_2.getLightId())) {
            DirectionalLight dl = (DirectionalLight)l;
            this.directionalLight_2.connect(dl);
        }
    }

    public Node getCamerRigGroupNode() {
        return this.cameraRigRootNode;
    }

    public Node getSceneNode() {
        return this.subSceneNode;
    }

    private void buildSceneComponents() {
        AmbientLight al = new AmbientLight();
        al.setColor(ColorRGBA.White.mult(0.5f));
        this.ambientLightl = new AmbientLightAdapter(al, Session.defaultAmbientLightUUID);
        com.jme3.light.DirectionalLight dl = new com.jme3.light.DirectionalLight();
        dl.setColor(ColorRGBA.White);
        dl.setDirection(Vector3f.UNIT_Y.negate());
        this.directionalLight_1 = new DirectionalLightAdapter(dl, Session.defaultDirectionalLight_1_UUID);
        com.jme3.light.DirectionalLight dl2 = new com.jme3.light.DirectionalLight();
        dl2.setColor(ColorRGBA.White);
        dl2.setDirection(Vector3f.UNIT_Y.negate());
        this.directionalLight_2 = new DirectionalLightAdapter(dl2, Session.defaultDirectionalLight_2_UUID);
        this.subSceneNode = new Node("subSceneNode");
        this.importedGeometriesNode = new Node("importedGeometriesNode");
        this.subSceneNode.attachChild((Spatial)this.importedGeometriesNode);
        this.cameraRigRootNode = new Node("cameraRigRootNode");
        this.subSceneNode.attachChild((Spatial)this.cameraRigRootNode);
        if (this.grid) {
            this.buildGrid();
        }
        if (this.city) {
            this.loadCityScene();
            this.showCityScene();
        }
        if (this.sky) {
            this.loadSky();
        }
    }

    private void buildGrid() {
        this.gridnode = new SceneCoordinateSystem(this.assetManager);
        this.subSceneNode.attachChild((Spatial)this.gridnode);
    }

    public void hideCar() {
        if (this.carModel != null) {
            this.subSceneNode.detachChild(this.carModel);
        }
    }

    public void showCar() {
        if (this.loadCar()) {
            this.subSceneNode.attachChild(this.carModel);
        }
    }

    public void showCubes1000() {
        if (this.loadCubes1000()) {
            this.subSceneNode.attachChild(this.cubes1000Model);
        }
    }

    public void hideCubes1000() {
        if (this.cubes1000Model != null) {
            this.subSceneNode.detachChild(this.cubes1000Model);
        }
    }

    public void showCityScene() {
        if (this.loadCityScene()) {
            this.subSceneNode.attachChild(this.citySceneModel);
        }
    }

    public void hideCityScene() {
        if (this.citySceneModel != null) {
            this.subSceneNode.detachChild(this.citySceneModel);
        }
    }

    public void showGokceTestScene() {
        if (this.loadGokceTestScene()) {
            this.subSceneNode.attachChild(this.gokceTestSceneModel);
        }
    }

    public void hideGokceTestScene() {
        if (this.gokceTestSceneModel != null) {
            this.subSceneNode.detachChild(this.gokceTestSceneModel);
        }
    }

    public void showSky() {
        this.loadSky();
        this.subSceneNode.attachChild(this.skySpatial);
    }

    public void hideSky() {
        if (this.skySpatial != null) {
            this.subSceneNode.detachChild(this.skySpatial);
        }
    }

    private boolean loadGokceTestScene() {
        if (this.gokceTestSceneModel == null) {
            try {
                String rootPath = this.assetPath + "testfieldcolored.zip";
                this.assetManager.registerLocator(rootPath, ZipLocator.class);
                this.gokceTestSceneModel = this.assetManager.loadModel("testfieldcolored.scene");
                this.gokceTestSceneModel.setLocalTranslation(0.0f, -1.0f, 0.0f);
                this.gokceTestSceneModel.setLocalScale(2.0f);
                return true;
            }
            catch (Exception e) {
                this.errorVisualizer.showReasonOfException(e);
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    private boolean loadCar() {
        if (this.carModel == null) {
            try {
                this.assetManager.registerLocator("fiat500.zip", ZipLocator.class);
                this.carModel = this.assetManager.loadModel("fiat500.scene");
                return true;
            }
            catch (Exception e) {
                this.errorVisualizer.showReasonOfException(e);
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    private boolean loadCubes1000() {
        if (this.cubes1000Model == null) {
            try {
                String rootPath = this.assetPath + "cubes1000.zip";
                this.assetManager.registerLocator(rootPath, ZipLocator.class);
                this.cubes1000Model = this.assetManager.loadModel("cubes1000.scene");
                return true;
            }
            catch (Exception e) {
                this.errorVisualizer.showReasonOfException(e);
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    private boolean loadCityScene() {
        if (this.citySceneModel == null) {
            try {
                this.assetManager.registerLocator("town.zip", ZipLocator.class);
                this.citySceneModel = this.assetManager.loadModel("main.scene");
                this.citySceneModel.setLocalTranslation(0.0f, -1.0f, 0.0f);
                this.citySceneModel.setShadowMode(RenderQueue.ShadowMode.CastAndReceive);
                return true;
            }
            catch (Exception e) {
                this.errorVisualizer.showReasonOfException(e);
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    public void loadSky() {
        if (this.skySpatial == null) {
            TextureKey key = new TextureKey("Textures/Sky/Bright/FullskiesBlueClear03.dds", true);
            key.setGenerateMips(true);
            Texture skyTex = this.assetManager.loadTexture(key);
            this.skySpatial = SkyFactory.createSky((AssetManager)this.assetManager, (Texture)skyTex, (SkyFactory.EnvMapType)SkyFactory.EnvMapType.CubeMap);
        }
    }

    public void loadSky(File f) throws Exception {
        if (this.skySpatial == null) {
            String dir = f.getAbsolutePath();
            String file = f.getName();
            this.assetManager.registerLocator(dir, FileLocator.class);
            TextureKey key = new TextureKey(file, true);
            key.setGenerateMips(true);
            Texture skyTex = this.assetManager.loadTexture(key);
            this.skySpatial = SkyFactory.createSky((AssetManager)this.assetManager, (Texture)skyTex, (SkyFactory.EnvMapType)SkyFactory.EnvMapType.CubeMap);
        }
    }

    private Node createCoordinateAxes(Vector3f pos) {
        Node node = new Node("axes");
        Arrow arrow = new Arrow(new Vector3f(10.0f, 0.0f, 0.0f));
        arrow.setLineWidth(4.0f);
        Geometry g = this.putShape((Mesh)arrow, ColorRGBA.Red);
        g.setLocalTranslation(pos);
        node.attachChild((Spatial)g);
        arrow = new Arrow(new Vector3f(0.0f, 10.0f, 0.0f));
        arrow.setLineWidth(4.0f);
        g = this.putShape((Mesh)arrow, ColorRGBA.Green);
        g.setLocalTranslation(pos);
        node.attachChild((Spatial)g);
        arrow = new Arrow(new Vector3f(0.0f, 0.0f, 10.0f));
        arrow.setLineWidth(4.0f);
        g = this.putShape((Mesh)arrow, ColorRGBA.Blue);
        g.setLocalTranslation(pos);
        node.attachChild((Spatial)g);
        return node;
    }

    private Geometry putShape(Mesh shape, ColorRGBA color) {
        Geometry g = new Geometry("coordinate axis", shape);
        Material mat = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        mat.getAdditionalRenderState().setWireframe(true);
        mat.setColor("Color", color);
        g.setMaterial(mat);
        return g;
    }

    private Geometry createGrid(Vector3f pos, int size, ColorRGBA color) {
        Geometry g = new Geometry("wireframe grid", (Mesh)new Grid(size, size, 0.2f));
        Material mat = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        mat.getAdditionalRenderState().setWireframe(true);
        mat.setColor("Color", color);
        g.setMaterial(mat);
        g.center().move(pos);
        return g;
    }

    public void update(float tpf) {
        this.subSceneNode.updateLogicalState(tpf);
        this.subSceneNode.updateGeometricState();
    }

    public Future<Spatial> loadSkyReturnFuture(final String path, final String file, final Sky.SourceType sourceType) {
        Callable<Spatial> loader = new Callable<Spatial>(){

            @Override
            public Spatial call() throws Exception {
                try {
                    try {
                        DesktopAssetManager dam = (DesktopAssetManager)Jme3HyveSceneManager.this.assetManager;
                        dam.clearCache();
                    }
                    catch (Exception e) {
                        Jme3HyveSceneManager.this.errorVisualizer.showReasonOfException(e);
                        e.printStackTrace();
                    }
                    switch (sourceType) {
                        case DDS: {
                            Jme3HyveSceneManager.this.assetManager.registerLocator(path, FileLocator.class);
                            TextureKey key = new TextureKey(file, true);
                            key.setGenerateMips(true);
                            Texture skyTex = Jme3HyveSceneManager.this.assetManager.loadTexture(key);
                            Spatial loadedSkySpatial = SkyFactory.createSky((AssetManager)Jme3HyveSceneManager.this.assetManager, (Texture)skyTex, (SkyFactory.EnvMapType)SkyFactory.EnvMapType.CubeMap);
                            return loadedSkySpatial;
                        }
                    }
                }
                catch (Exception e) {
                    Jme3HyveSceneManager.this.errorVisualizer.showReasonOfException(e);
                    e.printStackTrace();
                }
                return null;
            }
        };
        FutureTask<Spatial> ttt = new FutureTask<Spatial>(loader);
        ExecutorService executor = Executors.newFixedThreadPool(2);
        executor.execute(ttt);
        return ttt;
    }

    public Future<Spatial> loadPointCloudReturnFuture(final String path, final String file) {
        Callable<Spatial> loader = new Callable<Spatial>(){

            @Override
            public Spatial call() throws Exception {
                try {
                    try {
                        DesktopAssetManager dam = (DesktopAssetManager)Jme3HyveSceneManager.this.assetManager;
                        dam.clearCache();
                    }
                    catch (Exception e) {
                        Jme3HyveSceneManager.this.errorVisualizer.showReasonOfException(e);
                        e.printStackTrace();
                    }
                    if (Jme3HyveSceneManager.this.generator == null) {
                        Jme3HyveSceneManager.this.generator = new RawPointCloudGraphGenerator(Jme3HyveSceneManager.this.assetManager);
                    }
                    float[] points = null;
                    float[] colors = null;
                    boolean randomcloud = false;
                    if (randomcloud) {
                        points = PointCloudHelper.generatePoints(PointCloudHelper.NUMPOINTS);
                        colors = PointCloudHelper.generateColors(PointCloudHelper.NUMPOINTS);
                    } else {
                        PointCloudData pcd = PointCloudHelper.parsePlyFile(path, file);
                        points = pcd.points;
                        colors = pcd.colors;
                    }
                    Node pointcloudroot = new Node("PointCloud from File '" + path + file + "'");
                    pointcloudroot.attachChild((Spatial)Jme3HyveSceneManager.this.generator.generatePointCloudGraph(points, colors));
                    return pointcloudroot;
                }
                catch (Exception e) {
                    Jme3HyveSceneManager.this.errorVisualizer.showReasonOfException(e);
                    e.printStackTrace();
                    return null;
                }
            }
        };
        FutureTask<Spatial> ttt = new FutureTask<Spatial>(loader);
        ExecutorService executor = Executors.newFixedThreadPool(2);
        executor.execute(ttt);
        return ttt;
    }

    public Future<Spatial> loadFBXReturnFuture(final String path, final String file, Asset.Type type) {
        Callable<Spatial> loader = new Callable<Spatial>(){

            @Override
            public Spatial call() throws Exception {
                try {
                    try {
                        DesktopAssetManager dam = (DesktopAssetManager)Jme3HyveSceneManager.this.assetManager;
                        dam.clearCache();
                    }
                    catch (Exception e) {
                        Jme3HyveSceneManager.this.errorVisualizer.showReasonOfException(e);
                        e.printStackTrace();
                    }
                    Jme3HyveSceneManager.this.assetManager.registerLocator(path, FileLocator.class);
                    Spatial loadedSpatial = Jme3HyveSceneManager.this.assetManager.loadModel(file);
                    return loadedSpatial;
                }
                catch (Exception e) {
                    Jme3HyveSceneManager.this.errorVisualizer.showReasonOfException(e);
                    e.printStackTrace();
                    return null;
                }
            }
        };
        FutureTask<Spatial> ttt = new FutureTask<Spatial>(loader);
        ExecutorService executor = Executors.newFixedThreadPool(2);
        executor.execute(ttt);
        return ttt;
    }

    public Future<Spatial> loadObjReturnFuture(final String path, final String file, final Asset.Type type) {
        Callable<Spatial> loader = new Callable<Spatial>(){

            @Override
            public Spatial call() throws Exception {
                try {
                    try {
                        DesktopAssetManager dam = (DesktopAssetManager)Jme3HyveSceneManager.this.assetManager;
                        dam.clearCache();
                    }
                    catch (Exception e) {
                        Jme3HyveSceneManager.this.errorVisualizer.showReasonOfException(e);
                        e.printStackTrace();
                    }
                    boolean isZip = type.equals((Object)Asset.Type.OBJ_ZIPPED);
                    if (isZip) {
                        String scene = file.replace(".zip", ".obj");
                        Jme3HyveSceneManager.this.assetManager.registerLocator(path + file, ZipLocator.class);
                        Spatial loadedSpatial = Jme3HyveSceneManager.this.assetManager.loadModel(scene);
                        return loadedSpatial;
                    }
                    Jme3HyveSceneManager.this.assetManager.registerLocator(path, FileLocator.class);
                    Spatial loadedSpatial = Jme3HyveSceneManager.this.assetManager.loadModel(file);
                    return loadedSpatial;
                }
                catch (Exception e) {
                    Jme3HyveSceneManager.this.errorVisualizer.showReasonOfException(e);
                    e.printStackTrace();
                    return null;
                }
            }
        };
        FutureTask<Spatial> ttt = new FutureTask<Spatial>(loader);
        ExecutorService executor = Executors.newFixedThreadPool(2);
        executor.execute(ttt);
        return ttt;
    }

    public Future<Spatial> loadOgreZipReturnFuture(final String path, final String file) {
        Callable<Spatial> loader = new Callable<Spatial>(){

            @Override
            public Spatial call() throws Exception {
                try {
                    DesktopAssetManager dam = (DesktopAssetManager)Jme3HyveSceneManager.this.assetManager;
                    dam.clearCache();
                }
                catch (Exception e) {
                    Jme3HyveSceneManager.this.errorVisualizer.showReasonOfException(e);
                    e.printStackTrace();
                }
                try {
                    String scene = file.replace(".zip", ".scene");
                    Jme3HyveSceneManager.this.assetManager.registerLocator(path + file, ZipLocator.class);
                    Spatial loadedSpatial = Jme3HyveSceneManager.this.assetManager.loadModel(scene);
                    return loadedSpatial;
                }
                catch (Exception e) {
                    Jme3HyveSceneManager.this.errorVisualizer.showReasonOfException(e);
                    e.printStackTrace();
                    return null;
                }
            }
        };
        FutureTask<Spatial> ttt = new FutureTask<Spatial>(loader);
        ExecutorService executor = Executors.newFixedThreadPool(2);
        executor.execute(ttt);
        return ttt;
    }

    public void loadOgreZip(final String path, final String file) {
        Callable<Object> loader = new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                try {
                    DesktopAssetManager dam = (DesktopAssetManager)Jme3HyveSceneManager.this.assetManager;
                    dam.clearCache();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    String scene = file.replace(".zip", ".scene");
                    Jme3HyveSceneManager.this.assetManager.registerLocator(path + file, ZipLocator.class);
                    Spatial loadedSpatial = Jme3HyveSceneManager.this.assetManager.loadModel(scene);
                    Jme3HyveSceneManager.this.importedGeometriesNode.attachChild(loadedSpatial);
                }
                catch (Exception e) {
                    Jme3HyveSceneManager.this.errorVisualizer.showReasonOfException(e);
                    e.printStackTrace();
                }
                return null;
            }
        };
        if (this.jme3ThreadingHelper.isThreadEqualToRenderThread(Thread.currentThread())) {
            try {
                loader.call();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.jme3ThreadingHelper.enqueue(loader);
        }
    }

    public void clearAllImportedModels() {
        this.importedGeometriesNode.detachAllChildren();
    }

    public void setBackGrounds(Set<String> allItems) {
        if (allItems.contains("City")) {
            this.showCityScene();
        } else {
            this.hideCityScene();
            this.hideSky();
        }
        if (allItems.contains("Car")) {
            this.showCar();
        } else {
            this.hideCar();
        }
        if (allItems.contains("Cubes")) {
            this.showCubes1000();
        } else {
            this.hideCubes1000();
        }
        if (allItems.contains("Test")) {
            this.showGokceTestScene();
        } else {
            this.hideGokceTestScene();
        }
    }

    public String getTempFolder() {
        return this.tempFolder;
    }

    public void teardownObj(String path, String file, Asset.Type type) {
        try {
            try {
                DesktopAssetManager dam = (DesktopAssetManager)this.assetManager;
                dam.clearCache();
            }
            catch (Exception e) {
                this.errorVisualizer.showReasonOfException(e);
                e.printStackTrace();
            }
            boolean isZip = type.equals((Object)Asset.Type.OBJ_ZIPPED);
            if (isZip) {
                this.assetManager.unregisterLocator(path + file, ZipLocator.class);
            } else {
                this.assetManager.unregisterLocator(path, FileLocator.class);
            }
        }
        catch (Exception e) {
            this.errorVisualizer.showReasonOfException(e);
            e.printStackTrace();
        }
    }

    public void teardownOgreZip(String path, String file) {
        try {
            DesktopAssetManager dam = (DesktopAssetManager)this.assetManager;
            dam.clearCache();
        }
        catch (Exception e) {
            this.errorVisualizer.showReasonOfException(e);
            e.printStackTrace();
        }
        try {
            this.assetManager.unregisterLocator(path + file, ZipLocator.class);
        }
        catch (Exception e) {
            this.errorVisualizer.showReasonOfException(e);
            e.printStackTrace();
        }
    }

    public void teardownPointCloud(String path, String file) {
    }

    private class AmbientLightAdapter
    extends AbstractLightAdapter {
        public AmbientLightAdapter(AmbientLight al, UUID lid) {
            super((Light)al, lid);
        }

        @Override
        public Vector3f getDirection() {
            return Vector3f.ZERO;
        }

        @Override
        public void setDirection(Vector3f v) {
        }
    }

    private class DirectionalLightAdapter
    extends AbstractLightAdapter {
        private com.jme3.light.DirectionalLight dirlight;
        private DirectionalLight sessionDirectionalLight;

        public DirectionalLightAdapter(com.jme3.light.DirectionalLight dl, UUID luid) {
            super((Light)dl, luid);
            this.dirlight = dl;
        }

        public void connect(DirectionalLight sesLight) {
            super.connect(sesLight);
            this.sessionDirectionalLight = sesLight;
            this.update();
        }

        private void update() {
            this.setRealLightDirection(this.sessionDirectionalLight.getDirection());
        }

        @Override
        public Vector3f getDirection() {
            if (this.sessionDirectionalLight != null) {
                return this.sessionDirectionalLight.getDirection();
            }
            return this.dirlight.getDirection();
        }

        @Override
        public void setDirection(Vector3f v) {
            if (this.sessionDirectionalLight != null) {
                this.sessionDirectionalLight.setDirection(v);
            } else {
                this.setRealLightDirection(v);
            }
        }

        private void setRealLightDirection(final Vector3f v) {
            Callable<Object> c = new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    DirectionalLightAdapter.this.dirlight.setDirection(v);
                    DirectionalLightAdapter.this.hasChanged();
                    return null;
                }
            };
            if (Jme3HyveSceneManager.this.jme3ThreadingHelper.isThreadEqualToRenderThread(Thread.currentThread())) {
                try {
                    c.call();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                Jme3HyveSceneManager.this.jme3ThreadingHelper.enqueue(c);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String prop;
            super.propertyChange(evt);
            if (evt.getSource() == this.sessionDirectionalLight && (prop = evt.getPropertyName()).endsWith("direction")) {
                Vector3f d = (Vector3f)evt.getNewValue();
                this.setRealLightDirection(d);
            }
        }
    }

    private abstract class AbstractLightAdapter
    implements LightAdapter,
    PropertyChangeListener {
        private Light light;
        private UUID lightId;
        private Set<LightAdapter.HasChangedListener> listener = new HashSet<LightAdapter.HasChangedListener>();
        private boolean isEnabled;
        private com.hybridlab.hyve3d.data.domainobjects.Light sessionLight;

        public AbstractLightAdapter(Light light, UUID lid) {
            this.light = light;
            this.lightId = lid;
        }

        @Override
        public void add(LightAdapter.HasChangedListener l) {
            this.listener.add(l);
        }

        @Override
        public boolean getEnabled() {
            if (this.sessionLight != null) {
                return this.sessionLight.getEnabled();
            }
            return this.isEnabled;
        }

        @Override
        public void setEnabled(boolean enabled) {
            if (this.sessionLight != null) {
                this.sessionLight.setEnabled(enabled);
            } else {
                this.setRealLightEnabled(enabled);
            }
        }

        @Override
        public ColorRGBA getColor() {
            if (this.sessionLight != null) {
                return this.sessionLight.getColor();
            }
            return this.light.getColor();
        }

        @Override
        public void setColor(ColorRGBA color) {
            if (this.sessionLight != null) {
                this.sessionLight.setColor(color);
            } else {
                this.setRealLightColor(color);
            }
        }

        public void setRealLightColor(final ColorRGBA color) {
            Callable<Object> c = new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    AbstractLightAdapter.this.light.setColor(color);
                    AbstractLightAdapter.this.hasChanged();
                    return null;
                }
            };
            if (Jme3HyveSceneManager.this.jme3ThreadingHelper.isThreadEqualToRenderThread(Thread.currentThread())) {
                try {
                    c.call();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                Jme3HyveSceneManager.this.jme3ThreadingHelper.enqueue(c);
            }
        }

        protected void hasChanged() {
            for (LightAdapter.HasChangedListener l : this.listener) {
                l.hasChanged();
            }
        }

        public UUID getLightId() {
            return this.lightId;
        }

        public void connect(com.hybridlab.hyve3d.data.domainobjects.Light sesLight) {
            if (this.sessionLight != null) {
                this.sessionLight.removePropertyChangeListener(this);
            }
            this.sessionLight = sesLight;
            this.sessionLight.addPropertyChangeListener(this);
            this.update();
        }

        private void update() {
            this.setRealLightColor(this.sessionLight.getColor());
            this.setRealLightEnabled(this.sessionLight.getEnabled());
        }

        public void disconnect() {
            this.setRealLightEnabled(false);
            this.sessionLight.removePropertyChangeListener(this);
            this.sessionLight = null;
        }

        private void setRealLightEnabled(final boolean enabled) {
            Callable<Object> c = new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    AbstractLightAdapter.this.isEnabled = enabled;
                    if (AbstractLightAdapter.this.isEnabled) {
                        Jme3HyveSceneManager.this.subSceneNode.addLight(AbstractLightAdapter.this.light);
                    } else {
                        Jme3HyveSceneManager.this.subSceneNode.removeLight(AbstractLightAdapter.this.light);
                    }
                    AbstractLightAdapter.this.hasChanged();
                    return null;
                }
            };
            if (Jme3HyveSceneManager.this.jme3ThreadingHelper.isThreadEqualToRenderThread(Thread.currentThread())) {
                try {
                    c.call();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                Jme3HyveSceneManager.this.jme3ThreadingHelper.enqueue(c);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() == this.sessionLight) {
                String prop = evt.getPropertyName();
                if (prop.endsWith("color")) {
                    ColorRGBA c = (ColorRGBA)evt.getNewValue();
                    this.setRealLightColor(c);
                } else if (prop.endsWith("enabled")) {
                    Boolean e = (Boolean)evt.getNewValue();
                    this.setRealLightEnabled(e);
                }
            }
        }
    }

    public static interface LightAdapter {
        public boolean getEnabled();

        public void setEnabled(boolean var1);

        public Vector3f getDirection();

        public void setDirection(Vector3f var1);

        public ColorRGBA getColor();

        public void setColor(ColorRGBA var1);

        public void add(HasChangedListener var1);

        public static interface HasChangedListener {
            public void hasChanged();
        }
    }
}

