/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.rendering;

import com.hybridlab.hyve3d.data.domainobjects.Sky;
import com.hybridlab.hyve3d.data.valueobjects.Transformation;
import com.hybridlab.hyve3d.files.ImportOptions;
import com.hybridlab.hyve3d.rendering.Jme3HyveDataVisualization;
import com.hybridlab.hyve3d.rendering.Jme3HyveSceneManager;
import com.hybridlab.hyve3d.rendering.Jme3SessionVisualizer;
import com.hybridlab.hyve3d.rendering.ProgressVisualizer;
import com.jme3.asset.AssetManager;
import com.jme3.math.Quaternion;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Locale;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;

public class Jme3SkyVisualization
extends Jme3HyveDataVisualization {
    private Sky skyAsset;
    private ImportOptions importOptions;
    private Jme3HyveSceneManager sceneManager;
    private Node importTrfNode = new Node("importTransform");
    private boolean bugfixOfBlackSkyFacesIssueWhenNavigating = true;
    private Node parentNode;
    private Spatial sky;
    private boolean debug = false;

    public Jme3SkyVisualization(AssetManager assetManager, Jme3HyveSceneManager sceneManager, Jme3SessionVisualizer.Updater updater, Sky skyAsset, ProgressVisualizer progVis) {
        super(assetManager, skyAsset, updater, progVis);
        this.sceneManager = sceneManager;
        this.skyAsset = skyAsset;
        if (this.bugfixOfBlackSkyFacesIssueWhenNavigating) {
            this.parentNode = sceneManager.getSceneNode();
        }
        this.importOptions = skyAsset.getImportOptionsInstance();
        this.addTodo(new Runnable(){

            @Override
            public void run() {
                Jme3SkyVisualization.this.build();
            }
        });
    }

    public void detachHideQuickTestBugFix() {
        if (this.bugfixOfBlackSkyFacesIssueWhenNavigating && this.parentNode != null && this.sky != null) {
            this.addTodo(new Runnable(){

                @Override
                public void run() {
                    Jme3SkyVisualization.this.parentNode.detachChild(Jme3SkyVisualization.this.sky);
                }
            });
        }
    }

    protected void build() {
        File f = new File(this.skyAsset.getPath(), this.skyAsset.getFile());
        if (!f.exists() || this.debug) {
            this.debug = false;
            String targetFolder = this.sceneManager.getTempFolder() + this.skyAsset.getId().toString() + "/";
            f = new File(targetFolder, this.skyAsset.getFile());
            try {
                FileUtils.forceMkdir(new File(targetFolder));
                IOUtils.write(this.skyAsset.getFileContent(), (OutputStream)new FileOutputStream(f));
                if (this.skyAsset.isMultipleFileAsset()) {
                    String[] assetMultipleFileList = this.skyAsset.getMultipleFileList();
                    for (int i = 0; i < assetMultipleFileList.length; ++i) {
                        String mf = assetMultipleFileList[i];
                        File ff = new File(targetFolder, mf);
                        IOUtils.write(this.skyAsset.getMultipleFileContent(i), (OutputStream)new FileOutputStream(ff));
                    }
                }
                String path = targetFolder;
                this.skyAsset.setPath(path);
                String fileName = FilenameUtils.getName(f.getName());
                this.skyAsset.setFile(fileName);
                this.build();
                return;
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (f.exists()) {
            switch (this.skyAsset.getSourceType()) {
                case DDS: {
                    Future<Spatial> future = this.sceneManager.loadSkyReturnFuture(this.skyAsset.getPath(), this.skyAsset.getFile(), this.skyAsset.getSourceType());
                    this.addTodo(new Check(future));
                    break;
                }
                default: {
                    Logger.getAnonymousLogger().severe("Unable to visualize Sky with type='" + this.skyAsset.getSourceType() + "' !");
                    break;
                }
            }
        } else {
            System.out.println("File does not exist: " + f.toString());
        }
    }

    private void applyAssetTransformationToRootNode() {
        Transformation t = this.skyAsset.getTransformation();
        Node root = this.getRootNode();
        root.setLocalTranslation(t.getPosition());
        root.setLocalRotation(t.getRotation());
        root.setLocalScale(t.getScale());
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String prop;
        if (evt.getSource() == this.skyAsset && (prop = evt.getPropertyName()).endsWith("transformation")) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    Jme3SkyVisualization.this.applyAssetTransformationToRootNode();
                }
            };
            this.addChange("transformation", r);
        }
    }

    private class Check
    implements Runnable {
        private int checkNum;
        private long startmillisCheckZero;
        private Future<Spatial> future;

        public Check(Future<Spatial> future, int check, long starttime) {
            this.startmillisCheckZero = starttime;
            this.future = future;
            this.checkNum = check;
        }

        public Check(Future<Spatial> future) {
            this(future, 0, System.currentTimeMillis());
        }

        @Override
        public void run() {
            if (this.future.isDone()) {
                if (!this.future.isCancelled()) {
                    try {
                        Spatial s = this.future.get();
                        if (s != null) {
                            if (Jme3SkyVisualization.this.bugfixOfBlackSkyFacesIssueWhenNavigating) {
                                Jme3SkyVisualization.this.sky = s;
                                Jme3SkyVisualization.this.parentNode.attachChild(s);
                            } else {
                                Node root = Jme3SkyVisualization.this.getRootNode();
                                float scale = Jme3SkyVisualization.this.importOptions.getScaleFactor();
                                System.out.println("importTrfNode.setLocalScale(" + scale + ");");
                                Jme3SkyVisualization.this.importTrfNode.setLocalScale(scale);
                                Quaternion rotation = Jme3SkyVisualization.this.importOptions.getRotation();
                                Jme3SkyVisualization.this.importTrfNode.setLocalRotation(rotation);
                                Jme3SkyVisualization.this.importTrfNode.attachChild(s);
                                root.attachChild((Spatial)Jme3SkyVisualization.this.importTrfNode);
                                Jme3SkyVisualization.this.applyAssetTransformationToRootNode();
                            }
                            Jme3SkyVisualization.this.getProgressVisualizer().setProgressText(Jme3SkyVisualization.this.skyAsset.getId().toString() + "-loading", "loading " + Jme3SkyVisualization.this.skyAsset.getFile() + " finished (" + this.getDuration() + ") !");
                            Jme3SkyVisualization.this.getProgressVisualizer().setProgressComplete(Jme3SkyVisualization.this.skyAsset.getId().toString() + "-loading");
                        }
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    catch (ExecutionException e) {
                        e.printStackTrace();
                    }
                }
            } else {
                Jme3SkyVisualization.this.getProgressVisualizer().setProgressText(Jme3SkyVisualization.this.skyAsset.getId().toString() + "-loading", "loading " + Jme3SkyVisualization.this.skyAsset.getFile() + " still checking (" + this.getDuration() + ") ...");
                Jme3SkyVisualization.this.addTodo(new Check(this.future, this.checkNum + 1, this.startmillisCheckZero));
            }
        }

        private String getDuration() {
            long duration = System.currentTimeMillis() - this.startmillisCheckZero;
            double dur = (double)duration * 0.001;
            return String.format(Locale.ENGLISH, "%.2f seconds", dur);
        }
    }
}

