/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.rendering;

import com.hybridlab.hyve3d.data.domainobjects.Space;
import com.hybridlab.hyve3d.data.valueobjects.Transformation;
import com.hybridlab.hyve3d.rendering.Jme3HyveDataVisualization;
import com.hybridlab.hyve3d.rendering.Jme3SessionVisualizer;
import com.hybridlab.hyve3d.rendering.ProgressVisualizer;
import com.jme3.asset.AssetManager;
import com.jme3.font.BitmapFont;
import com.jme3.font.BitmapText;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Cylinder;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class Jme3SpaceVisualization
extends Jme3HyveDataVisualization
implements PropertyChangeListener {
    private Space space;
    private Node visualizationRoot = new Node();
    private BitmapText label;
    private BitmapText label2;
    private boolean islocal = false;
    private String spaceLabelText;
    private Jme3SessionVisualizer sessionVisualizer;
    private boolean visible = true;

    public Jme3SpaceVisualization(AssetManager assetManager, Space space, Jme3SessionVisualizer.Updater visUpdater, Jme3SessionVisualizer sessionVisualizer, ProgressVisualizer progressVisualizer) {
        super(assetManager, space, visUpdater, progressVisualizer);
        this.space = space;
        this.sessionVisualizer = sessionVisualizer;
        Transformation t = space.getTransformation();
        Node root = this.getRootNode();
        root.setLocalTranslation(t.getPosition());
        root.setLocalRotation(t.getRotation());
        this.spaceLabelText = space.getName();
        this.addChange("building", new Runnable(){

            @Override
            public void run() {
                Jme3SpaceVisualization.this.build();
            }
        });
    }

    public Space getSpace() {
        return this.space;
    }

    @Override
    public void destroy() {
        super.destroy();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() == this.space) {
            String prop = evt.getPropertyName();
            if (prop.endsWith("transformation")) {
                final Transformation t = (Transformation)evt.getNewValue();
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        Node root = Jme3SpaceVisualization.this.getRootNode();
                        root.setLocalTranslation(t.getPosition());
                        root.setLocalRotation(t.getRotation());
                        if (Jme3SpaceVisualization.this.islocal) {
                            Jme3SpaceVisualization.this.sessionVisualizer.onTransformationHasChangedInLocalVisualization(Jme3SpaceVisualization.this, t);
                        } else {
                            Jme3SpaceVisualization.this.sessionVisualizer.onTransformationHasChangedInRemoteVisualization(Jme3SpaceVisualization.this, t);
                        }
                    }
                };
                this.addChange("transformation", r);
            } else if (prop.endsWith("name")) {
                this.spaceLabelText = (String)evt.getNewValue();
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        Jme3SpaceVisualization.this.label.setText(Jme3SpaceVisualization.this.spaceLabelText);
                        Jme3SpaceVisualization.this.label2.setText(Jme3SpaceVisualization.this.spaceLabelText);
                    }
                };
                this.addChange("name", r);
            }
        }
    }

    private void build() {
        Material matMagenta = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        matMagenta.setColor("Color", this.islocal ? ColorRGBA.Green : ColorRGBA.Magenta);
        float r1 = 0.25f;
        float r2 = 0.25f;
        float h = 0.1f;
        Cylinder shape = new Cylinder(4, 16, r1, r2, h, true, false);
        Geometry g = new Geometry("center", (Mesh)shape);
        g.setMaterial(matMagenta);
        g.rotate(1.5707964f, 0.0f, 0.0f);
        this.visualizationRoot.attachChild((Spatial)g);
        float l = 1.0f;
        this.visualizationRoot.attachChild((Spatial)this.createArrow(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, -1.0f * l), this.islocal ? ColorRGBA.Green : ColorRGBA.Magenta, 10.0f));
        BitmapFont font = this.assetManager.loadFont("Interface/Fonts/Default.fnt");
        Vector3f pos = new Vector3f(0.0f, 0.65f, 0.0f);
        this.label = new BitmapText(font, false);
        float textSize = 0.35f;
        this.label.setSize(textSize);
        this.label.setText(this.spaceLabelText);
        this.label.setColor(new ColorRGBA(1.0f, 1.0f, 1.0f, 0.8f));
        this.label.setLocalTranslation(pos);
        this.label2 = new BitmapText(font, false);
        this.label2.setSize(textSize);
        this.label2.setText(this.spaceLabelText);
        this.label2.setColor(new ColorRGBA(1.0f, 1.0f, 1.0f, 0.8f));
        this.label2.setLocalTranslation(pos);
        this.label2.rotate(0.0f, (float)Math.PI, 0.0f);
        if (!this.islocal) {
            this.getRootNode().attachChild((Spatial)this.label);
            this.getRootNode().attachChild((Spatial)this.label2);
            this.getRootNode().attachChild((Spatial)this.visualizationRoot);
        }
        this.orientAndPositionLabel();
    }

    private void orientAndPositionLabel() {
    }

    public void setIsLocal() {
        this.islocal = true;
    }

    public void setVisible(boolean b) {
        if (this.visible != b) {
            this.visible = b;
            this.getRootNode().setCullHint(b ? Spatial.CullHint.Inherit : Spatial.CullHint.Always);
        }
    }
}

