/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.rendering;

import com.hybridlab.hyve3d.data.domainobjects.Stroke;
import com.hybridlab.hyve3d.data.valueobjects.Ink;
import com.hybridlab.hyve3d.data.valueobjects.StrokePoint;
import com.hybridlab.hyve3d.data.valueobjects.Transformation;
import com.hybridlab.hyve3d.geometry.Line;
import com.hybridlab.hyve3d.geometry.StrokeFaceMesh;
import com.hybridlab.hyve3d.rendering.Jme3HyveDataVisualization;
import com.hybridlab.hyve3d.rendering.Jme3SessionVisualizer;
import com.hybridlab.hyve3d.rendering.ProgressVisualizer;
import com.jme3.asset.AssetManager;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import java.beans.IndexedPropertyChangeEvent;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;

public class Jme3StrokeVisualization
extends Jme3HyveDataVisualization {
    private Stroke stroke;
    private float thicknessVisualizationFactor = 1.0f;
    private Line strokeLine;
    private float baseThickness = 1.0f;
    private ColorRGBA color;
    private ArrayList<StrokePoint> strokePoints;
    private Vector3f[] points;
    private Geometry strokeLineGeometry;
    private StrokeFaceMesh strokeFaceMesh;
    private Material mat;
    private Ink.Style style;
    protected ColorRGBA selectedcolor = ColorRGBA.Magenta;

    public Jme3StrokeVisualization(AssetManager assetManager, Stroke stroke, Jme3SessionVisualizer.Updater visUpdater, ProgressVisualizer progressVisualizer) {
        super(assetManager, stroke, visUpdater, progressVisualizer);
        this.stroke = stroke;
        this.thicknessVisualizationFactor = Jme3SessionVisualizer.getLineWidthMultiplyFactor();
        this.baseThickness = stroke.getBaseThickness();
        this.color = stroke.getColor();
        this.style = stroke.getStyle();
        this.strokePoints = stroke.getAllPoints();
        Node root = this.getRootNode();
        Transformation t = stroke.getTransformation();
        root.setLocalTranslation(t.getPosition());
        root.setLocalRotation(t.getRotation());
        root.setLocalScale(t.getScale());
        this.build();
    }

    @Override
    public void destroy() {
        super.destroy();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() == this.stroke) {
            String prop = evt.getPropertyName();
            if (evt instanceof IndexedPropertyChangeEvent) {
                StrokePoint sp;
                IndexedPropertyChangeEvent ipce = (IndexedPropertyChangeEvent)evt;
                if (prop.endsWith("point") && (sp = (StrokePoint)ipce.getNewValue()) != null) {
                    this.addTodo(new Runnable(){

                        @Override
                        public void run() {
                            Jme3StrokeVisualization.this.strokePoints.add(sp);
                            Jme3StrokeVisualization.this.strokeFaceMesh.addStrokePoint(sp);
                            Jme3StrokeVisualization.this.update();
                        }
                    });
                }
            } else if (prop.endsWith("transformation")) {
                final Transformation t = (Transformation)evt.getNewValue();
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        Node root = Jme3StrokeVisualization.this.getRootNode();
                        root.setLocalTranslation(t.getPosition());
                        root.setLocalRotation(t.getRotation());
                        root.setLocalScale(t.getScale());
                    }
                };
                this.addChange("transformation", r);
            } else if (prop.endsWith("style")) {
                final Ink.Style newstyle = (Ink.Style)((Object)evt.getNewValue());
                this.addChange("style", new Runnable(){

                    @Override
                    public void run() {
                        Jme3StrokeVisualization.this.style = newstyle;
                        Jme3StrokeVisualization.this.showOrHideStrokeVisualizationsDependingOnCurrentStyle();
                    }
                });
            } else if (prop.endsWith("selected")) {
                final boolean selected = (Boolean)evt.getNewValue();
                this.addChange("selected", new Runnable(){

                    @Override
                    public void run() {
                        Jme3StrokeVisualization.this.mat.setColor("Color", selected ? Jme3StrokeVisualization.this.selectedcolor : Jme3StrokeVisualization.this.color);
                        if (Jme3StrokeVisualization.this.strokeFaceMesh != null) {
                            Jme3StrokeVisualization.this.strokeFaceMesh.setColor(selected ? Jme3StrokeVisualization.this.selectedcolor : Jme3StrokeVisualization.this.color);
                        }
                    }
                });
            }
        }
    }

    private Vector3f[] getPointsForLine() {
        this.points = new Vector3f[this.strokePoints.size()];
        int i = 0;
        for (StrokePoint sp : this.strokePoints) {
            this.points[i++] = sp.getPoint3d();
        }
        return this.points;
    }

    private void update() {
        this.strokeLine.feed(this.getPointsForLine());
        this.getRootNode().updateGeometricState();
        this.getRootNode().updateModelBound();
    }

    private void build() {
        this.strokeLine = new Line(Mesh.Mode.LineStrip, this.getPointsForLine());
        this.strokeLine.feed(this.getPointsForLine());
        this.mat = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        this.mat.getAdditionalRenderState().setLineWidth(this.baseThickness * this.thicknessVisualizationFactor);
        this.mat.setColor("Color", this.color);
        this.strokeLineGeometry = new Geometry("Stroke", (Mesh)this.strokeLine);
        this.strokeLineGeometry.setShadowMode(RenderQueue.ShadowMode.CastAndReceive);
        this.strokeLineGeometry.setMaterial(this.mat);
        this.strokeFaceMesh = new StrokeFaceMesh(this.assetManager, this.color, this.stroke.getBaseThickness());
        this.strokeFaceMesh.initialize(this.strokePoints);
        this.showOrHideStrokeVisualizationsDependingOnCurrentStyle();
    }

    private void showOrHideStrokeVisualizationsDependingOnCurrentStyle() {
        if (this.strokeFaceMesh != null) {
            this.getRootNode().attachChild((Spatial)this.strokeFaceMesh);
        }
        if (this.strokeLineGeometry != null) {
            this.getRootNode().attachChild((Spatial)this.strokeLineGeometry);
        }
        switch (this.style) {
            case FACE: {
                if (this.strokeFaceMesh != null) {
                    this.getRootNode().attachChild((Spatial)this.strokeFaceMesh);
                }
                if (this.strokeLineGeometry == null) break;
                this.getRootNode().detachChild((Spatial)this.strokeLineGeometry);
                break;
            }
            case LINE: {
                if (this.strokeFaceMesh != null) {
                    this.getRootNode().detachChild((Spatial)this.strokeFaceMesh);
                }
                if (this.strokeLineGeometry == null) break;
                this.getRootNode().attachChild((Spatial)this.strokeLineGeometry);
                break;
            }
        }
    }
}

