/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.scenemanipulation;

import com.hybridlab.hyve3d.scenemanipulation.Volume;
import com.hybridlab.utils.math.Rectangle3D;
import com.jme3.math.Plane;
import com.jme3.math.Vector3f;
import com.jogamp.opengl.math.geom.AABBox;

public class ConvexBiRectangleVolume
implements Volume {
    private Plane[] walls;
    private AABBox aabbox;
    private Rectangle3D a;
    private Rectangle3D b;

    public ConvexBiRectangleVolume(Rectangle3D a, Rectangle3D b) {
        this.a = a;
        this.b = b;
    }

    public Rectangle3D getFirstRect() {
        return this.a;
    }

    public Rectangle3D getSecondRect() {
        return this.b;
    }

    @Override
    public AABBox getAABBox() {
        if (this.aabbox == null) {
            this.aabbox = this.a.getAABBox();
            this.aabbox.resize(this.b.getAABBox());
        }
        return this.aabbox;
    }

    @Override
    public boolean contains(Vector3f v) {
        if (!this.getAABBox().contains(v.x, v.y, v.z)) {
            return false;
        }
        if (this.walls == null) {
            this.buildWallNormals();
        }
        for (Plane testPlane : this.walls) {
            Plane.Side side = testPlane.whichSide(v);
            if (side != Plane.Side.Positive) continue;
            return false;
        }
        return true;
    }

    private void buildWallNormals() {
        boolean isReverse;
        Vector3f[] normals = new Vector3f[10];
        Vector3f[] pointsOnPlanes = new Vector3f[10];
        Vector3f[] cornersOfA = this.a.getCorners();
        Vector3f[] cornersOfB = this.b.getCorners();
        normals[0] = this.a.getNormal().clone().negate();
        pointsOnPlanes[0] = cornersOfA[0];
        normals[1] = this.b.getNormal().clone();
        pointsOnPlanes[1] = cornersOfB[0];
        Vector3f a0_to_b0 = cornersOfB[0].subtract(cornersOfA[0]);
        Vector3f a1_to_b1 = cornersOfB[1].subtract(cornersOfA[1]);
        Vector3f a2_to_b2 = cornersOfB[2].subtract(cornersOfA[2]);
        Vector3f a3_to_b3 = cornersOfB[3].subtract(cornersOfA[3]);
        Vector3f a0_to_a1 = cornersOfA[1].subtract(cornersOfA[0]);
        Vector3f a1_to_a2 = cornersOfA[2].subtract(cornersOfA[1]);
        Vector3f a2_to_a3 = cornersOfA[3].subtract(cornersOfA[2]);
        Vector3f a3_to_a0 = cornersOfA[0].subtract(cornersOfA[3]);
        Vector3f a0_to_b1 = cornersOfB[1].subtract(cornersOfA[0]);
        Vector3f a1_to_b2 = cornersOfB[2].subtract(cornersOfA[1]);
        Vector3f a2_to_b3 = cornersOfB[3].subtract(cornersOfA[2]);
        Vector3f a3_to_b0 = cornersOfB[0].subtract(cornersOfA[3]);
        normals[2] = a0_to_b0.cross(a0_to_b1).normalizeLocal();
        pointsOnPlanes[2] = cornersOfA[0];
        normals[3] = a0_to_b1.cross(a0_to_a1).normalizeLocal();
        pointsOnPlanes[3] = cornersOfA[1];
        normals[4] = a1_to_b1.cross(a1_to_b2).normalizeLocal();
        pointsOnPlanes[4] = cornersOfA[1];
        normals[5] = a1_to_b2.cross(a1_to_a2).normalizeLocal();
        pointsOnPlanes[5] = cornersOfA[2];
        normals[6] = a2_to_b2.cross(a2_to_b3).normalizeLocal();
        pointsOnPlanes[6] = cornersOfA[2];
        normals[7] = a2_to_b3.cross(a2_to_a3).normalizeLocal();
        pointsOnPlanes[7] = cornersOfA[3];
        normals[8] = a3_to_b3.cross(a3_to_b0).normalizeLocal();
        pointsOnPlanes[8] = cornersOfA[3];
        normals[9] = a3_to_b0.cross(a3_to_a0).normalizeLocal();
        pointsOnPlanes[9] = cornersOfA[0];
        boolean bl = isReverse = a0_to_b0.dot(this.a.getNormal()) < 0.0f;
        if (isReverse) {
            for (Vector3f n : normals) {
                n.negateLocal();
            }
        }
        this.walls = new Plane[10];
        for (int i = 0; i < 10; ++i) {
            float constant = pointsOnPlanes[i].dot(normals[i]);
            this.walls[i] = new Plane(normals[i], constant);
        }
    }
}

