/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.scenemanipulation;

import com.hybridlab.hyve3d.core.FrameRect;
import com.hybridlab.hyve3d.data.decorators.Transformer;
import com.hybridlab.hyve3d.data.domainobjects.DrawingArea;
import com.hybridlab.hyve3d.data.valueobjects.Transformation;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class DrawingAreaListeningTransformer
implements Transformer,
PropertyChangeListener {
    private Transformer.TransformerListener listener = null;
    private DrawingArea drawingArea;
    private Transform trf = new Transform();

    public DrawingAreaListeningTransformer(DrawingArea drawingArea) {
        this.drawingArea = drawingArea;
        Transformation datrf = this.drawingArea.getTransformation();
        FrameRect frame = this.drawingArea.getFrame();
        float sc = frame.getDiagonalLength();
        Vector3f scale = new Vector3f(sc, sc, sc);
        this.trf = new Transform(datrf.getPosition(), datrf.getRotation(), scale);
        this.drawingArea.addPropertyChangeListener("transformation", this);
        this.drawingArea.addPropertyChangeListener("frame", this);
    }

    @Override
    public void connectChangeListener(Transformer.TransformerListener l) {
        this.listener = l;
    }

    @Override
    public void disconnectChangeListener(Transformer.TransformerListener l) {
        if (this.listener == l) {
            this.listener = null;
        }
    }

    private void fireChange(Transform oldValue, Transform newValue) {
        if (this.listener != null) {
            this.listener.hasChanged(oldValue, newValue);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() == this.drawingArea) {
            String prop = evt.getPropertyName();
            if (prop.endsWith("transformation")) {
                Transformation t = (Transformation)evt.getNewValue();
                this.updateTransformation(t);
            } else if (prop.endsWith("frame")) {
                FrameRect fr = (FrameRect)evt.getNewValue();
                this.updateFrame(fr);
            }
        }
    }

    private void updateTransformation(Transformation t) {
        if (!t.getRotation().equals((Object)this.trf.getRotation()) || !t.getPosition().equals((Object)this.trf.getTranslation())) {
            Transform old = this.trf.clone();
            this.trf.setTranslation(t.getPosition());
            this.trf.setRotation(t.getRotation());
            this.fireChange(old, this.trf);
        }
    }

    private void updateFrame(FrameRect fr) {
        float sc = fr.getDiagonalLength();
        Vector3f scale = new Vector3f(sc, sc, sc);
        if (this.trf.getScale() != scale) {
            Transform old = this.trf.clone();
            this.trf.setScale(scale);
            this.fireChange(old, this.trf);
        }
    }

    @Override
    public Transform getCurrentValue() {
        return this.trf;
    }
}

