/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.scenemanipulation;

import com.hybridlab.hyve3d.core.commands.SetSatelliteSelectionModeCommand;
import com.hybridlab.hyve3d.data.decorators.TransformableSelection;
import com.hybridlab.hyve3d.data.domainobjects.DrawingArea;
import com.hybridlab.hyve3d.data.domainobjects.Selectable;
import com.hybridlab.hyve3d.data.domainobjects.Selection;
import com.hybridlab.hyve3d.data.valueobjects.Transformation;
import com.hybridlab.hyve3d.hyve.SatelliteDrawingAreaAdapter;
import com.hybridlab.hyve3d.hyve.SelectableProvider;
import com.hybridlab.hyve3d.hyve.undoredo.DrawingAreaTransformerState;
import com.hybridlab.hyve3d.hyve.undoredo.SelectionCommand;
import com.hybridlab.hyve3d.hyve.undoredo.SelectionTransformationCommand;
import com.hybridlab.hyve3d.hyve.undoredo.TransformerState;
import com.hybridlab.hyve3d.scenemanipulation.BrailedVolume;
import com.hybridlab.hyve3d.scenemanipulation.DrawingAreaListeningTransformer;
import com.hybridlab.hyve3d.scenemanipulation.DrawingAreaRectangleBrailer;
import com.hybridlab.hyve3d.scenemanipulation.SelectionModificationMode;
import com.hybridlab.hyve3d.scenemanipulation.Selector;
import com.hybridlab.hyve3d.scenemanipulation.VolumeSelectionProcess;
import com.hybridlab.utils.math.MathUtils;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Logger;

public class SceneElementSelector
implements VolumeSelectionProcess.ProcessObserver,
Selector.SelectorObserver {
    private List<VolumeSelectionProcess> processes = new ArrayList<VolumeSelectionProcess>();
    private Map<VolumeSelectionProcess, Selector> currentRunningSelectionProcesses = new HashMap<VolumeSelectionProcess, Selector>();
    private TransformableSelection selection;
    private Selection sessionSelection;
    private DrawingArea drawingArea;
    private DrawingAreaRectangleBrailer brailer;
    private SelectableProvider provider;
    private DrawingAreaListeningTransformer transformer;
    private SelectionModificationMode modificationMode = SelectionModificationMode.ADDSTROKE;
    private Logger logger = Logger.getLogger(SceneElementSelector.class.getSimpleName());
    private SelectionTransformationCommand selectionTrfCommand;
    private SelectionCommand selCmd;

    public SceneElementSelector(DrawingArea da) {
        this.setDrawingArea(da);
    }

    public void setDrawingArea(DrawingArea drawingArea) {
        if (this.drawingArea != drawingArea) {
            if (this.drawingArea != null) {
                if (this.brailer != null) {
                    this.brailer.destroy();
                    this.brailer = null;
                }
                if (this.selection != null) {
                    this.selection.disconnectTransformer();
                    this.selection.clear();
                    this.selection = null;
                }
                this.drawingArea = null;
            }
            this.drawingArea = drawingArea;
            this.brailer = new DrawingAreaRectangleBrailer(this.drawingArea);
            this.transformer = new DrawingAreaListeningTransformer(this.drawingArea);
            this.selection = new TransformableSelection(this.transformer);
        }
    }

    public synchronized boolean hasSomethingSelected() {
        return !this.selection.isEmpty();
    }

    private void beginSelection() {
        this.endRunningSelectionProcesses();
        this.selCmd = new SelectionCommand(this.modificationMode);
        this.selCmd.setTransformerStateBefore(this.getTransformerState());
        VolumeSelectionProcess p = new VolumeSelectionProcess(this.brailer);
        this.processes.add(p);
        p.setSelectionMode(this.modificationMode);
        p.registerProcessObserver(this);
        p.startBrailing();
    }

    private void endSelection() {
        this.selCmd.setTransformerStateAfter(this.getTransformerState());
        this.endRunningSelectionProcesses();
    }

    public void setSelectionModificationMode(SelectionModificationMode modificationMode) {
        this.modificationMode = modificationMode;
    }

    private void endRunningSelectionProcesses() {
        if (this.processes.isEmpty()) {
            this.logger.severe("no volumeSelectionProcesses in: " + this + "to stop");
        } else {
            VolumeSelectionProcess lastProcess = this.processes.get(this.processes.size() - 1);
            if (lastProcess.isActive()) {
                lastProcess.unRegisterProcessObserver(this);
                lastProcess.stopBrailing();
            }
        }
    }

    public void processCommand(SetSatelliteSelectionModeCommand selectionCmd) {
        this.setSelectionModificationMode(selectionCmd.getModificationMode());
        if (selectionCmd.getIsSelectionModeEnabled()) {
            this.beginSelection();
        } else {
            this.endSelection();
        }
    }

    @Override
    public void onStarted(VolumeSelectionProcess process) {
        BrailedVolume v = process.getVolume();
        Selector selector = new Selector(v, this.provider, process);
        selector.addSelectionObserver(this);
        this.currentRunningSelectionProcesses.put(process, selector);
    }

    @Override
    public void onFinished(VolumeSelectionProcess process) {
        Selector sel = this.currentRunningSelectionProcesses.get(process);
        sel.finish();
        this.currentRunningSelectionProcesses.remove(process);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onElementSelectionHasChanged(Selector selector, Set<Selectable> newlySelected, Set<Selectable> notSelected, Set<Selectable> selected) {
        TransformableSelection transformableSelection = this.selection;
        synchronized (transformableSelection) {
            VolumeSelectionProcess p = selector.getProcess();
            switch (p.getSelectionMode()) {
                case ADDSTROKE: {
                    if (this.sessionSelection == null) {
                        this.sessionSelection = this.provider.createNewSelection(this.drawingArea.getId());
                    }
                    for (Selectable s : newlySelected) {
                        if (!this.selection.add(s)) continue;
                        s.setSelected(true);
                        this.sessionSelection.addItemId(s.getId());
                        this.selCmd.add(s.getId());
                    }
                    break;
                }
                case REMOVESTROKE: {
                    for (Selectable s : newlySelected) {
                        if (!this.selection.remove(s)) continue;
                        s.setSelected(false);
                        this.sessionSelection.removeItemId(s.getId());
                        this.selCmd.add(s.getId());
                    }
                    if (!this.selection.isEmpty() || this.sessionSelection == null) break;
                    this.provider.removeSelection(this.sessionSelection);
                    break;
                }
            }
        }
    }

    public Set<Selectable> getSelected() {
        return Collections.unmodifiableSet(this.selection.getAll());
    }

    public void dismissSelection() {
        for (Selectable s : this.selection.getAll()) {
            s.setSelected(false);
        }
        this.selection.clear();
        if (this.sessionSelection != null) {
            this.sessionSelection.clear();
        }
    }

    public void prepareSelectionTransformation(SatelliteDrawingAreaAdapter.DrawingAreaPlaceMentOption option) {
        System.out.println("prepareSelectionTransformation(" + option + ") ");
        Quaternion rot = this.drawingArea.getTransformation().getRotation();
        Vector3f pos = this.drawingArea.getTransformation().getPosition();
        switch (option) {
            case DoNothing: {
                break;
            }
            case SnapToVerticalOrHorizontalPlane: {
                this.selection.calculateCenter();
                float snapAngle = 0.7853982f;
                rot = MathUtils.snapSimple(rot, snapAngle);
                pos = this.selection.getCenter();
            }
        }
        Transformation newTransformation = new Transformation(pos, rot);
        this.drawingArea.setTransformation(newTransformation);
    }

    public void beginSelectionTransformation(SelectionTransformationCommand selectionTrfCommand) {
        this.selectionTrfCommand = selectionTrfCommand;
        this.selectionTrfCommand.setBefore(this.getSelected());
        this.selectionTrfCommand.setTransformerStateBefore(this.getTransformerState());
        this.selection.connectTransformer();
    }

    public SelectionTransformationCommand endSelectionTransformation() {
        this.selection.disconnectTransformer();
        this.selectionTrfCommand.setAfter(this.getSelected());
        this.selectionTrfCommand.setTransformerStateAfter(this.getTransformerState());
        return this.selectionTrfCommand;
    }

    private TransformerState getTransformerState() {
        DrawingAreaTransformerState state = new DrawingAreaTransformerState(this.drawingArea.getId(), this.drawingArea.getTransformation().copy(), this.drawingArea.getFrame().getCopy());
        return state;
    }

    public void setSelectableProvider(SelectableProvider p) {
        this.provider = p;
    }

    public SelectionCommand beginOrEndSelection(boolean isSelectionModeEnabled) {
        if (isSelectionModeEnabled) {
            this.beginSelection();
            return null;
        }
        this.endSelection();
        return this.selCmd;
    }

    public void add(Set<UUID> ids) {
        if (this.sessionSelection == null) {
            this.sessionSelection = this.provider.createNewSelection(this.drawingArea.getId());
        }
        for (UUID id : ids) {
            Selectable s = this.provider.get(id);
            if (s == null) {
                System.out.println("Could not retrieve Selectable <" + id + "> in " + SceneElementSelector.class.getSimpleName() + " add(Set<UUID> ids)!\n" + Arrays.toString(Thread.currentThread().getStackTrace()));
                continue;
            }
            if (!this.selection.add(s)) continue;
            s.setSelected(true);
            this.sessionSelection.addItemId(s.getId());
        }
    }

    public void remove(Set<UUID> ids) {
        for (UUID id : ids) {
            Selectable s = this.provider.get(id);
            if (!this.selection.remove(s)) continue;
            s.setSelected(false);
            if (this.sessionSelection == null) continue;
            this.sessionSelection.removeItemId(s.getId());
        }
        if (this.selection.isEmpty() && this.sessionSelection != null) {
            this.provider.removeSelection(this.sessionSelection);
        }
    }

    public void regainSelection(Set<UUID> ids) {
        this.add(ids);
    }
}

