/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.scenemanipulation;

import com.hybridlab.hyve3d.data.domainobjects.Selectable;
import com.hybridlab.hyve3d.hyve.SelectableProvider;
import com.hybridlab.hyve3d.scenemanipulation.BrailedVolume;
import com.hybridlab.hyve3d.scenemanipulation.Volume;
import com.hybridlab.hyve3d.scenemanipulation.VolumeSelectionProcess;
import com.hybridlab.utils.Shuffle;
import com.hybridlab.utils.math.MathUtils;
import com.jme3.math.Vector3f;
import com.jogamp.opengl.math.geom.AABBox;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class Selector
implements BrailedVolume.VolumeObserver,
Runnable,
SelectableProvider.SelectableCollectionListener {
    private BrailedVolume volume;
    private Thread selectionCalculatorThread;
    private boolean calculating = false;
    private Set<Selectable> selectedObjects = new HashSet<Selectable>();
    private Set<Selectable> notSelectedObjects;
    private boolean needsUpdate = false;
    private Set<SelectorObserver> observer = new HashSet<SelectorObserver>();
    private VolumeSelectionProcess process;
    private Set<Integer> volumePartNumbersToCheck = new HashSet<Integer>();
    private SelectableProvider selectableProvider;
    Map<Selectable, int[]> strokeIndiciesMap = new HashMap<Selectable, int[]>();

    public Selector(BrailedVolume volume, SelectableProvider provider, VolumeSelectionProcess process) {
        this.process = process;
        this.selectableProvider = provider;
        this.selectableProvider.addSelectableCollectionListener(this);
        this.notSelectedObjects = new HashSet<Selectable>(this.selectableProvider.getAllCurrentlySelectable());
        this.volume = volume;
        this.volume.addVolumeObserver(this);
        this.selectionCalculatorThread = new Thread((Runnable)this, this.toString());
        this.selectionCalculatorThread.start();
    }

    public void finish() {
        this.observer.clear();
        this.selectableProvider.removeSelectableCollectionListener(this);
        this.volume.removeVolumeObserver(this);
        this.calculating = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onVolumeExtended(BrailedVolume brailedVolume, int newNumberOfVolumeParts) {
        if (brailedVolume.equals(this.volume)) {
            this.needsUpdate = true;
            Set<Integer> set = this.volumePartNumbersToCheck;
            synchronized (set) {
                this.volumePartNumbersToCheck.add(newNumberOfVolumeParts);
            }
        }
    }

    @Override
    public void onVolumeReduced(BrailedVolume brailedVolume) {
        if (brailedVolume.equals(this.volume)) {
            Logger.getAnonymousLogger().severe("not implemented!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.calculating = true;
        while (this.calculating) {
            if (!this.needsUpdate) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            HashSet<Selectable> willBeSelected = new HashSet<Selectable>();
            Set<Integer> set = this.volumePartNumbersToCheck;
            synchronized (set) {
                this.needsUpdate = false;
                for (Integer volumePartNumber : this.volumePartNumbersToCheck) {
                    Volume volumePartToTestAgainst = this.volume.getVolumeSubPart(volumePartNumber);
                    for (Selectable s : this.notSelectedObjects) {
                        switch (s.getButterFlyNetSelectionCriteria()) {
                            case AnyPointOfSelectableContainedInButterFlyVolume: {
                                if (!this.volumeContainsAnyPointOfSelectable(volumePartToTestAgainst, s)) break;
                                willBeSelected.add(s);
                                break;
                            }
                            case ButterFlyVolumeIntersectsBoundingBoxOfSelectable: {
                                if (!this.volumeIntersectsBoundingBoxOfSelectable(volumePartToTestAgainst, s)) break;
                                willBeSelected.add(s);
                            }
                        }
                    }
                }
                this.volumePartNumbersToCheck.clear();
            }
            if (!willBeSelected.isEmpty()) {
                this.notSelectedObjects.removeAll(willBeSelected);
                this.selectedObjects.addAll(willBeSelected);
                this.objectSelectionHasChanged(willBeSelected, this.notSelectedObjects, this.selectedObjects);
            }
            if (this.notSelectedObjects.isEmpty()) {
                System.out.println("no more Strokes to select ");
                this.calculating = false;
            }
            System.out.println("selected: " + this.selectedObjects.size());
        }
        System.out.println("finishing " + this.selectionCalculatorThread);
    }

    private void objectSelectionHasChanged(Set<Selectable> newlySelected, Set<Selectable> notSelected, Set<Selectable> selected) {
        for (SelectorObserver o : this.observer) {
            o.onElementSelectionHasChanged(this, newlySelected, notSelected, selected);
        }
    }

    private boolean volumeIntersectsBoundingBoxOfSelectable(Volume volumeToTestAgainst, Selectable s) {
        AABBox vbox = volumeToTestAgainst.getAABBox();
        AABBox sbox = s.getAABBox();
        return MathUtils.AABBoxesIntersect(vbox, sbox);
    }

    private boolean volumeContainsAnyPointOfSelectable(Volume volumeToTestAgainst, Selectable s) {
        boolean b = this.volumeIntersectsBoundingBoxOfSelectable(volumeToTestAgainst, s);
        if (!b) {
            return b;
        }
        List<Vector3f> points = s.getPointsInSceneCoordinates();
        int numpoints = points.size();
        int[] inidicesToTest = this.strokeIndiciesMap.get(s);
        if (inidicesToTest == null) {
            inidicesToTest = Shuffle.getShuffledArrayOfAllIntegersBetween(0, numpoints - 1);
            this.strokeIndiciesMap.put(s, inidicesToTest);
        } else if (inidicesToTest.length != numpoints) {
            inidicesToTest = Shuffle.getShuffledArrayOfAllIntegersBetween(0, numpoints - 1);
            this.strokeIndiciesMap.put(s, inidicesToTest);
        }
        for (int pointIndex : inidicesToTest) {
            Vector3f p = points.get(pointIndex);
            if (!volumeToTestAgainst.contains(p)) continue;
            return true;
        }
        return false;
    }

    public void addSelectionObserver(SelectorObserver o) {
        this.observer.add(o);
    }

    public VolumeSelectionProcess getProcess() {
        return this.process;
    }

    public static interface SelectorObserver {
        public void onElementSelectionHasChanged(Selector var1, Set<Selectable> var2, Set<Selectable> var3, Set<Selectable> var4);
    }
}

