/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.scenemanipulation;

import com.hybridlab.hyve3d.scenemanipulation.BrailedVolume;
import com.hybridlab.hyve3d.scenemanipulation.Brailer;
import com.hybridlab.hyve3d.scenemanipulation.SelectionModificationMode;
import com.hybridlab.utils.ThreePerpendicularAxes;
import com.hybridlab.utils.math.MathUtils;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;

public class VolumeSelectionProcess
implements Brailer.BrailerObserver {
    private SelectionModificationMode selectionMode = SelectionModificationMode.ADDSTROKE;
    private Set<ProcessObserver> processObservers = new HashSet<ProcessObserver>();
    private BrailedVolume volume;
    private Brailer selector;
    private Brailer.BrailerTransformation lastSignificantTransformation;
    private float significantAngle = 0.08726646f;
    private float significantDistance = 0.1f;
    private ProcessState state = ProcessState.CREATED;
    private Logger logger = Logger.getLogger(VolumeSelectionProcess.class.getName());

    public VolumeSelectionProcess(Brailer selectingBrailer) {
        this.volume = new BrailedVolume();
        this.selector = selectingBrailer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerProcessObserver(ProcessObserver observer) {
        Set<ProcessObserver> set = this.processObservers;
        synchronized (set) {
            this.processObservers.add(observer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unRegisterProcessObserver(ProcessObserver observer) {
        Set<ProcessObserver> set = this.processObservers;
        synchronized (set) {
            this.processObservers.remove(observer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startBrailing() {
        if (this.state.equals((Object)ProcessState.CREATED)) {
            this.state = ProcessState.SELECTING;
            this.lastSignificantTransformation = this.selector.getTransformation().clone();
            this.volume.extendWithBrailer(this.selector);
            this.selector.addObserver(this);
            Set<ProcessObserver> set = this.processObservers;
            synchronized (set) {
                for (ProcessObserver o : this.processObservers) {
                    o.onStarted(this);
                }
            }
        } else {
            if (this.state.equals((Object)ProcessState.FINISHED)) {
                throw new RuntimeException("An already finished " + VolumeSelectionProcess.class.getSimpleName() + " cannot be started again!");
            }
            throw new RuntimeException("A " + VolumeSelectionProcess.class.getSimpleName() + " cannot be started more than once!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopBrailing() {
        if (this.state.equals((Object)ProcessState.SELECTING)) {
            this.selector.removeObserver(this);
            this.state = ProcessState.FINISHED;
            Set<ProcessObserver> set = this.processObservers;
            synchronized (set) {
                for (ProcessObserver o : this.processObservers) {
                    o.onFinished(this);
                }
            }
        } else {
            this.logger.info(this + " is already finished and cant get stopped again.");
        }
    }

    public BrailedVolume getVolume() {
        return this.volume;
    }

    @Override
    public void onTransformationChanged(Brailer brailer) {
        Brailer.BrailerTransformation t = brailer.getTransformation();
        if (this.isSignificantChange(t) && this.volume.extendWithBrailer(brailer)) {
            this.lastSignificantTransformation = t;
        }
    }

    private boolean isSignificantChange(Brailer.BrailerTransformation t) {
        float posdiff = t.position.distance(this.lastSignificantTransformation.position);
        if (posdiff > this.significantDistance) {
            return true;
        }
        ThreePerpendicularAxes a = MathUtils.getQuaternionAxes(this.lastSignificantTransformation.rotation);
        ThreePerpendicularAxes b = MathUtils.getQuaternionAxes(t.rotation);
        float diffx = a.X.angleBetween(b.X);
        float diffy = a.Y.angleBetween(b.Y);
        float diffz = a.Z.angleBetween(b.Z);
        if (diffx > this.significantAngle) {
            return true;
        }
        if (diffy > this.significantAngle) {
            return true;
        }
        return diffz > this.significantAngle;
    }

    public boolean isActive() {
        return this.state.equals((Object)ProcessState.SELECTING);
    }

    public boolean isFinished() {
        return this.state.equals((Object)ProcessState.FINISHED);
    }

    public boolean isNotYetStarted() {
        return this.state.equals((Object)ProcessState.CREATED);
    }

    public SelectionModificationMode getSelectionMode() {
        return this.selectionMode;
    }

    public void setSelectionMode(SelectionModificationMode selectionMode) {
        this.selectionMode = selectionMode;
    }

    private static enum ProcessState {
        CREATED,
        SELECTING,
        FINISHED;

    }

    public static interface ProcessObserver {
        public void onStarted(VolumeSelectionProcess var1);

        public void onFinished(VolumeSelectionProcess var1);
    }
}

