/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyveclient.ControlUI;

import com.hybridlab.hyve3d.LocalFileScene;
import com.hybridlab.hyve3d.data.domainobjects.BackGround;
import com.hybridlab.hyve3d.files.ImportOptions;
import com.hybridlab.hyve3d.hyve.FileTypes;
import com.hybridlab.hyve3d.hyve.GlobalSettings;
import com.hybridlab.hyve3d.nina.ImmersionMode;
import com.hybridlab.hyve3d.nina.ImportOptionsWindow;
import com.hybridlab.hyve3d.nina.NinaConfiguration;
import com.hybridlab.hyveclient.ControlUI.AppControlImportProcess;
import com.hybridlab.hyveclient.ControlUI.ControlUINetworkingWindow;
import com.hybridlab.hyveclient.ControlUI.HyveClientControlUI;
import com.hybridlab.hyveclient.ControlUI.HyveClientPreferencesWindow;
import com.hybridlab.hyveclient.ControlUI.MenuApplication;
import com.hybridlab.hyveclient.ControlUI.OSXApplicationAdapter;
import com.hybridlab.hyveclient.ControlUI.UndoRedoAdapter;
import com.hybridlab.hyveclient.SimpleAppControl.AppControlClientMessageListner;
import com.hybridlab.hyveclient.SimpleAppControl.AppControlWelcomeMessage;
import com.hybridlab.hyveclient.SimpleAppControl.HyveApplicationAdapter;
import com.hybridlab.hyveclient.SimpleAppControl.HyveNetworkingAdapter;
import com.hybridlab.licensing.Feature;
import com.hybridlab.utils.logging.MessageBox;
import com.jme3.math.ColorRGBA;
import java.awt.Desktop;
import java.awt.FileDialog;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.lang3.StringUtils;

public class MenuController
implements AppControlClientMessageListner {
    private final HyveClientControlUI.PerformerAdapter performer;
    private final MenuApplication menuApplication;
    private UndoRedoAdapter undoRedoAdapter;
    private OSXApplicationAdapter adapter;
    private Desktop macApplication;
    private JMenu menuDeveloper;
    private JMenu menuMisc;
    private Set<Feature> enabledFeatures;
    private JCheckBoxMenuItem showFPS;
    private JSeparator modeSeparator;
    private JCheckBoxMenuItem menuItem_enableImmersiveMode;
    private JCheckBoxMenuItem menuItem_enableNonImmersiveMode;
    private JCheckBoxMenuItem toggleFullScreen;
    private JCheckBoxMenuItem highlightMask;
    private JMenu menuDisplay;
    private boolean useAlternativeSaveDialog = true;
    private File currentDirectory = null;
    private JMenuBar menubar;
    private boolean menuesGenerallyVisible = true;
    private Map<JMenu, Boolean> menuVisibility = new HashMap<JMenu, Boolean>();
    private JMenu fileMenu;
    private JMenu menuEdit;
    private JMenu networkingMenu;
    private JCheckBoxMenuItem snapDuringHingeCheckBox;
    private HyveClientControlUI.AppControlMaskModifier maskModifier;
    private HyveClientControlUI.AppControlProjectionCalibrator projectionCalibrator;
    private ControlUINetworkingWindow networkingViewWindow;
    private HyveClientPreferencesWindow preferencesWindow;

    public MenuController(Desktop desktop, HyveClientControlUI.PerformerAdapter performer, MenuApplication menuApplication) {
        this.macApplication = desktop;
        this.performer = performer;
        this.menuApplication = menuApplication;
        this.adapter = menuApplication.getOSXApplicationAdapter();
    }

    private void updateMenuVisibilities() {
        this.fileMenu.setVisible(this.menuVisibility.get(this.fileMenu) != false && this.menuesGenerallyVisible);
        this.menuEdit.setVisible(this.menuVisibility.get(this.menuEdit) != false && this.menuesGenerallyVisible);
        this.networkingMenu.setVisible(this.menuVisibility.get(this.networkingMenu) != false && this.menuesGenerallyVisible);
        this.menuDisplay.setVisible(this.menuVisibility.get(this.menuDisplay) != false && this.menuesGenerallyVisible);
        this.menuMisc.setVisible(this.menuVisibility.get(this.menuMisc) != false && this.menuesGenerallyVisible);
        this.menuDeveloper.setVisible(this.menuVisibility.get(this.menuDeveloper) != false && this.menuesGenerallyVisible);
    }

    public void showMenus() {
        this.menuesGenerallyVisible = true;
        this.updateMenuVisibilities();
    }

    @Deprecated
    public void createMenu(boolean isFullscreen) {
        if (!isFullscreen) {
            this.menuesGenerallyVisible = true;
        }
        this.macApplication.setDefaultMenuBar(this.createMenuBar());
        this.updateMenuVisibilities();
    }

    public void createMenu() {
        JMenuBar mb = this.createMenuBar();
        JFrame mainWindow = this.menuApplication.getMainWindow();
        this.macApplication.setDefaultMenuBar(mb);
        this.updateMenuVisibilities();
    }

    public void setDevelopermode(boolean enable) {
        this.menuVisibility.put(this.menuDeveloper, enable);
        this.menuDeveloper.setVisible(enable && this.menuesGenerallyVisible);
    }

    private void setAutoExportEnabled(boolean enabled) {
        this.performer.setupAutoExportTimer(enabled);
    }

    private void setSketchLogEnabled(boolean enabled) {
        this.performer.setupSketchLog(enabled);
    }

    private JMenuBar createMenuBar() {
        this.menubar = new JMenuBar();
        this.fileMenu = new JMenu("File");
        this.menuVisibility.put(this.fileMenu, true);
        JMenu scaffoldMenu = new JMenu("Background geometry");
        String[] stringArray = BackGround.InBuiltBackgrounds;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String item;
            final String s = item = stringArray[i];
            JMenuItem bgCity = new JMenuItem(s);
            scaffoldMenu.add(bgCity);
            bgCity.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            MenuController.this.performer.toggleBackGround(s);
                        }
                    });
                }
            });
        }
        JMenu menu_import = new JMenu("Import...");
        JMenuItem mi_importObj = new JMenuItem("Wavefront (*.obj)");
        menu_import.add(mi_importObj);
        mi_importObj.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String fileHint = " '*.obj' or '*.zip' ";
                Object[] validTypes = new String[]{".obj", ".zip"};
                FileDialog fd = new FileDialog(MenuController.this.menuApplication.getDialogParentWindow(), "open a " + fileHint + "file", 0);
                fd.setAlwaysOnTop(true);
                fd.setVisible(true);
                String filename = fd.getFile();
                String dir = fd.getDirectory();
                if (filename == null) {
                    System.out.println("You cancelled the choice");
                } else {
                    System.out.println("You chose " + filename + " in " + dir);
                    boolean hasValidType = false;
                    for (String string : validTypes) {
                        if (!filename.toLowerCase().endsWith(string)) continue;
                        hasValidType = true;
                        break;
                    }
                    if (hasValidType) {
                        FileTypes ft = filename.toLowerCase().endsWith(".zip") ? FileTypes.OBJ_ZIPPED : FileTypes.OBJ;
                        ImportOptions options = ImportOptions.createDefaultOptions();
                        MenuController.this.createAndShowImportOptionsDialog(filename, dir, ft, options);
                    } else {
                        MessageBox.show("You have to select one of the following filetypes for this import type:\n" + StringUtils.join(validTypes, " "));
                    }
                }
            }
        });
        mi_importObj.setEnabled(true);
        JMenuItem mi_importFBX = new JMenuItem("FBX (*.fbx)");
        mi_importFBX.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String fileHint = " '*.fbx' ";
                Object[] validTypes = new String[]{".fbx"};
                FileDialog fd = new FileDialog(MenuController.this.menuApplication.getDialogParentWindow(), "open a " + fileHint + "file", 0);
                fd.setAlwaysOnTop(true);
                fd.setVisible(true);
                String filename = fd.getFile();
                String dir = fd.getDirectory();
                if (filename == null) {
                    System.out.println("You cancelled the choice");
                } else {
                    System.out.println("You chose " + filename + " in " + dir);
                    boolean hasValidType = false;
                    for (String string : validTypes) {
                        if (!filename.toLowerCase().endsWith(string)) continue;
                        hasValidType = true;
                        break;
                    }
                    if (hasValidType) {
                        FileTypes ft = FileTypes.FBX;
                        ImportOptions options = ImportOptions.createDefaultOptions();
                        MenuController.this.createAndShowImportOptionsDialog(filename, dir, ft, options);
                    } else {
                        MessageBox.show("You have to select one of the following filetypes for this import type:\n" + StringUtils.join(validTypes, " "));
                    }
                }
            }
        });
        mi_importFBX.setEnabled(true);
        JMenuItem mi_importPointCloudFile = new JMenuItem("Pointcloud (*.ply)");
        menu_import.add(mi_importPointCloudFile);
        mi_importPointCloudFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String fileHint = "'*.ply' ";
                Object[] validTypes = new String[]{".ply"};
                FileDialog fd = new FileDialog(MenuController.this.menuApplication.getDialogParentWindow(), "open a " + fileHint + "file", 0);
                fd.setAlwaysOnTop(true);
                fd.setVisible(true);
                String filename = fd.getFile();
                String dir = fd.getDirectory();
                if (filename == null) {
                    System.out.println("You cancelled the choice");
                } else {
                    System.out.println("You chose " + filename + " in " + dir);
                    boolean hasValidType = false;
                    for (String string : validTypes) {
                        if (!filename.toLowerCase().endsWith(string)) continue;
                        hasValidType = true;
                        break;
                    }
                    if (hasValidType) {
                        FileTypes ft = filename.toLowerCase().endsWith(".ply") ? FileTypes.PLY_POINTCLOUD : FileTypes.UNKNOWN;
                        ImportOptions options = ImportOptions.createDefaultOptions();
                        MenuController.this.createAndShowImportOptionsDialog(filename, dir, ft, options);
                    } else {
                        MessageBox.show("You have to select one of the following filetypes for this import type:\n" + StringUtils.join(validTypes, " "));
                    }
                }
            }
        });
        mi_importPointCloudFile.setEnabled(true);
        JMenuItem mi_importHyve = new JMenuItem("Hyve-3D (*.hyve)");
        menu_import.add(mi_importHyve);
        mi_importHyve.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String fileHint = " '*.hyve' ";
                Object[] validTypes = new String[]{".hyve"};
                boolean setSysProp = GlobalSettings.SetAWTfileDialogForDirectories;
                if (setSysProp) {
                    System.setProperty("apple.awt.fileDialogForDirectories", "true");
                }
                FileDialog fd = new FileDialog(MenuController.this.menuApplication.getDialogParentWindow(), "open a " + fileHint + "file", 0);
                fd.setAlwaysOnTop(true);
                fd.setVisible(true);
                String filename = fd.getFile();
                String dir = fd.getDirectory();
                if (filename == null) {
                    System.out.println("You cancelled the choice");
                } else {
                    System.out.println("You chose " + filename + " in " + dir);
                    boolean hasValidType = false;
                    for (String string : validTypes) {
                        if (!filename.toLowerCase().endsWith(string)) continue;
                        hasValidType = true;
                        break;
                    }
                    if (hasValidType) {
                        ImportOptions options = ImportOptions.createDefaultOptions();
                        MenuController.this.createAndShowImportOptionsDialog(filename, dir, FileTypes.HYVE, options);
                    } else {
                        MessageBox.show("You have to select one of the following filetypes for this import type:\n" + StringUtils.join(validTypes, " "));
                    }
                }
                if (setSysProp) {
                    System.setProperty("apple.awt.fileDialogForDirectories", "false");
                }
            }
        });
        mi_importHyve.setEnabled(true);
        JMenuItem mi_importOGRE = new JMenuItem("Asset (zip package)");
        mi_importOGRE.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String fileHint = " '*.zip' ";
                Object[] validTypes = new String[]{".zip"};
                FileDialog fd = new FileDialog(MenuController.this.menuApplication.getDialogParentWindow(), "open a " + fileHint + "file", 0);
                fd.setAlwaysOnTop(true);
                fd.setVisible(true);
                String filename = fd.getFile();
                String dir = fd.getDirectory();
                if (filename == null) {
                    System.out.println("You cancelled the choice");
                } else {
                    System.out.println("You chose " + filename + " in " + dir);
                    boolean hasValidType = false;
                    for (String string : validTypes) {
                        if (!filename.toLowerCase().endsWith(string)) continue;
                        hasValidType = true;
                        break;
                    }
                    if (hasValidType) {
                        ImportOptions options = ImportOptions.createDefaultOptions();
                        MenuController.this.createAndShowImportOptionsDialog(filename, dir, FileTypes.OGRE_ZIPPED, options);
                    } else {
                        MessageBox.show("You have to select one of the following filetypes for this import type:\n" + StringUtils.join(validTypes, " "));
                    }
                }
            }
        });
        mi_importOGRE.setEnabled(true);
        JMenu menu_export = new JMenu("Export...");
        menu_export.add(new JSeparator());
        JMenuItem mi_exportSTL = new JMenuItem("3D Sketches to STL file");
        menu_export.add(mi_exportSTL);
        mi_exportSTL.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Object filename;
                System.out.println("Export STL...");
                String directory = null;
                Object[] validTypes = new String[]{".stl"};
                if (MenuController.this.useAlternativeSaveDialog) {
                    JFileChooser fc = new JFileChooser();
                    fc.setFileSelectionMode(0);
                    fc.setAcceptAllFileFilterUsed(false);
                    if (MenuController.this.currentDirectory == null) {
                        String home = System.getProperty("user.home");
                        MenuController.this.currentDirectory = new File(home + File.separator + "Desktop");
                    }
                    File suggestedfile = new File(MenuController.this.currentDirectory, "Untitled.stl");
                    fc.setSelectedFile(suggestedfile);
                    fc.setFileFilter(new FileFilter(){

                        @Override
                        public String getDescription() {
                            return "*.stl";
                        }

                        @Override
                        public boolean accept(File f) {
                            if (f == null) {
                                return false;
                            }
                            return f.isFile() && f.getName().toLowerCase().endsWith("stl");
                        }
                    });
                    int returnVal = fc.showDialog(MenuController.this.menuApplication.getDialogParentWindow(), "Export");
                    if (returnVal == 0) {
                        File file = fc.getSelectedFile();
                        filename = file.getName();
                        if (!((String)filename).endsWith(".stl")) {
                            filename = (String)filename + ".stl";
                        }
                        directory = file.getParent();
                        MenuController.this.currentDirectory = new File(directory);
                    } else {
                        filename = null;
                        directory = null;
                    }
                } else {
                    FileDialog fd2 = new FileDialog(MenuController.this.menuApplication.getDialogParentWindow(), "Export STL", 1);
                    fd2.setFile("Untitled.stl");
                    fd2.setAlwaysOnTop(true);
                    fd2.setVisible(true);
                    filename = fd2.getFile();
                    directory = fd2.getDirectory();
                }
                if (filename == null) {
                    System.out.println("You cancelled the choice");
                } else {
                    boolean hasValidType = false;
                    for (String string : validTypes) {
                        if (!((String)filename).toLowerCase().endsWith(string)) continue;
                        hasValidType = true;
                        break;
                    }
                    if (hasValidType) {
                        MenuController.this.performer.saveToLocalFile(directory, (String)filename);
                    } else {
                        MessageBox.show("You have to chose a filename with the ending:\n" + StringUtils.join(validTypes, " "));
                    }
                }
            }
        });
        JMenuItem mi_exportDXF = new JMenuItem("3D Sketches to DXF file");
        menu_export.add(mi_exportDXF);
        mi_exportDXF.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Object filename;
                System.out.println("Export DXF...");
                String directory = null;
                Object[] validTypes = new String[]{".dxf"};
                if (MenuController.this.useAlternativeSaveDialog) {
                    JFileChooser fc = new JFileChooser();
                    fc.setFileSelectionMode(0);
                    fc.setAcceptAllFileFilterUsed(false);
                    if (MenuController.this.currentDirectory == null) {
                        String home = System.getProperty("user.home");
                        MenuController.this.currentDirectory = new File(home + File.separator + "Desktop");
                    }
                    File suggestedfile = new File(MenuController.this.currentDirectory, "Untitled.dxf");
                    fc.setSelectedFile(suggestedfile);
                    fc.setFileFilter(new FileFilter(){

                        @Override
                        public String getDescription() {
                            return "*.dxf";
                        }

                        @Override
                        public boolean accept(File f) {
                            if (f == null) {
                                return false;
                            }
                            return f.isFile() && f.getName().toLowerCase().endsWith("dxf");
                        }
                    });
                    int returnVal = fc.showDialog(MenuController.this.menuApplication.getDialogParentWindow(), "Export");
                    if (returnVal == 0) {
                        File file = fc.getSelectedFile();
                        filename = file.getName();
                        if (!((String)filename).endsWith(".dxf")) {
                            filename = (String)filename + ".dxf";
                        }
                        directory = file.getParent();
                        MenuController.this.currentDirectory = new File(directory);
                    } else {
                        filename = null;
                        directory = null;
                    }
                } else {
                    FileDialog fd2 = new FileDialog(MenuController.this.menuApplication.getDialogParentWindow(), "Export DXF", 1);
                    fd2.setFile("Untitled.dxf");
                    fd2.setAlwaysOnTop(true);
                    fd2.setVisible(true);
                    filename = fd2.getFile();
                    directory = fd2.getDirectory();
                }
                if (filename == null) {
                    System.out.println("You cancelled the choice");
                } else {
                    boolean hasValidType = false;
                    for (String string : validTypes) {
                        if (!((String)filename).toLowerCase().endsWith(string)) continue;
                        hasValidType = true;
                        break;
                    }
                    if (hasValidType) {
                        MenuController.this.performer.saveToLocalFile(directory, (String)filename);
                    } else {
                        MessageBox.show("You have to chose a filename with the ending:\n" + StringUtils.join(validTypes, " "));
                    }
                }
            }
        });
        mi_exportDXF.setEnabled(true);
        menu_export.add(new JSeparator());
        String disableText = "Disable automatic export to dxf";
        String enableText = "Enable automatic export to dxf";
        final JMenuItem enableAutoExport = new JMenuItem("Enable automatic export to dxf");
        enableAutoExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (MenuController.this.performer.isAutoExportEnabled()) {
                    MenuController.this.setAutoExportEnabled(false);
                    enableAutoExport.setText("Enable automatic export to dxf");
                } else {
                    MenuController.this.setAutoExportEnabled(true);
                    enableAutoExport.setText("Disable automatic export to dxf");
                }
            }
        });
        menu_export.add(enableAutoExport);
        disableText = "Disable sketch log";
        enableText = "Enable sketch log";
        final JMenuItem enableSketchLog = new JMenuItem("Enable sketch log");
        enableSketchLog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (MenuController.this.performer.isSketchLogEnabled()) {
                    MenuController.this.setSketchLogEnabled(false);
                    enableSketchLog.setText("Enable sketch log");
                } else {
                    MenuController.this.setSketchLogEnabled(true);
                    enableSketchLog.setText("Disable sketch log");
                }
            }
        });
        menu_export.add(enableSketchLog);
        JMenuItem open = new JMenuItem("Open (*.hyve) ...");
        open.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String fileHint = " '*.hyve' ";
                Object[] validTypes = new String[]{".hyve", ".xml"};
                boolean setSysProp = GlobalSettings.SetAWTfileDialogForDirectories;
                if (setSysProp) {
                    System.setProperty("apple.awt.fileDialogForDirectories", "true");
                }
                FileDialog fd = new FileDialog(MenuController.this.menuApplication.getDialogParentWindow(), "open a " + fileHint + "file", 0);
                fd.setAlwaysOnTop(true);
                fd.setVisible(true);
                String filename = fd.getFile();
                String dir = fd.getDirectory();
                if (filename == null) {
                    System.out.println("You cancelled the choice");
                } else {
                    System.out.println("You chose " + filename + " in " + dir);
                    boolean hasValidType = false;
                    for (String string : validTypes) {
                        if (!filename.toLowerCase().endsWith(string)) continue;
                        hasValidType = true;
                        break;
                    }
                    if (hasValidType) {
                        MenuController.this.performer.openLocalFile(dir, filename, FileTypes.HYVE);
                    } else {
                        MessageBox.show("You have to select one of the following filetypes for this import type:\n" + StringUtils.join(validTypes, " "));
                    }
                }
                if (setSysProp) {
                    System.setProperty("apple.awt.fileDialogForDirectories", "false");
                }
            }
        });
        open.setEnabled(true);
        JMenuItem saveAsItem = new JMenuItem("Save (*.hyve) ...");
        saveAsItem.setAccelerator(KeyStroke.getKeyStroke(83, 1 | Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        saveAsItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object filename;
                System.out.println("Save As...");
                String directory = null;
                if (MenuController.this.useAlternativeSaveDialog) {
                    JFileChooser fc = new JFileChooser();
                    fc.setFileSelectionMode(0);
                    fc.setAcceptAllFileFilterUsed(false);
                    if (MenuController.this.currentDirectory == null) {
                        String home = System.getProperty("user.home");
                        MenuController.this.currentDirectory = new File(home + File.separator + "Desktop");
                    }
                    File suggestedfile = new File(MenuController.this.currentDirectory, "Untitled.hyve");
                    fc.setSelectedFile(suggestedfile);
                    fc.setFileFilter(new FileFilter(){

                        @Override
                        public String getDescription() {
                            return "*.hyve";
                        }

                        @Override
                        public boolean accept(File f) {
                            if (f == null) {
                                return false;
                            }
                            return f.isFile() && f.getName().toLowerCase().endsWith("hyve");
                        }
                    });
                    int returnVal = fc.showSaveDialog(MenuController.this.menuApplication.getDialogParentWindow());
                    if (returnVal == 0) {
                        File file = fc.getSelectedFile();
                        filename = file.getName();
                        if (!((String)filename).endsWith(".hyve")) {
                            filename = (String)filename + ".hyve";
                        }
                        directory = file.getParent();
                        MenuController.this.currentDirectory = new File(directory);
                    } else {
                        filename = null;
                        directory = null;
                    }
                } else {
                    FileDialog fd2 = new FileDialog(MenuController.this.menuApplication.getDialogParentWindow(), "Save", 1);
                    fd2.setFile("Untitled.hyve");
                    fd2.setAlwaysOnTop(true);
                    fd2.setVisible(true);
                    filename = fd2.getFile();
                    directory = fd2.getDirectory();
                }
                if (filename != null) {
                    MenuController.this.performer.saveToLocalFile(directory, (String)filename);
                }
            }
        });
        saveAsItem.setEnabled(true);
        this.fileMenu.add(open);
        this.fileMenu.add(saveAsItem);
        this.fileMenu.add(new JSeparator());
        this.fileMenu.add(menu_import);
        this.fileMenu.add(menu_export);
        this.fileMenu.add(new JSeparator());
        this.fileMenu.add(scaffoldMenu);
        final JMenu skySelectMenu = new JMenu("Sky");
        final JMenuItem noSky = new JMenuItem("Remove");
        noSky.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MenuController.this.performer.clearSky();
            }
        });
        skySelectMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                skySelectMenu.removeAll();
                try {
                    List<File> skyFiles = MenuController.this.performer.scanSkyFiles();
                    for (final File f : skyFiles) {
                        JMenuItem item = new JMenuItem(StringUtils.remove(f.getName(), ".dds"));
                        skySelectMenu.add(item);
                        item.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent arg0) {
                                String dir = f.getParent();
                                FileTypes ft = f.getName().toLowerCase().endsWith(".dds") ? FileTypes.DDS_SKY : FileTypes.UNKNOWN;
                                ImportOptions options = ImportOptions.createDefaultOptions();
                                MenuController.this.performer.importLocalFile(dir, f.getName(), ft, options.toImportOptionsString());
                            }
                        });
                    }
                }
                catch (Exception ex) {
                    JMenuItem item = new JMenuItem("No sky files found.");
                    skySelectMenu.add(item);
                }
                skySelectMenu.add(new JSeparator());
                skySelectMenu.add(noSky);
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }
        });
        JMenu skyMenu = new JMenu("Sky");
        this.fileMenu.add(skySelectMenu);
        boolean showImportDDS = false;
        if (showImportDDS) {
            JMenuItem skydds = new JMenuItem("Import *.dds file");
            skyMenu.add(skydds);
            skydds.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    String fileHint = " '*.dds'";
                    Object[] validTypes = new String[]{".dds"};
                    FileDialog fd = new FileDialog(MenuController.this.menuApplication.getDialogParentWindow(), "open a " + fileHint + "file", 0);
                    fd.setAlwaysOnTop(true);
                    fd.setVisible(true);
                    String filename = fd.getFile();
                    String dir = fd.getDirectory();
                    if (filename == null) {
                        System.out.println("You cancelled the choice");
                    } else {
                        System.out.println("You chose " + filename + " in " + dir);
                        boolean hasValidType = false;
                        for (String string : validTypes) {
                            if (!filename.toLowerCase().endsWith(string)) continue;
                            hasValidType = true;
                            break;
                        }
                        if (hasValidType) {
                            FileTypes ft = filename.toLowerCase().endsWith(".dds") ? FileTypes.DDS_SKY : FileTypes.UNKNOWN;
                            ImportOptions options = ImportOptions.createDefaultOptions();
                            MenuController.this.performer.importLocalFile(dir, filename, ft, options.toImportOptionsString());
                        } else {
                            MessageBox.show("You have to select one of the following filetypes for this import type:\n" + StringUtils.join(validTypes, " "));
                        }
                    }
                }
            });
            skydds.setEnabled(true);
        }
        this.menubar.add(this.fileMenu);
        this.menuEdit = new JMenu("Edit");
        this.menubar.add(this.menuEdit);
        this.menuVisibility.put(this.menuEdit, true);
        JMenuItem undo = new JMenuItem("Undo");
        undo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuController.this.undoRedoAdapter.undo();
            }
        });
        undo.setEnabled(false);
        JMenuItem redo = new JMenuItem("Redo");
        redo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuController.this.undoRedoAdapter.redo();
            }
        });
        redo.setEnabled(false);
        this.undoRedoAdapter = new UndoRedoAdapter(undo, redo);
        boolean showUndoRedoInEditMenu = false;
        if (showUndoRedoInEditMenu) {
            this.menuEdit.add(undo);
            this.menuEdit.add(redo);
            this.menuEdit.add(new JSeparator());
        }
        JMenuItem eraseAll = new JMenuItem("Erase all");
        eraseAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("Erase all!");
                int dialogButton = 0;
                int dialogResult = JOptionPane.showConfirmDialog(null, "Do you like to erase all ?", "Warning", dialogButton);
                if (dialogResult == 0) {
                    MenuController.this.performer.eraseAll();
                }
            }
        });
        eraseAll.setEnabled(true);
        this.menuEdit.add(eraseAll);
        this.networkingMenu = new JMenu("Network");
        this.menubar.add(this.networkingMenu);
        this.menuVisibility.put(this.networkingMenu, true);
        JMenuItem overview = new JMenuItem("Connection ...");
        overview.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MenuController.this.menuApplication.showNetworkingWindow(MenuController.this.performer);
                    }
                });
            }
        });
        this.networkingMenu.add(overview);
        this.networkingMenu.add(new JSeparator());
        final JCheckBoxMenuItem onlyusetcp = new JCheckBoxMenuItem("Only use TCP (no UDP)", false);
        onlyusetcp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        boolean b = onlyusetcp.isSelected();
                        MenuController.this.performer.setOnlyUseTCP(b);
                    }
                });
            }
        });
        this.networkingMenu.add(onlyusetcp);
        this.highlightMask = new JCheckBoxMenuItem("Communication light", false);
        this.networkingMenu.add(this.highlightMask);
        this.highlightMask.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean b = MenuController.this.maskModifier.colorIsCalibrationColor();
                if (b) {
                    MenuController.this.maskModifier.setEllipseColor(ColorRGBA.Black);
                } else {
                    MenuController.this.maskModifier.setEllipseColor(NinaConfiguration.CalibrationColor);
                }
            }
        });
        this.networkingMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                boolean b = MenuController.this.maskModifier.colorIsCalibrationColor();
                MenuController.this.highlightMask.setState(b);
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }
        });
        this.menuDisplay = new JMenu("Display");
        this.menuVisibility.put(this.menuDisplay, true);
        this.menuItem_enableImmersiveMode = new JCheckBoxMenuItem("Immersive");
        this.menuItem_enableNonImmersiveMode = new JCheckBoxMenuItem("Non-immersive");
        this.menuItem_enableImmersiveMode.setEnabled(false);
        this.menuItem_enableImmersiveMode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MenuController.this.performer.enableImmersiveMode();
                        MenuController.this.menuItem_enableImmersiveMode.setEnabled(false);
                        MenuController.this.menuItem_enableNonImmersiveMode.setEnabled(true);
                    }
                });
            }
        });
        this.menuDisplay.add(this.menuItem_enableImmersiveMode);
        this.menuItem_enableNonImmersiveMode.setEnabled(true);
        this.menuItem_enableNonImmersiveMode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MenuController.this.performer.enableNonImmersiveMode();
                        MenuController.this.menuItem_enableImmersiveMode.setEnabled(true);
                        MenuController.this.menuItem_enableNonImmersiveMode.setEnabled(false);
                    }
                });
            }
        });
        this.menuDisplay.add(this.menuItem_enableNonImmersiveMode);
        this.modeSeparator = new JSeparator();
        this.menuDisplay.add(this.modeSeparator);
        this.menuDisplay.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                ImmersionMode immersionmode = MenuController.this.performer.getMode();
                MenuController.this.menuItem_enableImmersiveMode.setEnabled(!immersionmode.equals((Object)ImmersionMode.IMMERSIVE));
                MenuController.this.menuItem_enableNonImmersiveMode.setEnabled(!immersionmode.equals((Object)ImmersionMode.NONIMMERSIVE));
                MenuController.this.menuItem_enableImmersiveMode.setSelected(immersionmode.equals((Object)ImmersionMode.IMMERSIVE));
                MenuController.this.menuItem_enableNonImmersiveMode.setSelected(immersionmode.equals((Object)ImmersionMode.NONIMMERSIVE));
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }
        });
        this.toggleFullScreen = new JCheckBoxMenuItem("Fullscreen", this.performer.getFullScreen());
        this.toggleFullScreen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        boolean b = MenuController.this.toggleFullScreen.isSelected();
                        MenuController.this.performer.setFullscreen(b);
                    }
                });
            }
        });
        this.menuDisplay.add(this.toggleFullScreen);
        this.menuDisplay.add(new JSeparator());
        this.showFPS = new JCheckBoxMenuItem("Show statistics and FPS", false);
        this.menuDisplay.add(this.showFPS);
        this.showFPS.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean b = MenuController.this.showFPS.isSelected();
                MenuController.this.performer.setDisplayFps(b);
                MenuController.this.performer.setDisplayStatView(b);
            }
        });
        this.menuMisc = new JMenu("Control");
        this.menuMisc.setVisible(true);
        this.menubar.add(this.menuMisc);
        this.menuVisibility.put(this.menuMisc, true);
        JMenuItem sceneWindow = new JMenuItem("Light control ...");
        sceneWindow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MenuController.this.menuApplication.showSceneWindow();
                    }
                });
            }
        });
        this.menuMisc.add(sceneWindow);
        final JCheckBoxMenuItem pullSpaces = new JCheckBoxMenuItem("Control navigation of remote Hyve-3D");
        pullSpaces.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        boolean b = pullSpaces.isSelected();
                        MenuController.this.performer.synchronizeHyvePositions(b);
                    }
                });
            }
        });
        this.menuMisc.add(pullSpaces);
        JMenuItem resetNav = new JMenuItem("Reset navigation to origin");
        resetNav.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MenuController.this.performer.resetNavigation();
                    }
                });
            }
        });
        this.menuMisc.add(resetNav);
        final JCheckBoxMenuItem cb = new JCheckBoxMenuItem("Inertia navigation", this.performer.isInertiaNavigationEnabled());
        cb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuController.this.performer.setInertiaNavigationEnabled(cb.isSelected());
            }
        });
        this.menuMisc.add(cb);
        this.snapDuringHingeCheckBox = new JCheckBoxMenuItem("Snap during hinge", this.performer.getSnapDuringHinge());
        this.snapDuringHingeCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuController.this.performer.setSnapDuringHinge(MenuController.this.snapDuringHingeCheckBox.isSelected());
            }
        });
        this.menuMisc.add(this.snapDuringHingeCheckBox);
        this.menuDeveloper = new JMenu("Developer Tools");
        this.menuDeveloper.setVisible(false);
        this.menubar.add(this.menuDeveloper);
        this.menuVisibility.put(this.menuDeveloper, false);
        JMenuItem resourceWindow = new JMenuItem("Rendered Resources Debug Window");
        resourceWindow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MenuController.this.menuApplication.showResourceWatcherWindow();
                    }
                });
            }
        });
        this.menuDeveloper.add(resourceWindow);
        return this.menubar;
    }

    private void createAndShowImportOptionsDialog(String filename, String dir, FileTypes ft, ImportOptions options) {
        LocalFileScene storage = new LocalFileScene();
        storage.filename = filename;
        storage.directory = dir;
        AppControlImportProcess importProcess = new AppControlImportProcess(this.performer, storage, ft, options);
        final ImportOptionsWindow importOptionsWindow = new ImportOptionsWindow(importProcess, this.menuApplication.getErrorVisualizer());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                importOptionsWindow.setVisible(true);
            }
        });
    }

    public boolean isDeveloperModeEnabled() {
        boolean b = false;
        if (this.menuDeveloper != null) {
            b = this.menuDeveloper.isVisible();
        }
        return b;
    }

    private void updateMenuToFitFeatures() {
        boolean nonimmersive = this.enabledFeatures.contains((Object)Feature.NONIMMERSIVE);
        this.showFPS.setVisible(nonimmersive);
        boolean immersiveAndNonImmersive = this.enabledFeatures.contains((Object)Feature.NONIMMERSIVE) && this.enabledFeatures.contains((Object)Feature.IMMERSIVE);
        this.modeSeparator.setVisible(immersiveAndNonImmersive);
        this.menuItem_enableImmersiveMode.setVisible(immersiveAndNonImmersive);
        this.menuItem_enableNonImmersiveMode.setVisible(immersiveAndNonImmersive);
        boolean nonimmersiveOnly = this.enabledFeatures.contains((Object)Feature.NONIMMERSIVE) && !this.enabledFeatures.contains((Object)Feature.IMMERSIVE);
        this.highlightMask.setVisible(this.enabledFeatures.contains((Object)Feature.IMMERSIVE));
        this.toggleFullScreen.setVisible(immersiveAndNonImmersive || nonimmersiveOnly);
        this.menuVisibility.put(this.menuDisplay, immersiveAndNonImmersive || nonimmersiveOnly);
        this.updateMenuVisibilities();
    }

    public void setFeatures(Set<Feature> enabledFeatures) {
        this.enabledFeatures = enabledFeatures;
        this.updateMenuToFitFeatures();
    }

    @Override
    public void receiveWelcomeMessage(final AppControlWelcomeMessage message) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MenuController.this.toggleFullScreen.setState(message.fullscreen);
                MenuController.this.snapDuringHingeCheckBox.setState(message.snapDuringHinge);
                MenuController.this.projectionCalibrator.receiveWelcomeMessage(message);
                MenuController.this.maskModifier.receiveWelcomeMessage(message);
                MenuController.this.performer.receiveWelcomeMessage(message);
            }
        });
    }

    @Override
    public void receiveFrameRate(float frameRate) {
        this.menuApplication.showFrameRate(frameRate);
    }

    public void showNetworkingWindow() {
        this.networkingViewWindow.setVisible(true);
    }

    public void showPreferencesWindow() {
        this.preferencesWindow.setVisible(true);
    }

    public void showSplashWindow() {
    }

    public void createMenuRelatedWindows() {
        this.networkingViewWindow = new ControlUINetworkingWindow();
        this.networkingViewWindow.setSize(514, 651);
        this.preferencesWindow = new HyveClientPreferencesWindow(this.menuApplication);
    }

    public void connectCalibratorUI(HyveClientControlUI.AppControlMaskModifier maskModifier, HyveClientControlUI.AppControlProjectionCalibrator projectionCalibrator) {
        this.maskModifier = maskModifier;
        this.projectionCalibrator = projectionCalibrator;
        this.preferencesWindow.connect(maskModifier);
        this.preferencesWindow.connect(projectionCalibrator);
    }

    public void connectNetworkingUIAdapters(HyveNetworkingAdapter nwa, HyveApplicationAdapter app) {
        this.networkingViewWindow.connectAdapter(nwa, app);
    }
}

