/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyveclient.ControlUI;

import com.hybridlab.hyve3d.data.domainobjects.CommandHistory;
import com.hybridlab.hyve3d.hyve.undoredo.HistoryController;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;

public class UndoRedoAdapter
implements HistoryController,
CommandHistory.StateListener {
    private final JMenuItem undoMenutItem;
    private final JMenuItem redoMenutItem;
    private CommandHistory history;
    private final String regularUndoText;
    private final String regularRedoText;

    public UndoRedoAdapter(JMenuItem undo, JMenuItem redo) {
        this.undoMenutItem = undo;
        this.redoMenutItem = redo;
        this.regularUndoText = undo.getText();
        this.regularRedoText = redo.getText();
        this.onStateChanged(false, false);
    }

    public void undo() {
        if (this.history != null) {
            this.history.undo();
        }
    }

    public void redo() {
        if (this.history != null) {
            this.history.redo();
        }
    }

    @Override
    public void connect(CommandHistory history) {
        if (history == null) {
            if (this.history != null) {
                this.history.removeStateListener(this);
            }
            this.history = null;
            this.onStateChanged(false, false);
        } else {
            this.history = history;
            this.history.addStateListener(this);
        }
    }

    @Override
    public void onStateChanged(final boolean hasUndos, final boolean hasRedos) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                UndoRedoAdapter.this.undoMenutItem.setEnabled(hasUndos);
                UndoRedoAdapter.this.redoMenutItem.setEnabled(hasRedos);
            }
        };
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(r);
        } else {
            r.run();
        }
    }

    @Override
    public void onInfoAvailable(final String undoInfo, final String redoInfo) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                if (undoInfo != null) {
                    UndoRedoAdapter.this.undoMenutItem.setText(UndoRedoAdapter.this.regularUndoText + " " + undoInfo);
                } else {
                    UndoRedoAdapter.this.undoMenutItem.setText(UndoRedoAdapter.this.regularUndoText);
                }
                if (redoInfo != null) {
                    UndoRedoAdapter.this.redoMenutItem.setText(UndoRedoAdapter.this.regularRedoText + " " + redoInfo);
                } else {
                    UndoRedoAdapter.this.redoMenutItem.setText(UndoRedoAdapter.this.regularRedoText);
                }
            }
        };
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(r);
        } else {
            r.run();
        }
    }
}

