/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyveclient;

import com.hybridlab.hyve3d.LocalFileScene;
import com.hybridlab.hyve3d.applicationcontrol.TerminalConversation;
import com.hybridlab.hyve3d.config.ConfigurationAdapter;
import com.hybridlab.hyve3d.config.MaskProperties;
import com.hybridlab.hyve3d.config.NamedAngle;
import com.hybridlab.hyve3d.config.NamedString;
import com.hybridlab.hyve3d.config.RingMaskProperties;
import com.hybridlab.hyve3d.core.FrameRect;
import com.hybridlab.hyve3d.core.HisSphericalRendererApplication;
import com.hybridlab.hyve3d.core.Transformable;
import com.hybridlab.hyve3d.core.animation.AnimationTrigger;
import com.hybridlab.hyve3d.data.HyveData;
import com.hybridlab.hyve3d.data.Session;
import com.hybridlab.hyve3d.data.domainobjects.Asset;
import com.hybridlab.hyve3d.data.domainobjects.CommandHistory;
import com.hybridlab.hyve3d.data.domainobjects.Space;
import com.hybridlab.hyve3d.data.domainobjects.Stroke;
import com.hybridlab.hyve3d.data.synch.SynchronizationProgressTracer;
import com.hybridlab.hyve3d.data.synch.exceptions.ConcurrentAddException;
import com.hybridlab.hyve3d.data.synch.messages.ChunkedSynchMessage;
import com.hybridlab.hyve3d.data.valueobjects.Ink;
import com.hybridlab.hyve3d.data.valueobjects.StrokePoint;
import com.hybridlab.hyve3d.data.valueobjects.Transformation;
import com.hybridlab.hyve3d.hyve.FileTypes;
import com.hybridlab.hyve3d.hyve.GlobalSettings;
import com.hybridlab.hyve3d.hyve.HubNodeNetworkingController;
import com.hybridlab.hyve3d.hyve.Hyve;
import com.hybridlab.hyve3d.hyve.HyveApplication;
import com.hybridlab.hyve3d.hyve.HyveNetworking;
import com.hybridlab.hyve3d.hyve.OrthoShooter;
import com.hybridlab.hyve3d.hyve.SatelliteCenter;
import com.hybridlab.hyve3d.hyve.SessionInfo;
import com.hybridlab.hyve3d.hyve.SessionVisualizer;
import com.hybridlab.hyve3d.hyve.undoredo.HistoryController;
import com.hybridlab.hyve3d.hyveclient.InterconnectivitySessionObserver;
import com.hybridlab.hyve3d.hyveclient.TCPAppCtrlConnectedConfiguration;
import com.hybridlab.hyve3d.inputdevice.InputDeviceManager;
import com.hybridlab.hyve3d.network.ResourceProvider;
import com.hybridlab.hyve3d.network.discovery.NetworkServiceManager;
import com.hybridlab.hyve3d.network.interconnection.HubConnection;
import com.hybridlab.hyve3d.network.interconnection.HubNode;
import com.hybridlab.hyve3d.network.interconnection.HubNodeHost;
import com.hybridlab.hyve3d.network.interconnection.InterconnectivityDataModel;
import com.hybridlab.hyve3d.network.interconnection.SessionRepository;
import com.hybridlab.hyve3d.network.interconnection.implementations.SimpleSessionController;
import com.hybridlab.hyve3d.network.interconnection.implementations.adressing.HubNodeAddress;
import com.hybridlab.hyve3d.network.interconnection.messages.Registry;
import com.hybridlab.hyve3d.nina.CalibrationConfiguration;
import com.hybridlab.hyve3d.nina.ImmersionMode;
import com.hybridlab.hyve3d.nina.Jme3DualViewPortRenderer;
import com.hybridlab.hyve3d.nina.NScreenshotAppState;
import com.hybridlab.hyve3d.nina.NinaConfiguration;
import com.hybridlab.hyve3d.rendering.ErrorVisualizer;
import com.hybridlab.hyve3d.rendering.Jme3HyveSceneManager;
import com.hybridlab.hyve3d.rendering.Jme3SessionVisualizer;
import com.hybridlab.hyve3d.rendering.Jme3ThreadingHelper;
import com.hybridlab.hyve3d.rendering.ProgressVisualizer;
import com.hybridlab.hyve3d.rendering.spherical.ProjectionCalibrator;
import com.hybridlab.hyveclient.SceneController;
import com.hybridlab.hyveclient.SimpleAppControl.AppControlServerMessageAdapter;
import com.hybridlab.hyveclient.SimpleAppControl.AppCtrlServer;
import com.hybridlab.hyveclient.SimpleAppControl.CommandCode;
import com.hybridlab.hyveclient.SimpleAppControl.PlainTcpAppCtrlServer;
import com.hybridlab.hyveclient.SimpleAppControl.SimpleCommandWithStringArgumentMessage;
import com.hybridlab.hyveclient.Test1;
import com.hybridlab.hyveclient.Test2;
import com.hybridlab.licensing.Feature;
import com.hybridlab.licensing.LicenseKey;
import com.hybridlab.utils.Hardware4Mac;
import com.jme3.app.Application;
import com.jme3.app.SimpleApplication;
import com.jme3.app.state.AppState;
import com.jme3.input.controls.InputListener;
import com.jme3.input.controls.KeyTrigger;
import com.jme3.input.controls.Trigger;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Box;
import com.jme3.system.AppSettings;
import com.jme3.texture.TextureCubeMap;
import java.awt.Dimension;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.invoke.CallSite;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.joda.time.DateTime;
import org.joda.time.Instant;

public class HyveClientApplicationWithBlackScreenBug
extends SimpleApplication
implements Jme3ThreadingHelper {
    static HyveClientApplicationWithBlackScreenBug clientApp;
    static AppSettings settings;
    private Geometry geom4;
    private NetworkServiceManager networkServiceManager;
    private SatelliteCenter satCenter;
    private InputDeviceManager inputDeviceManager;
    private TCPAppCtrlConnectedConfiguration cfg;
    private HyveApplication hyveApplication;
    private static Session session;
    private AppCtrlServer appControlServer;
    private Geometry noValidLicenseLabelGeometry;
    private NetworkingUIControlTerminalAdapter networkingUIControlTerminalAdapter;
    private InterconnectivitySessionObserver icSessionObserver;
    private SceneController sceneController;
    private int[] nonFullscreenWindowPosition = new int[]{100, 100, 500, 400};
    public static String executablePath;
    public static String openglVersion;
    private LicenseKey license;
    private LicenseBoxPositionUpdater licBoxUpdater = new LicenseBoxPositionUpdater();
    private MenuUndoRedoAdapter undoRedoAdapter;
    private Jme3SessionVisualizer sessionVisualizer;
    private final ErrorVisualizer errorVisualizer = new ErrorVisualizer(){

        @Override
        public void showReasonOfException(Exception e) {
            Throwable t = e.getCause();
            HyveClientApplicationWithBlackScreenBug.this.ShowLogAndPrint("log", e.toString() + (String)(t != null ? "\n" + t.toString() : ""));
        }

        @Override
        public void showReasonOfExceptionWithoutExceptionName(Exception e) {
            Throwable t = e.getCause();
            System.out.println(e.getLocalizedMessage() + (String)(t != null ? "\n" + t.getLocalizedMessage() : ""));
        }
    };
    private Thread renderThread;
    private Jme3HyveSceneManager sceneManager;
    private Jme3DualViewPortRenderer dvRenderer;
    private CalibrationConfiguration calibrationConfiguration;
    private Timer licenseTimer;
    private final ProgressVisualizer progVis = new ProgressVisualizer(){

        @Override
        public void setProgressText(String id, String txt) {
            HyveClientApplicationWithBlackScreenBug.this.ShowLogAndPrint("progress", id + ": " + txt);
        }

        @Override
        public void setProgressComplete(String id) {
            HyveClientApplicationWithBlackScreenBug.this.ShowLogAndPrint("progress", id + " complete");
        }
    };
    private JmeUpdateFrameTrigger animationTrigger;

    @Override
    public boolean isThreadEqualToRenderThread(Thread currentThread) {
        return this.renderThread.equals(currentThread);
    }

    private void cancelFullScreen() {
        int[] rect = this.nonFullscreenWindowPosition;
        settings.setWindowXPosition(rect[0]);
        settings.setWindowYPosition(rect[1]);
        settings.setWindowSize(rect[2], rect[3]);
        settings.putBoolean("Undecorated", false);
        clientApp.setSettings(settings);
        clientApp.restart();
        this.dvRenderer.onWindowResized(new Dimension(rect[2], rect[3]));
        clientApp.bringUIToFront();
    }

    private void sendToSecondScreen(int[] rect) {
        this.nonFullscreenWindowPosition[0] = settings.getWindowXPosition();
        this.nonFullscreenWindowPosition[1] = settings.getWindowYPosition();
        this.nonFullscreenWindowPosition[2] = settings.getWindowWidth();
        this.nonFullscreenWindowPosition[3] = settings.getWindowHeight();
        settings.setWindowXPosition(rect[0]);
        settings.setWindowYPosition(rect[1]);
        settings.setWindowSize(rect[2], rect[3]);
        settings.putBoolean("Undecorated", true);
        clientApp.setSettings(settings);
        clientApp.restart();
        this.dvRenderer.onWindowResized(new Dimension(rect[2], rect[3]));
        clientApp.bringUIToFront();
    }

    private void checkLicense() {
        String key = null;
        LicenseKey lk = LicenseKey.Unlicensed;
        if (key != null) {
            String uppercaseTrimmedKey = key.trim().toUpperCase();
            try {
                lk = new LicenseKey(uppercaseTrimmedKey);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.setLicense(lk);
    }

    public static boolean isRunfromJar() {
        return !executablePath.endsWith(".app");
    }

    public static String getUiExecutablePath() {
        String uiExecutableName = "Hyve3D UI.app";
        if (HyveClientApplicationWithBlackScreenBug.isRunfromJar()) {
            return "/Applications/Hybridlab/" + uiExecutableName;
        }
        File file = new File(executablePath);
        String folder = file.getParent();
        return folder + "/" + uiExecutableName;
    }

    public static void main(String[] args) {
        HyveClientApplicationWithBlackScreenBug.dl(1, "start of main");
        try {
            File file = new File("/tmp/HyveRenderWindow.log");
            System.out.println("console output redirected to file: " + file.getAbsolutePath() + " ");
            PrintStream stream = null;
            stream = new PrintStream(file);
            System.setOut(stream);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        File t1 = new File("/tmp/h3d-test-1");
        File t2 = new File("/tmp/h3d-test-2");
        File ogl2 = new File("/tmp/h3d-opengl2");
        File ogl3 = new File("/tmp/h3d-opengl3");
        File ogl4 = new File("/tmp/h3d-opengl4");
        try {
            if (ogl2.exists()) {
                HyveClientApplicationWithBlackScreenBug.dl(1, ogl2.getAbsolutePath() + " file or directory exists ! ... using OPENGL 2");
                openglVersion = "LWJGL-OpenGL2";
            } else if (ogl3.exists()) {
                HyveClientApplicationWithBlackScreenBug.dl(1, ogl3.getAbsolutePath() + " file or directory exists ! ... using OPENGL 4.0 ...");
                openglVersion = "LWJGL-OpenGL33";
            } else if (ogl4.exists()) {
                HyveClientApplicationWithBlackScreenBug.dl(1, ogl4.getAbsolutePath() + " file or directory exists ! ... using OPENGL 4.0 ...");
                openglVersion = "LWJGL-OpenGL4";
            } else {
                HyveClientApplicationWithBlackScreenBug.dl(1, "no h3d-opengl file or directory exists ! ... using " + openglVersion);
            }
        }
        catch (SecurityException se) {
            HyveClientApplicationWithBlackScreenBug.dl(1, se.getLocalizedMessage());
        }
        try {
            if (t1.exists()) {
                HyveClientApplicationWithBlackScreenBug.dl(1, t1.getAbsolutePath() + " file or directory exists ! ... enabling TEST MODE ...");
                Test1.main(args);
            } else if (t2.exists()) {
                HyveClientApplicationWithBlackScreenBug.dl(1, t2.getAbsolutePath() + " file or directory exists ! ... enabling TEST MODE ...");
                Test2.main(args);
            } else {
                HyveClientApplicationWithBlackScreenBug.dl(1, "no test activation found - entering normal operations");
                HyveClientApplicationWithBlackScreenBug.main_normal_operation(args);
            }
        }
        catch (SecurityException se) {
            HyveClientApplicationWithBlackScreenBug.dl(1, se.getLocalizedMessage());
            HyveClientApplicationWithBlackScreenBug.main_normal_operation(args);
        }
    }

    public static void main_normal_operation(String[] args) {
        NetworkingUIControlTerminalAdapter nui;
        executablePath = HyveClientApplicationWithBlackScreenBug.class.getResource("HyveClientApplication.class").getPath();
        executablePath = executablePath.replace("/Contents/Resources/Java/HyveClient.jar!/com/hybridlab/hyveclient/HyveClientApplication.class", "");
        executablePath = executablePath.replace("file:", "");
        HyveClientApplicationWithBlackScreenBug.dl(2, "getUiExecutablePath() = " + HyveClientApplicationWithBlackScreenBug.getUiExecutablePath());
        clientApp = new HyveClientApplicationWithBlackScreenBug();
        HyveClientApplicationWithBlackScreenBug.dl(3, "checkLicense()");
        clientApp.checkLicense();
        settings = new AppSettings(true);
        settings.setTitle("Hyve3D Render Window");
        settings.setVSync(true);
        settings.setSamples(2);
        settings.setResizable(true);
        settings.setRenderer(openglVersion);
        settings.setDepthBits(32);
        settings.setUseInput(true);
        settings.setFullscreen(false);
        settings.setUseRetinaFrameBuffer(true);
        boolean gc = settings.isGammaCorrection();
        settings.setGammaCorrection(false);
        settings.setCenterWindow(false);
        clientApp.setShowSettings(false);
        clientApp.setSettings(settings);
        HyveClientApplicationWithBlackScreenBug.dl(4, "AppSettings prepared and set");
        HyveClientApplicationWithBlackScreenBug.clientApp.animationTrigger = new JmeUpdateFrameTrigger();
        HyveClientApplicationWithBlackScreenBug.clientApp.networkServiceManager = new NetworkServiceManager();
        HyveClientApplicationWithBlackScreenBug.dl(5, "creating TCPAppCtrlConnectedConfiguration ...");
        HyveClientApplicationWithBlackScreenBug.clientApp.cfg = new TCPAppCtrlConnectedConfiguration();
        HyveClientApplicationWithBlackScreenBug.dl(6, "calling clientApp.cfg.saveIfChanged() ...");
        HyveClientApplicationWithBlackScreenBug.clientApp.cfg.saveIfChanged();
        boolean appctrlServer = true;
        if (appctrlServer) {
            HyveClientApplicationWithBlackScreenBug.dl(7, "creating PlainTcpAppCtrlServer ...");
            HyveClientApplicationWithBlackScreenBug.clientApp.appControlServer = new PlainTcpAppCtrlServer();
        }
        UUID localSessionId = UUID.randomUUID();
        HyveClientApplicationWithBlackScreenBug.dl(8, "creating HyveApplication(localSessionId=" + localSessionId + ") ...");
        HyveClientApplicationWithBlackScreenBug.clientApp.hyveApplication = new HyveApplication(localSessionId);
        ConfigurationAdapter ca = new ConfigurationAdapter(){

            @Override
            public String getHyveName() {
                return HyveClientApplicationWithBlackScreenBug.clientApp.cfg.getHyveName();
            }

            @Override
            public NamedAngle getNorthHeading() {
                return HyveClientApplicationWithBlackScreenBug.clientApp.cfg.getNorthHeading();
            }

            @Override
            public void setHyveName(String hyveName) {
                HyveClientApplicationWithBlackScreenBug.clientApp.cfg.setHyveName(hyveName);
            }

            @Override
            public NamedString getUsedRotationSensor() {
                return HyveClientApplicationWithBlackScreenBug.clientApp.cfg.getUsedRotationSensor();
            }

            @Override
            public NamedAngle getHydraControllerAttachmentAngle() {
                return HyveClientApplicationWithBlackScreenBug.clientApp.cfg.getHydraControllerAttachmentAngle();
            }

            @Override
            public MaskProperties getEllipseMaskProperties() {
                return HyveClientApplicationWithBlackScreenBug.clientApp.cfg.getEllipseMaskProperties();
            }

            @Override
            public Map<TextureCubeMap.Face, Boolean> getEnabledFaces() {
                return HyveClientApplicationWithBlackScreenBug.clientApp.cfg.getEnabledFaces();
            }

            @Override
            public void setEnabledFaces(Map<TextureCubeMap.Face, Boolean> faces) {
                HyveClientApplicationWithBlackScreenBug.clientApp.cfg.setEnabledFaces(faces);
            }

            @Override
            public RingMaskProperties getRingMaskProperties() {
                return HyveClientApplicationWithBlackScreenBug.clientApp.cfg.getRingMaskProperties();
            }
        };
        HyveClientApplicationWithBlackScreenBug.dl(9, "creating localhyve  ...");
        Hyve localhyve = new Hyve(UUID.fromString(HyveClientApplicationWithBlackScreenBug.clientApp.cfg.getHyveUuid()), ca);
        HyveClientApplicationWithBlackScreenBug.clientApp.hyveApplication.setLocalHyve(localhyve);
        HyveClientApplicationWithBlackScreenBug.dl(10, "creating SimpleSessionController / SessionRepository  ...");
        SimpleSessionController sessionCtrl = new SimpleSessionController();
        HyveClientApplicationWithBlackScreenBug.clientApp.hyveApplication.setSessionRepository(sessionCtrl);
        UUID hubnodeid = UUID.fromString(HyveClientApplicationWithBlackScreenBug.clientApp.cfg.getHubNodeUUID());
        HyveClientApplicationWithBlackScreenBug.dl(11, "creating HubNode " + hubnodeid + "  ...");
        HubNode n = new HubNode(hubnodeid);
        n.setDescription("Hubnode in " + HyveClientApplicationWithBlackScreenBug.clientApp.cfg.getAppId());
        HyveClientApplicationWithBlackScreenBug.dl(12, "creating SynchronizationProgressTracer  ...");
        SynchronizationProgressTracer pt2 = new SynchronizationProgressTracer(){

            @Override
            public void trace(ChunkedSynchMessage message, SynchronizationProgressTracer.MessageDirection direction, String connectionkey) {
                String id = connectionkey;
                String txt = "synchronizing session: (" + (direction == SynchronizationProgressTracer.MessageDirection.RECEIVE ? "receiving" : "sending") + " " + message.chunkid + "/" + message.numchunks + " packets)";
                System.out.println(txt);
            }
        };
        HyveClientApplicationWithBlackScreenBug.dl(13, "creating HubNodeNetworkingController  ...");
        HubNodeNetworkingController net = new HubNodeNetworkingController(n, sessionCtrl, HyveClientApplicationWithBlackScreenBug.clientApp.networkServiceManager, pt2);
        HyveClientApplicationWithBlackScreenBug.clientApp.hyveApplication.setNetworkingController(net);
        HyveClientApplicationWithBlackScreenBug.dl(14, "creating NetworkingUIControlTerminalAdapter  ...");
        HyveClientApplicationWithBlackScreenBug.clientApp.networkingUIControlTerminalAdapter = nui = new NetworkingUIControlTerminalAdapter(net);
        HyveClientApplicationWithBlackScreenBug.dl(15, "creating InputDeviceManager  ...");
        HyveClientApplicationWithBlackScreenBug.clientApp.inputDeviceManager = new InputDeviceManager();
        HyveClientApplicationWithBlackScreenBug.clientApp.inputDeviceManager.registerDefaultDevices();
        if (HyveClientApplicationWithBlackScreenBug.clientApp.cfg.getInitDefaultDevices()) {
            try {
                HyveClientApplicationWithBlackScreenBug.clientApp.inputDeviceManager.initDefaultDevices();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        HyveClientApplicationWithBlackScreenBug.dl(16, "creating SatelliteCenter  ...");
        HyveClientApplicationWithBlackScreenBug.clientApp.satCenter = new SatelliteCenter(HyveClientApplicationWithBlackScreenBug.clientApp.networkServiceManager, HyveClientApplicationWithBlackScreenBug.clientApp.inputDeviceManager, HyveClientApplicationWithBlackScreenBug.clientApp.cfg.getSatelliteConfigurationSet(), HyveClientApplicationWithBlackScreenBug.clientApp.cfg.getHydraControllerAttachmentAngle(), localhyve);
        HyveClientApplicationWithBlackScreenBug.clientApp.hyveApplication.setSatelliteCenter(HyveClientApplicationWithBlackScreenBug.clientApp.satCenter);
        try {
            ResourceProvider resourceProvider = new ResourceProvider();
            String address = InetAddress.getLocalHost().getHostAddress();
            HyveClientApplicationWithBlackScreenBug.dl(17, "creating ResourceProvider (address='" + address + "') ...");
            int port = HyveClientApplicationWithBlackScreenBug.clientApp.networkServiceManager.registerService(resourceProvider.getServiceIdentifier(), address);
            resourceProvider.start(address, port);
            HyveClientApplicationWithBlackScreenBug.dl(18, "... resourceProvider.start(address=" + address + ", port=" + port + ") has been called");
            ResourceProvider.setInstance(resourceProvider);
        }
        catch (UnknownHostException e1) {
            e1.printStackTrace();
        }
        try {
            HyveClientApplicationWithBlackScreenBug.dl(19, "creating initial Session (" + localSessionId + ")  ...");
            session = sessionCtrl.createNewSession(localSessionId, "Initial Session in " + HyveClientApplicationWithBlackScreenBug.clientApp.cfg.getAppId());
            HyveClientApplicationWithBlackScreenBug.dl(20, "... calling session.addDefaultLights ()  ...");
            session.addDefaultLights();
        }
        catch (SessionRepository.SessionAlreadyInRepositoryException e) {
            e.printStackTrace();
        }
        HyveClientApplicationWithBlackScreenBug.dl(21, "creating SceneController ...");
        HyveClientApplicationWithBlackScreenBug.clientApp.sceneController = new SceneController();
        HyveClientApplicationWithBlackScreenBug.clientApp.sceneController.connectHyve(HyveClientApplicationWithBlackScreenBug.clientApp.hyveApplication.getLocalHyve());
        HyveClientApplicationWithBlackScreenBug.dl(22, "creating InterconnectivityDataModel ...");
        InterconnectivityDataModel icDataModel = HyveClientApplicationWithBlackScreenBug.clientApp.networkingUIControlTerminalAdapter.nc.getInterConnectivityDataModel();
        HyveClientApplicationWithBlackScreenBug.dl(23, "creating InterconnectivitySessionObserver ...");
        HyveClientApplicationWithBlackScreenBug.clientApp.icSessionObserver = new InterconnectivitySessionObserver(icDataModel, new InterconnectivitySessionObserver.TextField(){

            @Override
            public void setText(String txt) {
                clientApp.ShowLogAndPrint("log ", txt);
            }
        }, new InterconnectivitySessionObserver.SessionList(){

            @Override
            public void setAvailableSessions(List<SessionInfo> sinfo) {
                Object s = "";
                for (SessionInfo sessionInfo : sinfo) {
                    s = (String)s + sessionInfo.description + " " + sessionInfo.id + "\n";
                }
                clientApp.ShowLogAndPrint("log ", "AvailableSessions: " + (String)s);
                ArrayList<CallSite> sessionsInformation = new ArrayList<CallSite>();
                for (SessionInfo si : sinfo) {
                    if (si.id.equals(HyveClientApplicationWithBlackScreenBug.clientApp.hyveApplication.getLocalSessionId())) continue;
                    sessionsInformation.add((CallSite)((Object)(si.id + " " + si.description)));
                }
                if (!sessionsInformation.isEmpty()) {
                    String string = "ic session list\n" + String.join((CharSequence)"\n", sessionsInformation);
                    SimpleCommandWithStringArgumentMessage m = SimpleCommandWithStringArgumentMessage.createWith(CommandCode.TerminalStringCommand, string);
                    if (HyveClientApplicationWithBlackScreenBug.clientApp.appControlServer != null) {
                        HyveClientApplicationWithBlackScreenBug.clientApp.appControlServer.sendToAllClients(m);
                    }
                }
            }
        }, HyveClientApplicationWithBlackScreenBug.clientApp.hyveApplication);
        HyveClientApplicationWithBlackScreenBug.dl(24, "reaching 'finalstep' ...");
        try {
            HyveClientApplicationWithBlackScreenBug.dl(25, "calling sessionCtrl.createNewSession(" + localSessionId + ")");
            Session session = sessionCtrl.createNewSession(localSessionId, "Initial Session in " + HyveClientApplicationWithBlackScreenBug.clientApp.cfg.getAppId());
            HyveClientApplicationWithBlackScreenBug.dl(26, "... calling session.addDefaultLights ()  ...");
            session.addDefaultLights();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        HyveClientApplicationWithBlackScreenBug.dl(27, "Registry.registerMessageTypes() ...");
        Registry.registerMessageTypes();
        HyveClientApplicationWithBlackScreenBug.dl(28, "clientApp.appControlServer.connectAdapter(new AppCtrlServerAdapter(clientApp)); ...");
        HyveClientApplicationWithBlackScreenBug.clientApp.appControlServer.connectAdapter(new AppCtrlServerAdapter(clientApp));
        HyveClientApplicationWithBlackScreenBug.dl(29, "clientApp.appControlServer.start(); ...");
        HyveClientApplicationWithBlackScreenBug.clientApp.appControlServer.start();
        int num = 30;
        HyveClientApplicationWithBlackScreenBug.dl(num, "clientApp.enqueue( ... Future ...);");
        clientApp.enqueue(() -> {
            HyveClientApplicationWithBlackScreenBug.dl(300, "Future from Point " + num + " being executed now ...");
            HyveClientApplicationWithBlackScreenBug.dl(301, "setOrthoShooter ...");
            localhyve.setOrthoShooter(clientApp.getOrthoShooter());
            HyveClientApplicationWithBlackScreenBug.dl(302, "setAnimationTrigger ...");
            localhyve.setAnimationTrigger(clientApp.getAnimationTrigger());
            HyveClientApplicationWithBlackScreenBug.dl(303, "setHistoryController ...");
            localhyve.setHistoryController(HyveClientApplicationWithBlackScreenBug.clientApp.undoRedoAdapter);
            SessionVisualizer vis = clientApp.getSessionVisualizer();
            HyveClientApplicationWithBlackScreenBug.dl(304, "addSessionVisualizer ...");
            HyveClientApplicationWithBlackScreenBug.clientApp.hyveApplication.addSessionVisualizer(vis);
            Hyve.CameraAdapter camAdapter = HyveClientApplicationWithBlackScreenBug.clientApp.hyveApplication.setCameraTransformer(clientApp.getCameraRig());
            HyveClientApplicationWithBlackScreenBug.dl(305, "clientApp.connectCameraAdapter(" + camAdapter + ") ...");
            if (camAdapter != null) {
                clientApp.connectCameraAdapter(camAdapter);
            }
            HyveClientApplicationWithBlackScreenBug.dl(306, "showSession ...");
            HyveClientApplicationWithBlackScreenBug.clientApp.hyveApplication.showSession(session.getId());
            HyveClientApplicationWithBlackScreenBug.dl(307, "localhyve.joinSession(...) ...");
            localhyve.joinSession(session);
            HyveClientApplicationWithBlackScreenBug.dl(308, "clientApp.satCenter.start() ...");
            HyveClientApplicationWithBlackScreenBug.clientApp.satCenter.start();
            HyveClientApplicationWithBlackScreenBug.dl(309, "clientApp.networkServiceManager.start() ...");
            HyveClientApplicationWithBlackScreenBug.clientApp.networkServiceManager.start();
            return null;
        });
        HyveClientApplicationWithBlackScreenBug.dl(31, "clientApp.bringUIToFront(); ...");
        clientApp.bringUIToFront();
        boolean sendHello = false;
        if (sendHello) {
            ScheduledExecutorService exec = Executors.newScheduledThreadPool(1);
            exec.schedule(new Runnable(){

                @Override
                public void run() {
                    System.out.println("sending hello with UDP...");
                    UDPHelloSender.sendHello();
                }
            }, 500L, TimeUnit.MILLISECONDS);
        }
        HyveClientApplicationWithBlackScreenBug.dl(32, ">>>>> clientApp.start(); ...");
        clientApp.start();
        HyveClientApplicationWithBlackScreenBug.dl(33, ">>>>> System.exit(0); ...");
        System.exit(0);
    }

    public void openUIExecutable() {
        try {
            System.out.println("Runtime.getRuntime().exec([\"open\", \"" + HyveClientApplicationWithBlackScreenBug.getUiExecutablePath() + "\"]);");
            String[] cmd = new String[]{"open", HyveClientApplicationWithBlackScreenBug.getUiExecutablePath()};
            Runtime.getRuntime().exec(cmd);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void bringUIToFront() {
        if (!HyveClientApplicationWithBlackScreenBug.isRunfromJar()) {
            System.out.println("---------- BRING UI TO FRONT ------------");
            this.openUIExecutable();
        } else {
            System.out.println("-- RunfromJar -- normally BRING UI TO FRONT - but not calling openUIExecutable(); ------------");
        }
    }

    private void callSafe(Callable<Object> c) {
        if (clientApp.isThreadEqualToRenderThread(Thread.currentThread())) {
            try {
                c.call();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            clientApp.enqueue(c);
        }
    }

    private LicenseKey getLicense() {
        return this.license;
    }

    private void setLicense(LicenseKey license) {
        this.license = license;
    }

    private void updateLicense(LicenseKey key) {
        this.setLicense(key);
        String hardwareuuid = Hardware4Mac.getHardwareUUIDNumber();
        try {
            if (this.getLicense().isValidForHardwareIDAtThisMoment(hardwareuuid)) {
                this.licenseTimer.cancel();
                clientApp.enqueue(new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        HyveClientApplicationWithBlackScreenBug.clientApp.sceneManager.getSceneNode().detachChild((Spatial)HyveClientApplicationWithBlackScreenBug.this.noValidLicenseLabelGeometry);
                        HyveClientApplicationWithBlackScreenBug.this.dvRenderer.removeCameraPositionObserver(HyveClientApplicationWithBlackScreenBug.this.licBoxUpdater);
                        return null;
                    }
                });
                if (HyveClientApplicationWithBlackScreenBug.clientApp.appControlServer != null) {
                    HyveClientApplicationWithBlackScreenBug.clientApp.appControlServer.sendToAllClients(SimpleCommandWithStringArgumentMessage.createWith(CommandCode.TerminalStringCommand, "license valid"));
                    LicenseKey l = this.getLicense();
                    DateTime until = l.getValidUntil();
                    Instant instant = until.toInstant();
                    Object features = "Features[ ";
                    for (Feature f : l.getEnabledFeatures()) {
                        features = (String)features + f.toString() + " ";
                    }
                    features = (String)features + "]";
                    HyveClientApplicationWithBlackScreenBug.clientApp.appControlServer.sendToAllClients(SimpleCommandWithStringArgumentMessage.createWith(CommandCode.TerminalStringCommand, "license detail " + instant.toString() + " " + (String)features));
                }
            } else if (HyveClientApplicationWithBlackScreenBug.clientApp.appControlServer != null) {
                HyveClientApplicationWithBlackScreenBug.clientApp.appControlServer.sendToAllClients(SimpleCommandWithStringArgumentMessage.createWith(CommandCode.TerminalStringCommand, "license invalid"));
                LicenseKey l = this.getLicense();
                DateTime until = l.getValidUntil();
                Instant instant = until.toInstant();
                Object features = "Features[ ";
                for (Feature f : l.getEnabledFeatures()) {
                    features = (String)features + f.toString() + " ";
                }
                features = (String)features + "]";
                HyveClientApplicationWithBlackScreenBug.clientApp.appControlServer.sendToAllClients(SimpleCommandWithStringArgumentMessage.createWith(CommandCode.TerminalStringCommand, "license detail " + instant.toString() + " " + (String)features));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Transformable getCameraRig() {
        if (this.dvRenderer == null) {
            throw new RuntimeException("Unallowed Access before correct initialization!");
        }
        return this.dvRenderer.getCameraRig();
    }

    private void connectCameraAdapter(Hyve.CameraAdapter camAdapter) {
        this.dvRenderer.connectCameraAdapter(camAdapter);
    }

    private SessionVisualizer getSessionVisualizer() {
        return this.sessionVisualizer;
    }

    private AnimationTrigger getAnimationTrigger() {
        return this.animationTrigger;
    }

    private OrthoShooter getOrthoShooter() {
        return this.dvRenderer;
    }

    private Jme3HyveSceneManager getSceneManager() {
        return this.sceneManager;
    }

    public static void toggleToFullscreen() {
        String key;
        settings.putBoolean(key, !settings.getBoolean(key = "Undecorated"));
        clientApp.setSettings(settings);
        clientApp.restart();
    }

    private static ArrayList<String> multiLine(String longString, int maxLength) {
        int l = longString.length();
        int i = 0;
        ArrayList<String> r = new ArrayList<String>();
        while (i < l) {
            int e = Math.min(i + maxLength, l);
            String part = longString.substring(i, e);
            r.add(part);
            i = e;
        }
        return r;
    }

    private void ShowLogAndPrint(String channel, String message) {
        ArrayList<String> parts = HyveClientApplicationWithBlackScreenBug.multiLine(message, 500);
        for (String p : parts) {
            String msg = channel + " " + p;
            SimpleCommandWithStringArgumentMessage m = SimpleCommandWithStringArgumentMessage.createWith(CommandCode.TerminalStringCommand, msg);
            if (clientApp == null || HyveClientApplicationWithBlackScreenBug.clientApp.appControlServer == null) continue;
            HyveClientApplicationWithBlackScreenBug.clientApp.appControlServer.sendToAllClients(m);
        }
        System.out.println(message);
    }

    public ErrorVisualizer getErrorVisualizer() {
        return this.errorVisualizer;
    }

    public void simpleInitApp() {
        this.flyCam.setEnabled(false);
        this.renderThread = Thread.currentThread();
        NScreenshotAppState screenShotState = new NScreenshotAppState();
        this.stateManager.attach((AppState)screenShotState);
        this.inputManager.addMapping("ScreenShot", new Trigger[]{new KeyTrigger(57)});
        this.inputManager.addListener((InputListener)screenShotState, new String[]{"ScreenShot"});
        this.setPauseOnLostFocus(false);
        this.setDisplayStatView(false);
        this.setDisplayFps(false);
        this.inputManager.setCursorVisible(true);
        String tempFolder = "/tmp/hyvesession-" + this.hyveApplication.getLocalSessionId().toString() + "/";
        try {
            FileUtils.forceMkdir(new File(tempFolder));
        }
        catch (IOException e1) {
            this.errorVisualizer.showReasonOfException(e1);
            e1.printStackTrace();
        }
        this.sceneManager = new Jme3HyveSceneManager(this.assetManager, this, this.errorVisualizer, tempFolder);
        String afp = executablePath + "/Contents/Resources/Java/";
        this.sceneManager.setAssetPath(afp);
        this.sessionVisualizer = new Jme3SessionVisualizer((Application)this, this.hyveApplication, this.sceneManager, this.progVis);
        Jme3SessionVisualizer.setLineWidthMultiplyFactor(switch (openglVersion) {
            case "LWJGL-OpenGL2" -> 1.0f;
            case "LWJGL-OpenGL4" -> 10.3f;
            case "LWJGL-OpenGL33" -> 2.3f;
            default -> 1.0f;
        });
        this.sessionVisualizer.simpleInit();
        this.sceneManager.getSceneNode().attachChild((Spatial)this.sessionVisualizer.getSessionVisualizationRootNode());
        HyveClientApplicationWithBlackScreenBug.clientApp.sceneController.setSceneManager(HyveClientApplicationWithBlackScreenBug.clientApp.sceneManager);
        this.calibrationConfiguration = this.cfg.getProjectionCalibration();
        int cubeTextureResolution = 2048;
        boolean startInSphericalMode = false;
        Dimension windowdimensions = new Dimension();
        windowdimensions.setSize(settings.getWindowWidth(), settings.getWindowHeight());
        this.dvRenderer = new Jme3DualViewPortRenderer(this.assetManager, this.renderManager, this.rootNode, this.sceneManager.getSceneNode(), this.flyCam, this.cam, this.sceneManager, this, this.calibrationConfiguration, this.cfg.getShiftHVProperties(), this.cfg.getEllipseMaskProperties(), this.cfg.getRingMaskProperties(), windowdimensions, startInSphericalMode ? HisSphericalRendererApplication.AppMode.SPHERICAL : HisSphericalRendererApplication.AppMode.FRUSTUM, cubeTextureResolution, this.cfg.getEnabledFaces());
        this.dvRenderer.simpleInit();
        this.dvRenderer.setEnabled(true);
        String hardwareuuid = Hardware4Mac.getHardwareUUIDNumber();
        Box bnvl = new Box(1.0f, 1.0f, 1.0f);
        this.noValidLicenseLabelGeometry = new Geometry("Box", (Mesh)bnvl);
        this.noValidLicenseLabelGeometry.rotate(3.1425f, 0.0f, 0.0f);
        Material matbnvl = this.assetManager.loadMaterial("Interface/NoLicense.j3m");
        matbnvl.getAdditionalRenderState().setFaceCullMode(RenderState.FaceCullMode.Off);
        this.noValidLicenseLabelGeometry.setMaterial(matbnvl);
        Vector3f pos = this.dvRenderer.getCameraRig().getTransformation().getPosition();
        this.noValidLicenseLabelGeometry.getLocalTransform().setTranslation(pos);
        long milliSecondsUntilLicensWarningWillBeShown = 30000L;
        try {
            if (!this.getLicense().isValidForHardwareIDAtThisMoment(hardwareuuid)) {
                this.licenseTimer = new Timer(true);
                TimerTask t = new TimerTask(){

                    @Override
                    public void run() {
                        clientApp.enqueue(() -> {
                            HyveClientApplicationWithBlackScreenBug.clientApp.sceneManager.getSceneNode().attachChild((Spatial)HyveClientApplicationWithBlackScreenBug.this.noValidLicenseLabelGeometry);
                            HyveClientApplicationWithBlackScreenBug.this.dvRenderer.addCameraPositionObserver(HyveClientApplicationWithBlackScreenBug.this.licBoxUpdater);
                            return null;
                        });
                    }
                };
                this.licenseTimer.schedule(t, milliSecondsUntilLicensWarningWillBeShown);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        boolean debug = false;
        if (debug) {
            Vector3f scale = new Vector3f(1.0f, 1.0f, 1.0f);
            Quaternion rotation = new Quaternion();
            Vector3f position = new Vector3f(0.0f, 0.0f, 0.0f);
            Transformation trf = new Transformation(position, rotation, scale);
            Stroke s = new Stroke(UUID.randomUUID(), new Ink(ColorRGBA.Cyan, Ink.Style.FACE, Float.valueOf(10.0f)), trf);
            StrokePoint p1 = new StrokePoint(new Vector2f(0.0f, 0.0f));
            StrokePoint p2 = new StrokePoint(new Vector2f(1.0f, 0.0f));
            StrokePoint p3 = new StrokePoint(new Vector2f(2.0f, 0.0f));
            s.addStrokePoint(p1);
            s.addStrokePoint(p2);
            s.addStrokePoint(p3);
            try {
                session.add(s);
            }
            catch (ConcurrentAddException e) {
                e.printStackTrace();
            }
            Transformation t = clientApp.getCameraRig().getTransformation();
            t.add(new Vector3f(0.0f, 2.0f, 0.0f));
            clientApp.getCameraRig().setTransformation(t);
        }
        HyveClientApplicationWithBlackScreenBug.dl(100, "clientApp.bringUIToFront() (at the end of simpleInitApp");
        clientApp.bringUIToFront();
    }

    public static void dl(int a, String msg) {
        String indent = " ";
        System.out.println(a + " > \n" + indent + msg + "\n < " + a);
    }

    public void simpleUpdate(float tpf) {
        this.noValidLicenseLabelGeometry.rotate(0.0f, -0.05f * tpf, 0.0f);
        if (this.dvRenderer.getImmersionMode().equals((Object)ImmersionMode.NONIMMERSIVE)) {
            Vector3f frustumCamPos = this.cam.getLocation().clone();
            this.noValidLicenseLabelGeometry.setLocalTranslation(frustumCamPos);
        }
        this.animationTrigger.update(tpf);
        this.sessionVisualizer.simpleUpdate(tpf);
        this.dvRenderer.simpleUpdate(tpf);
        super.simpleUpdate(tpf);
    }

    static {
        openglVersion = "LWJGL-OpenGL4";
    }

    private class LicenseBoxPositionUpdater
    implements Transformable.TransformationChangedListener {
        private LicenseBoxPositionUpdater() {
        }

        @Override
        public void hasChanged(Transformable transformable) {
            HyveClientApplicationWithBlackScreenBug.this.callSafe(() -> {
                Transformation trf = transformable.getTransformation();
                Vector3f pos = trf.getPosition();
                HyveClientApplicationWithBlackScreenBug.this.noValidLicenseLabelGeometry.setLocalTranslation(pos);
                return null;
            });
        }
    }

    private static class JmeUpdateFrameTrigger
    implements AnimationTrigger {
        private final Set<AnimationTrigger.TriggerListener> listener = new HashSet<AnimationTrigger.TriggerListener>();

        private JmeUpdateFrameTrigger() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void update(float tpf) {
            Set<AnimationTrigger.TriggerListener> set = this.listener;
            synchronized (set) {
                for (AnimationTrigger.TriggerListener l : this.listener) {
                    l.onUpdate(tpf);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addTriggerListener(AnimationTrigger.TriggerListener l) {
            Set<AnimationTrigger.TriggerListener> set = this.listener;
            synchronized (set) {
                this.listener.add(l);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeTriggerListener(AnimationTrigger.TriggerListener l) {
            Set<AnimationTrigger.TriggerListener> set = this.listener;
            synchronized (set) {
                this.listener.remove(l);
            }
        }
    }

    static class NetworkingUIControlTerminalAdapter {
        HubNodeNetworkingController nc;
        HyveNetworking.ConnectionEstablishListener connEstablishListener;

        public NetworkingUIControlTerminalAdapter(HubNodeNetworkingController net) {
            this.nc = net;
        }

        public void receiveTerminalStringCommand(String terminalCommandString, final TerminalConversation conversation) {
            if (terminalCommandString.startsWith("ic getallinfos")) {
                String reply = "ic hosting off";
                conversation.reply(reply);
                String reply2 = "ic localhyvename " + HyveClientApplicationWithBlackScreenBug.clientApp.hyveApplication.getLocalHyve().getLocalSpaceName();
                conversation.reply(reply2);
                String reply3 = "ic knownhosts hyve3d.com hyve3d.com 8779";
                conversation.reply(reply3);
            } else if (terminalCommandString.startsWith("ic setlocalhyvename ")) {
                String newname = terminalCommandString.substring("ic setlocalhyvename ".length());
                HyveClientApplicationWithBlackScreenBug.clientApp.hyveApplication.getLocalHyve().setLocalSpaceName(newname);
                conversation.reply("ic localhyvename " + HyveClientApplicationWithBlackScreenBug.clientApp.hyveApplication.getLocalHyve().getLocalSpaceName());
            } else if (terminalCommandString.startsWith("ic useonlytcp")) {
                boolean on = terminalCommandString.endsWith("on");
                boolean useUDP = !on;
                this.nc.getHubNode().setUseUDP(useUDP);
                conversation.reply("useonlytcp is " + (on ? "on" : "off"));
            } else if (terminalCommandString.startsWith("ic host start ")) {
                String portpart = terminalCommandString.substring("ic host start ".length());
                try {
                    final int port = Integer.parseInt(portpart);
                    this.nc.createHost(port, new HyveNetworking.HostingEstablishListener(){

                        @Override
                        public void onHostCreationFailed(Exception e) {
                            conversation.reply("ic failed to create host with exception '" + e.getLocalizedMessage() + "'");
                        }

                        @Override
                        public void onHostCreated(HubNodeHost hnh) {
                            conversation.reply("ic hosting on port " + port);
                        }

                        @Override
                        public void onHostShutdown() {
                            conversation.reply("ic host shutdown");
                        }
                    });
                }
                catch (NumberFormatException e) {
                    conversation.reply("ic failed to create host with port='" + portpart + "'");
                }
            } else if (terminalCommandString.startsWith("ic disconnect")) {
                if (this.connEstablishListener != null) {
                    try {
                        this.nc.disconnectFromHubNode(this.connEstablishListener);
                        this.connEstablishListener = null;
                    }
                    catch (Exception e) {
                        conversation.reply("ic failed to disconnect with exception: '" + e.getLocalizedMessage() + "'");
                    }
                } else {
                    conversation.reply("ic failed to disconnect because there was no established connection");
                }
            } else if (terminalCommandString.startsWith("ic connect ")) {
                String hostAndPort = terminalCommandString.substring("ic connect ".length());
                try {
                    if (this.connEstablishListener != null) {
                        throw new Exception("There is already an active connection!");
                    }
                    String[] parts = hostAndPort.split("\\s+");
                    String host = parts[0];
                    int port = Integer.parseInt(parts[1]);
                    this.connEstablishListener = new HyveNetworking.ConnectionEstablishListener(){

                        @Override
                        public void onConnectionFailed(String message, String targetNodeInfo) {
                            conversation.reply("ic failed to connect to host - " + message + " - " + targetNodeInfo);
                        }

                        @Override
                        public void onConnectionEstablished(HubNodeAddress targetHubNodeAdress) {
                            conversation.reply("ic connection established to " + targetHubNodeAdress.describe());
                        }

                        @Override
                        public void onConnectionLost(HubConnection removed) {
                            conversation.reply("ic connection removed - " + removed.describe());
                        }
                    };
                    this.nc.asynchConnectToHubNode(host, port, this.connEstablishListener);
                }
                catch (NumberFormatException e) {
                    conversation.reply("ic failed to connect to host: '" + hostAndPort + "'");
                }
                catch (Exception e) {
                    conversation.reply("ic failed to connect with exception: '" + e.getLocalizedMessage() + "'");
                }
            } else if (terminalCommandString.startsWith("ic session ")) {
                String sessionCmd = terminalCommandString.substring("ic session ".length());
                String[] parts = sessionCmd.split("\\s+");
                if (parts.length == 0) {
                    conversation.reply("ic failed executing session command: '" + terminalCommandString + "'");
                } else {
                    try {
                        String cmd = parts[0];
                        String uuid = parts[1];
                        UUID sid = UUID.fromString(uuid);
                        switch (cmd.trim()) {
                            case "avd": {
                                this.nc.synchWithRemoteSession(sid);
                                HyveClientApplicationWithBlackScreenBug.clientApp.hyveApplication.visualizeSession(sid);
                                HyveClientApplicationWithBlackScreenBug.clientApp.hyveApplication.letHyveJoinSession();
                                break;
                            }
                            case "attend": {
                                this.nc.synchWithRemoteSession(sid);
                                break;
                            }
                            case "visualize": {
                                HyveClientApplicationWithBlackScreenBug.clientApp.hyveApplication.visualizeSession(sid);
                                break;
                            }
                            case "join": {
                                HyveClientApplicationWithBlackScreenBug.clientApp.hyveApplication.letHyveJoinSession();
                                break;
                            }
                            default: {
                                conversation.reply("ic failed executing session command: '" + terminalCommandString + "'");
                                break;
                            }
                        }
                    }
                    catch (Exception e) {
                        conversation.reply("ic failed executing session command: '" + terminalCommandString + "' with Exception: " + e.getLocalizedMessage());
                    }
                }
            }
        }
    }

    private static class AppCtrlServerAdapter
    implements AppControlServerMessageAdapter {
        private final HyveClientApplicationWithBlackScreenBug clientApp;
        private List<UUID> lastChangedAssets = null;

        public AppCtrlServerAdapter(HyveClientApplicationWithBlackScreenBug clientApp) {
            this.clientApp = clientApp;
        }

        @Override
        public void setAppMode(HisSphericalRendererApplication.AppMode mode) {
            switch (mode) {
                case SPHERICAL: {
                    this.enableImmersiveMode();
                    break;
                }
                case FRUSTUM: {
                    this.enableNonImmersiveMode();
                }
            }
        }

        @Override
        public void shoot() {
            Transformation t = new Transformation();
            Quaternion r = new Quaternion().fromAngleNormalAxis(0.7853982f, new Vector3f(1.0f, 0.0f, 1.0f).normalize());
            FrameRect fr = new FrameRect();
            OrthoShooter.FinishCallback cb = new OrthoShooter.FinishCallback(){

                @Override
                public void onFinishedShooting(String shootId, byte[] data) {
                    System.out.println(shootId);
                    ResourceProvider.get().setImagePng(shootId, data);
                    String url = ResourceProvider.get().getUrlForResource(shootId);
                    System.out.println(url);
                }
            };
            String shootid = this.clientApp.dvRenderer.shootAt(t, fr, cb);
        }

        @Override
        public void closeApplicationGraceFully() {
            this.clientApp.cfg.saveIfChanged();
            this.clientApp.stop();
            System.exit(0);
        }

        @Override
        public void sendToSecondScreen(int[] rect) {
            this.clientApp.sendToSecondScreen(rect);
        }

        @Override
        public float getFrameRate() {
            return this.clientApp.timer.getFrameRate();
        }

        @Override
        public void setSpherecameraFieldOfViewAngleAlongYInDegrees(float fov, boolean correctDistance) {
            this.clientApp.dvRenderer.getProjectionCalibrator().setSpherecameraFieldOfViewAngleAlongYInDegrees(fov, correctDistance);
        }

        @Override
        public void setCameraDistance(float distance, boolean correctFOV) {
            this.clientApp.dvRenderer.getProjectionCalibrator().setCameraDistance(distance, correctFOV);
        }

        @Override
        public void handleFloatCommand(CommandCode commandCode, float floatValue) {
            switch (commandCode) {
                case RingRadius: {
                    this.clientApp.dvRenderer.getMaskModifier().setRingRadius(floatValue);
                    break;
                }
                case EllipseWidth: {
                    this.clientApp.dvRenderer.getMaskModifier().setEllipseWidth(floatValue);
                    break;
                }
                case EllipseHeight: {
                    this.clientApp.dvRenderer.getMaskModifier().setEllipseHeight(floatValue);
                    break;
                }
                case EllipsePosition: {
                    this.clientApp.dvRenderer.getMaskModifier().setEllipsePosition(floatValue);
                    break;
                }
                case EllipseBlend: {
                    this.clientApp.dvRenderer.getMaskModifier().setEllipseBlend(floatValue);
                    break;
                }
                case ShiftVertical: {
                    this.clientApp.dvRenderer.getMaskModifier().setShiftVertical(floatValue);
                    break;
                }
                case ShiftHorizontal: {
                    this.clientApp.dvRenderer.getMaskModifier().setShiftHorizontal(floatValue);
                    break;
                }
                case ChangeSpherecamDistance: {
                    this.clientApp.dvRenderer.getProjectionCalibrator().changeSpherecamDistance(floatValue);
                    break;
                }
                case CameraDistance: {
                    this.clientApp.dvRenderer.getProjectionCalibrator().setCameraDistance(floatValue);
                    break;
                }
                case ChangeSpherecamScale: {
                    this.clientApp.dvRenderer.getProjectionCalibrator().changeSpherecamScale(floatValue);
                    break;
                }
                case SphereScale: {
                    this.clientApp.dvRenderer.getProjectionCalibrator().setSphereScale(floatValue);
                    break;
                }
                case ChangeSpherecamViewPortRadius: {
                    this.clientApp.dvRenderer.getProjectionCalibrator().changeSpherecamViewPortRadius(floatValue);
                    break;
                }
                case ViewPortRadius: {
                    this.clientApp.dvRenderer.getProjectionCalibrator().setViewPortRadius(floatValue);
                    break;
                }
                case SpherecameraFieldOfViewAngleAlongYInDegrees: {
                    this.clientApp.dvRenderer.getProjectionCalibrator().setSpherecameraFieldOfViewAngleAlongYInDegrees(floatValue);
                }
            }
        }

        @Override
        public void setEllipseColor(ColorRGBA c) {
            this.clientApp.dvRenderer.getMaskModifier().setEllipseColor(c);
        }

        @Override
        public void setRingColor(ColorRGBA c) {
            this.clientApp.dvRenderer.getMaskModifier().setRingColor(c);
        }

        @Override
        public void setRingMaskVisibility(boolean b) {
            this.clientApp.dvRenderer.getMaskModifier().setRingMaskVisibility(b);
        }

        @Override
        public Jme3DualViewPortRenderer.MaskModifier getMaskModifier() {
            return this.clientApp.dvRenderer.getMaskModifier();
        }

        @Override
        public ProjectionCalibrator getProjectionCalibrator() {
            return this.clientApp.dvRenderer.getProjectionCalibrator();
        }

        @Override
        public void updateLicense(String key) {
            LicenseKey lk = new LicenseKey(key);
            this.clientApp.updateLicense(lk);
        }

        @Override
        public String getLicenseKey() {
            return this.clientApp.getLicense().toLicenseKeyString();
        }

        @Override
        public UUID getLocalSessionID() {
            return this.clientApp.hyveApplication.getLocalSessionId();
        }

        @Override
        public String getLocalSpaceName() {
            return this.clientApp.hyveApplication.getLocalHyve().getLocalSpaceName();
        }

        @Override
        public void setLocalSpaceName(String name) {
            this.clientApp.hyveApplication.getLocalHyve().setLocalSpaceName(name);
        }

        @Override
        public void joinSession(UUID id) {
            this.clientApp.hyveApplication.joinSession(id);
        }

        @Override
        public void visualizeSession(UUID id) {
            this.clientApp.hyveApplication.visualizeSession(id);
        }

        @Override
        public void synchSession(UUID id) {
            this.clientApp.hyveApplication.synchSession(id);
        }

        @Override
        public void shareSession(UUID id, boolean mustbeconnected) {
            this.clientApp.hyveApplication.getNetworking().shareSession(id, mustbeconnected);
        }

        @Override
        public void disconnectFromHubNode(HyveNetworking.ConnectionEstablishListener l) {
            this.clientApp.hyveApplication.getNetworking().disconnectFromHubNode(l);
        }

        @Override
        public void closeHost(HyveNetworking.HostingEstablishListener l) {
            this.clientApp.hyveApplication.getNetworking().closeHost(l);
        }

        @Override
        public void asynchConnectToHubNode(String host, int port, HyveNetworking.ConnectionEstablishListener connectionEstablishListener) {
            this.clientApp.hyveApplication.getNetworking().asynchConnectToHubNode(host, port, connectionEstablishListener);
        }

        @Override
        public void createHost(int port, HyveNetworking.HostingEstablishListener listener) {
            this.clientApp.hyveApplication.getNetworking().createHost(port, listener);
        }

        @Override
        public void receiveTerminalStringCommand(String terminalCommandString, TerminalConversation conversation) {
            if (terminalCommandString.startsWith("ic ")) {
                this.clientApp.networkingUIControlTerminalAdapter.receiveTerminalStringCommand(terminalCommandString, conversation);
            } else if (terminalCommandString.startsWith("scenectrl ")) {
                this.clientApp.sceneController.receiveTerminalStringCommand(terminalCommandString, conversation);
            } else if (terminalCommandString.startsWith("make selection unselectable")) {
                Hyve hyve = this.clientApp.hyveApplication.getLocalHyve();
                Session s = hyve.currentSession();
                Set<Asset> assets = s.getAllAssets();
                Set<Stroke> strokes = s.getAllStrokes();
                ArrayList<UUID> changedAssetsOrStrokes = new ArrayList<UUID>();
                for (Asset a : assets) {
                    if (!a.getSelected()) continue;
                    changedAssetsOrStrokes.add(a.getId());
                    a.setIsSelectable(false);
                }
                for (Stroke str : strokes) {
                    if (!str.getSelected()) continue;
                    changedAssetsOrStrokes.add(str.getId());
                    str.setIsSelectable(false);
                }
                if (changedAssetsOrStrokes.size() > 0) {
                    this.lastChangedAssets = changedAssetsOrStrokes;
                    conversation.reply("unselectable property has been changed for current selection");
                } else {
                    conversation.reply("unselectable property not changed because there was no selection");
                }
            } else if (terminalCommandString.startsWith("undo last unselectable command")) {
                if (this.lastChangedAssets != null && this.lastChangedAssets.size() > 0) {
                    Hyve hyve = this.clientApp.hyveApplication.getLocalHyve();
                    Session s = hyve.currentSession();
                    Set<Asset> assets = s.getAllAssets();
                    Set<HyveData> data = s.getWithIDs(new HashSet<UUID>(this.lastChangedAssets));
                    for (HyveData d : data) {
                        if (d instanceof Asset) {
                            Asset a = (Asset)d;
                            a.setIsSelectable(true);
                            continue;
                        }
                        if (!(d instanceof Stroke)) continue;
                        Stroke stroke = (Stroke)d;
                        stroke.setIsSelectable(true);
                    }
                }
                conversation.reply("last unselectable action has been undone");
            } else if (terminalCommandString.startsWith("communicationlight")) {
                boolean on = terminalCommandString.endsWith("on");
                this.setEllipseColor(on ? NinaConfiguration.CalibrationColor : ColorRGBA.Black);
                conversation.reply("communicationlight is " + (on ? "on" : "off"));
            } else if (terminalCommandString.startsWith("inertianavigation")) {
                boolean on = terminalCommandString.endsWith("on");
                this.setInertiaNavigationEnabled(on);
                conversation.reply("inertianavigation is " + (on ? "on" : "off"));
            } else if (terminalCommandString.startsWith("controlremotenavigation")) {
                boolean on = terminalCommandString.endsWith("on");
                this.synchronizeHyvePositions(on);
                conversation.reply("controlremotenavigation is " + (on ? "on" : "off"));
            } else if (terminalCommandString.startsWith("snapduringhinge")) {
                boolean on = terminalCommandString.endsWith("on");
                this.setSnapDuringHinge(on);
                conversation.reply("snapduringhinge is " + (on ? "on" : "off"));
            } else if (terminalCommandString.equals("resetnavigationtoorigin")) {
                this.resetNavigation();
            } else if (terminalCommandString.equals("eraseall")) {
                this.eraseAll();
            } else {
                switch (terminalCommandString) {
                    case "X": {
                        conversation.reply("Y");
                    }
                }
            }
        }

        @Override
        public void receiveTerminalStringResponse(String terminalCommandResponseString, TerminalConversation conversation) {
            System.out.println("HyveClientApplication receiveTerminalStringResponse:\n" + terminalCommandResponseString);
        }

        @Override
        public String toggleBackGround(String background) {
            String label = this.clientApp.hyveApplication.toggleBackGround(background);
            return label;
        }

        @Override
        public void setDisplayFps(boolean b) {
            clientApp.setDisplayFps(b);
        }

        @Override
        public void setDisplayStatView(boolean b) {
            clientApp.setDisplayStatView(b);
        }

        @Override
        public void setupAutoExportTimer(boolean enabled) {
        }

        @Override
        public void setupSketchLog(boolean enabled) {
        }

        @Override
        public void importLocalFile(String dir, String filename, FileTypes ft, String options) {
            this.clientApp.callSafe(() -> {
                LocalFileScene storage = new LocalFileScene();
                storage.filename = filename;
                storage.directory = dir;
                this.clientApp.hyveApplication.importFile(storage, ft, options);
                return null;
            });
        }

        @Override
        public void saveToLocalFile(String directory, String filename) {
            this.clientApp.callSafe(() -> {
                LocalFileScene storage = new LocalFileScene();
                storage.filename = filename;
                storage.directory = directory;
                this.clientApp.hyveApplication.saveFile(storage);
                return null;
            });
        }

        @Override
        public boolean isAutoExportEnabled() {
            return false;
        }

        @Override
        public boolean isSketchLogEnabled() {
            return false;
        }

        @Override
        public void openLocalFile(String dir, String filename, FileTypes type) {
            System.out.println("openLocalFile(dir='" + dir + "', filename='" + filename + "', type='" + type.toString() + "')");
            this.clientApp.callSafe(() -> {
                LocalFileScene storage = new LocalFileScene();
                storage.filename = filename;
                storage.directory = dir;
                this.clientApp.hyveApplication.openFile(storage, type);
                return null;
            });
        }

        @Override
        public void clearSky() {
            this.clientApp.hyveApplication.getLocalHyve().clearSkyInCurrentSession();
        }

        @Override
        public List<File> scanSkyFiles() {
            return null;
        }

        @Override
        public void eraseAll() {
            this.clientApp.hyveApplication.eraseAll();
            this.clientApp.appControlServer.sendToAllClients(SimpleCommandWithStringArgumentMessage.createWith(CommandCode.TerminalStringResponse, "eraseall has been performed"));
        }

        @Override
        public void setOnlyUseTCP(boolean onlyusetcp) {
            this.clientApp.hyveApplication.getNetworking().getHubNode().setUseUDP(!onlyusetcp);
        }

        @Override
        public void resetNavigation() {
            Space sp = this.clientApp.hyveApplication.getLocalHyve().getLocalSpace();
            sp.resetTransformationToDefault();
        }

        @Override
        public void synchronizeHyvePositions(boolean b) {
            this.clientApp.hyveApplication.setSynchronizeHyvePositions(b);
        }

        @Override
        public void setFullscreen(boolean b) {
            if (!b) {
                this.clientApp.cancelFullScreen();
            }
        }

        @Override
        public ImmersionMode getMode() {
            return this.clientApp.dvRenderer.getImmersionMode();
        }

        @Override
        public void enableNonImmersiveMode() {
            this.clientApp.dvRenderer.enableNonImmersiveMode();
        }

        @Override
        public void enableImmersiveMode() {
            this.clientApp.dvRenderer.enableImmersiveMode();
        }

        @Override
        public boolean getFullScreen() {
            return false;
        }

        @Override
        public boolean isInertiaNavigationEnabled() {
            return GlobalSettings.InertiaNavigationEnabled;
        }

        @Override
        public void setInertiaNavigationEnabled(boolean b) {
            GlobalSettings.InertiaNavigationEnabled = b;
        }

        @Override
        public boolean getSnapDuringHinge() {
            return GlobalSettings.SnapDuringHinge;
        }

        @Override
        public void setSnapDuringHinge(boolean selected) {
            GlobalSettings.SnapDuringHinge = selected;
        }
    }

    private class MenuUndoRedoAdapter
    implements HistoryController,
    CommandHistory.StateListener {
        private CommandHistory history;

        public MenuUndoRedoAdapter() {
            this.onStateChanged(false, false);
        }

        public void undo() {
            if (this.history != null) {
                this.history.undo();
            }
        }

        public void redo() {
            if (this.history != null) {
                this.history.redo();
            }
        }

        @Override
        public void connect(CommandHistory history) {
            if (history == null) {
                if (this.history != null) {
                    this.history.removeStateListener(this);
                }
                this.history = null;
                this.onStateChanged(false, false);
            } else {
                this.history = history;
                this.history.addStateListener(this);
            }
        }

        @Override
        public void onStateChanged(boolean hasUndos, boolean hasRedos) {
        }

        @Override
        public void onInfoAvailable(String undoInfo, String redoInfo) {
        }
    }

    public class UDPHelloSender {
        private static DatagramSocket socket;
        private static InetAddress address;
        private static int port;
        private static byte[] buf;
        private static String message;

        public static void sendHello() {
            try {
                socket = new DatagramSocket();
                address = InetAddress.getByName("127.0.0.1");
            }
            catch (SocketException e) {
                e.printStackTrace();
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
            buf = message.getBytes();
            DatagramPacket packet = new DatagramPacket(buf, buf.length, address, port);
            try {
                System.out.println("sending with udp to " + address.getHostAddress() + ":" + port + " --> " + message);
                socket.send(packet);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            socket.close();
        }

        static {
            port = 65432;
            message = "Please please connect to me now!";
        }
    }
}

