/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyveclient;

import com.hybridlab.hyve3d.applicationcontrol.TerminalConversation;
import com.hybridlab.hyve3d.hyve.DrawingAreaDirectionAdapter;
import com.hybridlab.hyve3d.hyve.Hyve;
import com.hybridlab.hyve3d.rendering.Jme3HyveSceneManager;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;

public class SceneController {
    private Jme3HyveSceneManager sceneManager;
    private Hyve localHyve;
    private LightRemoteControl light_RC_dir1;
    private LightRemoteControl light_RC_dir2;

    public void connectHyve(Hyve localHyve) {
        this.localHyve = localHyve;
    }

    public void setSceneManager(Jme3HyveSceneManager sceneManager) {
        this.sceneManager = sceneManager;
        Jme3HyveSceneManager.LightAdapter la_d1 = sceneManager.getDirectional1();
        Jme3HyveSceneManager.LightAdapter la_d2 = sceneManager.getDirectional2();
        Jme3HyveSceneManager.LightAdapter la_am = sceneManager.getAmbient();
        this.light_RC_dir1 = new LightRemoteControl(sceneManager.getDirectional1(), "dl1");
        this.light_RC_dir2 = new LightRemoteControl(sceneManager.getDirectional2(), "dl2");
    }

    private SceneControllerDirectionObserver connectDrawingAreaDirectionObserver(Jme3HyveSceneManager.LightAdapter la, LightRemoteControl b) {
        SceneControllerDirectionObserver diro = new SceneControllerDirectionObserver(la, b);
        this.localHyve.registerDrawingAreaDirectionObserver(diro);
        return diro;
    }

    public void receiveTerminalStringCommand(String terminalCommandString, TerminalConversation conversation) {
        if (terminalCommandString.startsWith("scenectrl al ")) {
            String lightcmd = terminalCommandString.substring("scenectrl al ".length());
            switch (lightcmd.trim()) {
                case "on": {
                    this.sceneManager.getAmbient().setEnabled(true);
                    conversation.reply("scenectrl al is on");
                    break;
                }
                case "off": {
                    this.sceneManager.getAmbient().setEnabled(false);
                    conversation.reply("scenectrl al is off");
                    break;
                }
                case "color=red": {
                    this.sceneManager.getAmbient().setColor(ColorRGBA.Red);
                    conversation.reply("scenectrl al color is red");
                    break;
                }
                case "resetcolor": {
                    this.sceneManager.getAmbient().setColor(ColorRGBA.White);
                    conversation.reply("scenectrl al color is white");
                    break;
                }
            }
        } else if (terminalCommandString.startsWith("scenectrl light ")) {
            String lightcmd = terminalCommandString.substring("scenectrl light ".length());
            switch (lightcmd.trim()) {
                case "status all": {
                    conversation.reply("scenectrl light directional 1 is " + (this.sceneManager.getDirectional1().getEnabled() ? "on" : "off"));
                    conversation.reply("scenectrl light directional 2 is " + (this.sceneManager.getDirectional2().getEnabled() ? "on" : "off"));
                    conversation.reply("scenectrl light ambient is " + (this.sceneManager.getAmbient().getEnabled() ? "on" : "off"));
                    break;
                }
                case "directional 1 on": {
                    this.sceneManager.getDirectional1().setEnabled(true);
                    conversation.reply("scenectrl light directional 1 is on");
                    break;
                }
                case "directional 1 off": {
                    this.sceneManager.getDirectional1().setEnabled(false);
                    conversation.reply("scenectrl light directional 1 is off");
                    break;
                }
                case "directional 2 on": {
                    this.sceneManager.getDirectional2().setEnabled(true);
                    conversation.reply("scenectrl light directional 2 is on");
                    break;
                }
                case "directional 2 off": {
                    this.sceneManager.getDirectional2().setEnabled(false);
                    conversation.reply("scenectrl light directional 2 is off");
                    break;
                }
                case "request-connect-dl1": {
                    this.light_RC_dir1.request(conversation);
                    conversation.reply("scenectrl light waiting-to-connect-dl1");
                    break;
                }
                case "request-connect-dl2": {
                    this.light_RC_dir2.request(conversation);
                    conversation.reply("scenectrl light waiting-to-connect-dl2");
                    break;
                }
                case "cancel-connect-dl1": {
                    this.light_RC_dir1.cancel();
                    conversation.reply("scenectrl light canceled-to-connect-dl1");
                    break;
                }
                case "cancel-connect-dl2": {
                    this.light_RC_dir2.cancel();
                    conversation.reply("scenectrl light canceled-to-connect-dl2");
                    break;
                }
                case "disconnect-dl1": {
                    this.light_RC_dir1.disconnect();
                    conversation.reply("scenectrl light disconnected-dl1");
                    break;
                }
                case "disconnect-dl2": {
                    this.light_RC_dir2.disconnect();
                    conversation.reply("scenectrl light disconnected-dl2");
                    break;
                }
            }
        }
    }

    private class LightRemoteControl {
        private final String identifier;
        private TerminalConversation conversation;
        private Jme3HyveSceneManager.LightAdapter light;
        private SceneControllerDirectionObserver diro;

        public LightRemoteControl(Jme3HyveSceneManager.LightAdapter light, String identifier) {
            this.identifier = identifier;
            this.light = light;
        }

        private void request(TerminalConversation conversation) {
            this.conversation = conversation;
            this.diro = SceneController.this.connectDrawingAreaDirectionObserver(this.light, this);
        }

        public void cancel() {
            this.diro = null;
        }

        public void disconnect() {
            this.diro.cancelFromButton();
        }

        private void onConnect() {
            if (this.conversation != null) {
                this.conversation.reply("scenectrl light connected-" + this.identifier);
            } else {
                System.out.println("LightRemoteControl::onConnect - this.conversation was null");
            }
        }
    }

    private class SceneControllerDirectionObserver
    implements DrawingAreaDirectionAdapter.DirectionObserver {
        private DrawingAreaDirectionAdapter adapter;
        private Jme3HyveSceneManager.LightAdapter la;
        private LightRemoteControl lightRemoteControl;

        public SceneControllerDirectionObserver(Jme3HyveSceneManager.LightAdapter la, LightRemoteControl lrc) {
            this.la = la;
            this.lightRemoteControl = lrc;
        }

        @Override
        public void onDirectionChange(Vector3f newDirection) {
            this.la.setDirection(newDirection);
        }

        @Override
        public void connect(DrawingAreaDirectionAdapter adapter) {
            this.adapter = adapter;
            this.adapter.addObserver(this);
            this.la.setDirection(adapter.getDirection());
            this.lightRemoteControl.onConnect();
        }

        @Override
        public void cancel() {
            this.lightRemoteControl.cancel();
        }

        public void cancelFromButton() {
            if (this.adapter != null) {
                this.adapter.destroy();
            }
        }
    }
}

