/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyveclient.SimpleAppControl;

import com.hybridlab.hyve3d.applicationcontrol.TerminalConversation;
import com.hybridlab.hyve3d.core.HisSphericalRendererApplication;
import com.hybridlab.hyve3d.hyve.FileTypes;
import com.hybridlab.hyve3d.hyve.HyveNetworking;
import com.hybridlab.hyve3d.network.interconnection.HubConnection;
import com.hybridlab.hyve3d.network.interconnection.HubNodeHost;
import com.hybridlab.hyve3d.network.interconnection.implementations.adressing.HubNodeAddress;
import com.hybridlab.hyve3d.network.transport.appCtrl.AppCtrlClientConnectionListener;
import com.hybridlab.hyve3d.network.transport.appCtrl.AppCtrlMessageTransportConnection;
import com.hybridlab.hyve3d.network.transport.appCtrl.AppCtrlTCPSocketConnection;
import com.hybridlab.hyve3d.network.transport.appCtrl.AppCtrl_MessageTranslator;
import com.hybridlab.hyve3d.network.transport.fab8.FAB8BasedSatelliteServer;
import com.hybridlab.hyve3d.nina.Jme3DualViewPortRenderer;
import com.hybridlab.hyve3d.rendering.spherical.ProjectionCalibrator;
import com.hybridlab.hyveclient.HyveClientApplication;
import com.hybridlab.hyveclient.SimpleAppControl.AppControlServerMessageAdapter;
import com.hybridlab.hyveclient.SimpleAppControl.AppControlWelcomeMessage;
import com.hybridlab.hyveclient.SimpleAppControl.AppCtrlServer;
import com.hybridlab.hyveclient.SimpleAppControl.CommandCode;
import com.hybridlab.hyveclient.SimpleAppControl.FileMessage;
import com.hybridlab.hyveclient.SimpleAppControl.SimpleColorRGBAMessage;
import com.hybridlab.hyveclient.SimpleAppControl.SimpleCommandMessage;
import com.hybridlab.hyveclient.SimpleAppControl.SimpleCommandWithFloatAndBooleanArgumentMessage;
import com.hybridlab.hyveclient.SimpleAppControl.SimpleCommandWithFloatArgumentMessage;
import com.hybridlab.hyveclient.SimpleAppControl.SimpleCommandWithIntegerArgumentsMessage;
import com.hybridlab.hyveclient.SimpleAppControl.SimpleCommandWithStringAndBooleanArgumentMessage;
import com.hybridlab.hyveclient.SimpleAppControl.SimpleCommandWithStringAndIntegerArgumentMessage;
import com.hybridlab.hyveclient.SimpleAppControl.SimpleCommandWithStringArgumentMessage;
import com.jme3.network.AbstractMessage;
import com.jme3.network.Message;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class PlainTcpAppCtrlServer
implements AppCtrlServer {
    public static final int DEFAULT_APP_CTRL_SERVER_PORT = 4711;
    private int port = 4711;
    final ExecutorService pool;
    ServerSocket serverSocket;
    private boolean running = false;
    private Logger logger = Logger.getLogger(PlainTcpAppCtrlServer.class.getName());
    private AppControlServerMessageAdapter adapter;
    private List<AppCtrlTCPSocketConnection> clients = new ArrayList<AppCtrlTCPSocketConnection>();

    public PlainTcpAppCtrlServer() {
        this.pool = Executors.newCachedThreadPool();
    }

    @Override
    public void connectAdapter(AppControlServerMessageAdapter adapter) {
        this.adapter = adapter;
    }

    @Override
    public void send(Message msg) {
        if (this.running) {
            // empty if block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendToAllClients(AbstractMessage msg) {
        if (this.running) {
            List<AppCtrlTCPSocketConnection> list = this.clients;
            synchronized (list) {
                for (AppCtrlTCPSocketConnection c : this.clients) {
                    try {
                        c.send(msg);
                    }
                    catch (AppCtrlMessageTransportConnection.SendFailedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public void stop() {
        this.running = false;
        this.pool.shutdown();
        try {
            this.pool.awaitTermination(2L, TimeUnit.SECONDS);
            if (!this.serverSocket.isClosed()) {
                System.out.println("ServerSocket close");
                this.serverSocket.close();
            }
        }
        catch (IOException iOException) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void start() {
        try {
            this.logger.info(String.format("Start %s at port %d", FAB8BasedSatelliteServer.class.getSimpleName(), this.port));
            this.startListeningForAppCtrlConnections();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, null, e);
        }
    }

    private void startListeningForAppCtrlConnections() throws IOException {
        this.serverSocket = new ServerSocket(this.port);
        AppCtrlSessionFactory f8sf = new AppCtrlSessionFactory(this.pool, this.serverSocket);
        Thread t1 = new Thread((Runnable)f8sf, f8sf.getClass().getSimpleName() + " " + String.valueOf(f8sf.hashCode()));
        this.logger.log(Level.INFO, "start " + PlainTcpAppCtrlServer.class.getSimpleName() + " | Port: " + String.valueOf(this.port) + " Thread: " + Thread.currentThread());
        this.running = true;
        t1.start();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                System.out.println("Strg+C, pool.shutdown");
                PlainTcpAppCtrlServer.this.stop();
            }
        });
    }

    class AppCtrlSessionFactory
    implements Runnable {
        private final ServerSocket serverSocket;
        private final ExecutorService pool;

        public AppCtrlSessionFactory(ExecutorService pool, ServerSocket serverSocket) {
            this.serverSocket = serverSocket;
            this.pool = pool;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                try {
                    while (true) {
                        Socket clientSocket = this.serverSocket.accept();
                        MyAppCtrlClientConnectionListener appCtrlClientConnectionListener = new MyAppCtrlClientConnectionListener();
                        AppCtrlTCPSocketConnection conn = new AppCtrlTCPSocketConnection(this.serverSocket, clientSocket, appCtrlClientConnectionListener, new AppCtrl_MessageTranslator());
                        this.pool.execute(conn);
                    }
                }
                catch (IOException ex) {
                    PlainTcpAppCtrlServer.this.logger.log(Level.SEVERE, "--- Interrupt NetworkService-run");
                    PlainTcpAppCtrlServer.this.logger.log(Level.INFO, "--- Ende NetworkService(pool.shutdown)");
                    this.pool.shutdown();
                    try {
                        this.pool.awaitTermination(2L, TimeUnit.SECONDS);
                        if (!this.serverSocket.isClosed()) {
                            PlainTcpAppCtrlServer.this.logger.log(Level.INFO, "--- Ende NetworkService:ServerSocket close");
                            this.serverSocket.close();
                        }
                    }
                    catch (IOException e) {
                        PlainTcpAppCtrlServer.this.logger.log(Level.SEVERE, "IOException while closing pool: " + e.getMessage());
                    }
                    catch (InterruptedException ei) {
                        PlainTcpAppCtrlServer.this.logger.log(Level.SEVERE, "InterruptedException while closing pool: " + ei.getMessage());
                    }
                }
            }
            catch (Throwable throwable) {
                PlainTcpAppCtrlServer.this.logger.log(Level.INFO, "--- Ende NetworkService(pool.shutdown)");
                this.pool.shutdown();
                try {
                    this.pool.awaitTermination(2L, TimeUnit.SECONDS);
                    if (!this.serverSocket.isClosed()) {
                        PlainTcpAppCtrlServer.this.logger.log(Level.INFO, "--- Ende NetworkService:ServerSocket close");
                        this.serverSocket.close();
                    }
                }
                catch (IOException e) {
                    PlainTcpAppCtrlServer.this.logger.log(Level.SEVERE, "IOException while closing pool: " + e.getMessage());
                }
                catch (InterruptedException ei) {
                    PlainTcpAppCtrlServer.this.logger.log(Level.SEVERE, "InterruptedException while closing pool: " + ei.getMessage());
                }
                throw throwable;
            }
        }
    }

    class MyAppCtrlClientConnectionListener
    implements AppCtrlClientConnectionListener {
        MyAppCtrlClientConnectionListener() {
        }

        private void trySend(AppCtrlTCPSocketConnection connection, AbstractMessage message) {
            try {
                connection.send(message);
            }
            catch (AppCtrlMessageTransportConnection.SendFailedException e) {
                e.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onConnectionLost(AppCtrlTCPSocketConnection appCtrlTCPSocketConnection) {
            PlainTcpAppCtrlServer.this.logger.info(appCtrlTCPSocketConnection.toString());
            List<AppCtrlTCPSocketConnection> list = PlainTcpAppCtrlServer.this.clients;
            synchronized (list) {
                PlainTcpAppCtrlServer.this.clients.remove(appCtrlTCPSocketConnection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onConnectionEstablished(AppCtrlTCPSocketConnection appCtrlTCPSocketConnection) {
            PlainTcpAppCtrlServer.this.logger.info(appCtrlTCPSocketConnection.toString());
            List<AppCtrlTCPSocketConnection> list = PlainTcpAppCtrlServer.this.clients;
            synchronized (list) {
                PlainTcpAppCtrlServer.this.clients.add(appCtrlTCPSocketConnection);
            }
            try {
                AppControlWelcomeMessage wm = new AppControlWelcomeMessage();
                wm.immersionMode = PlainTcpAppCtrlServer.this.adapter.getMode().toString();
                wm.autoExport = PlainTcpAppCtrlServer.this.adapter.isAutoExportEnabled();
                wm.background = "";
                wm.fullscreen = PlainTcpAppCtrlServer.this.adapter.getFullScreen();
                wm.sketchLog = PlainTcpAppCtrlServer.this.adapter.isSketchLogEnabled();
                wm.snapDuringHinge = PlainTcpAppCtrlServer.this.adapter.getSnapDuringHinge();
                Jme3DualViewPortRenderer.MaskModifier mm = PlainTcpAppCtrlServer.this.adapter.getMaskModifier();
                wm.ellipsePosition = mm.getEllipsePosition();
                wm.ellipseWidth = mm.getEllipseWidth();
                wm.ellipseHeight = mm.getEllipseHeight();
                wm.maskColorIsBlack = mm.colorIsBlack();
                wm.ringColorIsBlack = mm.ringColorIsBlack();
                wm.maskColorIsCalibrationColor = mm.colorIsCalibrationColor();
                wm.ringColorIsCalibrationColor = mm.ringColorIsCalibrationColor();
                wm.ringRadius = mm.getRingRadius();
                wm.ringMaskVisibility = mm.getRingMaskVisibility();
                wm.maskVisibility = mm.getMaskVisibility();
                wm.shiftHorizontal = mm.getShiftHorizontal();
                wm.shiftVertical = mm.getShiftVertical();
                ProjectionCalibrator pc = PlainTcpAppCtrlServer.this.adapter.getProjectionCalibrator();
                wm.cameraDistance = pc.getCameraDistance();
                wm.sphereScale = pc.getSphereScale();
                wm.viewPortRadius = pc.getViewPortRadius();
                wm.spherecameraFieldOfViewAngleAlongYInDegrees = pc.getSpherecameraFieldOfViewAngleAlongYInDegrees();
                wm.isFOVconnectedToDistance = pc.isFOVconnectedToDistance();
                wm.licenseKey = PlainTcpAppCtrlServer.this.adapter.getLicenseKey();
                wm.localSessionIDString = PlainTcpAppCtrlServer.this.adapter.getLocalSessionID().toString();
                wm.localSpaceName = PlainTcpAppCtrlServer.this.adapter.getLocalSpaceName();
                String allInfos = AppControlWelcomeMessage.transformToString(wm);
                SimpleCommandWithStringArgumentMessage termMessage = SimpleCommandWithStringArgumentMessage.createWith(CommandCode.TerminalStringCommand, allInfos);
                appCtrlTCPSocketConnection.send(termMessage);
                String afp = "assetsfolderpath " + HyveClientApplication.executablePath + "/Contents/Resources/Java/hyveassets/";
                appCtrlTCPSocketConnection.send(SimpleCommandWithStringArgumentMessage.createWith(CommandCode.TerminalStringCommand, afp));
                appCtrlTCPSocketConnection.send(SimpleCommandWithStringArgumentMessage.createWith(CommandCode.TerminalStringCommand, "license request"));
            }
            catch (AppCtrlMessageTransportConnection.SendFailedException e) {
                e.printStackTrace();
            }
        }

        @Override
        public void onAbstractMessageReceived(AbstractMessage message, final AppCtrlTCPSocketConnection source) {
            PlainTcpAppCtrlServer.this.logger.info(message.toString());
            if (message instanceof FileMessage) {
                FileMessage m = (FileMessage)message;
                System.out.println("PlainTcpAppCtrlServer received '" + m.getCommandCode() + "'");
                switch (m.getCommandCode()) {
                    case Open: {
                        PlainTcpAppCtrlServer.this.adapter.openLocalFile(m.getDirectory(), m.getFilename(), m.getType());
                        break;
                    }
                    case Save: {
                        PlainTcpAppCtrlServer.this.adapter.saveToLocalFile(m.getDirectory(), m.getFilename());
                        break;
                    }
                    case Import: {
                        PlainTcpAppCtrlServer.this.adapter.importLocalFile(m.getDirectory(), m.getFilename(), m.getType(), m.getOptionsString());
                        if (!m.getType().equals((Object)FileTypes.DDS_SKY)) break;
                        this.trySend(source, SimpleCommandWithStringArgumentMessage.createWith(CommandCode.ClearSky, StringUtils.remove(m.getFilename(), ".dds")));
                        break;
                    }
                }
            } else if (message instanceof SimpleCommandWithIntegerArgumentsMessage) {
                SimpleCommandWithIntegerArgumentsMessage m = (SimpleCommandWithIntegerArgumentsMessage)message;
                System.out.println("Server received '" + m.getCommandCode() + "' ");
                switch (m.getCommandCode()) {
                    case SendToSecondScreen: {
                        int[] args = m.getArgs();
                        Object s = "";
                        for (int i = 0; i < args.length; ++i) {
                            s = (String)s + " " + args[i] + " ";
                        }
                        System.out.println(" Screen Arguments: " + (String)s);
                        PlainTcpAppCtrlServer.this.adapter.sendToSecondScreen(m.getArgs());
                        String answer = "fullscreen is on";
                        this.trySend(source, SimpleCommandWithStringArgumentMessage.createWith(CommandCode.TerminalStringResponse, answer));
                        break;
                    }
                    case CreateHost: {
                        PlainTcpAppCtrlServer.this.adapter.createHost(m.getArgs()[0], new HyveNetworking.HostingEstablishListener(){

                            @Override
                            public void onHostCreationFailed(Exception e) {
                                System.out.println("onHostCreationFailed " + e.getLocalizedMessage());
                            }

                            @Override
                            public void onHostCreated(HubNodeHost hnh) {
                                System.out.println("onConnectionLost " + hnh);
                            }

                            @Override
                            public void onHostShutdown() {
                                System.out.println("onHostShutdown ");
                            }
                        });
                    }
                }
            } else if (message instanceof SimpleColorRGBAMessage) {
                SimpleColorRGBAMessage m = (SimpleColorRGBAMessage)message;
                System.out.println("Server received '" + m.getCommandCode() + "'");
                switch (m.getCommandCode()) {
                    case EllipseColor: {
                        PlainTcpAppCtrlServer.this.adapter.setEllipseColor(m.getColor());
                        break;
                    }
                    case RingColor: {
                        PlainTcpAppCtrlServer.this.adapter.setRingColor(m.getColor());
                    }
                }
            } else if (message instanceof SimpleCommandWithStringAndBooleanArgumentMessage) {
                SimpleCommandWithStringAndBooleanArgumentMessage m = (SimpleCommandWithStringAndBooleanArgumentMessage)message;
                System.out.println("Server received '" + m.getCommandCode() + "'");
                switch (m.getCommandCode()) {
                    case ShareSession: {
                        UUID id = UUID.fromString(m.getArgumentString());
                        boolean mustbeconnected = m.getBoolean();
                        PlainTcpAppCtrlServer.this.adapter.shareSession(id, mustbeconnected);
                    }
                }
            } else if (message instanceof SimpleCommandWithFloatAndBooleanArgumentMessage) {
                SimpleCommandWithFloatAndBooleanArgumentMessage m = (SimpleCommandWithFloatAndBooleanArgumentMessage)message;
                System.out.println("Server received '" + m.getCommandCode() + "'");
                switch (m.getCommandCode()) {
                    case CameraDistance: {
                        float distance = m.getFloat();
                        boolean correctFOV = m.getBoolean();
                        PlainTcpAppCtrlServer.this.adapter.setCameraDistance(distance, correctFOV);
                        break;
                    }
                    case SpherecameraFieldOfViewAngleAlongYInDegrees: {
                        boolean correctDistance = m.getBoolean();
                        float fov = m.getFloat();
                        PlainTcpAppCtrlServer.this.adapter.setSpherecameraFieldOfViewAngleAlongYInDegrees(fov, correctDistance);
                    }
                }
            } else if (message instanceof SimpleCommandWithFloatArgumentMessage) {
                SimpleCommandWithFloatArgumentMessage m = (SimpleCommandWithFloatArgumentMessage)message;
                System.out.println("Server received '" + m.getCommandCode() + "'");
                switch (m.getCommandCode()) {
                    case CameraDistance: 
                    case SpherecameraFieldOfViewAngleAlongYInDegrees: 
                    case RingRadius: 
                    case EllipseWidth: 
                    case EllipseHeight: 
                    case EllipsePosition: 
                    case EllipseBlend: 
                    case ShiftVertical: 
                    case ShiftHorizontal: 
                    case ChangeSpherecamDistance: 
                    case ChangeSpherecamScale: 
                    case SphereScale: 
                    case ChangeSpherecamViewPortRadius: 
                    case ViewPortRadius: {
                        PlainTcpAppCtrlServer.this.adapter.handleFloatCommand(m.getCommandCode(), m.getFloat());
                    }
                }
            } else if (message instanceof SimpleCommandWithStringAndIntegerArgumentMessage) {
                SimpleCommandWithStringAndIntegerArgumentMessage m = (SimpleCommandWithStringAndIntegerArgumentMessage)message;
                System.out.println("Server received '" + m.getCommandCode() + "'");
                switch (m.getCommandCode()) {
                    case AsynchConnectToHubNode: {
                        int port = m.getInteger();
                        String host = m.getString();
                        PlainTcpAppCtrlServer.this.adapter.asynchConnectToHubNode(host, port, new HyveNetworking.ConnectionEstablishListener(){

                            @Override
                            public void onConnectionFailed(String message, String targetNodeInfo) {
                                System.out.println("onConnectionFailed " + message + " " + targetNodeInfo);
                            }

                            @Override
                            public void onConnectionEstablished(HubNodeAddress targetHubNodeAdress) {
                                System.out.println("onConnectionLost " + targetHubNodeAdress);
                            }

                            @Override
                            public void onConnectionLost(HubConnection removed) {
                                System.out.println("onConnectionLost " + removed);
                            }
                        });
                    }
                }
            } else if (message instanceof SimpleCommandWithStringArgumentMessage) {
                SimpleCommandWithStringArgumentMessage m = (SimpleCommandWithStringArgumentMessage)message;
                System.out.println("Server received '" + m.getCommandCode() + "'\n" + m.getCommandString() + "(" + m.getCommandCodeNumber() + ")\n" + m.getArgumentString());
                switch (m.getCommandCode()) {
                    case TerminalStringCommand: {
                        TerminalConversation conversation = new TerminalConversation();
                        conversation.prepareReplyPossibility(new TerminalConversation.TerminalReplyPossibility(){

                            @Override
                            public void reply(String answer) {
                                MyAppCtrlClientConnectionListener.this.trySend(source, SimpleCommandWithStringArgumentMessage.createWith(CommandCode.TerminalStringResponse, answer));
                            }
                        });
                        PlainTcpAppCtrlServer.this.adapter.receiveTerminalStringCommand(m.getArgumentString(), conversation);
                        break;
                    }
                    case TerminalStringResponse: {
                        TerminalConversation conversation = null;
                        PlainTcpAppCtrlServer.this.adapter.receiveTerminalStringResponse(m.getArgumentString(), conversation);
                        break;
                    }
                    case ToggleBackground: {
                        String newLabel = PlainTcpAppCtrlServer.this.adapter.toggleBackGround(m.getArgumentString());
                        this.trySend(source, SimpleCommandWithStringArgumentMessage.createWith(CommandCode.ToggleBackground, newLabel));
                        break;
                    }
                    case License: {
                        PlainTcpAppCtrlServer.this.adapter.updateLicense(m.getArgumentString());
                        break;
                    }
                    case LocalSpaceName: {
                        PlainTcpAppCtrlServer.this.adapter.setLocalSpaceName(m.getArgumentString());
                        break;
                    }
                    case JoinSession: {
                        UUID id = UUID.fromString(m.getArgumentString());
                        PlainTcpAppCtrlServer.this.adapter.joinSession(id);
                        break;
                    }
                    case VisualizeSession: {
                        UUID id = UUID.fromString(m.getArgumentString());
                        PlainTcpAppCtrlServer.this.adapter.visualizeSession(id);
                        break;
                    }
                    case SynchSession: {
                        UUID id = UUID.fromString(m.getArgumentString());
                        PlainTcpAppCtrlServer.this.adapter.synchSession(id);
                    }
                }
            } else if (message instanceof SimpleCommandMessage) {
                SimpleCommandMessage m = (SimpleCommandMessage)message;
                System.out.println("Server received '" + m.getCommandCode() + "'");
                switch (m.getCommandCode()) {
                    case RequestFrameRate: {
                        float fr = PlainTcpAppCtrlServer.this.adapter.getFrameRate();
                        SimpleCommandWithStringArgumentMessage frm = SimpleCommandWithStringArgumentMessage.createWith(CommandCode.RequestFrameRate, String.valueOf(fr));
                        this.trySend(source, frm);
                        break;
                    }
                    case Quit: {
                        PlainTcpAppCtrlServer.this.adapter.closeApplicationGraceFully();
                        break;
                    }
                    case Shoot: {
                        PlainTcpAppCtrlServer.this.adapter.shoot();
                        break;
                    }
                    case ResetNavigation: {
                        PlainTcpAppCtrlServer.this.adapter.resetNavigation();
                        break;
                    }
                    case EraseAll: {
                        PlainTcpAppCtrlServer.this.adapter.eraseAll();
                        break;
                    }
                    case ClearSky: {
                        PlainTcpAppCtrlServer.this.adapter.clearSky();
                        this.trySend(source, SimpleCommandWithStringArgumentMessage.createWith(CommandCode.ClearSky, "none"));
                        break;
                    }
                    case Immersive: {
                        PlainTcpAppCtrlServer.this.adapter.setAppMode(HisSphericalRendererApplication.AppMode.SPHERICAL);
                        break;
                    }
                    case NonImmersive: {
                        PlainTcpAppCtrlServer.this.adapter.setAppMode(HisSphericalRendererApplication.AppMode.FRUSTUM);
                        break;
                    }
                    case EnableHyvePositionSyncronization: {
                        PlainTcpAppCtrlServer.this.adapter.synchronizeHyvePositions(true);
                        break;
                    }
                    case DisableHyvePositionSyncronization: {
                        PlainTcpAppCtrlServer.this.adapter.synchronizeHyvePositions(false);
                        break;
                    }
                    case EnableOnlyTCP: {
                        PlainTcpAppCtrlServer.this.adapter.setOnlyUseTCP(true);
                        break;
                    }
                    case DisbleOnlyTCP: {
                        PlainTcpAppCtrlServer.this.adapter.setOnlyUseTCP(false);
                        break;
                    }
                    case EnableDisplayFps: {
                        PlainTcpAppCtrlServer.this.adapter.setDisplayFps(true);
                        break;
                    }
                    case DisbleDisplayFps: {
                        PlainTcpAppCtrlServer.this.adapter.setDisplayFps(false);
                        break;
                    }
                    case EnableDisplayStats: {
                        PlainTcpAppCtrlServer.this.adapter.setDisplayStatView(true);
                        break;
                    }
                    case DisbleDisplayStats: {
                        PlainTcpAppCtrlServer.this.adapter.setDisplayStatView(false);
                        break;
                    }
                    case EnableAutoExportTimer: {
                        PlainTcpAppCtrlServer.this.adapter.setupAutoExportTimer(true);
                        break;
                    }
                    case DisbleAutoExportTimer: {
                        PlainTcpAppCtrlServer.this.adapter.setupAutoExportTimer(false);
                        break;
                    }
                    case EnableSketchLog: {
                        PlainTcpAppCtrlServer.this.adapter.setupSketchLog(true);
                        break;
                    }
                    case DisbleSketchLog: {
                        PlainTcpAppCtrlServer.this.adapter.setupSketchLog(false);
                        break;
                    }
                    case EnableInertiaNavigation: {
                        PlainTcpAppCtrlServer.this.adapter.setInertiaNavigationEnabled(true);
                        break;
                    }
                    case DisableInertiaNavigation: {
                        PlainTcpAppCtrlServer.this.adapter.setInertiaNavigationEnabled(false);
                        break;
                    }
                    case EnableSnapDuringHinge: {
                        PlainTcpAppCtrlServer.this.adapter.setSnapDuringHinge(true);
                        break;
                    }
                    case DisableSnapDuringHinge: {
                        PlainTcpAppCtrlServer.this.adapter.setSnapDuringHinge(false);
                        break;
                    }
                    case HideRingMask: {
                        PlainTcpAppCtrlServer.this.adapter.setRingMaskVisibility(false);
                        break;
                    }
                    case ShowRingMask: {
                        PlainTcpAppCtrlServer.this.adapter.setRingMaskVisibility(true);
                        break;
                    }
                    case EnableFullscreen: {
                        break;
                    }
                    case DisableFullscreen: {
                        PlainTcpAppCtrlServer.this.adapter.setFullscreen(false);
                        this.trySend(source, SimpleCommandMessage.createWith(CommandCode.DisableFullscreen));
                        break;
                    }
                    case DisconnectFromHubNode: {
                        PlainTcpAppCtrlServer.this.adapter.disconnectFromHubNode(new HyveNetworking.ConnectionEstablishListener(){

                            @Override
                            public void onConnectionFailed(String message, String targetNodeInfo) {
                            }

                            @Override
                            public void onConnectionEstablished(HubNodeAddress targetHubNodeAdress) {
                            }

                            @Override
                            public void onConnectionLost(HubConnection removed) {
                            }
                        });
                        break;
                    }
                    case CloseHost: {
                        PlainTcpAppCtrlServer.this.adapter.closeHost(new HyveNetworking.HostingEstablishListener(){

                            @Override
                            public void onHostCreationFailed(Exception e) {
                            }

                            @Override
                            public void onHostCreated(HubNodeHost hnh) {
                            }

                            @Override
                            public void onHostShutdown() {
                            }
                        });
                    }
                }
            }
        }

        @Override
        public void onMessageReceived(SimpleCommandMessage message, AppCtrlTCPSocketConnection sender) {
            System.out.println("SimpleCommandMessage received" + message.getCommandString());
        }
    }
}

