/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyveclient.SimpleAppControl;

import com.hybridlab.hyve3d.core.HisSphericalRendererApplication;
import com.hybridlab.hyve3d.hyve.HyveNetworking;
import com.hybridlab.hyve3d.network.MessageRegistry;
import com.hybridlab.hyve3d.network.interconnection.HubConnection;
import com.hybridlab.hyve3d.network.interconnection.HubNodeHost;
import com.hybridlab.hyve3d.network.interconnection.implementations.adressing.HubNodeAddress;
import com.hybridlab.hyve3d.nina.Jme3DualViewPortRenderer;
import com.hybridlab.hyve3d.rendering.spherical.ProjectionCalibrator;
import com.hybridlab.hyveclient.SimpleAppControl.AppControlServerMessageAdapter;
import com.hybridlab.hyveclient.SimpleAppControl.AppControlWelcomeMessage;
import com.hybridlab.hyveclient.SimpleAppControl.AppCtrlServer;
import com.hybridlab.hyveclient.SimpleAppControl.CommandCode;
import com.hybridlab.hyveclient.SimpleAppControl.FileMessage;
import com.hybridlab.hyveclient.SimpleAppControl.SimpleColorRGBAMessage;
import com.hybridlab.hyveclient.SimpleAppControl.SimpleCommandMessage;
import com.hybridlab.hyveclient.SimpleAppControl.SimpleCommandWithFloatAndBooleanArgumentMessage;
import com.hybridlab.hyveclient.SimpleAppControl.SimpleCommandWithFloatArgumentMessage;
import com.hybridlab.hyveclient.SimpleAppControl.SimpleCommandWithIntegerArgumentsMessage;
import com.hybridlab.hyveclient.SimpleAppControl.SimpleCommandWithStringAndBooleanArgumentMessage;
import com.hybridlab.hyveclient.SimpleAppControl.SimpleCommandWithStringAndIntegerArgumentMessage;
import com.hybridlab.hyveclient.SimpleAppControl.SimpleCommandWithStringArgumentMessage;
import com.hybridlab.hyveclient.SimpleAppControl.SimpleWelcomeMessage;
import com.jme3.network.AbstractMessage;
import com.jme3.network.ConnectionListener;
import com.jme3.network.HostedConnection;
import com.jme3.network.Message;
import com.jme3.network.MessageListener;
import com.jme3.network.Network;
import com.jme3.network.Server;
import com.jme3.network.service.HostedService;
import com.jme3.network.service.serializer.ServerSerializerRegistrationsService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class SimpleAppCtrlServer
implements ConnectionListener,
AppCtrlServer {
    public static String ServerName = "AppCtrl";
    public static int Version = 1;
    public static int DefaultTCPPort = 4711;
    public static int DefaultUPDPort = 4711;
    private List<HostedConnection> clients = new ArrayList<HostedConnection>(2);
    private Server appCtrlServerInstance;
    private Boolean creationSuccessful = false;
    private AppControlServerMessageAdapter adapter;

    @Override
    public void connectAdapter(AppControlServerMessageAdapter adapter) {
        this.adapter = adapter;
    }

    public SimpleAppCtrlServer() {
        try {
            this.appCtrlServerInstance = Network.createServer((String)ServerName, (int)Version, (int)DefaultTCPPort, (int)DefaultUPDPort);
            this.creationSuccessful = true;
            ServerSerializerRegistrationsService ssr = (ServerSerializerRegistrationsService)this.appCtrlServerInstance.getServices().getService(ServerSerializerRegistrationsService.class);
            this.appCtrlServerInstance.getServices().removeService((HostedService)ssr);
            this.appCtrlServerInstance.addConnectionListener((ConnectionListener)this);
            this.appCtrlServerInstance.addMessageListener((MessageListener)new SimpleServerListener(), new Class[]{SimpleCommandMessage.class, SimpleCommandWithIntegerArgumentsMessage.class, FileMessage.class, SimpleCommandWithFloatArgumentMessage.class, SimpleCommandWithStringArgumentMessage.class, SimpleColorRGBAMessage.class, SimpleCommandWithFloatAndBooleanArgumentMessage.class});
        }
        catch (IOException e) {
            e.printStackTrace();
            this.creationSuccessful = false;
        }
    }

    @Override
    public void send(Message msg) {
        if (this.appCtrlServerInstance.isRunning()) {
            this.appCtrlServerInstance.broadcast(msg);
        }
    }

    @Override
    public void sendToAllClients(AbstractMessage msg) {
    }

    public Boolean isReadyToConnect() {
        return this.creationSuccessful != false && this.appCtrlServerInstance.isRunning();
    }

    public void connectionAdded(Server server, HostedConnection conn) {
        if (server == this.appCtrlServerInstance) {
            this.clients.add(conn);
            SimpleWelcomeMessage m = new SimpleWelcomeMessage("welcome");
            conn.send((Message)m);
            AppControlWelcomeMessage wm = new AppControlWelcomeMessage();
            wm.immersionMode = this.adapter.getMode().toString();
            wm.autoExport = this.adapter.isAutoExportEnabled();
            wm.background = "";
            wm.fullscreen = this.adapter.getFullScreen();
            wm.sketchLog = this.adapter.isSketchLogEnabled();
            wm.snapDuringHinge = this.adapter.getSnapDuringHinge();
            Jme3DualViewPortRenderer.MaskModifier mm = this.adapter.getMaskModifier();
            wm.ellipsePosition = mm.getEllipsePosition();
            wm.ellipseWidth = mm.getEllipseWidth();
            wm.ellipseHeight = mm.getEllipseHeight();
            wm.maskColorIsBlack = mm.colorIsBlack();
            wm.ringColorIsBlack = mm.ringColorIsBlack();
            wm.maskColorIsCalibrationColor = mm.colorIsCalibrationColor();
            wm.ringColorIsCalibrationColor = mm.ringColorIsCalibrationColor();
            wm.ringRadius = mm.getRingRadius();
            wm.ringMaskVisibility = mm.getRingMaskVisibility();
            wm.maskVisibility = mm.getMaskVisibility();
            wm.shiftHorizontal = mm.getShiftHorizontal();
            wm.shiftVertical = mm.getShiftVertical();
            ProjectionCalibrator pc = this.adapter.getProjectionCalibrator();
            wm.cameraDistance = pc.getCameraDistance();
            wm.sphereScale = pc.getSphereScale();
            wm.viewPortRadius = pc.getViewPortRadius();
            wm.spherecameraFieldOfViewAngleAlongYInDegrees = pc.getSpherecameraFieldOfViewAngleAlongYInDegrees();
            wm.isFOVconnectedToDistance = pc.isFOVconnectedToDistance();
            wm.licenseKey = this.adapter.getLicenseKey();
            wm.localSessionIDString = this.adapter.getLocalSessionID().toString();
            wm.localSpaceName = this.adapter.getLocalSpaceName();
            conn.send((Message)wm);
        }
    }

    public void connectionRemoved(Server server, HostedConnection conn) {
        if (server == this.appCtrlServerInstance) {
            this.clients.remove(conn);
        }
    }

    @Override
    public void start() {
        if (!MessageRegistry.isRegistrationDone()) {
            throw new RuntimeException("no messages registered");
        }
        this.appCtrlServerInstance.start();
    }

    private class SimpleServerListener
    implements MessageListener<HostedConnection> {
        private SimpleServerListener() {
        }

        public void messageReceived(HostedConnection source, Message message) {
            if (message instanceof FileMessage) {
                FileMessage m = (FileMessage)message;
                System.out.println("Server received '" + m.getCommandCode() + "' from client #" + source.getId());
                switch (m.getCommandCode()) {
                    case Open: {
                        SimpleAppCtrlServer.this.adapter.openLocalFile(m.getDirectory(), m.getFilename(), m.getType());
                        break;
                    }
                    case Save: {
                        SimpleAppCtrlServer.this.adapter.saveToLocalFile(m.getDirectory(), m.getFilename());
                        break;
                    }
                    case Import: {
                        SimpleAppCtrlServer.this.adapter.importLocalFile(m.getDirectory(), m.getFilename(), m.getType(), m.getOptionsString());
                        break;
                    }
                }
            } else if (message instanceof SimpleCommandWithIntegerArgumentsMessage) {
                SimpleCommandWithIntegerArgumentsMessage m = (SimpleCommandWithIntegerArgumentsMessage)message;
                System.out.println("Server received '" + m.getCommandCode() + "' from client #" + source.getId());
                switch (m.getCommandCode()) {
                    case SendToSecondScreen: {
                        SimpleAppCtrlServer.this.adapter.sendToSecondScreen(m.getArgs());
                        break;
                    }
                    case CreateHost: {
                        SimpleAppCtrlServer.this.adapter.createHost(m.getArgs()[0], new HyveNetworking.HostingEstablishListener(){

                            @Override
                            public void onHostCreationFailed(Exception e) {
                                System.out.println("onHostCreationFailed " + e.getLocalizedMessage());
                            }

                            @Override
                            public void onHostCreated(HubNodeHost hnh) {
                                System.out.println("onConnectionLost " + hnh);
                            }

                            @Override
                            public void onHostShutdown() {
                                System.out.println("onHostShutdown ");
                            }
                        });
                    }
                }
            } else if (message instanceof SimpleColorRGBAMessage) {
                SimpleColorRGBAMessage m = (SimpleColorRGBAMessage)message;
                System.out.println("Server received '" + m.getCommandCode() + "' from client #" + source.getId());
                switch (m.getCommandCode()) {
                    case EllipseColor: {
                        SimpleAppCtrlServer.this.adapter.setEllipseColor(m.getColor());
                        break;
                    }
                    case RingColor: {
                        SimpleAppCtrlServer.this.adapter.setRingColor(m.getColor());
                    }
                }
            } else if (message instanceof SimpleCommandWithStringAndBooleanArgumentMessage) {
                SimpleCommandWithStringAndBooleanArgumentMessage m = (SimpleCommandWithStringAndBooleanArgumentMessage)message;
                System.out.println("Server received '" + m.getCommandCode() + "' from client #" + source.getId());
                switch (m.getCommandCode()) {
                    case ShareSession: {
                        UUID id = UUID.fromString(m.getArgumentString());
                        boolean mustbeconnected = m.getBoolean();
                        SimpleAppCtrlServer.this.adapter.shareSession(id, mustbeconnected);
                    }
                }
            } else if (message instanceof SimpleCommandWithFloatAndBooleanArgumentMessage) {
                SimpleCommandWithFloatAndBooleanArgumentMessage m = (SimpleCommandWithFloatAndBooleanArgumentMessage)message;
                System.out.println("Server received '" + m.getCommandCode() + "' from client #" + source.getId());
                switch (m.getCommandCode()) {
                    case CameraDistance: {
                        float distance = m.getFloat();
                        boolean correctFOV = m.getBoolean();
                        SimpleAppCtrlServer.this.adapter.setCameraDistance(distance, correctFOV);
                        break;
                    }
                    case SpherecameraFieldOfViewAngleAlongYInDegrees: {
                        boolean correctDistance = m.getBoolean();
                        float fov = m.getFloat();
                        SimpleAppCtrlServer.this.adapter.setSpherecameraFieldOfViewAngleAlongYInDegrees(fov, correctDistance);
                    }
                }
            } else if (message instanceof SimpleCommandWithFloatArgumentMessage) {
                SimpleCommandWithFloatArgumentMessage m = (SimpleCommandWithFloatArgumentMessage)message;
                System.out.println("Server received '" + m.getCommandCode() + "' from client #" + source.getId());
                switch (m.getCommandCode()) {
                    case CameraDistance: 
                    case SpherecameraFieldOfViewAngleAlongYInDegrees: 
                    case RingRadius: 
                    case EllipseWidth: 
                    case EllipseHeight: 
                    case EllipsePosition: 
                    case EllipseBlend: 
                    case ShiftVertical: 
                    case ShiftHorizontal: 
                    case ChangeSpherecamDistance: 
                    case ChangeSpherecamScale: 
                    case SphereScale: 
                    case ChangeSpherecamViewPortRadius: 
                    case ViewPortRadius: {
                        SimpleAppCtrlServer.this.adapter.handleFloatCommand(m.getCommandCode(), m.getFloat());
                    }
                }
            } else if (message instanceof SimpleCommandWithStringAndIntegerArgumentMessage) {
                SimpleCommandWithStringAndIntegerArgumentMessage m = (SimpleCommandWithStringAndIntegerArgumentMessage)message;
                System.out.println("Server received '" + m.getCommandCode() + "' from client #" + source.getId());
                switch (m.getCommandCode()) {
                    case AsynchConnectToHubNode: {
                        int port = m.getInteger();
                        String host = m.getString();
                        SimpleAppCtrlServer.this.adapter.asynchConnectToHubNode(host, port, new HyveNetworking.ConnectionEstablishListener(){

                            @Override
                            public void onConnectionFailed(String message, String targetNodeInfo) {
                                System.out.println("onConnectionFailed " + message + " " + targetNodeInfo);
                            }

                            @Override
                            public void onConnectionEstablished(HubNodeAddress targetHubNodeAdress) {
                                System.out.println("onConnectionLost " + targetHubNodeAdress);
                            }

                            @Override
                            public void onConnectionLost(HubConnection removed) {
                                System.out.println("onConnectionLost " + removed);
                            }
                        });
                    }
                }
            } else if (message instanceof SimpleCommandWithStringArgumentMessage) {
                SimpleCommandWithStringArgumentMessage m = (SimpleCommandWithStringArgumentMessage)message;
                System.out.println("Server received '" + m.getCommandCode() + "' from client #" + source.getId());
                switch (m.getCommandCode()) {
                    case ToggleBackground: {
                        String newLabel = SimpleAppCtrlServer.this.adapter.toggleBackGround(m.getArgumentString());
                        source.send((Message)SimpleCommandWithStringArgumentMessage.createWith(CommandCode.ToggleBackground, newLabel));
                        break;
                    }
                    case License: {
                        SimpleAppCtrlServer.this.adapter.updateLicense(m.getArgumentString());
                        break;
                    }
                    case LocalSpaceName: {
                        SimpleAppCtrlServer.this.adapter.setLocalSpaceName(m.getArgumentString());
                        break;
                    }
                    case JoinSession: {
                        UUID id = UUID.fromString(m.getArgumentString());
                        SimpleAppCtrlServer.this.adapter.joinSession(id);
                        break;
                    }
                    case VisualizeSession: {
                        UUID id = UUID.fromString(m.getArgumentString());
                        SimpleAppCtrlServer.this.adapter.visualizeSession(id);
                        break;
                    }
                    case SynchSession: {
                        UUID id = UUID.fromString(m.getArgumentString());
                        SimpleAppCtrlServer.this.adapter.synchSession(id);
                    }
                }
            } else if (message instanceof SimpleCommandMessage) {
                SimpleCommandMessage m = (SimpleCommandMessage)message;
                System.out.println("Server received '" + m.getCommandCode() + "' from client #" + source.getId());
                switch (m.getCommandCode()) {
                    case RequestFrameRate: {
                        float fr = SimpleAppCtrlServer.this.adapter.getFrameRate();
                        SimpleCommandWithFloatArgumentMessage frm = SimpleCommandWithFloatArgumentMessage.createWith(CommandCode.RequestFrameRate, fr);
                        source.send((Message)frm);
                        break;
                    }
                    case Quit: {
                        SimpleAppCtrlServer.this.adapter.closeApplicationGraceFully();
                        break;
                    }
                    case Shoot: {
                        SimpleAppCtrlServer.this.adapter.shoot();
                        break;
                    }
                    case ResetNavigation: {
                        SimpleAppCtrlServer.this.adapter.resetNavigation();
                        break;
                    }
                    case EraseAll: {
                        SimpleAppCtrlServer.this.adapter.eraseAll();
                        break;
                    }
                    case ClearSky: {
                        SimpleAppCtrlServer.this.adapter.clearSky();
                        break;
                    }
                    case Immersive: {
                        SimpleAppCtrlServer.this.adapter.setAppMode(HisSphericalRendererApplication.AppMode.SPHERICAL);
                        break;
                    }
                    case NonImmersive: {
                        SimpleAppCtrlServer.this.adapter.setAppMode(HisSphericalRendererApplication.AppMode.FRUSTUM);
                        break;
                    }
                    case EnableHyvePositionSyncronization: {
                        SimpleAppCtrlServer.this.adapter.synchronizeHyvePositions(true);
                        break;
                    }
                    case DisableHyvePositionSyncronization: {
                        SimpleAppCtrlServer.this.adapter.synchronizeHyvePositions(false);
                        break;
                    }
                    case EnableOnlyTCP: {
                        SimpleAppCtrlServer.this.adapter.setOnlyUseTCP(true);
                        break;
                    }
                    case DisbleOnlyTCP: {
                        SimpleAppCtrlServer.this.adapter.setOnlyUseTCP(false);
                        break;
                    }
                    case EnableDisplayFps: {
                        SimpleAppCtrlServer.this.adapter.setDisplayFps(true);
                        break;
                    }
                    case DisbleDisplayFps: {
                        SimpleAppCtrlServer.this.adapter.setDisplayFps(false);
                        break;
                    }
                    case EnableDisplayStats: {
                        SimpleAppCtrlServer.this.adapter.setDisplayStatView(true);
                        break;
                    }
                    case DisbleDisplayStats: {
                        SimpleAppCtrlServer.this.adapter.setDisplayStatView(false);
                        break;
                    }
                    case EnableAutoExportTimer: {
                        SimpleAppCtrlServer.this.adapter.setupAutoExportTimer(true);
                        break;
                    }
                    case DisbleAutoExportTimer: {
                        SimpleAppCtrlServer.this.adapter.setupAutoExportTimer(false);
                        break;
                    }
                    case EnableSketchLog: {
                        SimpleAppCtrlServer.this.adapter.setupSketchLog(true);
                        break;
                    }
                    case DisbleSketchLog: {
                        SimpleAppCtrlServer.this.adapter.setupSketchLog(false);
                        break;
                    }
                    case EnableInertiaNavigation: {
                        SimpleAppCtrlServer.this.adapter.setInertiaNavigationEnabled(true);
                        break;
                    }
                    case DisableInertiaNavigation: {
                        SimpleAppCtrlServer.this.adapter.setInertiaNavigationEnabled(false);
                        break;
                    }
                    case EnableSnapDuringHinge: {
                        SimpleAppCtrlServer.this.adapter.setSnapDuringHinge(true);
                        break;
                    }
                    case DisableSnapDuringHinge: {
                        SimpleAppCtrlServer.this.adapter.setSnapDuringHinge(false);
                        break;
                    }
                    case HideRingMask: {
                        SimpleAppCtrlServer.this.adapter.setRingMaskVisibility(false);
                        break;
                    }
                    case ShowRingMask: {
                        SimpleAppCtrlServer.this.adapter.setRingMaskVisibility(true);
                        break;
                    }
                    case EnableFullscreen: {
                        SimpleAppCtrlServer.this.adapter.setFullscreen(true);
                        break;
                    }
                    case DisableFullscreen: {
                        SimpleAppCtrlServer.this.adapter.setFullscreen(false);
                        break;
                    }
                    case DisconnectFromHubNode: {
                        SimpleAppCtrlServer.this.adapter.disconnectFromHubNode(new HyveNetworking.ConnectionEstablishListener(){

                            @Override
                            public void onConnectionFailed(String message, String targetNodeInfo) {
                            }

                            @Override
                            public void onConnectionEstablished(HubNodeAddress targetHubNodeAdress) {
                            }

                            @Override
                            public void onConnectionLost(HubConnection removed) {
                            }
                        });
                        break;
                    }
                    case CloseHost: {
                        SimpleAppCtrlServer.this.adapter.closeHost(new HyveNetworking.HostingEstablishListener(){

                            @Override
                            public void onHostCreationFailed(Exception e) {
                            }

                            @Override
                            public void onHostCreated(HubNodeHost hnh) {
                            }

                            @Override
                            public void onHostShutdown() {
                            }
                        });
                    }
                }
            }
        }
    }
}

