/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyveswingapp;

import com.hybridlab.hyve3d.data.valueobjects.StrokePoint;
import com.hybridlab.hyve3d.hyve.StrokeCreationAdapter;
import com.jme3.math.ColorRGBA;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.swing.JLayeredPane;

public class Canvas
extends JLayeredPane
implements PropertyChangeListener {
    private static final long serialVersionUID = -2289594043735056424L;
    protected MouseEvent pressed;
    protected MouseEvent released;
    private StrokeCreationAdapter strokeAdapter;
    private UUID currentStrokeId = null;
    private List<com.hybridlab.hyve3d.data.domainobjects.Stroke> strokes = new ArrayList<com.hybridlab.hyve3d.data.domainobjects.Stroke>();
    private float scaleFactor = 0.1f;

    public Canvas() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getSource() == Canvas.this) {
                    Canvas.this.pressed = e;
                    Canvas.this.startStroke();
                    Canvas.this.feedToStroke(Canvas.this.pressed.getX(), Canvas.this.pressed.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getSource() == Canvas.this) {
                    Canvas.this.released = e;
                    Canvas.this.endStroke();
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (e.getSource() == Canvas.this) {
                    int x = e.getX();
                    int y = e.getY();
                    Canvas.this.feedToStroke(x, y);
                }
            }
        });
    }

    public void connectStrokeCreationAdapter(StrokeCreationAdapter a) {
        this.strokeAdapter = a;
    }

    protected void startStroke() {
        if (this.strokeAdapter == null) {
            return;
        }
        if (this.currentStrokeId == null) {
            this.currentStrokeId = UUID.randomUUID();
            this.strokeAdapter.create(this.currentStrokeId);
        }
    }

    protected void feedToStroke(int x, int y) {
        if (this.strokeAdapter == null) {
            return;
        }
        if (this.currentStrokeId != null) {
            this.strokeAdapter.feed(this.currentStrokeId, (float)x * this.scaleFactor, (float)y * this.scaleFactor);
        }
    }

    protected void endStroke() {
        if (this.strokeAdapter == null) {
            return;
        }
        if (this.currentStrokeId != null) {
            this.strokeAdapter.finish(this.currentStrokeId);
            this.currentStrokeId = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        RenderingHints hints = g2d.getRenderingHints();
        Stroke renderStroke = g2d.getStroke();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setStroke(new BasicStroke(3.0f, 1, 2));
        List<com.hybridlab.hyve3d.data.domainobjects.Stroke> list = this.strokes;
        synchronized (list) {
            for (com.hybridlab.hyve3d.data.domainobjects.Stroke s : this.strokes) {
                ColorRGBA c = s.getColor();
                g2d.setColor(new Color(c.r, c.g, c.b, c.a));
                ArrayList<StrokePoint> points = s.getAllPoints();
                if (points.size() == 1) {
                    int width;
                    StrokePoint p = points.get(0);
                    int height = width = 4;
                    g2d.drawOval((int)p.getPoint().x, (int)p.getPoint().y, width, height);
                    continue;
                }
                if (points.size() <= 0) continue;
                for (int i = 0; i < points.size() - 1; ++i) {
                    StrokePoint p = points.get(i);
                    StrokePoint q = points.get(i + 1);
                    g2d.drawLine((int)(p.getPoint().x / this.scaleFactor), (int)(p.getPoint().y / this.scaleFactor), (int)(q.getPoint().x / this.scaleFactor), (int)(q.getPoint().y / this.scaleFactor));
                }
            }
        }
        g2d.setRenderingHints(hints);
        g2d.setStroke(renderStroke);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(com.hybridlab.hyve3d.data.domainobjects.Stroke data) {
        data.removePropertyChangeListener(this);
        List<com.hybridlab.hyve3d.data.domainobjects.Stroke> list = this.strokes;
        synchronized (list) {
            this.strokes.remove(data);
        }
        data.removePropertyChangeListener(this);
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(com.hybridlab.hyve3d.data.domainobjects.Stroke data) {
        List<com.hybridlab.hyve3d.data.domainobjects.Stroke> list = this.strokes;
        synchronized (list) {
            this.strokes.add(data);
        }
        data.addPropertyChangeListener(this);
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        List<com.hybridlab.hyve3d.data.domainobjects.Stroke> list = this.strokes;
        synchronized (list) {
            for (com.hybridlab.hyve3d.data.domainobjects.Stroke s : this.strokes) {
                s.removePropertyChangeListener(this);
            }
            this.strokes.clear();
        }
        this.repaint();
    }

    @Override
    public void propertyChange(PropertyChangeEvent arg0) {
        this.repaint();
    }
}

