/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyveswingapp;

import com.hybridlab.hyve3d.data.DataModelKey;
import com.hybridlab.hyve3d.data.DataModelObserver;
import com.hybridlab.hyve3d.data.HyveData;
import com.hybridlab.hyve3d.data.domainobjects.HubNodeInfo;
import com.hybridlab.hyve3d.hyve.HyveApplication;
import com.hybridlab.hyve3d.hyve.SessionInfo;
import com.hybridlab.hyve3d.network.interconnection.InterconnectivityDataModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;

public class InterconnectivityVisualizer
implements DataModelObserver,
PropertyChangeListener {
    private List<HyveData> dataList = new ArrayList<HyveData>();
    private InterconnectivityDataModel dataModel;
    private JTextPane textfield;
    private JList sessionList;
    private HyveApplication app;

    public InterconnectivityVisualizer(InterconnectivityDataModel interConnectivityDataModel, JTextPane interConnectivityTextField, JList sessionList, HyveApplication app) {
        this.app = app;
        this.textfield = interConnectivityTextField;
        this.dataModel = interConnectivityDataModel;
        this.sessionList = sessionList;
        for (HyveData d : this.dataModel.getEntities()) {
            this.onDataAdded(d.getKey(), d);
        }
        this.dataModel.addObserver(this);
    }

    @Override
    public void onDataAdded(DataModelKey key, HyveData data) {
        this.dataList.add(data);
        data.addPropertyChangeListener(this);
        this.update();
    }

    private void update() {
        Object txt = "";
        ArrayList<SessionInfo> sinfo = new ArrayList<SessionInfo>();
        ArrayList<HyveData> dataListCopy = new ArrayList<HyveData>(this.dataList);
        for (HyveData d : dataListCopy) {
            if (d instanceof HubNodeInfo) {
                HubNodeInfo info = (HubNodeInfo)d;
                Object sn = "";
                for (SessionInfo s : info.getSession()) {
                    sn = (String)sn + "  " + s.toString() + "\n";
                    if (info.getId().equals(this.app.getNetworking().getHubNode().getId()) || s.id.equals(this.app.getLocalSessionId())) continue;
                    sinfo.add(s);
                }
                txt = (String)txt + String.format("Node: %s - %s\n  Sessions\n%s\n", info.getDescriptiveName(), info.getId().toString(), sn);
                continue;
            }
            txt = (String)txt + d.toString() + "\n\n";
        }
        this.setText((String)txt);
        this.setAvailableSessions(sinfo);
    }

    private void setAvailableSessions(final List<SessionInfo> sinfo) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DefaultListModel<SessionInfo> listModel = new DefaultListModel<SessionInfo>();
                for (SessionInfo si : sinfo) {
                    listModel.addElement(si);
                }
                InterconnectivityVisualizer.this.sessionList.setModel(listModel);
            }
        });
    }

    @Override
    public void onDataRemoved(DataModelKey key, HyveData data) {
        data.removePropertyChangeListener(this);
        this.dataList.remove(data);
        this.update();
    }

    private void setText(final String txt) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (InterconnectivityVisualizer.this.textfield == null) {
                    System.out.println("WARNING! - textfield was null");
                } else {
                    InterconnectivityVisualizer.this.textfield.setText(txt);
                }
            }
        });
    }

    @Override
    public void propertyChange(PropertyChangeEvent arg0) {
        System.out.println(arg0);
        this.update();
    }
}

