/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyveswingapp;

import com.hybridlab.hyve3d.data.domainobjects.Node;
import com.hybridlab.hyve3d.data.valueobjects.Transformation;
import com.hybridlab.hyveswingapp.MovingPanel;
import com.hybridlab.hyveswingapp.SwingRotationValueVisualizer;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SwingAssetVisualization
extends MovingPanel
implements PropertyChangeListener,
SwingRotationValueVisualizer.RotationChangeRequestor {
    private static final long serialVersionUID = 4533513771924484122L;
    private Node asset;
    private float scaleFactor = 0.4f;
    private JSlider slider;
    ChangeListener sliderListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent e) {
            JSlider source = (JSlider)e.getSource();
            int v = source.getValue();
            SwingAssetVisualization.this.requestNewLocation(v);
        }
    };

    public SwingAssetVisualization(Node da) {
        this.asset = da;
        this.asset.addPropertyChangeListener(this);
        this.setSize(200, 200);
        this.slider = new JSlider();
        this.slider.setOrientation(1);
        GridBagConstraints gbc_slider = new GridBagConstraints();
        gbc_slider.fill = 3;
        gbc_slider.gridx = 2;
        gbc_slider.gridy = 1;
        this.add((Component)this.slider, gbc_slider);
        this.slider.setMaximum(290);
        this.slider.setMinimum(-10);
        this.slider.setValue(0);
        this.slider.addChangeListener(this.sliderListener);
        this.update();
    }

    protected void requestNewLocation(int v) {
        Vector3f pos = this.asset.getTransformation().getPosition().clone();
        float newPos = (float)v * this.scaleFactor;
        if (pos.y != newPos) {
            pos.y = newPos;
            Transformation t = new Transformation(pos, this.asset.getTransformation().getRotation().clone());
            this.asset.setTransformation(t);
        }
    }

    public void destroy() {
        this.asset.removePropertyChangeListener(this);
    }

    public void update() {
        this.setLabelText("Asset\n" + this.asset.getId().toString());
        Vector3f pos = this.asset.getTransformation().getPosition();
        this.setLocation((int)(pos.x / this.scaleFactor), (int)(pos.z / this.scaleFactor));
        this.repaint();
    }

    @Override
    protected void requestNewLocation(int x, int y) {
        Vector3f pos = this.asset.getTransformation().getPosition().clone();
        pos.x = (float)x * this.scaleFactor;
        pos.z = (float)y * this.scaleFactor;
        Transformation t = new Transformation(pos, this.asset.getTransformation().getRotation().clone());
        this.asset.setTransformation(t);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String prop;
        if (evt.getSource() == this.asset && (prop = evt.getPropertyName()).endsWith("transformation")) {
            final Transformation t = (Transformation)evt.getNewValue();
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    SwingAssetVisualization.this.setLocation((int)(t.getPosition().x / SwingAssetVisualization.this.scaleFactor), (int)(t.getPosition().z / SwingAssetVisualization.this.scaleFactor));
                    SwingAssetVisualization.this.setSliderValueFromSpace((int)(t.getPosition().y / SwingAssetVisualization.this.scaleFactor));
                }
            };
            if (!"AWT-EventQueue-0".equals(Thread.currentThread().getName())) {
                SwingUtilities.invokeLater(r);
            } else {
                r.run();
            }
        }
    }

    private void setSliderValueFromSpace(int v) {
        this.slider.removeChangeListener(this.sliderListener);
        this.slider.setValue(v);
        this.slider.addChangeListener(this.sliderListener);
    }

    @Override
    public void requestNewValue(Quaternion newRot) {
        Transformation t = new Transformation(this.asset.getTransformation().getPosition().clone(), newRot);
        this.asset.setTransformation(t);
    }
}

