/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyveswingapp;

import com.hybridlab.hyve3d.data.domainobjects.BackGround;
import com.hybridlab.hyveswingapp.MovingPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.StringUtils;

public class SwingBackGroundVisualization
extends MovingPanel
implements PropertyChangeListener {
    private static final long serialVersionUID = -6693205330481086862L;
    private BackGround backGround;
    private JTextPane txtElements;

    public SwingBackGroundVisualization(BackGround da) {
        this.setSize(200, 200);
        this.backGround = da;
        this.backGround.addPropertyChangeListener(this);
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{234, 0};
        gridBagLayout.rowHeights = new int[]{11, 0, 0, 0};
        gridBagLayout.columnWeights = new double[]{1.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, 1.0, 0.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        this.txtElements = new JTextPane();
        this.txtElements.setText("<empty>");
        this.txtElements.setFont(new Font("Lucida Grande", 0, 9));
        this.txtElements.setBackground(Color.WHITE);
        GridBagConstraints gbc_txtElements = new GridBagConstraints();
        gbc_txtElements.fill = 1;
        gbc_txtElements.insets = new Insets(0, 0, 5, 0);
        gbc_txtElements.gridx = 0;
        gbc_txtElements.gridy = 1;
        this.add((Component)this.txtElements, gbc_txtElements);
        JButton btnApply = new JButton("apply");
        btnApply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String s = SwingBackGroundVisualization.this.txtElements.getText();
                String[] parts = StringUtils.split(s, " ");
                HashSet<String> sp = new HashSet<String>();
                for (String x : parts) {
                    sp.add(x);
                }
                SwingBackGroundVisualization.this.backGround.setElements(sp);
            }
        });
        GridBagConstraints gbc_btnApply = new GridBagConstraints();
        gbc_btnApply.gridx = 0;
        gbc_btnApply.gridy = 2;
        this.add((Component)btnApply, gbc_btnApply);
        this.update();
    }

    public void destroy() {
        this.backGround.removePropertyChangeListener(this);
    }

    private void setElements(final String s) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                SwingBackGroundVisualization.this.txtElements.setText(s);
            }
        };
        if (!"AWT-EventQueue-0".equals(Thread.currentThread().getName())) {
            SwingUtilities.invokeLater(r);
        } else {
            r.run();
        }
    }

    public void update() {
        this.setLabelText("Background");
        String s = StringUtils.join(this.backGround.getElements(), " ");
        this.setElements(s);
        this.repaint();
    }

    @Override
    protected void requestNewLocation(int x, int y) {
        this.setLocation(x, y);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String prop;
        if (evt.getSource() == this.backGround && (prop = evt.getPropertyName()).endsWith("elements")) {
            String s = StringUtils.join((Set)evt.getNewValue(), " ");
            this.setElements(s);
        }
    }
}

