/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyveswingapp;

import com.hybridlab.hyveswingapp.SwingSingleAxisRotationValueVisualizer;
import com.hybridlab.utils.math.MathUtils;
import com.jme3.math.Quaternion;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JPanel;

public class SwingRotationValueVisualizer
extends JPanel {
    private final String prop = "rotationangle";
    private RotationChangeRequestor valueChangeRequestor;
    private Listener l = new Listener();
    private static final long serialVersionUID = 7371630043417435448L;
    private SwingSingleAxisRotationValueVisualizer z;
    private SwingSingleAxisRotationValueVisualizer y;
    private SwingSingleAxisRotationValueVisualizer x;
    private Quaternion rotation = new Quaternion();

    public SwingRotationValueVisualizer() {
        this((RotationChangeRequestor)null);
    }

    public SwingRotationValueVisualizer(RotationChangeRequestor r) {
        this.valueChangeRequestor = r;
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0};
        gridBagLayout.rowHeights = new int[]{0, 0, 0};
        gridBagLayout.columnWeights = new double[]{1.0};
        gridBagLayout.rowWeights = new double[]{1.0, 1.0, 1.0};
        this.setLayout(gridBagLayout);
        this.x = new SwingSingleAxisRotationValueVisualizer("X-Axis", -90, 90);
        GridBagConstraints gbc_x = new GridBagConstraints();
        gbc_x.fill = 1;
        gbc_x.insets = new Insets(0, 0, 5, 0);
        gbc_x.gridx = 0;
        gbc_x.gridy = 0;
        this.add((Component)this.x, gbc_x);
        this.y = new SwingSingleAxisRotationValueVisualizer("Y-Axis", -180, 180);
        GridBagLayout gbl_y = (GridBagLayout)this.y.getLayout();
        gbl_y.rowWeights = new double[]{0.0, 0.0, 0.0};
        gbl_y.rowHeights = new int[]{0, 0, 0};
        gbl_y.columnWeights = new double[]{1.0};
        gbl_y.columnWidths = new int[]{0};
        GridBagConstraints gbc_y = new GridBagConstraints();
        gbc_y.insets = new Insets(0, 0, 5, 0);
        gbc_y.fill = 1;
        gbc_y.gridx = 0;
        gbc_y.gridy = 1;
        this.add((Component)this.y, gbc_y);
        this.z = new SwingSingleAxisRotationValueVisualizer("Z-Axis", -180, 180);
        GridBagLayout gbl_z = (GridBagLayout)this.z.getLayout();
        gbl_z.rowWeights = new double[]{0.0, 0.0, 0.0};
        gbl_z.rowHeights = new int[]{0, 0, 0};
        gbl_z.columnWeights = new double[]{1.0};
        gbl_z.columnWidths = new int[]{0};
        GridBagConstraints gbc_z = new GridBagConstraints();
        gbc_z.fill = 1;
        gbc_z.gridx = 0;
        gbc_z.gridy = 2;
        this.add((Component)this.z, gbc_z);
    }

    public void setRotation(Quaternion rotation) {
        if (rotation != null && !rotation.equals((Object)this.rotation)) {
            Quaternion old = this.rotation;
            this.rotation = rotation;
            this.firePropertyChange("rotationquaternion", old, this.rotation);
            this.update();
        }
    }

    private void update() {
        float[] a = MathUtils.quaternionToEulerAnglesInRad(this.rotation);
        this.x.setAngle(a[0]);
        this.y.setAngle(a[1]);
        this.z.setAngle(a[2]);
    }

    public static interface RotationChangeRequestor {
        public void requestNewValue(Quaternion var1);
    }

    private class Listener
    implements PropertyChangeListener {
        private Listener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("rotationangle")) {
                float[] angles = MathUtils.quaternionToEulerAnglesInRad(SwingRotationValueVisualizer.this.rotation);
                if (evt.getSource() == SwingRotationValueVisualizer.this.x) {
                    angles[0] = ((Float)evt.getNewValue()).floatValue();
                } else if (evt.getSource() == SwingRotationValueVisualizer.this.y) {
                    angles[1] = ((Float)evt.getNewValue()).floatValue();
                } else if (evt.getSource() == SwingRotationValueVisualizer.this.z) {
                    angles[2] = ((Float)evt.getNewValue()).floatValue();
                }
                Quaternion newRot = new Quaternion();
                newRot.fromAngles(angles);
                SwingRotationValueVisualizer.this.valueChangeRequestor.requestNewValue(newRot);
            }
        }
    }
}

