/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyveswingapp;

import com.hybridlab.hyve3d.config.ConfigurationAdapter;
import com.hybridlab.hyve3d.config.MaskProperties;
import com.hybridlab.hyve3d.config.NamedAngle;
import com.hybridlab.hyve3d.config.NamedString;
import com.hybridlab.hyve3d.config.RingMaskProperties;
import com.hybridlab.hyve3d.data.Session;
import com.hybridlab.hyve3d.hyve.HubNodeNetworkingController;
import com.hybridlab.hyve3d.hyve.Hyve;
import com.hybridlab.hyve3d.hyve.HyveApplication;
import com.hybridlab.hyve3d.hyve.SessionVisualizer;
import com.hybridlab.hyve3d.network.discovery.NetworkServiceManager;
import com.hybridlab.hyve3d.network.interconnection.HubNode;
import com.hybridlab.hyve3d.network.interconnection.implementations.SimpleSessionController;
import com.hybridlab.hyve3d.network.interconnection.messages.Registry;
import com.hybridlab.hyveswingapp.InterconnectivityVisualizer;
import com.hybridlab.hyveswingapp.SwingSessionVisualizer;
import com.hybridlab.hyveswingapp.XUIWindow;
import com.jme3.texture.TextureCubeMap;
import java.awt.Dimension;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.RandomUtils;

public class XApp {
    private XUIWindow fenster;
    private SessionVisualizer vis;
    private String appid;
    private String localSessionUUID;
    private String hubNodeUUID;
    private int hostport;
    private int connectport;
    private String hyveName;
    private String hyveUuid;

    public static void main(String[] args) {
        int connectport;
        int hostport;
        String appid = null;
        String localSessionUUID = null;
        String hubNodeUUID = null;
        String hyveUUID = null;
        String hyveNameArg = null;
        Map<String, String> argmap = XApp.parseArgList(args);
        appid = argmap.get("appId");
        localSessionUUID = argmap.get("localSessionUUID");
        hubNodeUUID = argmap.get("hubNodeUUID");
        hyveUUID = argmap.get("hyveUUID");
        hyveNameArg = argmap.get("hyveName");
        String alternativeAppId = String.valueOf(RandomUtils.nextInt(10, 99)) + "-" + String.valueOf(RandomUtils.nextInt(10, 99));
        String alternativeLocalSessionId = UUID.randomUUID().toString();
        String alternativehubNodeUUID = UUID.randomUUID().toString();
        String alternativehyveUUID = UUID.randomUUID().toString();
        String alternativehyveName = alternativeAppId;
        try {
            hostport = Integer.parseInt(argmap.get("hostport"));
        }
        catch (NumberFormatException e) {
            hostport = 40000;
        }
        try {
            connectport = Integer.parseInt(argmap.get("connectto"));
        }
        catch (NumberFormatException e) {
            connectport = 40000;
        }
        XApp app = new XApp((String)(appid != null ? appid : alternativeAppId), localSessionUUID != null ? localSessionUUID : alternativeLocalSessionId, hubNodeUUID != null ? hubNodeUUID : alternativehubNodeUUID, hostport, connectport, hyveUUID != null ? hyveUUID : alternativehyveUUID, (String)(hyveNameArg != null ? hyveNameArg : alternativehyveName));
        app.start();
    }

    private static Map<String, String> parseArgList(String[] args) {
        HashMap<String, String> argmap = new HashMap<String, String>();
        String arg = null;
        for (String part : args) {
            if (part.startsWith("-")) {
                arg = part.substring(1);
                argmap.put(arg, "");
                continue;
            }
            if (arg == null) continue;
            String a = (String)argmap.get(arg);
            argmap.put(arg, a + part);
        }
        return argmap;
    }

    public XApp(String appid, String localSessionUUID, String hubNodeUUID, int hostport, int connectport, String hyveUuid, String hyveName) {
        this.appid = appid;
        this.localSessionUUID = localSessionUUID;
        this.hubNodeUUID = hubNodeUUID;
        this.hostport = hostport;
        this.connectport = connectport;
        this.hyveName = hyveName;
        this.hyveUuid = hyveUuid;
        String filename = XApp.class.getSimpleName() + String.valueOf(appid + ".log");
        try {
            System.setErr(new PrintStream("/tmp/" + filename));
            for (int i = 0; i < 80; ++i) {
                System.err.println();
            }
            SimpleDateFormat df = new SimpleDateFormat("EEE, d MMM yyyy, hh:mm aaa");
            Date now = Calendar.getInstance().getTime();
            String msg = "-----------------------\nrunning started: " + df.format(now) + "\n-----------------------\n\n";
            System.err.println(msg);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    private void start() {
        Registry.registerMessageTypes();
        HyveApplication app = new HyveApplication(UUID.fromString(this.localSessionUUID));
        final NamedAngle north = new NamedAngle("NorthHeading", 45.0f);
        ConfigurationAdapter ca = new ConfigurationAdapter(){

            @Override
            public String getHyveName() {
                return XApp.this.hyveName;
            }

            @Override
            public NamedAngle getNorthHeading() {
                return north;
            }

            @Override
            public void setHyveName(String name) {
                XApp.this.hyveName = name;
            }

            @Override
            public NamedString getUsedRotationSensor() {
                return null;
            }

            @Override
            public NamedAngle getHydraControllerAttachmentAngle() {
                return null;
            }

            @Override
            public MaskProperties getEllipseMaskProperties() {
                return null;
            }

            @Override
            public Map<TextureCubeMap.Face, Boolean> getEnabledFaces() {
                return null;
            }

            @Override
            public void setEnabledFaces(Map<TextureCubeMap.Face, Boolean> faces) {
            }

            @Override
            public RingMaskProperties getRingMaskProperties() {
                return null;
            }
        };
        Hyve localhyve = new Hyve(UUID.fromString(this.hyveUuid), ca);
        app.setLocalHyve(localhyve);
        SimpleSessionController sessionCtrl = new SimpleSessionController();
        app.setSessionRepository(sessionCtrl);
        HubNode n = new HubNode(UUID.fromString(this.hubNodeUUID));
        n.setDescription("Hubnode in XApp " + this.appid);
        NetworkServiceManager networkServiceManager = new NetworkServiceManager();
        HubNodeNetworkingController net = new HubNodeNetworkingController(n, sessionCtrl, networkServiceManager);
        app.setNetworkingController(net);
        try {
            Session session = sessionCtrl.createNewSession(UUID.fromString(this.localSessionUUID), "Initial Session in " + this.appid);
            localhyve.joinSession(session);
            this.createUIAndVisualizeInitialSession(app, String.valueOf(this.appid), this.hostport, this.connectport, session.getId());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createUIAndVisualizeInitialSession(final HyveApplication app, final String windowTitle, final int hostport, final int connectport, final UUID sessionid) {
        Runnable guiCreator = new Runnable(){

            @Override
            public void run() {
                XApp.this.fenster = new XUIWindow(app);
                XApp.this.fenster.setSize(new Dimension(800, 600));
                XApp.this.fenster.setTitle(windowTitle);
                XApp.this.fenster.setVisible(true);
                XApp.this.fenster.setDefaultCloseOperation(3);
                XApp.this.fenster.setPorts(hostport, connectport);
                XApp.this.vis = new SwingSessionVisualizer(app, XApp.this.fenster.getCanvas(), XApp.this.fenster.getSessionLabel(), XApp.this.fenster.getTableModel());
                app.addSessionVisualizer(XApp.this.vis);
                InterconnectivityVisualizer interconnectivityVisualizer = new InterconnectivityVisualizer(app.getNetworking().getInterConnectivityDataModel(), XApp.this.fenster.getInterConnectivityTextField(), XApp.this.fenster.getSessionList(), app);
                app.showSession(sessionid);
            }
        };
        SwingUtilities.invokeLater(guiCreator);
    }
}

