/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.licensing;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public enum Feature {
    NONIMMERSIVE(1),
    IMMERSIVE(2);

    private final byte value;
    public static final Set<Feature> ALL;
    public static final Set<Feature> NONE;
    public static final Set<Feature> ONLY_IMMERSIVE;
    public static final Set<Feature> ONLY_NONIMMERSIVE;

    private Feature(byte v) {
        this.value = v;
    }

    public byte getValue() {
        return this.value;
    }

    public static byte toByte(Set<Feature> features) {
        byte fb = 0;
        for (Feature f : features) {
            fb = (byte)(fb + f.value);
        }
        return fb;
    }

    public static Set<Feature> fromByte(byte fb) {
        switch (fb) {
            default: {
                return Collections.emptySet();
            }
            case 1: {
                return ONLY_NONIMMERSIVE;
            }
            case 2: {
                return ONLY_IMMERSIVE;
            }
            case 3: 
        }
        return ALL;
    }

    static {
        ALL = new HashSet<Feature>();
        ALL.add(IMMERSIVE);
        ALL.add(NONIMMERSIVE);
        NONE = new HashSet<Feature>();
        ONLY_IMMERSIVE = new HashSet<Feature>();
        ONLY_IMMERSIVE.add(IMMERSIVE);
        ONLY_NONIMMERSIVE = new HashSet<Feature>();
        ONLY_NONIMMERSIVE.add(NONIMMERSIVE);
    }
}

