/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.misc.obj;

import com.momchil_atanasov.data.front.error.WFException;
import com.momchil_atanasov.data.front.parser.OBJDataReference;
import com.momchil_atanasov.data.front.parser.OBJFace;
import com.momchil_atanasov.data.front.parser.OBJMesh;
import com.momchil_atanasov.data.front.parser.OBJModel;
import com.momchil_atanasov.data.front.parser.OBJObject;
import com.momchil_atanasov.data.front.parser.OBJParser;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.List;

public class ObjParseExample {
    public static void main(String[] args) {
        ObjParseExample x = new ObjParseExample();
        try {
            x.parse();
        }
        catch (WFException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void parse() throws WFException, IOException {
        InputStream in = ObjParseExample.class.getResourceAsStream("teapot.obj");
        OBJParser parser = new OBJParser();
        OBJModel model = parser.parse(in);
        System.out.println(MessageFormat.format("OBJ model has {0} vertices, {1} normals, {2} texture coordinates, and {3} objects.", model.getVertices().size(), model.getNormals().size(), model.getTexCoords().size(), model.getObjects().size()));
        OBJObject o = model.getObjects().get(0);
        List<OBJMesh> meshes = o.getMeshes();
        for (OBJMesh m : meshes) {
            List<OBJFace> faces = m.getFaces();
            List<OBJDataReference> refs = faces.get(0).getReferences();
            System.out.println(MessageFormat.format("ref.get(0): hasVertexIndex:{0}, hasNormalIndex:{1},hasTexCoordIndex:{2}, v: {3} n: {4} t: {5}", refs.get(0).hasVertexIndex(), refs.get(0).hasNormalIndex(), refs.get(0).hasTexCoordIndex(), refs.get((int)0).vertexIndex, refs.get((int)0).normalIndex, refs.get((int)0).texCoordIndex));
        }
    }
}

