/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.misc.tryouts;

import com.hybridlab.utils.math.MathUtils;
import com.jme3.app.SimpleApplication;
import com.jme3.collision.Collidable;
import com.jme3.collision.CollisionResult;
import com.jme3.collision.CollisionResults;
import com.jme3.font.BitmapText;
import com.jme3.input.controls.ActionListener;
import com.jme3.input.controls.AnalogListener;
import com.jme3.input.controls.InputListener;
import com.jme3.input.controls.KeyTrigger;
import com.jme3.input.controls.MouseButtonTrigger;
import com.jme3.input.controls.Trigger;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Quaternion;
import com.jme3.math.Ray;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Box;
import com.jme3.scene.shape.Sphere;
import com.jme3.texture.FrameBuffer;
import com.jme3.texture.Image;
import com.jme3.util.BufferUtils;
import com.jme3.util.Screenshots;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.imageio.ImageIO;

public class OrthoRenderTryout
extends SimpleApplication {
    FrameBuffer offBuffer;
    private static final int width = 1024;
    private static final int height = 768;
    private static final String targetFile = "/tmp/img";
    private final int numBytesPerPixel = 4;
    private final ByteBuffer cpuBuf = BufferUtils.createByteBuffer((int)0x300000);
    private BufferedImage image = new BufferedImage(1024, 768, 6);
    private Node shootables;
    private Geometry mark;
    private float frustumSize = 1.0f;
    private Camera cam2;
    private AnalogListener analogListener = new AnalogListener(){

        public void onAnalog(String name, float value, float tpf) {
            OrthoRenderTryout.this.frustumSize = name.equals("Size-") ? (OrthoRenderTryout.this.frustumSize += 0.3f * tpf) : (OrthoRenderTryout.this.frustumSize -= 0.3f * tpf);
            float aspect = (float)OrthoRenderTryout.this.cam.getWidth() / (float)OrthoRenderTryout.this.cam.getHeight();
            OrthoRenderTryout.this.cam2.setFrustum(-1000.0f, 1000.0f, -aspect * OrthoRenderTryout.this.frustumSize, aspect * OrthoRenderTryout.this.frustumSize, OrthoRenderTryout.this.frustumSize, -OrthoRenderTryout.this.frustumSize);
        }
    };
    private ActionListener actionListener = new ActionListener(){

        public void onAction(String name, boolean keyPressed, float tpf) {
            if (name.equals("Place") && !keyPressed) {
                OrthoRenderTryout.this.cam2.setLocation(OrthoRenderTryout.this.cam.getLocation());
                OrthoRenderTryout.this.cam2.setRotation(OrthoRenderTryout.this.cam.getRotation());
                System.out.println("Place Camera " + OrthoRenderTryout.this.cam2.getLocation() + " " + MathUtils.quaternionToAxisAngleInDegreesString(OrthoRenderTryout.this.cam2.getRotation()));
            } else if (name.equals("Shoot") && !keyPressed) {
                CollisionResults results = new CollisionResults();
                Ray ray = new Ray(OrthoRenderTryout.this.cam.getLocation(), OrthoRenderTryout.this.cam.getDirection());
                OrthoRenderTryout.this.shootables.collideWith((Collidable)ray, results);
                System.out.println("----- Collisions? " + results.size() + "-----");
                for (int i = 0; i < results.size(); ++i) {
                    float dist = results.getCollision(i).getDistance();
                    Vector3f pt = results.getCollision(i).getContactPoint();
                    String hit = results.getCollision(i).getGeometry().getName();
                    System.out.println("* Collision #" + i);
                    System.out.println("  You shot " + hit + " at " + pt + ", " + dist + " wu away.");
                }
                if (results.size() > 0) {
                    CollisionResult closest = results.getClosestCollision();
                    OrthoRenderTryout.this.mark.setLocalTranslation(closest.getContactPoint());
                    OrthoRenderTryout.this.rootNode.attachChild((Spatial)OrthoRenderTryout.this.mark);
                } else {
                    OrthoRenderTryout.this.rootNode.detachChild((Spatial)OrthoRenderTryout.this.mark);
                }
                OrthoRenderTryout.this.shootOrthoImage();
            }
        }
    };

    public void simpleInitApp() {
        this.initCrossHairs();
        this.initKeys();
        this.initMark();
        this.shootables = new Node("Shootables");
        this.rootNode.attachChild((Spatial)this.shootables);
        this.shootables.attachChild((Spatial)this.makeCube("a Dragon", -2.0f, 0.0f, 1.0f));
        this.shootables.attachChild((Spatial)this.makeCube("a tin can", 1.0f, -2.0f, 0.0f));
        this.shootables.attachChild((Spatial)this.makeCube("the Sheriff", 0.0f, 1.0f, -2.0f));
        this.shootables.attachChild((Spatial)this.makeCube("the Deputy", 1.0f, 0.0f, -4.0f));
        this.shootables.attachChild((Spatial)this.makeFloor());
        this.cam2 = this.cam.clone();
        this.cam2.setViewPort(0.0f, 1.0f, 0.0f, 1.0f);
        this.cam2.setLocation(new Vector3f(0.0f, 0.0f, 1.0f));
        this.cam2.setRotation(new Quaternion().fromAngleAxis(0.5235988f, new Vector3f(1.0f, 0.0f, 0.0f)));
        this.cam2.setParallelProjection(true);
        float aspect = 1.3333334f;
        this.cam2.setFrustum(-1000.0f, 1000.0f, -aspect * this.frustumSize, aspect * this.frustumSize, this.frustumSize, -this.frustumSize);
        this.inputManager.addListener((InputListener)this.analogListener, new String[]{"Size+", "Size-"});
        this.inputManager.addMapping("Size+", new Trigger[]{new KeyTrigger(35)});
        this.inputManager.addMapping("Size-", new Trigger[]{new KeyTrigger(36)});
        this.setupOffscreenViewPort();
    }

    private void setupOffscreenViewPort() {
        ViewPort vp = this.renderManager.createPreView("ortho viewport", this.cam2);
        vp.setClearFlags(true, true, true);
        vp.setBackgroundColor(ColorRGBA.Black);
        this.offBuffer = new FrameBuffer(1024, 768, 1);
        this.offBuffer.setDepthBuffer(Image.Format.Depth);
        this.offBuffer.setColorBuffer(Image.Format.BGR8);
        vp.setOutputFrameBuffer(this.offBuffer);
        vp.attachScene((Spatial)this.rootNode);
    }

    public void updateImageContents() {
        this.cpuBuf.clear();
        this.renderer.readFrameBuffer(this.offBuffer, this.cpuBuf);
    }

    protected void shootOrthoImage() {
        this.updateImageContents();
        this.saveImage();
    }

    private void saveImage() {
        Screenshots.convertScreenShot((ByteBuffer)this.cpuBuf, (BufferedImage)this.image);
        try {
            ImageIO.write((RenderedImage)this.image, "jpg", new FileOutputStream("/tmp/img.jpg"));
            ImageIO.write((RenderedImage)this.image, "png", new FileOutputStream("/tmp/img.png"));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void initKeys() {
        this.inputManager.addMapping("Shoot", new Trigger[]{new KeyTrigger(57), new MouseButtonTrigger(0)});
        this.inputManager.addMapping("Place", new Trigger[]{new KeyTrigger(46), new MouseButtonTrigger(1)});
        this.inputManager.addListener((InputListener)this.actionListener, new String[]{"Shoot", "Place"});
        this.inputManager.addListener((InputListener)this.actionListener, new String[]{"Shoot", "Place"});
    }

    protected Geometry makeCube(String name, float x, float y, float z) {
        Box box = new Box(1.0f, 1.0f, 1.0f);
        Geometry cube = new Geometry(name, (Mesh)box);
        cube.setLocalTranslation(x, y, z);
        Material mat1 = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        mat1.setColor("Color", ColorRGBA.randomColor());
        cube.setMaterial(mat1);
        return cube;
    }

    protected Geometry makeFloor() {
        Box box = new Box(15.0f, 0.2f, 15.0f);
        Geometry floor = new Geometry("the Floor", (Mesh)box);
        floor.setLocalTranslation(0.0f, -4.0f, -5.0f);
        Material mat1 = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        mat1.setColor("Color", ColorRGBA.Gray);
        floor.setMaterial(mat1);
        return floor;
    }

    protected void initMark() {
        Sphere sphere = new Sphere(30, 30, 0.2f);
        this.mark = new Geometry("BOOM!", (Mesh)sphere);
        Material mark_mat = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        mark_mat.setColor("Color", ColorRGBA.Red);
        this.mark.setMaterial(mark_mat);
    }

    protected void initCrossHairs() {
        this.setDisplayStatView(false);
        this.guiFont = this.assetManager.loadFont("Interface/Fonts/Default.fnt");
        BitmapText ch = new BitmapText(this.guiFont, false);
        ch.setSize((float)(this.guiFont.getCharSet().getRenderedSize() * 2));
        ch.setText("+");
        ch.setLocalTranslation((float)(this.settings.getWidth() / 2) - ch.getLineWidth() / 2.0f, (float)(this.settings.getHeight() / 2) + ch.getLineHeight() / 2.0f, 0.0f);
        this.guiNode.attachChild((Spatial)ch);
    }

    public static void main(String[] args) {
        OrthoRenderTryout app = new OrthoRenderTryout();
        app.start();
    }
}

