/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.protocol;

import com.hybridlab.protocol.ProtocolEvent;

public class SatelliteEvent
extends ProtocolEvent {
    private String satelliteId;
    private String satelliteName;
    private Type type;
    private String additionalInfo;

    public SatelliteEvent(String sId, String satName, Type type) {
        this.satelliteId = sId;
        this.satelliteName = satName;
        this.type = type;
    }

    public SatelliteEvent(String sId, String satName, Type type, String additionalInfo) {
        this(sId, satName, type);
        this.additionalInfo = additionalInfo;
    }

    @Override
    public String toPrintableLine() {
        String line = String.format("%s, %d, %s, %s, %s, %s", this.getFormattedUTCTimeString(), this.eventTime, this.satelliteId, "'" + this.satelliteName + "'", this.type.toString(), this.additionalInfo == null ? "-" : this.additionalInfo);
        return line;
    }

    public static enum Type {
        SessionStart,
        SessionEnd,
        PivotingStart,
        PivotingEnd,
        StrokeEnd,
        StrokeBegin,
        NavigationStrideBegin,
        NavigationStrideEnd,
        DrawingAreaTransformationBegin,
        DrawingAreaTransformationEnd;

    }
}

