/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonHelper {
    public static Object toJSON(Object object) throws JSONException {
        if (object instanceof Map) {
            JSONObject json = new JSONObject();
            Map map = (Map)object;
            for (Object key : map.keySet()) {
                json.put(key.toString(), JsonHelper.toJSON(map.get(key)));
            }
            return json;
        }
        if (object instanceof Iterable) {
            JSONArray json = new JSONArray();
            for (Object value : (Iterable)object) {
                json.put(value);
            }
            return json;
        }
        return object;
    }

    public static boolean isEmptyObject(JSONObject object) {
        return object.names() == null;
    }

    public static Map<String, Object> getMap(JSONObject object, String key) throws JSONException {
        return JsonHelper.toMap(object.getJSONObject(key));
    }

    public static Map<String, Object> toMap(JSONObject object) throws JSONException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Iterator keys = object.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            map.put(key, JsonHelper.fromJson(object.get(key)));
        }
        return map;
    }

    public static List<Object> toList(JSONArray array) throws JSONException {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < array.length(); ++i) {
            list.add(JsonHelper.fromJson(array.get(i)));
        }
        return list;
    }

    private static Object fromJson(Object json) throws JSONException {
        if (json == JSONObject.NULL) {
            return null;
        }
        if (json instanceof JSONObject) {
            return JsonHelper.toMap((JSONObject)json);
        }
        if (json instanceof JSONArray) {
            return JsonHelper.toList((JSONArray)json);
        }
        return json;
    }
}

