/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.utils.logging;

import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import org.apache.commons.lang3.time.DateFormatUtils;

public class CustomConsoleFormatter
extends Formatter {
    private static String getTimeString() {
        return DateFormatUtils.format(System.currentTimeMillis(), "yyyy-MM-dd HH:mm:ss.S (Z)");
    }

    @Override
    public String format(LogRecord arg0) {
        StringBuilder b = new StringBuilder();
        b.append("_____________________________________________________________________");
        b.append(System.getProperty("line.separator"));
        b.append(CustomConsoleFormatter.getTimeString());
        b.append(System.getProperty("line.separator"));
        b.append("-- ");
        b.append(arg0.getLevel());
        b.append(" ----------");
        b.append(System.getProperty("line.separator"));
        b.append(" ");
        b.append(arg0.getSourceClassName());
        b.append(" ");
        b.append(arg0.getSourceMethodName());
        b.append(" ");
        b.append(arg0.getThreadID());
        b.append(" ");
        b.append(System.getProperty("line.separator"));
        b.append("   >>");
        b.append(System.getProperty("line.separator"));
        b.append(arg0.getMessage());
        b.append(System.getProperty("line.separator"));
        b.append(System.getProperty("line.separator"));
        b.append(System.getProperty("line.separator"));
        return b.toString();
    }
}

