/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.utils.math;

import com.hybridlab.utils.math.MathUtils;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jogamp.opengl.math.geom.AABBox;

public class Rectangle3D {
    private float width;
    private float height;
    private AABBox bounds;
    private Vector3f normal;
    private Vector3f u;
    private Vector3f v;
    private Quaternion rotation;
    private Vector3f position;
    private Vector3f[] corners;

    public Rectangle3D(float width, float height, Vector3f position, Quaternion rotation) {
        this.width = width;
        this.height = height;
        this.rotation = rotation;
        this.position = position;
        this.u = Vector3f.UNIT_X.mult(height * 0.5f);
        this.u = rotation.mult(this.u);
        this.v = Vector3f.UNIT_Y.mult(width * 0.5f);
        this.v = rotation.mult(this.v);
        this.normal = rotation.mult(Vector3f.UNIT_Z).normalize();
    }

    public Vector3f[] getCorners() {
        if (this.corners == null) {
            this.corners = new Vector3f[4];
            this.corners[0] = this.position.add(this.u).add(this.v);
            this.corners[1] = this.position.add(this.u).add(this.v.negate());
            this.corners[2] = this.position.add(this.u.negate()).add(this.v.negate());
            this.corners[3] = this.position.add(this.u.negate()).add(this.v);
        }
        return this.corners;
    }

    public String toString() {
        return "VolumeEntry [width=" + this.width + ", height=" + this.height + ", position=" + this.position + ", rotation=" + MathUtils.quaternionToAxisAngleInDegreesString(this.rotation) + "]";
    }

    public AABBox getAABBox() {
        if (this.bounds == null) {
            Vector3f[] corners = this.getCorners();
            Vector3f c = corners[0];
            this.bounds = new AABBox(c.x, c.y, c.z, c.x, c.y, c.z);
            for (Vector3f corner : corners) {
                this.bounds.resize(corner.x, corner.y, corner.z);
            }
        }
        return this.bounds;
    }

    public Vector3f getNormal() {
        return this.normal;
    }

    public Vector3f getCenter() {
        return this.position;
    }
}

